/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.coverage;

import com.google.common.collect.Maps;
import com.intellij.javascript.testFramework.coverage.PathConverter;
import com.intellij.util.containers.PeekableIteratorWrapper;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LcovCoverageReport {
    private final Map<String, List<LineHits>> myInfo = Maps.newHashMap();

    @NotNull
    public Map<String, List<LineHits>> getInfo() {
        Map<String, List<LineHits>> map2 = this.myInfo;
        if (map2 == null) {
            LcovCoverageReport.$$$reportNull$$$0(0);
        }
        return map2;
    }

    public void mergeReport(@NotNull LcovCoverageReport report) {
        if (report == null) {
            LcovCoverageReport.$$$reportNull$$$0(1);
        }
        for (Map.Entry<String, List<LineHits>> entry : report.getInfo().entrySet()) {
            this.mergeFileReport((Path)null, entry.getKey(), entry.getValue());
        }
    }

    @Deprecated
    public void mergeFileReport(@Nullable File basePath, @NotNull String filePath, @NotNull List<LineHits> report) {
        if (filePath == null) {
            LcovCoverageReport.$$$reportNull$$$0(2);
        }
        if (report == null) {
            LcovCoverageReport.$$$reportNull$$$0(3);
        }
        this.mergeFileReport(basePath != null ? basePath.toPath() : null, filePath, report);
    }

    public void mergeFileReport(@Nullable Path basePath, @NotNull String filePath, @NotNull List<LineHits> report) {
        String normalizedFilePath;
        if (filePath == null) {
            LcovCoverageReport.$$$reportNull$$$0(4);
        }
        if (report == null) {
            LcovCoverageReport.$$$reportNull$$$0(5);
        }
        if ((normalizedFilePath = PathConverter.getNormalizedPath(basePath, filePath)) == null) {
            return;
        }
        LcovCoverageReport.normalizeLineHitsList(report);
        List<LineHits> result2 = report;
        List<LineHits> old = this.myInfo.get(normalizedFilePath);
        if (old != null) {
            result2 = LcovCoverageReport.doMerge(old, report);
        }
        this.myInfo.put(normalizedFilePath, result2);
    }

    public void clearReportByFilePath(@NotNull String filePath) {
        if (filePath == null) {
            LcovCoverageReport.$$$reportNull$$$0(6);
        }
        this.myInfo.remove(filePath);
    }

    @NotNull
    private static List<LineHits> doMerge(@NotNull List<LineHits> aList, @NotNull List<LineHits> bList) {
        if (aList == null) {
            LcovCoverageReport.$$$reportNull$$$0(7);
        }
        if (bList == null) {
            LcovCoverageReport.$$$reportNull$$$0(8);
        }
        PeekableIteratorWrapper ai = new PeekableIteratorWrapper(aList.iterator());
        PeekableIteratorWrapper bi = new PeekableIteratorWrapper(bList.iterator());
        ArrayList<LineHits> out = new ArrayList<LineHits>();
        while (ai.hasNext() && bi.hasNext()) {
            LineHits x;
            LineHits a = (LineHits)ai.peek();
            LineHits b = (LineHits)bi.peek();
            if (a.getLineNumber() < b.getLineNumber()) {
                x = (LineHits)ai.next();
            } else if (a.getLineNumber() > b.getLineNumber()) {
                x = (LineHits)bi.next();
            } else {
                a.addHits(b.getHits());
                x = a;
                ai.next();
                bi.next();
            }
            out.add(x);
        }
        LcovCoverageReport.addRestItems(out, ai);
        LcovCoverageReport.addRestItems(out, bi);
        ArrayList<LineHits> arrayList = out;
        if (arrayList == null) {
            LcovCoverageReport.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static <T> void addRestItems(@NotNull List<T> out, Iterator<T> iterator) {
        if (out == null) {
            LcovCoverageReport.$$$reportNull$$$0(10);
        }
        while (iterator.hasNext()) {
            out.add(iterator.next());
        }
    }

    private static void normalizeLineHitsList(@NotNull List<LineHits> lineHitsList) {
        if (lineHitsList == null) {
            LcovCoverageReport.$$$reportNull$$$0(11);
        }
        LcovCoverageReport.makeSortedByLineNumber(lineHitsList);
        LcovCoverageReport.makeUniqueByLineNumber(lineHitsList);
    }

    private static void makeSortedByLineNumber(@NotNull List<LineHits> report) {
        if (report == null) {
            LcovCoverageReport.$$$reportNull$$$0(12);
        }
        LineHits prev = null;
        for (LineHits cur : report) {
            if (prev != null && prev.getLineNumber() > cur.getLineNumber()) {
                Collections.sort(report);
                return;
            }
            prev = cur;
        }
    }

    private static void makeUniqueByLineNumber(@NotNull List<LineHits> report) {
        boolean unique;
        if (report == null) {
            LcovCoverageReport.$$$reportNull$$$0(13);
        }
        if (unique = LcovCoverageReport.checkForLineUniqueness(report)) {
            return;
        }
        ArrayList<LineHits> out = new ArrayList<LineHits>(report.size());
        LineHits prev = null;
        for (LineHits cur : report) {
            if (prev != null && prev.getLineNumber() == cur.getLineNumber()) {
                prev.addHits(cur.getHits());
                continue;
            }
            out.add(cur);
            prev = cur;
        }
        report.clear();
        report.addAll(out);
    }

    private static boolean checkForLineUniqueness(@NotNull List<LineHits> lineHitsList) {
        if (lineHitsList == null) {
            LcovCoverageReport.$$$reportNull$$$0(14);
        }
        LineHits prev = null;
        for (LineHits cur : lineHitsList) {
            if (prev != null && prev.getLineNumber() == cur.getLineNumber()) {
                return false;
            }
            prev = cur;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/coverage/LcovCoverageReport";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "report";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bList";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineHitsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/coverage/LcovCoverageReport";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doMerge";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "mergeReport";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mergeFileReport";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "clearReportByFilePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doMerge";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addRestItems";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "normalizeLineHitsList";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "makeSortedByLineNumber";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "makeUniqueByLineNumber";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkForLineUniqueness";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }

    public static class LineHits
    implements Comparable<LineHits> {
        private final int myLineNumber;
        private int myHits;

        public LineHits(int lineNumber, int hits) {
            this.myLineNumber = lineNumber;
            this.myHits = hits;
        }

        public int getLineNumber() {
            return this.myLineNumber;
        }

        public int getHits() {
            return this.myHits;
        }

        @Override
        public int compareTo(LineHits o) {
            return this.myLineNumber - o.myLineNumber;
        }

        public void addHits(int hitCount) {
            this.myHits += hitCount;
        }
    }
}

