/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.web.htmx;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.XmlUnknownAttributeQuickFixProvider;
import com.intellij.javascript.web.htmx.EnableBundledHtmxWebTypesFix;
import com.intellij.javascript.web.htmx.HtmxBundledWebSymbolsContextProviderKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/web/htmx/HtmxUnknownAttributeQuickFixProvider;", "Lcom/intellij/codeInspection/htmlInspections/XmlUnknownAttributeQuickFixProvider;", "<init>", "()V", "getOrRegisterAttributeFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "name", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isFixRequired", "", "intellij.javascript.web"})
public final class HtmxUnknownAttributeQuickFixProvider
implements XmlUnknownAttributeQuickFixProvider {
    @NotNull
    public Collection<LocalQuickFix> getOrRegisterAttributeFixes(@NotNull XmlTag tag, @NotNull String name, @Nullable ProblemsHolder holder, boolean isFixRequired) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (isFixRequired && StringsKt.startsWith((String)name, (String)"hx-", (boolean)true)) {
            Project project = tag.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!HtmxBundledWebSymbolsContextProviderKt.isBundledHtmxEnabled(project)) {
                return CollectionsKt.listOf((Object)new EnableBundledHtmxWebTypesFix());
            }
        }
        return CollectionsKt.emptyList();
    }
}

