/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptMemberInfo;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class JSAddTypeMembersByLiteralFix
extends LocalQuickFixOnPsiElement
implements HighPriorityAction {
    @FileModifier.SafeFieldForPreview
    private final List<String> myNamesToAdd;
    private final String myClassName;
    private final int myClassIndex;
    private final boolean myClassIsInTheSameFile;

    static List<JSClass> getJSClasses(JSVariable varDeclaration) {
        JSType valuableType = JSTypeUtils.getValuableType(varDeclaration.getJSType(), (PsiElement)varDeclaration);
        if (valuableType == null) {
            return List.of();
        }
        List<JSType> allTypes = valuableType instanceof JSUnionOrIntersectionType ? ((JSUnionOrIntersectionType)valuableType).getTypes() : List.of(valuableType);
        return allTypes.stream().map(type2 -> {
            JSClass clazz;
            Collection<JSClass> classes;
            if (type2 instanceof JSGenericTypeImpl) {
                type2 = ((JSGenericTypeImpl)type2).getType();
            }
            if (type2 instanceof JSResolvableType && (classes = ((JSResolvableType)type2).resolveType().getDeclarationsOfType(JSClass.class)).size() == 1 && !((clazz = classes.iterator().next()) instanceof TypeScriptTypeAlias) && clazz.getName() != null) {
                return clazz;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    JSAddTypeMembersByLiteralFix(JSObjectLiteralExpression initializerLiteral, List<String> namesToAdd, String className, int classIndex, boolean classIsInTheSameFile) {
        super((PsiElement)initializerLiteral);
        this.myNamesToAdd = namesToAdd;
        this.myClassName = className;
        this.myClassIndex = classIndex;
        this.myClassIsInTheSameFile = classIsInTheSameFile;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.add.members.to.type.desc", new Object[0]);
        if (string == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("js.add.members.to.type", StringUtil.join(this.myNamesToAdd, n -> "'" + n + "'", (String)", "), this.myClassName);
        if (string == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSObjectLiteralExpression initializerLiteral;
        PsiElement parent;
        if (project == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(5);
        }
        if (!((parent = (initializerLiteral = (JSObjectLiteralExpression)startElement).getParent()) instanceof JSVariable)) {
            return;
        }
        List<JSClass> jsClasses = JSAddTypeMembersByLiteralFix.getJSClasses((JSVariable)parent);
        if (this.myClassIndex >= jsClasses.size()) {
            return;
        }
        JSClass clazz = jsClasses.get(this.myClassIndex);
        if (!this.myClassName.equals(clazz.getName())) {
            return;
        }
        if (IntentionPreviewUtils.isPreviewElement((PsiElement)initializerLiteral) && this.myClassIsInTheSameFile && initializerLiteral.getContainingFile() != clazz.getContainingFile()) {
            clazz = (JSClass)PsiTreeUtil.findSameElementInCopy((PsiElement)clazz, (PsiFile)initializerLiteral.getContainingFile());
        }
        for (JSProperty property : initializerLiteral.getProperties()) {
            String name = property.getName();
            if (name == null || !this.myNamesToAdd.contains(name)) continue;
            TypeScriptMemberInfo info = new TypeScriptMemberInfo(null, property, TypeScriptMemberInfo.Kind.UNIMPLEMENTED);
            LeafPsiElement anchor = (LeafPsiElement)SyntaxTraverser.psiTraverser((PsiElement)clazz).filter(LeafPsiElement.class).filter(e -> e.getElementType() == JSTokenTypes.LBRACE).first();
            if (property instanceof JSFunction) {
                TypeScriptImplementMemberUtil.addDistinctFunctionToClass(info, name, clazz, (PsiElement)anchor, Collections.emptyMap(), false);
                continue;
            }
            TypeScriptImplementMemberUtil.addPropertyToClass(clazz, (PsiElement)anchor, name, Collections.singletonList(info), Collections.emptyMap(), false);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(6);
        }
        if (previewDescriptor == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(7);
        }
        if (this.myClassIsInTheSameFile) {
            IntentionPreviewInfo intentionPreviewInfo = super.generatePreview(project, previewDescriptor);
            if (intentionPreviewInfo == null) {
                JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(8);
            }
            return intentionPreviewInfo;
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(9);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSAddTypeMembersByLiteralFix";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSAddTypeMembersByLiteralFix";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

