/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.intentions.JSConvertParametersToObjectIntention;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.typescript.refactoring.TypeScriptExtractInterfaceFromTypeHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSConvertParametersToObjectAndIntroduceInterfaceIntention
extends JavaScriptIntention {
    private final JSConvertParametersToObjectIntention myIntention;

    public JSConvertParametersToObjectAndIntroduceInterfaceIntention() {
        this.setText(this.getFamilyName());
        this.myIntention = new JSConvertParametersToObjectIntention(){

            @Override
            protected boolean isSimpleParameter(JSParameterListElement p) {
                return this.isValidSimpleParameter(p);
            }
        };
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSConvertParametersToObjectAndIntroduceInterfaceIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSConvertParametersToObjectAndIntroduceInterfaceIntention.$$$reportNull$$$0(1);
        }
        PsiFile file = element.getContainingFile();
        PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> this.myIntention.invoke(project, editor, element));
        PsiElement typeElement = JSConvertParametersToObjectAndIntroduceInterfaceIntention.findTypeElement(editor, file);
        if (typeElement == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message("dialog.message.cannot.infer.type.new.parameter", new Object[0]), (String)JavaScriptBundle.message("dialog.title.cannot.introduce.new.interface", new Object[0]), null);
            return;
        }
        editor.getSelectionModel().removeSelection();
        editor.getCaretModel().moveToOffset(typeElement.getTextOffset());
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)typeElement, JSFunction.class);
        final String name = function == null ? null : function.getName();
        new TypeScriptExtractInterfaceFromTypeHandler(){

            @Override
            @NotNull
            protected List<String> getNameCandidates(@NotNull JSElement scope2, JSType jsType) {
                if (scope2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (name != null) {
                    List<String> list = Collections.singletonList(JSNameSuggestionsUtil.ensureUniqueVariableName(StringUtil.capitalize((String)JSNameSuggestionsUtil.guessParameterNameByFunctionName(name)), (PsiElement)scope2, new HashSet<String>(), false));
                    if (list == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                List<String> list = super.getNameCandidates(scope2, jsType);
                if (list == null) {
                    2.$$$reportNull$$$0(2);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectAndIntroduceInterfaceIntention$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectAndIntroduceInterfaceIntention$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNameCandidates";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getNameCandidates";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        }.invoke(editor, file);
    }

    private static PsiElement findTypeElement(Editor editor, PsiFile file) {
        PsiElement psiElement = file.findElementAt(editor.getCaretModel().getOffset());
        JSParameterList parameterList = (JSParameterList)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSParameterList.class);
        if (parameterList == null) {
            return null;
        }
        JSParameterListElement[] parameters2 = parameterList.getParameters();
        if (parameters2.length != 1) {
            return null;
        }
        return parameters2[0].getTypeElement();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.convert.parameters.to.object.with.interface.intention.name", new Object[0]);
        if (string == null) {
            JSConvertParametersToObjectAndIntroduceInterfaceIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSConvertParametersToObjectAndIntroduceInterfaceIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JSConvertParametersToObjectAndIntroduceInterfaceIntention.$$$reportNull$$$0(4);
        }
        return !DialectDetector.isActionScript(element) && DialectDetector.hasFeature(element, JSLanguageFeature.TYPES) && this.myIntention.isAvailable(project, editor, element);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectAndIntroduceInterfaceIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectAndIntroduceInterfaceIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

