/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json;

import com.google.common.base.Predicates;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.javascript.json.JsonInJavaScriptSchemaFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaDocumentationProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaInJavaScriptDocumentationProvider
implements DocumentationProvider {
    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return JsonSchemaInJavaScriptDocumentationProvider.findSchemaAndGenerateDoc(element, true);
    }

    @Nullable
    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        return JsonSchemaInJavaScriptDocumentationProvider.findSchemaAndGenerateDoc(element, false);
    }

    @Nullable
    @Nls
    private static String findSchemaAndGenerateDoc(PsiElement element, boolean preferShort) {
        List extensions = JsonSchemaProviderFactory.EP_NAME.getExtensionList();
        JsonSchemaService jsonSchemaService = JsonSchemaService.Impl.get((Project)element.getProject());
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (!jsonSchemaService.isApplicableToFile(virtualFile)) {
            return null;
        }
        return extensions.stream().filter(factory -> factory instanceof JsonInJavaScriptSchemaFactory).flatMap(factory -> ((JsonInJavaScriptSchemaFactory)factory).getProviders().stream()).filter(provider -> provider.getSchemaFile() != null && provider.isAvailable(element)).map(provider -> {
            JsonSchemaObject schemaObject = jsonSchemaService.getSchemaObjectForSchemaFile(provider.getSchemaFile());
            if (schemaObject != null) {
                return JsonSchemaDocumentationProvider.generateDoc((PsiElement)element, (JsonSchemaObject)schemaObject, (boolean)preferShort, null);
            }
            return null;
        }).filter((Predicate<String>)Predicates.notNull()).findFirst().orElse(null);
    }
}

