/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.download;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.typings.TypeScriptDefinitionsUtils;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Stack;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bJ$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/lang/javascript/library/download/TypeScriptRelatedPackagesCollector;", "", "packageDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "modulesDirectory", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)V", "collectShortPackageNames", "", "", "collectFullPackageNames", "collectPackageNames", "nameGetter", "Lkotlin/Function1;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptRelatedPackagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptRelatedPackagesCollector.kt\ncom/intellij/lang/javascript/library/download/TypeScriptRelatedPackagesCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class TypeScriptRelatedPackagesCollector {
    @NotNull
    private final VirtualFile packageDirectory;
    @NotNull
    private final VirtualFile modulesDirectory;

    public TypeScriptRelatedPackagesCollector(@NotNull VirtualFile packageDirectory, @NotNull VirtualFile modulesDirectory) {
        Intrinsics.checkNotNullParameter((Object)packageDirectory, (String)"packageDirectory");
        Intrinsics.checkNotNullParameter((Object)modulesDirectory, (String)"modulesDirectory");
        this.packageDirectory = packageDirectory;
        this.modulesDirectory = modulesDirectory;
    }

    @NotNull
    public final Set<String> collectShortPackageNames() {
        return this.collectPackageNames((Function1<? super String, String>)((Function1)TypeScriptRelatedPackagesCollector::collectShortPackageNames$lambda$0));
    }

    @NotNull
    public final Set<String> collectFullPackageNames() {
        return this.collectPackageNames((Function1<? super String, String>)((Function1)TypeScriptRelatedPackagesCollector::collectFullPackageNames$lambda$1));
    }

    private final Set<String> collectPackageNames(Function1<? super String, String> nameGetter) {
        VirtualFile mainPackageJson = PackageJsonUtil.findChildPackageJsonFile(this.packageDirectory);
        if (mainPackageJson == null) {
            return SetsKt.emptySet();
        }
        Set result2 = new LinkedHashSet();
        Object[] objectArray = new VirtualFile[]{mainPackageJson};
        Stack toProcess = new Stack(objectArray);
        Object[] objectArray2 = new VirtualFile[]{mainPackageJson};
        Set processedPackageJsonFiles = SetsKt.mutableSetOf((Object[])objectArray2);
        while (!toProcess.isEmpty()) {
            PackageJsonData data;
            VirtualFile currentPackageJson = (VirtualFile)toProcess.pop();
            Intrinsics.checkNotNullExpressionValue((Object)PackageJsonData.getOrCreate(currentPackageJson), (String)"getOrCreate(...)");
            for (String dependency : data.getAllDependencies()) {
                String string;
                Intrinsics.checkNotNull((Object)dependency);
                String string2 = (String)nameGetter.invoke((Object)dependency);
                if (string2 == null) continue;
                String it = string = string2;
                boolean bl = false;
                string2 = ((CharSequence)it).length() > 0 ? string : null;
                if (string2 == null) {
                    continue;
                }
                String dependencyName = string2;
                VirtualFile directory = this.modulesDirectory.findFileByRelativePath(dependencyName);
                VirtualFile candidatePackageJson = PackageJsonUtil.findChildPackageJsonFile(directory);
                if (directory == null || candidatePackageJson == null || !processedPackageJsonFiles.add(candidatePackageJson)) continue;
                result2.add(dependencyName);
                toProcess.add((Object)candidatePackageJson);
            }
        }
        return result2;
    }

    private static final String collectShortPackageNames$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TypeScriptDefinitionsUtils.isTypingsPackage(it) ? TypeScriptDefinitionsUtils.getSourcePackageName(it) : null;
    }

    private static final String collectFullPackageNames$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }
}

