/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.lang.ecmascript6.psi.impl.JSImportDescriptorProcessor;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.JSFullImportRenderer;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidateWithExecutor;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSImportPopup;
import com.intellij.lang.javascript.modules.imports.filter.JSImportCandidatesFilter;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ListCellRenderer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public class JSImportAction
implements QuestionAction {
    public static final Key<Boolean> NO_HINT_KEY = Key.create((String)"ES6.auto.import.no.hint");
    @TestOnly
    public static final Key<String> NAME_TO_IMPORT = Key.create((String)"name.for.import");
    @TestOnly
    public static final Key<Set<String>> EXPECTED_NAMES_TO_IMPORT = Key.create((String)"expected.names.for.import");
    public static final Comparator<JSImportCandidate> COMPARE_CANDIDATES = Comparator.comparing(el -> -el.getPriority()).thenComparingInt(el -> {
        JSImportDescriptor descriptor = el.getDescriptor();
        if (descriptor == null) {
            return 0;
        }
        return descriptor.getModuleName().length();
    }).thenComparing(el -> {
        JSImportDescriptor descriptor = el.getDescriptor();
        if (descriptor == null) {
            return "";
        }
        return descriptor.getModuleName();
    }).thenComparing(el -> {
        JSImportDescriptor descriptor = el.getDescriptor();
        return descriptor == null ? 1 : -descriptor.getPriority();
    });
    @Nullable
    protected final Editor myEditor;
    @NotNull
    protected final String myName;
    @NotNull
    protected final JSImportPlaceInfo myPlaceInfo;

    public JSImportAction(@Nullable Editor editor, @NotNull String name, @NotNull JSImportPlaceInfo placeInfo) {
        if (name == null) {
            JSImportAction.$$$reportNull$$$0(0);
        }
        if (placeInfo == null) {
            JSImportAction.$$$reportNull$$$0(1);
        }
        this.myEditor = editor;
        this.myName = name;
        this.myPlaceInfo = placeInfo;
    }

    public JSImportAction(@Nullable Editor editor, @NotNull PsiElement context2, @NonNls @NotNull String name) {
        if (context2 == null) {
            JSImportAction.$$$reportNull$$$0(2);
        }
        if (name == null) {
            JSImportAction.$$$reportNull$$$0(3);
        }
        this(editor, name, JSHandlersFactory.forElement(context2).createImportPlaceInfo(context2));
    }

    @NotNull
    protected PsiElement getContext() {
        PsiElement psiElement = this.myPlaceInfo.getPlace();
        if (psiElement == null) {
            JSImportAction.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    public boolean execute() {
        this.executeForAllVariants();
        return true;
    }

    public void executeForAllVariants() {
        this.executeForAllVariants(null);
    }

    public void executeForAllVariants(@Nullable Consumer<JSImportCandidateWithExecutor> postProcess) {
        ThreadingAssertions.assertEventDispatchThread();
        PsiElement context2 = this.getContext();
        if (!context2.isValid()) {
            return;
        }
        Project project = context2.getProject();
        Runnable calcModuleNamesAndShowPopupIfNecessary = () -> {
            List newCandidates = (List)ReadAction.nonBlocking(() -> {
                if (this.isDisposed() || !context2.isValid()) {
                    return ContainerUtil.emptyList();
                }
                if (!this.isValidPlace()) {
                    return Collections.emptyList();
                }
                List<? extends JSImportCandidate> candidates = this.getRawCandidates();
                return this.filterAndSort(candidates);
            }).expireWhen(this::isDisposed).executeSynchronously();
            if (newCandidates.isEmpty()) {
                return;
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.executeForSingleOrShowPopup(project, postProcess, newCandidates);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> this.executeForSingleOrShowPopup(project, postProcess, newCandidates), ModalityState.nonModal(), __ -> (Boolean)ReadAction.compute(() -> this.isDisposed()));
            }
        };
        this.setNoHintFlag(true);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            calcModuleNamesAndShowPopupIfNecessary.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(calcModuleNamesAndShowPopupIfNecessary);
        }
    }

    private boolean isDisposed() {
        Project project = this.myPlaceInfo.getProject();
        return this.myEditor != null && this.myEditor.isDisposed() || project.isDisposed();
    }

    public void executeForSingleOrShowPopup(Project project, @Nullable Consumer<JSImportCandidateWithExecutor> postProcess, List<JSImportCandidateWithExecutor> newCandidates) {
        this.setNoHintFlag(false);
        PsiElement context2 = this.getContext();
        if (newCandidates.isEmpty() || !context2.isValid()) {
            return;
        }
        if (!this.shouldShowPopup(newCandidates)) {
            JSImportCandidateWithExecutor item = (JSImportCandidateWithExecutor)ContainerUtil.getFirstItem(newCandidates);
            assert (item != null);
            Runnable runnable = () -> this.executeFor(item, (Consumer<? super JSImportCandidateWithExecutor>)postProcess);
            CommandProcessor.getInstance().executeCommand(project, runnable, this.getName(), (Object)this);
            return;
        }
        this.chooseElement(newCandidates, postProcess);
    }

    protected boolean shouldShowPopup(@NotNull List<JSImportCandidateWithExecutor> candidates) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(5);
        }
        return candidates.size() > 1;
    }

    private void setNoHintFlag(boolean value) {
        PsiElement context2 = this.getContext();
        if (!context2.isValid()) {
            return;
        }
        PsiElement toSet = context2;
        if (context2.getNode() != null && context2.getNode().getElementType() == JSTokenTypes.IDENTIFIER) {
            context2.putUserData(NO_HINT_KEY, (Object)value);
            PsiElement parent = context2.getParent();
            toSet = parent == null ? toSet : parent;
        }
        toSet.putUserData(NO_HINT_KEY, (Object)value);
    }

    public final void executeWithoutPrepare(@NotNull JSImportCandidateWithExecutor candidate) {
        if (candidate == null) {
            JSImportAction.$$$reportNull$$$0(6);
        }
        this.runAction(this.myEditor, candidate, this.getContext());
    }

    public final void executeFor(@NotNull JSImportCandidateWithExecutor candidate, @Nullable Consumer<? super JSImportCandidateWithExecutor> postProcess) {
        PsiElement context2;
        if (candidate == null) {
            JSImportAction.$$$reportNull$$$0(7);
        }
        if (!(context2 = this.getContext()).isValid()) {
            return;
        }
        this.executeWithoutPrepare(candidate);
        if (postProcess != null) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> WriteAction.run(() -> postProcess.consume((Object)candidate)));
        }
    }

    @NotNull
    public List<JSImportCandidateWithExecutor> getFilteredCandidates() {
        return this.filterAndSort(this.getRawCandidates());
    }

    @NotNull
    public List<? extends JSImportCandidate> getRawCandidates() {
        List<JSImportCandidate> list = JSImportCandidatesProvider.getCandidatesFromProviders(this.myPlaceInfo, this.myName);
        if (list == null) {
            JSImportAction.$$$reportNull$$$0(8);
        }
        return list;
    }

    protected void runAction(@Nullable Editor editor, @NotNull JSImportCandidateWithExecutor candidate, @NotNull PsiElement place) {
        if (candidate == null) {
            JSImportAction.$$$reportNull$$$0(9);
        }
        if (place == null) {
            JSImportAction.$$$reportNull$$$0(10);
        }
        JSImportAction.createImports(editor, candidate, place);
    }

    public static void createImports(@Nullable Editor editor, @NotNull JSImportCandidateWithExecutor candidateWithExecutor, @NotNull PsiElement place) {
        if (candidateWithExecutor == null) {
            JSImportAction.$$$reportNull$$$0(11);
        }
        if (place == null) {
            JSImportAction.$$$reportNull$$$0(12);
        }
        PsiFile containingFile = place.getContainingFile();
        Project project = place.getProject();
        if (containingFile instanceof JSExpressionCodeFragment) {
            PsiElement element = candidateWithExecutor.getElement();
            if (element != null) {
                ((JSExpressionCodeFragment)containingFile).importElement(element);
            }
        } else {
            JSImportDescriptor descriptor = candidateWithExecutor.getDescriptor();
            if (descriptor == null) {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    TypeScriptAutoImportUtil.showError(place.getProject(), editor);
                }
                return;
            }
            candidateWithExecutor.execute();
            DaemonCodeAnalyzer.getInstance((Project)project).restart(containingFile);
        }
    }

    @NotNull
    protected final List<JSImportCandidateWithExecutor> filterAndSort(@NotNull List<? extends JSImportCandidate> candidates) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(13);
        }
        return JSImportAction.deduplicateByImportText(this.filterAndSort(candidates, this.myPlaceInfo.getPlace()));
    }

    @NotNull
    protected List<JSImportCandidateWithExecutor> filterAndSort(@NotNull List<? extends JSImportCandidate> candidates, @NotNull PsiElement place) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(14);
        }
        if (place == null) {
            JSImportAction.$$$reportNull$$$0(15);
        }
        List<JSImportCandidateWithExecutor> list = JSImportCandidateWithExecutor.sortWithExecutors(this.filter(candidates), place);
        if (list == null) {
            JSImportAction.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    protected List<? extends JSImportCandidate> filter(@NotNull List<? extends JSImportCandidate> candidates) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(17);
        }
        if (candidates.isEmpty()) {
            List<? extends JSImportCandidate> list = candidates;
            if (list == null) {
                JSImportAction.$$$reportNull$$$0(18);
            }
            return list;
        }
        List filtered = this.filterByBlacklist(candidates);
        if (filtered.size() <= 1) {
            List list = filtered;
            if (list == null) {
                JSImportAction.$$$reportNull$$$0(19);
            }
            return list;
        }
        if (((JSImportCandidate)(filtered = ContainerUtil.sorted(new ArrayList<JSImportCandidate>(filtered), COMPARE_CANDIDATES)).get(0)).getPriority() == 3) {
            filtered = JSImportAction.filterByExistingImports(this.myPlaceInfo.getProject(), filtered);
        }
        for (JSImportCandidatesFilter.FilterFactory filterFactory : this.getImportCandidatesFilterFactories()) {
            JSImportCandidatesFilter candidatesFilter = filterFactory.createFilter(filtered);
            if (candidatesFilter == null) continue;
            filtered = ContainerUtil.filter(filtered, candidatesFilter::accept);
        }
        List list = filtered;
        if (list == null) {
            JSImportAction.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    protected List<JSImportCandidatesFilter.FilterFactory> getImportCandidatesFilterFactories() {
        List list = JSImportCandidatesFilter.EP_NAME.getExtensionList();
        if (list == null) {
            JSImportAction.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private static List<? extends JSImportCandidate> filterByExistingImports(@NotNull Project project, @NotNull List<? extends JSImportCandidate> candidates) {
        if (project == null) {
            JSImportAction.$$$reportNull$$$0(22);
        }
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(23);
        }
        ArrayList<JSImportCandidate> result2 = new ArrayList<JSImportCandidate>();
        List<VirtualFile> globalDirectories = JSImportAction.getGlobalDirectories();
        for (JSImportCandidate jSImportCandidate : candidates) {
            JSImportDescriptor descriptor = jSImportCandidate.getDescriptor();
            if (descriptor == null) continue;
            String name = descriptor.getModuleName();
            VirtualFile module = jSImportCandidate.getElementFile();
            if (JSFileReferencesUtil.isRelative(name) || module == null || !JSImportAction.isAcceptableForExistingImports(project, module, globalDirectories)) {
                result2.add(jSImportCandidate);
                continue;
            }
            if (jSImportCandidate.getPriority() != 3) continue;
            result2.add(jSImportCandidate);
        }
        ArrayList<JSImportCandidate> arrayList = result2;
        if (arrayList == null) {
            JSImportAction.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    private static @Unmodifiable List<JSImportCandidateWithExecutor> deduplicateByImportText(@NotNull List<JSImportCandidateWithExecutor> candidates) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(25);
        }
        if (candidates.size() <= 1) {
            List<JSImportCandidateWithExecutor> list = candidates;
            if (list == null) {
                JSImportAction.$$$reportNull$$$0(26);
            }
            return list;
        }
        HashSet visited = new HashSet();
        List list = ContainerUtil.filter(candidates, el -> {
            JSImportDescriptor single = el.getDescriptor();
            if (single == null) {
                return true;
            }
            JSImportExportType type2 = single.getImportType();
            if (type2.isComposite()) {
                return true;
            }
            String text = el.getImportText();
            return visited.add(text);
        });
        if (list == null) {
            JSImportAction.$$$reportNull$$$0(27);
        }
        return list;
    }

    private void chooseElement(@NotNull List<JSImportCandidateWithExecutor> candidates, @Nullable Consumer<JSImportCandidateWithExecutor> postProcess) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(28);
        }
        if (this.myEditor == null || this.myEditor.isDisposed()) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        PsiElement place = this.getContext();
        Project project = place.getProject();
        Processor<JSImportCandidateWithExecutor> processor = this.createModuleProcessor(project, postProcess);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Set actualNames;
            Set expectedNamesToImport = (Set)this.myEditor.getUserData(EXPECTED_NAMES_TO_IMPORT);
            if (expectedNamesToImport != null && !(actualNames = ContainerUtil.map2Set(candidates, this::getDebugNameForElement)).equals(expectedNamesToImport)) {
                String expected = expectedNamesToImport.stream().sorted().collect(Collectors.joining(","));
                String actual = actualNames.stream().sorted().collect(Collectors.joining(","));
                throw new AssertionError((Object)("Unexpected import candidates. \nExpected: " + expected + "\nActual: " + actual));
            }
            String nameToImport = (String)this.myEditor.getUserData(NAME_TO_IMPORT);
            processor.process((Object)Optional.ofNullable(nameToImport).map(name -> (JSImportCandidateWithExecutor)ContainerUtil.find((Iterable)candidates, candidate -> this.getDebugNameForElement((JSImportCandidateWithExecutor)candidate).equals(name))).orElseThrow(() -> new AssertionError((Object)("Import name must be specified for multiple candidates.\nName to import: " + nameToImport + "\nAvailable names: " + StreamEx.of((Collection)candidates).map(candidate -> this.getDebugNameForElement((JSImportCandidateWithExecutor)candidate)).joining((CharSequence)",")))));
            return;
        }
        JSImportPopup.createPopup(project, new JSImportPopup.RendererFactory(){
            final Map<JSImportCandidateWithExecutor, ListCellRenderer<Object>> renderers = new HashMap<JSImportCandidateWithExecutor, ListCellRenderer<Object>>();

            @Override
            @NotNull
            public ListCellRenderer<Object> create(@NotNull JSImportCandidateWithExecutor candidate) {
                if (candidate == null) {
                    1.$$$reportNull$$$0(0);
                }
                ListCellRenderer listCellRenderer = this.renderers.computeIfAbsent(candidate, el -> new JSFullImportRenderer(candidate));
                if (listCellRenderer == null) {
                    1.$$$reportNull$$$0(1);
                }
                return listCellRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "candidate";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/modules/imports/JSImportAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/modules/imports/JSImportAction$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }, candidates, this.getModuleSelectionPopupTitle(), processor).showInBestPositionFor(this.myEditor);
    }

    @NotNull
    protected String getDebugNameForElement(@NotNull JSImportCandidateWithExecutor element) {
        if (element == null) {
            JSImportAction.$$$reportNull$$$0(29);
        }
        JSFullImportRenderer renderer = new JSFullImportRenderer(element);
        String string = renderer.getElementText(element.getElement());
        if (string == null) {
            JSImportAction.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NlsContexts.PopupTitle
    protected String getModuleSelectionPopupTitle() {
        return JavaScriptBundle.message("choose.class.to.import.title", new Object[0]);
    }

    @NotNull
    @NlsContexts.Command
    public String getName() {
        String string = JavaScriptBundle.message("command.name.import", this.myName);
        if (string == null) {
            JSImportAction.$$$reportNull$$$0(31);
        }
        return string;
    }

    public boolean isValidPlace() {
        return JSImportAction.isValidImportPlace(this.getContext());
    }

    @NotNull
    private Processor<JSImportCandidateWithExecutor> createModuleProcessor(final @NotNull Project project, final @Nullable Consumer<? super JSImportCandidateWithExecutor> postProcess) {
        if (project == null) {
            JSImportAction.$$$reportNull$$$0(32);
        }
        return new Processor<JSImportCandidateWithExecutor>(){

            public boolean process(@NotNull JSImportCandidateWithExecutor element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                CommandProcessor.getInstance().executeCommand(project, () -> JSImportAction.this.executeFor(element, (Consumer<? super JSImportCandidateWithExecutor>)postProcess), JSImportAction.this.getName(), (Object)this);
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/imports/JSImportAction$2", "process"));
            }
        };
    }

    @NotNull
    protected List<? extends JSImportCandidate> filterByBlacklist(@NotNull Collection<? extends JSImportCandidate> candidates) {
        if (candidates == null) {
            JSImportAction.$$$reportNull$$$0(33);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String[] excludedNames = JSCodeStyleSettings.getSettings(this.myPlaceInfo.getPlace()).getBlacklistImports();
        Ref ref2 = Ref.create();
        JSImportDescriptorProcessor processor = JSImportPathBuilder.createSearchProcessor((Ref<? super JSImportDescriptor>)ref2, excludedNames);
        ArrayList<JSImportCandidate> result2 = new ArrayList<JSImportCandidate>();
        Set<VirtualFile> predefinedLibraries = JsModulesSuggester.getPredefinedLibraries(this.getContext());
        for (JSImportCandidate jSImportCandidate : candidates) {
            VirtualFile file;
            ref2.set(null);
            JSImportDescriptor descriptor = jSImportCandidate.getDescriptor();
            if (descriptor == null || processor.processDescriptor(descriptor) || (file = jSImportCandidate.getElementFile()) != null && predefinedLibraries.contains(file)) continue;
            result2.add(jSImportCandidate);
        }
        ArrayList<JSImportCandidate> arrayList = result2;
        if (arrayList == null) {
            JSImportAction.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    public static boolean isValidImportPlace(@Nullable PsiElement context2) {
        if (context2 == null || !context2.isValid()) {
            return false;
        }
        if (JSXResolveUtil.isJSXContextPlace(context2)) {
            JSXmlLiteralExpression expression = (JSXmlLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)context2, JSXmlLiteralExpression.class, (boolean)false);
            if (expression != null) {
                PsiPolyVariantReference topLevelReference = JSXResolveUtil.getTopLevelReference(expression);
                if (topLevelReference == null) {
                    return false;
                }
                return JSStubBasedPsiTreeUtil.resolveReferenceLocally(topLevelReference, topLevelReference.getCanonicalText()) == null;
            }
            return true;
        }
        if (!(context2 instanceof JSReferenceExpression)) {
            return true;
        }
        if (((JSReferenceExpression)context2).getQualifier() != null) {
            context2 = JSResolveUtil.getLeftmostQualifier((JSExpression)context2);
        }
        return !(context2 instanceof JSReferenceExpression) || JSImportAction.checkReferenceExpressionAcceptable((JSReferenceExpression)context2);
    }

    private static boolean checkReferenceExpressionAcceptable(@NotNull JSReferenceExpression referenceExpression) {
        String name;
        if (referenceExpression == null) {
            JSImportAction.$$$reportNull$$$0(35);
        }
        return JSStubBasedPsiTreeUtil.resolveReferenceLocally(referenceExpression, name = referenceExpression.getReferenceName()) == null;
    }

    public static boolean isAcceptableForExistingImports(Project project, @NotNull VirtualFile file, @NotNull List<VirtualFile> globalTypesDirectories) {
        if (file == null) {
            JSImportAction.$$$reportNull$$$0(36);
        }
        if (globalTypesDirectories == null) {
            JSImportAction.$$$reportNull$$$0(37);
        }
        return NodeModuleUtil.hasNodeModulesDirInPath(file, null) || JSUrlImportsUtil.isInRemoteModulesLibrary(file) || ProjectFileIndex.getInstance((Project)project).isInLibrary(file) || JSImportAction.isGlobalTypes(file, globalTypesDirectories);
    }

    private static boolean isGlobalTypes(@NotNull VirtualFile file, @NotNull List<VirtualFile> globalTypesDirectories) {
        if (file == null) {
            JSImportAction.$$$reportNull$$$0(38);
        }
        if (globalTypesDirectories == null) {
            JSImportAction.$$$reportNull$$$0(39);
        }
        for (VirtualFile directory : globalTypesDirectories) {
            if (!VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)file, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<VirtualFile> getGlobalDirectories() {
        ArrayList<VirtualFile> globalTypesDirectories = new ArrayList<VirtualFile>();
        ContainerUtil.addIfNotNull(globalTypesDirectories, (Object)TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory());
        ContainerUtil.addIfNotNull(globalTypesDirectories, (Object)TypeScriptDefinitionFilesDirectory.getGlobalAutoDownloadTypesDirectory());
        ArrayList<VirtualFile> arrayList = globalTypesDirectories;
        if (arrayList == null) {
            JSImportAction.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 16, 18, 19, 20, 21, 24, 26, 27, 30, 31, 34, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/JSImportAction";
                break;
            }
            case 5: 
            case 13: 
            case 14: 
            case 17: 
            case 23: 
            case 25: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateWithExecutor";
                break;
            }
            case 22: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalTypesDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/JSImportAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawCandidates";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAndSort";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportCandidatesFilterFactories";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByExistingImports";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicateByImportText";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugNameForElement";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByBlacklist";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 34: 
            case 40: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowPopup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeWithoutPrepare";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeFor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runAction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createImports";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterAndSort";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "filterByExistingImports";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "deduplicateByImportText";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "chooseElement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDebugNameForElement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createModuleProcessor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "filterByBlacklist";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceExpressionAcceptable";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableForExistingImports";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 16, 18, 19, 20, 21, 24, 26, 27, 30, 31, 34, 40 -> new IllegalStateException(string);
        };
    }
}

