/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSInheritanceCallEvaluator;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpressionCommon;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSParenthesizedExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSCallExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCallExpressionImpl
extends JSImplicitElementProviderImpl<JSCallExpressionStub>
implements JSCallExpression,
JSCallLikeExpressionCommon {
    public JSCallExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSCallExpressionImpl(JSCallExpressionStub stub) {
        super(stub, JSStubElementTypes.CALL_EXPRESSION);
    }

    @Override
    public JSExpression getMethodExpression() {
        ASTNode node = JSCallExpressionImpl.getMethodExpression(this.getNode());
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    @Nullable
    public static ASTNode getMethodExpression(@NotNull ASTNode callExpression) {
        if (callExpression == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(0);
        }
        return callExpression.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
    }

    @Override
    public JSExpression getStubSafeMethodExpression() {
        JSCallExpressionStub stub = (JSCallExpressionStub)this.getStub();
        if (stub != null) {
            if (!stub.keepsMethodExpression()) {
                return null;
            }
            StubElement<?> initializerStub = StubTreeUtil.findChildStubByType(stub, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS, false);
            return initializerStub != null ? (JSExpression)initializerStub.getPsi() : null;
        }
        return this.getMethodExpression();
    }

    @Override
    @Nullable
    public JSArgumentList getArgumentList() {
        ASTNode argumentList = JSCallExpressionImpl.getArgumentList(this.getNode());
        return argumentList != null ? (JSArgumentList)argumentList.getPsi() : null;
    }

    @Nullable
    public static ASTNode getArgumentList(@NotNull ASTNode callExpressionNode) {
        if (callExpressionNode == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(1);
        }
        return callExpressionNode.findChildByType(JSExtendedLanguagesTokenSetProvider.ARGUMENT_LISTS);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(2);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSCallExpression(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public JSExpression replace(@NotNull JSExpression other) {
        if (other == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(3);
        }
        return JSChangeUtil.replaceExpression(this, other);
    }

    @Override
    @NotNull
    public JSElementIndexingData calculateIndexingData() {
        JSNamespace destinationNs;
        JSElementIndexingDataImpl indexingData = new JSElementIndexingDataImpl();
        JSInheritanceCallEvaluator.JSInheritanceCallResult inheritance = JSInheritanceCallEvaluator.findInheritance(this);
        if (inheritance != null && (destinationNs = inheritance.evaluateOrFindDestinationNamespace(this)) != null) {
            JSNamespace mixedNs;
            if (inheritance.mixed != null && (mixedNs = JSSymbolUtil.evaluateNamespaceLocally(inheritance.mixed)) != null) {
                mixedNs = JSNamedTypeFactory.copyWithJSContext(mixedNs, JSTypeUtils.combineJSContexts(mixedNs.getJSContext(), inheritance.context));
                JSStubIndexingUtils.processExtendCall(destinationNs, mixedNs, indexingData);
            }
            if (inheritance.destination != inheritance.base && inheritance.base instanceof JSReferenceExpression) {
                JSNamespace baseNs = JSStubIndexingUtils.getNamespaceFromReferenceExpression((JSReferenceExpression)inheritance.base, inheritance.context);
                JSStubIndexingUtils.processExtendCall(destinationNs, baseNs, indexingData);
            }
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions((PsiElement)this)) {
            handler.processCallExpression(this, indexingData);
        }
        JSElementIndexingDataImpl jSElementIndexingDataImpl = indexingData;
        if (jSElementIndexingDataImpl == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(4);
        }
        return jSElementIndexingDataImpl;
    }

    public static boolean shouldCreateStub(@NotNull ASTNode node) {
        String calledMethodName;
        ASTNode lastChildNode;
        if (node == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(5);
        }
        ASTNode methodExpression = node.getFirstChildNode();
        while (methodExpression != null && methodExpression.getElementType() == JSElementTypes.PARENTHESIZED_EXPRESSION) {
            methodExpression = JSParenthesizedExpressionImpl.getInnerExpression(methodExpression);
        }
        if (methodExpression != null && methodExpression.getElementType() == JSElementTypes.REFERENCE_EXPRESSION ? (lastChildNode = methodExpression.getLastChildNode()) != null && JSInheritanceCallEvaluator.isInheritanceMethodNameCandidate(calledMethodName = lastChildNode.getText()) : methodExpression != null && JSElementTypes.FUNCTION_EXPRESSIONS.contains(methodExpression.getElementType())) {
            return true;
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions(node)) {
            if (!handler.shouldCreateStubForCallExpression(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRequireCall() {
        JSCallExpressionStub stub = (JSCallExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isRequireCall();
        }
        return CommonJSUtil.calculateIsRequireCall(this);
    }

    @Override
    public boolean isDefineCall() {
        JSCallExpressionStub stub = (JSCallExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isDefineCall();
        }
        return JSAmdPsiUtil.isDefineCall(this);
    }

    @Override
    public boolean isElvis() {
        JSCallExpressionStub stub = (JSCallExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isElvisCall();
        }
        return this.getNode().findChildByType(JSTokenTypes.ELVIS) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpressionNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSCallExpressionImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSCallExpressionImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateIndexingData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodExpression";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentList";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateStub";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

