/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.ES6ExportOnlyAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptClassTypeParametersChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptConfigAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptImportTypeChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 >2\u00020\u0001:\u0002>?B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00032\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eJ\u0016\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"J\u001c\u0010#\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00032\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0014J\u001c\u0010$\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020%2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0014J\u001a\u0010&\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020%2\b\u0010'\u001a\u0004\u0018\u00010\u0003H\u0002J\u001e\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u001c\u001a\u00020\u00032\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0004J\u0012\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\"H\u0016J\u0012\u00106\u001a\u0002042\b\u00107\u001a\u0004\u0018\u000108H\u0016J \u00109\u001a\u00060\tR\u00020\u00002\b\u0010:\u001a\u0004\u0018\u0001082\b\u0010;\u001a\u0004\u0018\u000108H\u0002J\u0012\u0010<\u001a\u0002042\b\u0010=\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\b\u0018\u00010\tR\u00020\u00002\f\u0010\b\u001a\b\u0018\u00010\tR\u00020\u0000@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010R\u0014\u0010(\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000eR\u0014\u0010*\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000eR\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006@"}, d2={"Lcom/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler;", "", "place", "Lcom/intellij/psi/PsiElement;", "isConstructorWithNew", "", "<init>", "(Lcom/intellij/psi/PsiElement;Z)V", "value", "Lcom/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler$ClassContext;", "myClassContext", "setMyClassContext", "(Lcom/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler$ClassContext;)V", "isProcessStatics", "()Z", "setProcessStatics", "(Z)V", "allowUnqualifiedStaticsFromInstance", "getAllowUnqualifiedStaticsFromInstance", "setAllowUnqualifiedStaticsFromInstance", "myClassDeclarationStarted", "getMyClassDeclarationStarted", "setMyClassDeclarationStarted", "getPlace", "()Lcom/intellij/psi/PsiElement;", "isProcessingInheritedClasses", "setProcessingInheritedClasses", "accepts", "element", "resolveProcessor", "Lcom/intellij/lang/javascript/psi/resolve/SinkResolveProcessor;", "acceptsConstructorWithNew", "constructor", "className", "", "checkConstructorWithNew", "acceptsForMembersVisibility", "Lcom/intellij/lang/javascript/psi/JSPsiElementBase;", "needCheckAccessFromPlace", "parentOfElement", "acceptPrivateMembers", "getAcceptPrivateMembers", "acceptProtectedMembers", "getAcceptProtectedMembers", "checkers", "", "Lcom/intellij/lang/javascript/psi/resolve/accessibility/JSAccessibilityChecker;", "getCheckers", "()Ljava/util/List;", "processCheckers", "Lcom/intellij/lang/javascript/psi/resolve/JSResolveResult$ProblemKind;", "setTypeName", "", "qualifiedName", "configureClassScope", "jsClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "configureClassContext", "qualifierClass", "thisClass", "startingParent", "parent", "Companion", "ClassContext", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nAccessibilityProcessingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessibilityProcessingHandler.kt\ncom/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,320:1\n15#2:321\n*S KotlinDebug\n*F\n+ 1 AccessibilityProcessingHandler.kt\ncom/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler\n*L\n31#1:321\n*E\n"})
public class AccessibilityProcessingHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isConstructorWithNew;
    @Nullable
    private ClassContext myClassContext;
    private boolean isProcessStatics;
    private boolean allowUnqualifiedStaticsFromInstance;
    private boolean myClassDeclarationStarted;
    @Nullable
    private final PsiElement place;
    private boolean isProcessingInheritedClasses;
    @NotNull
    private static final List<JSAccessibilityChecker> CHECKERS;
    private static final int MAX_DEPTH = 10;

    public AccessibilityProcessingHandler(@Nullable PsiElement place, boolean isConstructorWithNew) {
        this.isConstructorWithNew = isConstructorWithNew;
        PsiElement psiElement = place;
        this.place = psiElement != null ? Companion.getRealElement(psiElement) : null;
    }

    public /* synthetic */ AccessibilityProcessingHandler(PsiElement psiElement, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(psiElement, bl);
    }

    private final void setMyClassContext(ClassContext value) {
        if (this.myClassContext != null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(AccessibilityProcessingHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Redeclaration of classScope");
        }
        this.myClassContext = value;
    }

    public final boolean isProcessStatics() {
        return this.isProcessStatics;
    }

    public final void setProcessStatics(boolean bl) {
        this.isProcessStatics = bl;
    }

    protected final boolean getAllowUnqualifiedStaticsFromInstance() {
        return this.allowUnqualifiedStaticsFromInstance;
    }

    protected final void setAllowUnqualifiedStaticsFromInstance(boolean bl) {
        this.allowUnqualifiedStaticsFromInstance = bl;
    }

    protected final boolean getMyClassDeclarationStarted() {
        return this.myClassDeclarationStarted;
    }

    protected final void setMyClassDeclarationStarted(boolean bl) {
        this.myClassDeclarationStarted = bl;
    }

    @Nullable
    protected final PsiElement getPlace() {
        return this.place;
    }

    public final boolean isProcessingInheritedClasses() {
        return this.isProcessingInheritedClasses;
    }

    public final void setProcessingInheritedClasses(boolean bl) {
        this.isProcessingInheritedClasses = bl;
    }

    public final boolean accepts(@NotNull PsiElement element, @NotNull SinkResolveProcessor<?> resolveProcessor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(resolveProcessor, (String)"resolveProcessor");
        if (!this.checkConstructorWithNew(element, resolveProcessor)) {
            return false;
        }
        JSResolveResult.ProblemKind errorFromCheckers = this.processCheckers(element, resolveProcessor);
        if (errorFromCheckers != null) {
            resolveProcessor.addPossibleCandidateResult(element, errorFromCheckers);
            return false;
        }
        if (this.isProcessStatics && this.myClassDeclarationStarted && element instanceof JSImplicitElement && ((JSImplicitElement)element).getType() == JSImplicitElement.Type.Tag) {
            return false;
        }
        if (element instanceof JSFieldVariable || element instanceof JSFunction || element instanceof JSNamespaceDeclaration || element instanceof JSLocalImplicitElementImpl) {
            return this.acceptsForMembersVisibility((JSPsiElementBase)element, resolveProcessor);
        }
        return true;
    }

    public final boolean acceptsConstructorWithNew(@NotNull PsiElement constructor, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return this.checkConstructorWithNew(constructor, new SinkResolveProcessor<ResultSink>(className, this.place, (ResultSink)new ResolveResultSink(this.place, className)));
    }

    protected boolean checkConstructorWithNew(@NotNull PsiElement element, @NotNull SinkResolveProcessor<?> resolveProcessor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(resolveProcessor, (String)"resolveProcessor");
        if (this.place == null || !(this.place.getContext() instanceof JSNewExpression) || !(element instanceof JSClass)) {
            return true;
        }
        JSFunction constructor = AccessibilityProcessingHandler.Companion.findOwnOrParentConstructor((JSClass)element, 0);
        if (constructor == null) {
            return true;
        }
        AccessibilityProcessingHandler handler = new AccessibilityProcessingHandler(this.place, true);
        handler.startingParent(element);
        return handler.accepts(constructor, resolveProcessor);
    }

    protected boolean acceptsForMembersVisibility(@NotNull JSPsiElementBase element, @NotNull SinkResolveProcessor<?> resolveProcessor) {
        block11: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter(resolveProcessor, (String)"resolveProcessor");
                if (!JSClassUtils.isClassMember((PsiElement)element)) {
                    return true;
                }
                JSAttributeList.AccessType accessType = element.getAccessType();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)accessType), (String)"getAccessType(...)");
                JSAttributeList.AccessType accessType2 = accessType;
                PsiElement parentOfElement = JSResolveUtil.findParent((PsiElement)element);
                if (!this.needCheckAccessFromPlace(element, parentOfElement)) break block11;
                if (!this.getAcceptPrivateMembers() && accessType2 == JSAttributeList.AccessType.PRIVATE) {
                    JSResolveResult.ProblemKind problemKind = element instanceof JSFunction && ((JSFunction)element).isConstructor() ? JSResolveResult.ProblemKind.PRIVATE_CONSTRUCTOR_IS_NOT_ACCESSIBLE : JSResolveResult.ProblemKind.PRIVATE_MEMBER_IS_NOT_ACCESSIBLE;
                    resolveProcessor.addPossibleCandidateResult((PsiElement)element, problemKind);
                    return false;
                }
                if (accessType2 != JSAttributeList.AccessType.PROTECTED || this.getAcceptProtectedMembers()) break block11;
                Object object = this.myClassContext;
                if (object != null && (object = ((ClassContext)object).getThisClasses()) != null ? !object.isEmpty() : false) break block12;
                if (!Companion.isParentClassContext((PsiElement)element)) break block11;
            }
            JSResolveResult.ProblemKind problemKind = element instanceof JSFunction && ((JSFunction)element).isConstructor() ? JSResolveResult.ProblemKind.PROTECTED_CONSTRUCTOR_IS_NOT_ACCESSIBLE : JSResolveResult.ProblemKind.PROTECTED_MEMBER_IS_NOT_ACCESSIBLE;
            resolveProcessor.addPossibleCandidateResult((PsiElement)element, problemKind);
            return false;
        }
        if (this.place instanceof JSIndexedPropertyAccessExpression && JSUtils.isPrivateSharpItem((PsiElement)element)) {
            return false;
        }
        if (this.isProcessStatics) {
            if (!(element.getJSContext() != JSContext.INSTANCE || this.place instanceof JSReferenceExpression && JSUtils.isPrivateBrandCheckReference((JSReferenceExpression)this.place))) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, JSResolveResult.ProblemKind.INSTANCE_MEMBER_INACCESSIBLE);
                return false;
            }
        } else if (this.myClassDeclarationStarted && !this.allowUnqualifiedStaticsFromInstance && element.getJSContext() == JSContext.STATIC) {
            resolveProcessor.addPossibleCandidateResult((PsiElement)element, JSResolveResult.ProblemKind.STATIC_MEMBER_INACCESSIBLE);
            return false;
        }
        return true;
    }

    private final boolean needCheckAccessFromPlace(JSPsiElementBase element, PsiElement parentOfElement) {
        if (this.place != null && parentOfElement instanceof TypeScriptModule) {
            PsiElement parent = JSResolveUtil.findParent(this.place);
            return parent != null && !PsiTreeUtil.isAncestor((PsiElement)parentOfElement, (PsiElement)parent, (boolean)false);
        }
        return JSResolveUtil.getClassOfContext(this.place) != JSUtils.getMemberContainingClass((PsiElement)element);
    }

    private final boolean getAcceptPrivateMembers() {
        ClassContext classContext = this.myClassContext;
        return !(classContext != null ? !classContext.getAcceptPrivateMembers() : false);
    }

    private final boolean getAcceptProtectedMembers() {
        ClassContext classContext = this.myClassContext;
        return !(classContext != null ? !classContext.getAcceptProtectedMembers() : false);
    }

    @NotNull
    public List<JSAccessibilityChecker> getCheckers() {
        return CHECKERS;
    }

    @Nullable
    protected final JSResolveResult.ProblemKind processCheckers(@NotNull PsiElement element, @NotNull SinkResolveProcessor<?> resolveProcessor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(resolveProcessor, (String)"resolveProcessor");
        for (JSAccessibilityChecker checker : this.getCheckers()) {
            JSResolveResult.ProblemKind check;
            if (!checker.isAvailable(this, resolveProcessor) || (check = checker.check(this.place, element)) == null) continue;
            return check;
        }
        return null;
    }

    public void setTypeName(@Nullable String qualifiedName) {
    }

    public void configureClassScope(@Nullable JSClass jsClass) {
        this.setMyClassContext(this.configureClassContext(null, jsClass));
    }

    private final ClassContext configureClassContext(JSClass qualifierClass, JSClass thisClass) {
        ClassContext classContext;
        if (thisClass != null) {
            JSClass realThisClass = (JSClass)Companion.getRealElement((PsiElement)thisClass);
            Set classes = SequencesKt.toSet((Sequence)SequencesKt.generateSequence((Object)realThisClass, AccessibilityProcessingHandler::configureClassContext$lambda$0));
            classContext = new ClassContext(qualifierClass, classes);
        } else {
            classContext = new ClassContext(qualifierClass, SetsKt.emptySet());
        }
        return classContext;
    }

    public void startingParent(@Nullable PsiElement parent) {
        this.myClassDeclarationStarted = parent instanceof JSClass;
        if (parent instanceof JSClass) {
            JSClass jsClass = (JSClass)Companion.getRealElement(parent);
            if (!this.isProcessingInheritedClasses && this.myClassContext == null) {
                JSClass thisClass = JSResolveUtil.getClassOfContext(this.place);
                this.setMyClassContext(this.configureClassContext(jsClass, thisClass));
            }
            ClassContext classContext = this.myClassContext;
            if (classContext != null) {
                ClassContext it = classContext;
                boolean bl = false;
                it.setMemberOwner(jsClass);
            }
        } else if (parent instanceof JSAttributeListOwner) {
            if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)parent, JSAttributeList.ModifierType.STATIC)) {
                this.isProcessStatics = true;
            }
        } else if (parent instanceof JSFile || parent instanceof JSPackageStatement || parent instanceof XmlTag) {
            this.isProcessStatics = false;
        }
    }

    private static final JSClass configureClassContext$lambda$0(JSClass it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (JSClass)PsiTreeUtil.getParentOfType((PsiElement)it, JSClass.class);
    }

    @NotNull
    protected static final List<JSAccessibilityChecker> getCHECKERS() {
        return Companion.getCHECKERS();
    }

    @JvmStatic
    public static final <T extends JSResolveProcessor> boolean processWithStatic(@NotNull T processor, boolean newStatic, @NotNull Supplier<Boolean> action) {
        return Companion.processWithStatic(processor, newStatic, action);
    }

    static {
        Object[] objectArray = new JSAccessibilityChecker[]{TypeScriptImportTypeChecker.INSTANCE, TypeScriptConfigAccessibilityChecker.INSTANCE, TypeScriptModuleAccessibilityChecker.INSTANCE, ES6ExportOnlyAccessibilityChecker.INSTANCE, TypeScriptClassTypeParametersChecker.INSTANCE};
        CHECKERS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0019\u001a\u00020\u0012H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR(\u0010\r\u001a\u0004\u0018\u00010\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler$ClassContext;", "", "qualifierClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "thisClasses", "", "<init>", "(Lcom/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler;Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;Ljava/util/Set;)V", "getQualifierClass", "()Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "getThisClasses", "()Ljava/util/Set;", "value", "memberOwner", "getMemberOwner", "setMemberOwner", "(Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;)V", "acceptPrivateMembers", "", "getAcceptPrivateMembers", "()Z", "_acceptProtectedMembers", "Ljava/lang/Boolean;", "acceptProtectedMembers", "getAcceptProtectedMembers", "computeAcceptProtected", "intellij.javascript.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nAccessibilityProcessingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessibilityProcessingHandler.kt\ncom/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler$ClassContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,320:1\n1755#2,3:321\n*S KotlinDebug\n*F\n+ 1 AccessibilityProcessingHandler.kt\ncom/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler$ClassContext\n*L\n313#1:321,3\n*E\n"})
    private final class ClassContext {
        @Nullable
        private final JSClass qualifierClass;
        @NotNull
        private final Set<JSClass> thisClasses;
        @Nullable
        private JSClass memberOwner;
        @Nullable
        private Boolean _acceptProtectedMembers;

        public ClassContext(@NotNull JSClass qualifierClass, Set<? extends JSClass> thisClasses) {
            Intrinsics.checkNotNullParameter(thisClasses, (String)"thisClasses");
            this.qualifierClass = qualifierClass;
            this.thisClasses = thisClasses;
        }

        @Nullable
        public final JSClass getQualifierClass() {
            return this.qualifierClass;
        }

        @NotNull
        public final Set<JSClass> getThisClasses() {
            return this.thisClasses;
        }

        @Nullable
        public final JSClass getMemberOwner() {
            return this.memberOwner;
        }

        public final void setMemberOwner(@Nullable JSClass value) {
            this._acceptProtectedMembers = null;
            this.memberOwner = value;
        }

        public final boolean getAcceptPrivateMembers() {
            return this.memberOwner == null || CollectionsKt.contains((Iterable)this.thisClasses, (Object)this.memberOwner);
        }

        public final boolean getAcceptProtectedMembers() {
            Boolean value = this._acceptProtectedMembers;
            if (value != null) {
                return value;
            }
            this._acceptProtectedMembers = value = Boolean.valueOf(this.computeAcceptProtected());
            return value;
        }

        private final boolean computeAcceptProtected() {
            JSClass memberOwner = this.memberOwner;
            if (memberOwner == null) {
                return false;
            }
            if (this.thisClasses.contains(memberOwner)) {
                return true;
            }
            if (this.qualifierClass == null) {
                return false;
            }
            if (AccessibilityProcessingHandler.this.isProcessStatics() || AccessibilityProcessingHandler.this.isConstructorWithNew) {
                boolean acceptProtected = !JSTypeEvaluateManager.iterateTypeHierarchyFromJSClasses((Collection<JSClass>)this.thisClasses, false, (Processor<? super JSClass>)((Processor)arg_0 -> ClassContext.computeAcceptProtected$lambda$1(arg_0 -> ClassContext.computeAcceptProtected$lambda$0(memberOwner, arg_0), arg_0)));
                return acceptProtected;
            }
            boolean acceptProtected = this.thisClasses.contains(this.qualifierClass) || !JSTypeEvaluateManager.iterateTypeHierarchyFromJSClasses(CollectionsKt.listOf((Object)this.qualifierClass), false, (Processor<? super JSClass>)((Processor)arg_0 -> ClassContext.computeAcceptProtected$lambda$3(arg_0 -> ClassContext.computeAcceptProtected$lambda$2(this, arg_0), arg_0)));
            return acceptProtected;
        }

        private static final boolean computeAcceptProtected$lambda$0(JSClass $memberOwner, JSClass it) {
            return !$memberOwner.isEquivalentTo(it);
        }

        private static final boolean computeAcceptProtected$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean computeAcceptProtected$lambda$2(ClassContext this$0, JSClass it) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this$0.thisClasses;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiElement p0 = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (!it.isEquivalentTo(p0)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return !bl;
        }

        private static final boolean computeAcceptProtected$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001d\u0010\u0015\u001a\u0002H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u00142\u0006\u0010\u0017\u001a\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J5\u0010\u0019\u001a\u00020\u0012\"\b\b\u0000\u0010\u0016*\u00020\u001a2\u0006\u0010\u001b\u001a\u0002H\u00162\u0006\u0010\u001c\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001eH\u0007\u00a2\u0006\u0002\u0010\u001fR\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler$Companion;", "", "<init>", "()V", "CHECKERS", "", "Lcom/intellij/lang/javascript/psi/resolve/accessibility/JSAccessibilityChecker;", "getCHECKERS$annotations", "getCHECKERS", "()Ljava/util/List;", "MAX_DEPTH", "", "findOwnOrParentConstructor", "Lcom/intellij/lang/javascript/psi/JSFunction;", "jsClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "depth", "isParentClassContext", "", "element", "Lcom/intellij/psi/PsiElement;", "getRealElement", "T", "psiElement", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "processWithStatic", "Lcom/intellij/lang/javascript/psi/resolve/processors/JSResolveProcessor;", "processor", "newStatic", "action", "Ljava/util/function/Supplier;", "(Lcom/intellij/lang/javascript/psi/resolve/processors/JSResolveProcessor;ZLjava/util/function/Supplier;)Z", "intellij.javascript.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final List<JSAccessibilityChecker> getCHECKERS() {
            return CHECKERS;
        }

        @JvmStatic
        protected static /* synthetic */ void getCHECKERS$annotations() {
        }

        private final JSFunction findOwnOrParentConstructor(JSClass jsClass, int depth) {
            JSFunction constructor = JSResolveUtil.getClassConstructor(jsClass);
            if (constructor != null || depth >= 10) {
                return constructor;
            }
            JSClass[] jSClassArray = jsClass.getSuperClasses();
            Intrinsics.checkNotNullExpressionValue((Object)jSClassArray, (String)"getSuperClasses(...)");
            for (JSClass cl : jSClassArray) {
                Intrinsics.checkNotNull((Object)cl);
                JSFunction jSFunction = constructor = this.findOwnOrParentConstructor(cl, depth + 1);
                if (jSFunction == null) continue;
                return jSFunction;
            }
            return null;
        }

        public final boolean isParentClassContext(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement parent = JSResolveUtil.findParent(element);
            return parent instanceof JSClass || parent instanceof TypeScriptFunction && ((TypeScriptFunction)parent).isConstructor();
        }

        @NotNull
        public final <T extends PsiElement> T getRealElement(@NotNull T psiElement) {
            Intrinsics.checkNotNullParameter(psiElement, (String)"psiElement");
            if (IntentionPreviewUtils.isPreviewElement(psiElement)) {
                return psiElement;
            }
            PsiElement realElement = CompletionUtilCoreImpl.getOriginalElement(psiElement);
            Object object = realElement;
            if (object == null) {
                object = psiElement;
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T extends JSResolveProcessor> boolean processWithStatic(@NotNull T processor, boolean newStatic, @NotNull Supplier<Boolean> action) {
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            if (!(processor instanceof ResolveProcessor)) {
                Boolean bl = action.get();
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
                return bl;
            }
            AccessibilityProcessingHandler accessibilityProcessingHandler = ((ResolveProcessor)processor).getAccessibilityProcessingHandler();
            Intrinsics.checkNotNullExpressionValue((Object)accessibilityProcessingHandler, (String)"getAccessibilityProcessingHandler(...)");
            AccessibilityProcessingHandler handler = accessibilityProcessingHandler;
            boolean oldValue = handler.isProcessStatics();
            handler.setProcessStatics(newStatic);
            try {
                Boolean bl = action.get();
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
                boolean bl2 = bl;
                return bl2;
            }
            finally {
                handler.setProcessStatics(oldValue);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

