/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSMergeResolveProcessor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSSuperMemberResolveProcessor
extends ResolveProcessor {
    private final PsiElement myContext;
    private final boolean myOnlyFunctions;
    private final String myNamespace;
    private boolean acceptGetter;
    private boolean acceptSetter;
    private boolean isStaticContext;
    private final JSMergeResolveProcessor processor;

    JSSuperMemberResolveProcessor(@NotNull String name, @Nullable PsiElement context2, boolean onlyFunctions, @Nullable String namespace) {
        if (name == null) {
            JSSuperMemberResolveProcessor.$$$reportNull$$$0(0);
        }
        super(name, context2);
        this.myContext = context2;
        this.processor = new JSMergeResolveProcessor(name, false);
        this.myOnlyFunctions = onlyFunctions;
        this.myNamespace = namespace;
        this.acceptGetter = false;
        this.acceptSetter = false;
        this.isStaticContext = false;
        if (context2 instanceof JSFunction && JSPsiImplUtils.isGetterOrSetter((JSFunction)context2)) {
            this.acceptGetter = ((JSFunction)context2).isGetProperty();
            this.acceptSetter = ((JSFunction)context2).isSetProperty();
        }
        if (context2 instanceof JSFunction || context2 instanceof JSField) {
            this.isStaticContext = ((JSQualifiedNamedElement)context2).getJSContext() == JSContext.STATIC;
        }
        this.setLocalResolve(true);
        this.setToProcessHierarchy(true);
        this.setToProcessActionScriptImplicits(false);
    }

    @NotNull
    List<PsiElement> getResults() {
        List<PsiElement> list = this.processor.getResults();
        if (list == null) {
            JSSuperMemberResolveProcessor.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            JSSuperMemberResolveProcessor.$$$reportNull$$$0(2);
        }
        if (state == null) {
            JSSuperMemberResolveProcessor.$$$reportNull$$$0(3);
        }
        if (element instanceof JSFunction) {
            JSFunction jsFunction = (JSFunction)element;
            if (jsFunction.isConstructor()) {
                return true;
            }
            if (jsFunction.isGetProperty() && !this.acceptGetter && !(this.myContext instanceof JSField)) {
                return true;
            }
            if (jsFunction.isSetProperty() && !this.acceptSetter && !(this.myContext instanceof JSField)) {
                return true;
            }
        }
        if (this.isAcceptableElement(element)) {
            boolean currentStatic;
            boolean bl = currentStatic = ((JSQualifiedNamedElement)element).getJSContext() == JSContext.STATIC;
            if (currentStatic != this.isStaticContext) {
                return true;
            }
            if (!JSInheritanceUtil.isRealOverride((JSAttributeListOwner)element, this.myNamespace, this.myContext)) {
                return true;
            }
            return this.processor.execute(element, state);
        }
        return true;
    }

    private boolean isAcceptableElement(@NotNull PsiElement element) {
        if (element == null) {
            JSSuperMemberResolveProcessor.$$$reportNull$$$0(4);
        }
        return !this.myOnlyFunctions && (element instanceof JSField || element instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)element)) || element instanceof JSFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSSuperMemberResolveProcessor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSSuperMemberResolveProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

