/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptMergedTypeImplicitElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSCompleteTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualifiedItemProcessor<T extends ResultSink>
extends SinkResolveProcessor<T>
implements JSQualifiedItemProcessor,
JSModuleElementsProcessor {
    public TypeResolveState resolved;

    public QualifiedItemProcessor(@NotNull T sink, @NotNull PsiFile containingFile) {
        if (sink == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(0);
        }
        if (containingFile == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(1);
        }
        super(sink);
        this.resolved = TypeResolveState.Unknown;
        this.setToProcessHierarchy(true);
    }

    protected void forceResolvedState() {
        this.resolved = TypeResolveState.Resolved;
    }

    @Override
    public void processAdditionalType(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext) {
        if (type2 == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(2);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(3);
        }
        this.process(type2, evaluateContext);
    }

    @NotNull
    public static Collection<PsiElement> getElementsForTypeMember(@NotNull JSRecordType.TypeMember typeMember, @Nullable PsiElement sourceElement, boolean createImplicitElement) {
        if (typeMember == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(4);
        }
        if (typeMember instanceof PsiElement) {
            List<PsiElement> list = Collections.singletonList((PsiElement)typeMember);
            if (list == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (typeMember instanceof JSCompositeFunctionPropertySignatureImpl) {
            ArrayList<PsiElement> results = new ArrayList<PsiElement>();
            for (JSRecordType.PropertySignature signature : ((JSCompositeFunctionPropertySignatureImpl)typeMember).getMembers()) {
                results.addAll(QualifiedItemProcessor.getElementsForTypeMember(signature, sourceElement, createImplicitElement));
            }
            ArrayList<PsiElement> arrayList = results;
            if (arrayList == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        JSRecordType.MemberSource ownSource = typeMember.getMemberSource();
        if ((createImplicitElement || ownSource.isMerged()) && typeMember instanceof JSRecordType.PropertySignature) {
            JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)typeMember;
            JSType propertySignatureType = propertySignature.getJSType();
            return QualifiedItemProcessor.createImplicitElements(sourceElement, propertySignature, propertySignatureType);
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)ownSource.getSingleElement());
        if (list == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static Collection<PsiElement> createImplicitElements(@Nullable PsiElement sourceElement, @NotNull JSRecordType.PropertySignature propertySignature, @Nullable JSType propertySignatureType) {
        JSRecordType.MemberSource source;
        if (propertySignature == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(8);
        }
        if (!(source = propertySignature.getMemberSource()).isMerged()) {
            List<JSImplicitElement> elementsByName;
            JSElementIndexingData indexingData;
            PsiElement propertySource = source.getSingleElement();
            final boolean hasType = propertySignatureType != null;
            final boolean isConst = propertySignature.isConst();
            PsiElement provider = (PsiElement)ObjectUtils.coalesce((Object)propertySource, (Object)sourceElement);
            if (provider == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    QualifiedItemProcessor.$$$reportNull$$$0(9);
                }
                return list;
            }
            String name = propertySignature.getMemberName();
            if (provider instanceof JSDocComment && (indexingData = ((JSDocComment)provider).getIndexingData()) != null && (elementsByName = indexingData.findElementsByNameOrQName(propertySignature.getMemberName())).size() == 1) {
                List<PsiElement> list = List.of((PsiElement)elementsByName.get(0));
                if (list == null) {
                    QualifiedItemProcessor.$$$reportNull$$$0(10);
                }
                return list;
            }
            JSLocalImplicitElementImpl element = new JSLocalImplicitElementImpl(name, propertySignatureType, provider, null){

                @Override
                public boolean hasMinorImportance() {
                    return !hasType;
                }

                @Override
                public boolean isConst() {
                    return isConst;
                }
            };
            List list = ContainerUtil.createMaybeSingletonList((Object)element);
            if (list == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<PsiElement> elements = source.getAllSourceElements();
        boolean readonly = propertySignature.isConst() || source.isReadonly() || source.isForceReadonly();
        boolean optional = propertySignature.isOptional() || source.isForceOptional();
        boolean hasSingleDoc = source.hasSingleDocumentation();
        Collection collection = elements.stream().filter(e -> e != null).map(e -> new TypeScriptMergedTypeImplicitElementImpl(propertySignature.getMemberName(), propertySignatureType, (PsiElement)e, readonly, optional, hasSingleDoc, source.getSourceKind())).collect(Collectors.toList());
        if (collection == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(13);
        }
        if (state == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(14);
        }
        if (this.resolved == TypeResolveState.PrefixUnknown && this.myName != null && element instanceof JSFunction && !(this.place.getParent() instanceof JSCallExpression)) {
            return true;
        }
        return super.execute(element, state);
    }

    public boolean noMoreResultsPossible() {
        return this.resolved == TypeResolveState.Resolved;
    }

    public ResolveResult @Nullable [] getResultsIfResolveCompleted() {
        return this.getResultsIfResolveCompletedJS();
    }

    protected ResolveResult @Nullable [] getResultsIfResolveCompletedJS() {
        ResolveResultSink sink = (ResolveResultSink)this.getResultSink();
        if (this.noMoreResultsPossible() || sink.getCompleteResult() != null) {
            return this.getResultsAsResolveResults();
        }
        return null;
    }

    public void evaluateExpressionOrElementType(@NotNull PsiElement element, @Nullable PsiFile targetFile) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(15);
        }
        JSCompleteTypeEvaluationProcessor.evaluateTypes(element, targetFile, (JSTypeProcessor)this, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySignature";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForTypeMember";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplicitElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAdditionalType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForTypeMember";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createImplicitElements";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpressionOrElementType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    public static enum TypeResolveState {
        Unknown,
        Resolved,
        PrefixUnknown;


        public boolean isResolved() {
            return this == Resolved;
        }

        public boolean isSuitableForReferenceResolve() {
            return this.isResolved();
        }
    }
}

