/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.evaluable;

import com.intellij.lang.ecmascript6.resolve.JSFileReferenceCache;
import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTaskList;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.ES6ImportCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ThrottledLogger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSRequireCallExpressionType
extends JSEvaluableOnlyTypeBase
implements JSEvaluableOnlyType {
    private static final ThrottledLogger TOO_MANY_MODULES_LOGGER = new ThrottledLogger(Logger.getInstance(JSRequireCallExpressionType.class), TimeUnit.MINUTES.toMillis(1L));
    @NotNull
    private final JSType myReferencedModule;

    public JSRequireCallExpressionType(@NotNull String referencedModule, @NotNull JSTypeSource source) {
        if (referencedModule == null) {
            JSRequireCallExpressionType.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSRequireCallExpressionType.$$$reportNull$$$0(1);
        }
        this(new JSStringLiteralTypeImpl(referencedModule, false, source), source);
    }

    public JSRequireCallExpressionType(@NotNull JSType referencedModule, @NotNull JSTypeSource source) {
        if (referencedModule == null) {
            JSRequireCallExpressionType.$$$reportNull$$$0(2);
        }
        if (source == null) {
            JSRequireCallExpressionType.$$$reportNull$$$0(3);
        }
        super(source);
        this.myReferencedModule = referencedModule;
    }

    public static int getMaxModulesToEvaluateCount() {
        return Registry.intValue((String)"js.max.modules.to.process");
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSRequireCallExpressionType.$$$reportNull$$$0(4);
        }
        this.myReferencedModule.accept(visitor);
    }

    public JSRequireCallExpressionType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSRequireCallExpressionType.$$$reportNull$$$0(5);
        }
        if (inputStream == null) {
            JSRequireCallExpressionType.$$$reportNull$$$0(6);
        }
        super(source);
        this.myReferencedModule = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSRequireCallExpressionType.$$$reportNull$$$0(7);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myReferencedModule, outputStream);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        JSType newModule;
        if (childTransform == null) {
            JSRequireCallExpressionType.$$$reportNull$$$0(8);
        }
        if (newSource == null) {
            JSRequireCallExpressionType.$$$reportNull$$$0(9);
        }
        if ((newModule = this.myReferencedModule.transformTypeHierarchy(childTransform)) == this.myReferencedModule) {
            JSRequireCallExpressionType jSRequireCallExpressionType = this;
            if (jSRequireCallExpressionType == null) {
                JSRequireCallExpressionType.$$$reportNull$$$0(10);
            }
            return jSRequireCallExpressionType;
        }
        return new JSRequireCallExpressionType(newModule, newSource);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.getSourceElement(), this.myReferencedModule);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type2, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type2 == null) {
            JSRequireCallExpressionType.$$$reportNull$$$0(11);
        }
        return Objects.equals(this.getSourceElement(), type2.getSourceElement()) && this.myReferencedModule.isEquivalentTo(((JSRequireCallExpressionType)type2).myReferencedModule, processingContext, allowResolve);
    }

    @NotNull
    public String resolveReferencedModule() {
        JSType substitute = this.myReferencedModule.substitute();
        if (substitute instanceof JSStringLiteralTypeImpl) {
            String string = ((JSStringLiteralTypeImpl)substitute).getLiteral();
            if (string == null) {
                JSRequireCallExpressionType.$$$reportNull$$$0(12);
            }
            return string;
        }
        return "";
    }

    @Override
    @NotNull
    protected JSRequireCallExpressionType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSRequireCallExpressionType.$$$reportNull$$$0(13);
        }
        return new JSRequireCallExpressionType(this.myReferencedModule, source);
    }

    @Override
    @NotNull
    public JSEvaluationTask evaluate(@NotNull JSEvaluateContext evaluateContext) {
        if (evaluateContext == null) {
            JSRequireCallExpressionType.$$$reportNull$$$0(14);
        }
        String referencedModule = this.resolveReferencedModule();
        PsiFile scope2 = this.getScope();
        if (scope2 == null) {
            JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
            if (jSEvaluationTaskList == null) {
                JSRequireCallExpressionType.$$$reportNull$$$0(15);
            }
            return jSEvaluationTaskList;
        }
        Collection<PsiElement> elements = JSFileReferenceCache.getInstance(scope2.getProject()).resolveModuleReference((PsiElement)scope2, referencedModule, false);
        int maxModulesToEvaluateCount = JSRequireCallExpressionType.getMaxModulesToEvaluateCount();
        if (elements.size() > maxModulesToEvaluateCount || elements.isEmpty()) {
            JSExpression methodExpression;
            if (elements.size() > maxModulesToEvaluateCount) {
                TOO_MANY_MODULES_LOGGER.warn("Too many resolved modules (" + elements.size() + ") for " + referencedModule);
            }
            PsiElement sourceElement = this.getSourceElement();
            if (this.isJavaScript()) {
                JSEvaluationResultElement jSEvaluationResultElement = JSRequireCallExpressionType.getTaskForUnknownElement(sourceElement, evaluateContext);
                if (jSEvaluationResultElement == null) {
                    JSRequireCallExpressionType.$$$reportNull$$$0(16);
                }
                return jSEvaluationResultElement;
            }
            if (sourceElement instanceof JSCallExpression && ((JSCallExpression)sourceElement).isRequireCall() && (methodExpression = ((JSCallExpression)sourceElement).getMethodExpression()) != null) {
                JSApplyCallType type2 = new JSApplyCallType((JSType)JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)methodExpression, evaluateContext), JSTypeSourceFactory.createTypeSource(sourceElement, true));
                JSEvaluationResultElement jSEvaluationResultElement = JSEvaluationResultElement.fromType(type2, evaluateContext);
                if (jSEvaluationResultElement == null) {
                    JSRequireCallExpressionType.$$$reportNull$$$0(17);
                }
                return jSEvaluationResultElement;
            }
            JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
            if (jSEvaluationTaskList == null) {
                JSRequireCallExpressionType.$$$reportNull$$$0(18);
            }
            return jSEvaluationTaskList;
        }
        List tasks = ContainerUtil.map(elements, element -> JSEvaluationResultElement.fromType(ES6ImportCallType.getTypeFromModuleReferenceResolveResult(evaluateContext, element, true).copyWithStrict(this.isSourceStrict()), evaluateContext));
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromSet(tasks, this.isJavaScript());
        if (jSEvaluationTask == null) {
            JSRequireCallExpressionType.$$$reportNull$$$0(19);
        }
        return jSEvaluationTask;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 15, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedModule";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSRequireCallExpressionType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSRequireCallExpressionType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferencedModule";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12, 15, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

