/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.concurrency.ThreadContext;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ObjectUtils;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a\u0006\u0010\r\u001a\u00020\u000e\"\u0014\u0010\u0003\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0018\u0010\u0006\u001a\u00020\u0001*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"normalizedNameAndPath", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "currentThreadDebugInfo", "getCurrentThreadDebugInfo", "()Ljava/lang/String;", "debugString", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;", "getDebugString", "(Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;)Ljava/lang/String;", "adjustIntoIdentifier", "Lcom/intellij/psi/PsiElement;", "originalElement", "isCommandFromDispatchThread", "", "intellij.javascript.impl"})
public final class JSLanguageServiceUtilKt {
    @Nullable
    public static final String normalizedNameAndPath(@NotNull VirtualFile $this$normalizedNameAndPath) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizedNameAndPath, (String)"<this>");
        return JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks($this$normalizedNameAndPath);
    }

    @NotNull
    public static final String getCurrentThreadDebugInfo() {
        return "[Thread " + Thread.currentThread().getId() + "]";
    }

    @NotNull
    public static final String getDebugString(@NotNull JSLanguageServiceCommand $this$debugString) {
        Intrinsics.checkNotNullParameter((Object)$this$debugString, (String)"<this>");
        return $this$debugString.getCommand() + "@" + System.identityHashCode($this$debugString);
    }

    @NotNull
    public static final PsiElement adjustIntoIdentifier(@NotNull PsiElement originalElement) {
        ASTNode name;
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        PsiElement originalElement2 = originalElement;
        if (originalElement2 instanceof JSImplicitElement) {
            originalElement2 = (PsiElement)ObjectUtils.coalesce((Object)originalElement2.getParent(), (Object)originalElement2);
        }
        if (originalElement2 instanceof PsiNameIdentifierOwner) {
            PsiElement identifier = ((PsiNameIdentifierOwner)originalElement2).getNameIdentifier();
            originalElement2 = (PsiElement)ObjectUtils.coalesce((Object)identifier, (Object)originalElement2);
        } else if (originalElement2 instanceof JSReferenceExpression) {
            originalElement2 = (PsiElement)ObjectUtils.coalesce((Object)((JSReferenceExpression)originalElement2).getReferenceNameElement(), (Object)originalElement2);
        } else if (originalElement2 instanceof JSThisExpression) {
            originalElement2 = (PsiElement)ObjectUtils.coalesce((Object)((JSThisExpression)originalElement2).getFirstChild(), (Object)originalElement2);
        } else if (originalElement2 instanceof XmlTag && (name = XmlChildRole.START_TAG_NAME_FINDER.findChild(originalElement2.getNode())) != null) {
            originalElement2 = (PsiElement)ObjectUtils.coalesce((Object)name.getPsi(), (Object)originalElement2);
        }
        return originalElement2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCommandFromDispatchThread() {
        if (ApplicationKt.getApplication().isDispatchThread()) return true;
        CoroutineName coroutineName = (CoroutineName)ThreadContext.currentThreadContext().get((CoroutineContext.Key)CoroutineName.Key);
        if (!Intrinsics.areEqual((Object)(coroutineName != null ? coroutineName.getName() : null), (Object)"runUpdateSessionForInputEvent")) return false;
        return true;
    }
}

