/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.ES6CreateClassOrInterfaceFix;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSScopeSelectionUI;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.extractMethod.JSIntroduceFunctionScopeSelectionPopup;
import com.intellij.lang.javascript.refactoring.extractMethod.JSSignatureContext;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionActionBase;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CreateJSFunctionIntentionAction
extends CreateJSFunctionIntentionActionBase {
    public static final String ATTRIBUTE_SEMICOLON = "SEMICOLON";
    private final boolean myIsMethod;
    private final boolean myIsModuleScope;
    private final boolean myIsAsync;
    private final boolean myIsArrow;
    private final String myFunctionName;
    private static final String ourJSImplementedMethodBodyTemplate = "JavaScript Implemented Method Body.js";
    private static final String ATTRIBUTE_IS_ASSIGNMENT_TARGET = "IS_ASSIGNMENT_TARGET";
    private static final String ATTRIBUTE_IS_NEW_CALL = "IS_NEW_CALL";
    private static final String ATTRIBUTE_HAS_EXPECTED_TYPE = "HAS_EXPECTED_TYPE";

    public CreateJSFunctionIntentionAction(String name, boolean isMethod, boolean isModuleScope) {
        this(name, isMethod, isModuleScope, false, false);
    }

    public CreateJSFunctionIntentionAction(String name, boolean isMethod, boolean isModuleScope, boolean isAsync, boolean isArrow) {
        super(name, isMethod && !isModuleScope ? "javascript.create.method.intention.name" : "javascript.create.function.intention.name");
        this.myFunctionName = name;
        this.myIsMethod = isMethod;
        this.myIsModuleScope = isModuleScope;
        this.myIsAsync = isAsync;
        this.myIsArrow = isArrow;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myIsArrow) {
            if (this.myIsProperty) {
                String string = JavaScriptBundle.message("javascript.create.property.holding.arrow.function.intention.name", this.myFunctionName);
                if (string == null) {
                    CreateJSFunctionIntentionAction.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (this.myIsMethod) {
                String string = JavaScriptBundle.message("javascript.create.field.holding.arrow.function.intention.name", this.myFunctionName);
                if (string == null) {
                    CreateJSFunctionIntentionAction.$$$reportNull$$$0(1);
                }
                return string;
            }
            if (DialectDetector.hasFeature(this.myElementPointer.getElement(), JSLanguageFeature.CONST_DEFINITIONS)) {
                String string = JavaScriptBundle.message("javascript.create.constant.holding.arrow.function.intention.name", this.myFunctionName);
                if (string == null) {
                    CreateJSFunctionIntentionAction.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = JavaScriptBundle.message("javascript.create.variable.holding.arrow.function.intention.name", this.myFunctionName);
            if (string == null) {
                CreateJSFunctionIntentionAction.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.myIsProperty ? JavaScriptBundle.message("javascript.create.function.property.intention.name", this.myFunctionName) : super.getName();
        if (string == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = this.myIsArrow ? PriorityAction.Priority.NORMAL : PriorityAction.Priority.HIGH;
        if (priority == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(5);
        }
        return priority;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, @NotNull PsiFile file, @Nullable Editor editor) {
        if (file == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(6);
        }
        this.applyFixWithScopeSelection(project, psiElement, file, editor, ApplicationManager.getApplication().isUnitTestMode() ? (defaultSuggestedScope, scopeList, cb) -> cb.accept(CreateJSFunctionIntentionAction.chooseIntroductionScopeForTest(psiElement, scopeList)) : new JSIntroduceFunctionScopeSelectionPopup(editor));
    }

    public void applyFixWithScopeSelection(Project project, final PsiElement psiElement, PsiFile file, Editor editor, JSScopeSelectionUI<JSExtractFunctionHandler.IntroductionScope> scopeSelectionUi) {
        if (psiElement == null) {
            return;
        }
        JSExtractFunctionHandler extractFunctionHandler = JSExtractFunctionHandler.forContext(psiElement);
        JSReferenceExpression referenceExpression = (JSReferenceExpression)this.calculateAnchors((PsiElement)psiElement).first;
        if (CreateJSFunctionIntentionAction.getScopeFromReferenceExpression(referenceExpression) != null) {
            this.doApplyFix(project, psiElement, file, editor);
            return;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(psiElement);
        List scopes = extractFunctionHandler.findBases(psiElement, false);
        if (referenceExpression != null && referenceExpression.getQualifier() == null) {
            boolean isEs6Class = JSClassUtils.isES6ClassImplementation(dialect);
            scopes = ContainerUtil.filter(scopes, scope2 -> {
                if (scope2.getParent() instanceof JSObjectLiteralExpression) {
                    return false;
                }
                if (isEs6Class) {
                    return scope2.isClassContext() == this.myIsMethod;
                }
                return true;
            });
        }
        final List finalScopes = scopes;
        final boolean isActionScript = dialect != null && dialect.isECMA4;
        final boolean isTypeScript = dialect != null && dialect.isTypeScript;
        JSSignatureContext context2 = new JSSignatureContext(){

            @Override
            public boolean isActionScript() {
                return isActionScript;
            }

            @Override
            public boolean isTypeScript() {
                return isTypeScript;
            }

            @Override
            public boolean isAsync() {
                return false;
            }

            @Override
            @NotNull
            public JSContext getJSContext() {
                JSContext jSContext = JSContext.UNKNOWN;
                if (jSContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                return jSContext;
            }

            @Override
            public PsiElement getContextElement() {
                return psiElement;
            }

            @Override
            @NotNull
            public List<JSExtractFunctionHandler.IntroductionScope> getIntroductionScopes() {
                List list = finalScopes;
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getJSContext";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIntroductionScopes";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        Consumer<JSExtractFunctionHandler.IntroductionScope> callback = scope2 -> {
            if (scope2.isClassContext()) {
                this.doApplyFix(project, psiElement, file, editor);
            } else {
                boolean placeAtScopeStart = JSCodeStyleSettings.isLocalDeclarationsAtScopeStart(psiElement);
                PsiElement anchor = JSPsiImplUtils.findLeadingCommentOrSelf(JSUtils.findFunctionAnchor(scope2.getParent(), psiElement, placeAtScopeStart));
                JSTypeEvaluationLocationProvider.withTypeEvaluationLocation(psiElement, () -> this.doApplyFix(project, psiElement, file, editor, anchor, scope2.getParent()));
            }
        };
        extractFunctionHandler.chooseIntroductionScope(context2, callback, scopeSelectionUi, this.myFunctionName);
    }

    @TestOnly
    private static JSExtractFunctionHandler.IntroductionScope chooseIntroductionScopeForTest(@NotNull PsiElement usageElement, @NotNull List<JSScopeSelectionUI.ScopePresentation<JSExtractFunctionHandler.IntroductionScope>> presentations) {
        List scopes;
        if (usageElement == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(7);
        }
        if (presentations == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(8);
        }
        if ((scopes = ContainerUtil.map(presentations, presentation -> (JSExtractFunctionHandler.IntroductionScope)presentation.getScope())).isEmpty()) {
            throw new RuntimeException("No available scopes");
        }
        if (scopes.size() == 1) {
            return (JSExtractFunctionHandler.IntroductionScope)scopes.get(0);
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)usageElement, JSStatement.class, (boolean)false);
        if (statement == null) {
            throw new RuntimeException("Could not find statement from usage");
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)statement);
        if (docComment instanceof JSDocComment) {
            String scopePresentation = docComment.getText().substring(3, docComment.getTextLength() - 2).trim();
            for (JSExtractFunctionHandler.IntroductionScope scope2 : scopes) {
                if (!scopePresentation.equals(scope2.toString())) continue;
                return scope2;
            }
            throw new RuntimeException("Scope with name " + scopePresentation + " not found");
        }
        return (JSExtractFunctionHandler.IntroductionScope)scopes.get(scopes.size() - 1);
    }

    @Nullable
    private static PsiElement getScopeFromReferenceExpression(@Nullable JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            return null;
        }
        JSExpression qualifier = referenceExpression.getQualifier();
        return qualifier != null ? CreateJSFunctionIntentionAction.getScope(qualifier, referenceExpression.getContainingFile()) : null;
    }

    @Override
    protected void writeFunctionAndName(Template template, String createdMethodName, @NotNull PsiElement anchorParent, @Nullable PsiElement clazz, JSReferenceExpression referenceExpression) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(9);
        }
        String generics = CreateJSFunctionIntentionAction.getGenericArgumentsString(anchorParent, clazz, referenceExpression);
        if (this.isObjectProperty(anchorParent)) {
            template.addTextSegment(CreateJSFunctionIntentionAction.afterLastDotSubstr(createdMethodName));
            if (this.myIsArrow) {
                template.addTextSegment(": ");
            } else if (!DialectDetector.hasFeature(anchorParent, JSLanguageFeature.METHOD_DEFINITION_SHORTHANDS)) {
                template.addTextSegment(": ");
                template.addTextSegment(this.getFunctionKeywords());
            }
            template.addTextSegment(generics);
            return;
        }
        if (clazz != null) {
            if (this.myIsArrow) {
                template.addTextSegment(CreateJSFunctionIntentionAction.afterLastDotSubstr(createdMethodName));
                template.addTextSegment(clazz instanceof JSClass && ((JSClass)clazz).isInterface() ? ": " : CreateJSFunctionIntentionAction.getAssignStr(anchorParent));
                if (this.myIsAsync) {
                    template.addTextSegment("async ");
                }
            } else {
                if (this.myIsAsync) {
                    template.addTextSegment("async ");
                }
                template.addTextSegment(JSClassUtils.createClassFunctionName(CreateJSFunctionIntentionAction.afterLastDotSubstr(createdMethodName), anchorParent));
            }
            template.addTextSegment(generics);
            return;
        }
        if (this.isSimpleFunction(anchorParent, referenceExpression)) {
            if (this.myIsArrow) {
                template.addTextSegment(this.getConstOrVarWithSpace());
                template.addTextSegment(createdMethodName);
                template.addTextSegment(CreateJSFunctionIntentionAction.getAssignStr(anchorParent));
            } else {
                template.addTextSegment(this.getFunctionKeywords());
                template.addTextSegment(createdMethodName);
            }
            template.addTextSegment(generics);
            return;
        }
        boolean hasDot = CreateJSFunctionIntentionAction.hasDot(createdMethodName);
        if (this.isExportedFunction(referenceExpression, hasDot, anchorParent)) {
            template.addTextSegment(this.isExportDefault() ? "export default " : "export ");
            if (this.myIsArrow) {
                template.addTextSegment(this.getConstOrVarWithSpace());
                template.addTextSegment(CreateJSFunctionIntentionAction.afterLastDotSubstr(createdMethodName));
                template.addTextSegment(CreateJSFunctionIntentionAction.getAssignStr(anchorParent));
            } else {
                template.addTextSegment(this.getFunctionKeywords());
                template.addTextSegment(CreateJSFunctionIntentionAction.afterLastDotSubstr(createdMethodName));
            }
            template.addTextSegment(generics);
            return;
        }
        if (!hasDot) {
            template.addTextSegment(JSChangeUtil.getVariablePrefix(anchorParent) + " ");
        }
        template.addTextSegment(createdMethodName);
        template.addTextSegment(CreateJSFunctionIntentionAction.getAssignStr(anchorParent));
        if (!this.myIsArrow) {
            template.addTextSegment(this.getFunctionKeywords());
        }
        template.addTextSegment(generics);
    }

    private static String afterLastDotSubstr(@NotNull String string) {
        if (string == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(10);
        }
        return string.substring(string.lastIndexOf(46) + 1);
    }

    private static String getGenericArgumentsString(@NotNull PsiElement anchorParent, PsiElement clazz, @Nullable JSReferenceExpression referenceExpression) {
        PsiElement parent;
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(11);
        }
        String genericArguments = null;
        if (referenceExpression != null && DialectDetector.hasFeature(anchorParent, JSLanguageFeature.GENERICS) && (parent = referenceExpression.getParent()) instanceof JSCallItem) {
            JSTypeDeclaration[] arguments = ((JSCallItem)parent).getTypeArguments();
            genericArguments = ES6CreateClassOrInterfaceFix.getTypeArgumentsString(arguments, clazz instanceof TypeScriptTypeParameterListOwner ? ContainerUtil.map2Set((Object[])((TypeScriptTypeParameterListOwner)clazz).getTypeParameters(), p -> p.getName()) : Collections.emptySet());
        }
        if (genericArguments == null) {
            genericArguments = "";
        }
        return genericArguments;
    }

    protected String getFunctionKeywords() {
        return this.myIsAsync ? "async function " : "function ";
    }

    private String getConstOrVarWithSpace() {
        return JSChangeUtil.getVariableKeyword(this.myElementPointer.getElement(), true).getText() + " ";
    }

    private static String getAssignStr(@NotNull PsiElement context2) {
        if (context2 == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(12);
        }
        return JSCodeStyleSettings.getCommonSettings((PsiElement)context2).SPACE_AROUND_ASSIGNMENT_OPERATORS ? " = " : "=";
    }

    private boolean isObjectProperty(@NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(13);
        }
        return anchorParent instanceof JSObjectLiteralExpression && !this.myIsModuleScope;
    }

    private boolean isSimpleFunction(@NotNull PsiElement anchorParent, JSReferenceExpression referenceExpression) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(14);
        }
        return !this.myIsMethod || this.isExportWithoutFrom() || DialectDetector.isActionScript(anchorParent) || DialectDetector.isTypeScript(anchorParent) && referenceExpression != null && referenceExpression.getQualifier() == null;
    }

    private boolean isExportedFunction(JSReferenceExpression referenceExpression, boolean hasDot, @NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(15);
        }
        return referenceExpression == null || hasDot && (referenceExpression.getContainingFile() != anchorParent.getContainingFile() || this.myIsModuleScope);
    }

    private static boolean hasDot(@NotNull String str) {
        if (str == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(16);
        }
        return str.indexOf(46) != -1;
    }

    @Override
    protected void addParameters(Template template, JSReferenceExpression methodExpression, @NotNull PsiElement anchorParent) {
        PsiElement element;
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(17);
        }
        if ((element = methodExpression.getParent()) instanceof JSCallLikeExpression) {
            JSExpression[] arguments = ((JSCallLikeExpression)element).getArguments();
            if (element instanceof ES6TaggedTemplateExpression) {
                CreateJSFunctionIntentionAction.addParameter(template, "strings", DialectDetector.isTypeScript((PsiElement)methodExpression) ? "TemplateStringsArray" : null, (PsiElement)methodExpression, false);
                if (arguments.length > 0) {
                    template.addTextSegment(", ");
                }
            }
            CreateJSFunctionIntentionAction.addParameters(template, arguments, (PsiElement)methodExpression, anchorParent);
        }
    }

    public static void addParameters(@NotNull Template template, JSExpression @NotNull [] expressions, @NotNull PsiElement callExpressionContext, PsiElement anchorParent) {
        if (template == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(18);
        }
        if (callExpressionContext == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(19);
        }
        if (expressions == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(20);
        }
        int paramCount = expressions.length;
        HashSet<Object> usedParameterNames = new HashSet<Object>();
        boolean hasSpread = false;
        for (int i = 0; i < paramCount && !hasSpread; ++i) {
            JSExpression passedParameterValue = expressions[i];
            Object var = passedParameterValue instanceof JSReferenceExpression ? ((JSReferenceExpression)passedParameterValue).getReferenceName() : JSNameSuggestionsUtil.generateVariableNameFromExpression(passedParameterValue, callExpressionContext);
            if (var == null || ((String)var).isEmpty()) {
                var = "param" + (i != 0 ? Integer.toString(i + 1) : "");
            } else {
                String baseName = var;
                int j = 2;
                while (usedParameterNames.contains(var)) {
                    var = baseName + j;
                    ++j;
                }
                usedParameterNames.add(var);
            }
            String typeName = null;
            DialectOptionHolder holder = DialectDetector.dialectOfElement(anchorParent);
            if (passedParameterValue instanceof JSSpreadExpression) {
                hasSpread = true;
                if (CreateJSFunctionIntentionAction.shouldHaveType(holder)) {
                    boolean eraseType = false;
                    for (int j = i + 1; j < paramCount; ++j) {
                        if (!(expressions[j] instanceof JSSpreadExpression)) continue;
                        eraseType = true;
                        break;
                    }
                    if (!eraseType) {
                        JSType innerType = ((JSSpreadExpression)passedParameterValue).getInnerExpressionType();
                        typeName = innerType == null ? null : CreateJSFunctionIntentionAction.getTypeText(innerType, anchorParent);
                    }
                }
            } else if (CreateJSFunctionIntentionAction.shouldHaveType(holder)) {
                JSType type2 = JSResolveUtil.getExpressionJSType(passedParameterValue);
                String string = typeName = type2 == null ? null : CreateJSFunctionIntentionAction.getTypeText(type2, anchorParent);
                if (holder.isTypeScript && (typeName == null || "null".equals(typeName))) {
                    typeName = null;
                }
            }
            if (i != 0) {
                template.addTextSegment(", ");
            }
            CreateJSFunctionIntentionAction.addParameter(template, (String)var, typeName, callExpressionContext, hasSpread);
        }
    }

    private static boolean shouldHaveType(DialectOptionHolder holder) {
        return holder != null && (holder.isTypeScript || holder.isECMA4);
    }

    private static void addParameter(@NotNull Template template, @NotNull String parameterName, @Nullable String typeName, @NotNull PsiElement context2, boolean isRest) {
        if (template == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(21);
        }
        if (parameterName == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(22);
        }
        if (context2 == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(23);
        }
        if (isRest) {
            template.addTextSegment("...");
        }
        ConstantNode expression = new ConstantNode(parameterName);
        template.addVariable(parameterName, (Expression)expression, (Expression)expression, true);
        if (typeName != null) {
            template.addTextSegment(":");
            CreateJSFunctionIntentionAction.addTypeVariable(template, parameterName, context2, typeName);
        }
    }

    @Override
    protected void addReturnType(Template template, JSReferenceExpression referenceExpression, @NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(24);
        }
        this.guessTypeAndAddTemplateVariable(template, referenceExpression, anchorParent, true);
    }

    @Override
    @Nullable
    protected JSReferenceExpression beforeStartTemplateAction(@Nullable JSReferenceExpression referenceExpression, @NotNull Editor editor, @NotNull PsiElement anchor, boolean isStaticContext) {
        JSReferenceExpression superRefExpression;
        if (editor == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(25);
        }
        if (anchor == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(26);
        }
        if ((superRefExpression = super.beforeStartTemplateAction(referenceExpression, editor, anchor, isStaticContext)) == null) {
            return null;
        }
        if (CreateJSFunctionIntentionAction.shouldInsertQualifier(anchor, superRefExpression)) {
            String name;
            JSClass contextClass = JSUtils.getMemberContainingClass(anchor);
            String qualifier = "this";
            if (contextClass != null && isStaticContext && (name = contextClass.getName()) != null) {
                qualifier = name;
            }
            return (JSReferenceExpression)JSInsertThisFix.insertQualifier(superRefExpression, editor, qualifier);
        }
        return superRefExpression;
    }

    private static boolean shouldInsertQualifier(@Nullable PsiElement anchor, JSReferenceExpression superRefExpression) {
        return !DialectDetector.isActionScript((PsiElement)superRefExpression) && superRefExpression.getQualifier() == null && anchor != null && null != JSUtils.getMemberContainingClass(anchor);
    }

    @Override
    protected void addBody(Template template, JSReferenceExpression refExpr, @NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(27);
        }
        template.addTextSegment("\n");
        template.addSelectionStartVariable();
        this.appendFunctionBody(template, refExpr, anchorParent);
        template.addSelectionEndVariable();
        template.addEndVariable();
        template.addTextSegment("\n");
    }

    protected void appendFunctionBody(Template template, JSReferenceExpression refExpr, PsiElement anchorParent) {
        JSType expectedType;
        PsiElement parent = refExpr.getParent();
        JSType jSType = expectedType = parent instanceof JSCallExpression ? JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parent) : null;
        if (parent != null && ES6PsiUtil.isAwaitExpression(parent.getParent())) {
            JSType type2;
            JSType jSType2 = type2 = expectedType == null ? null : JSTypeUtils.getPromiseComponentTypeOrNull(expectedType);
            if (type2 != null) {
                expectedType = type2;
            }
        }
        String methodName = refExpr.getReferenceName();
        assert (methodName != null);
        if (DialectDetector.isTypeScript(anchorParent)) {
            StringBuilder builder2 = new StringBuilder();
            TypeScriptImplementMemberUtil.appendDefaultMethodBody((PsiElement)refExpr, expectedType, builder2, methodName);
            template.addTextSegment(builder2.toString());
        } else {
            CreateJSFunctionIntentionAction.buildImplementedFunctionBody(template, refExpr.getParent() instanceof JSNewExpression, anchorParent.getProject(), CreateJSFunctionIntentionAction.isAssignmentTarget(parent, expectedType), expectedType, methodName, (PsiElement)refExpr);
        }
    }

    private static void buildImplementedFunctionBody(@NotNull Template template, boolean isNewCall, @NotNull Project project, boolean isAssignmentTarget, @Nullable JSType expectedType, @NotNull String methodName, @NotNull PsiElement context2) {
        if (template == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(28);
        }
        if (project == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(29);
        }
        if (methodName == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(30);
        }
        if (context2 == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(31);
        }
        template.addTextSegment(CreateJSFunctionIntentionAction.getImplementedFunctionBodyText(isNewCall, project, isAssignmentTarget, expectedType, methodName, context2));
    }

    @NotNull
    public static String getImplementedFunctionBodyText(boolean isNewCall, @NotNull Project project, boolean isAssignmentTarget, @Nullable JSType expectedType, @NotNull String methodName, @NotNull PsiElement context2) {
        if (project == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(32);
        }
        if (methodName == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(33);
        }
        if (context2 == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(34);
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project);
        FileTemplate fileTemplate = fileTemplateManager.getCodeTemplate(ourJSImplementedMethodBodyTemplate);
        Properties properties2 = fileTemplateManager.getDefaultProperties();
        properties2.setProperty(ATTRIBUTE_HAS_EXPECTED_TYPE, String.valueOf(expectedType != null && !(expectedType instanceof JSVoidType)));
        properties2.setProperty(ATTRIBUTE_IS_NEW_CALL, String.valueOf(isNewCall));
        properties2.setProperty(ATTRIBUTE_IS_ASSIGNMENT_TARGET, String.valueOf(isAssignmentTarget));
        properties2.setProperty(ATTRIBUTE_SEMICOLON, JSCodeStyleSettings.getSemicolon(context2));
        properties2.setProperty("DEFAULT_RETURN_VALUE", JSRefactoringUtil.defaultValueOfType(expectedType));
        properties2.setProperty("METHOD_NAME", methodName);
        String string = TypeScriptImplementMemberUtil.getBodyTextFromTemplate(fileTemplate, properties2);
        if (string == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(35);
        }
        return string;
    }

    private static boolean isAssignmentTarget(PsiElement parent, JSType expectedType) {
        PsiElement parentParent = parent == null ? null : parent.getParent();
        return expectedType != null || parentParent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parentParent).getROperand() == parent || parentParent instanceof JSVariable && ((JSVariable)parentParent).getInitializer() == parent || parentParent instanceof JSReturnStatement || parentParent instanceof JSArgumentList;
    }

    @Override
    protected boolean shouldAppendSemicolon(@NotNull PsiElement anchorParent, PsiElement clazz, String referencedName, JSReferenceExpression referenceExpression) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(36);
        }
        if (this.isObjectProperty(anchorParent) || clazz != null) {
            return false;
        }
        if (this.isSimpleFunction(anchorParent, referenceExpression) || this.isExportedFunction(referenceExpression, CreateJSFunctionIntentionAction.hasDot(referencedName), anchorParent)) {
            return this.myIsArrow;
        }
        return true;
    }

    @Override
    protected boolean isArrow() {
        return this.myIsArrow;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentations";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 27: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorParent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 12: 
            case 23: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 18: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpressionContext";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementedFunctionBodyText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "chooseIntroductionScopeForTest";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeFunctionAndName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "afterLastDotSubstr";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getGenericArgumentsString";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAssignStr";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isObjectProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleFunction";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isExportedFunction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasDot";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addReturnType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "beforeStartTemplateAction";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addBody";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "buildImplementedFunctionBody";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getImplementedFunctionBodyText";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "shouldAppendSemicolon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36 -> new IllegalArgumentException(string);
        };
    }
}

