/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSChangeTypeFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final String myType;
    private final String myNameKey;
    private final String myElementName;

    public JSChangeTypeFix(JSNamedElement namedElement, String typeQName, @PropertyKey(resourceBundle="messages.JavaScriptBundle") @PropertyKey(resourceBundle="messages.JavaScriptBundle") String nameKey) {
        super((PsiElement)namedElement);
        this.myType = typeQName;
        this.myNameKey = nameKey;
        this.myElementName = namedElement.getName();
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message(this.myNameKey, this.myElementName, this.myType);
        if (string == null) {
            JSChangeTypeFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            JSChangeTypeFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            JSChangeTypeFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JSChangeTypeFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            JSChangeTypeFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            JSChangeTypeFix.$$$reportNull$$$0(5);
        }
        JSRefactoringUtil.setType((JSNamedElement)startElement, this.myType);
        ImportUtils.importTypeIfNeeded(startElement, this.myType, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSChangeTypeFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSChangeTypeFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

