/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSDefaultFileReferenceCompletionFilter;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.typescript.modules.resolver.TypeScriptFileReferenceContext;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptFileReferenceCompletionFilter
extends JSDefaultFileReferenceCompletionFilter {
    private final String @NotNull [] myExtensionsWithDot;
    @NotNull
    private final Collection<String> myPatterns;

    @NotNull
    public static Condition<PsiFileSystemItem> createFileFilter(@Nullable PsiElement host, @Nullable TypeScriptConfig config) {
        if (host == null || !host.isValid()) {
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                TypeScriptFileReferenceCompletionFilter.$$$reportNull$$$0(0);
            }
            return condition;
        }
        if (host instanceof JSLiteralExpression || host instanceof PsiComment) {
            return new JSDefaultFileReferenceCompletionFilter(host){

                @Override
                protected boolean shouldExcludeTypes() {
                    return false;
                }
            };
        }
        if (host instanceof ES6ImportDeclaration && ((ES6ImportDeclaration)host).getImportModuleText() != null) {
            return new JSDefaultFileReferenceCompletionFilter(host);
        }
        PsiFile file = host.getContainingFile().getOriginalFile();
        Object[] extensionsWithDot = TypeScriptFileReferenceContext.getTypeScriptExtensionsWithDot(config);
        if (config != null && config.resolveJsonModule()) {
            extensionsWithDot = (String[])ArrayUtil.append((Object[])extensionsWithDot, (Object)".json");
        }
        Collection<String> patterns = TypeScriptFileReferenceCompletionFilter.getAcceptablePatterns(host);
        return new TypeScriptFileReferenceCompletionFilter(file, (String[])extensionsWithDot, patterns);
    }

    TypeScriptFileReferenceCompletionFilter(@Nullable PsiFile file, String @NotNull [] extensionsWithDot, @NotNull Collection<String> patterns) {
        if (patterns == null) {
            TypeScriptFileReferenceCompletionFilter.$$$reportNull$$$0(1);
        }
        if (extensionsWithDot == null) {
            TypeScriptFileReferenceCompletionFilter.$$$reportNull$$$0(2);
        }
        super((PsiElement)file);
        this.myExtensionsWithDot = extensionsWithDot;
        this.myPatterns = patterns;
    }

    @Override
    protected boolean shouldExcludeTypes() {
        return false;
    }

    @Override
    public boolean value(PsiFileSystemItem item) {
        if (!super.value(item)) {
            return false;
        }
        if (!(item instanceof PsiFile)) {
            return true;
        }
        PsiFile psiFile = (PsiFile)item;
        String name = psiFile.getName();
        String extension = JSFileReferencesUtil.findExtension(name, this.myExtensionsWithDot);
        if (extension != null) {
            return true;
        }
        for (String pattern : this.myPatterns) {
            if (!name.endsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Collection<String> getAcceptablePatterns(@Nullable PsiElement host) {
        if (host == null || DumbService.isDumb((Project)host.getProject())) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                TypeScriptFileReferenceCompletionFilter.$$$reportNull$$$0(3);
            }
            return set;
        }
        PsiFile file = host.getContainingFile();
        if (file == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                TypeScriptFileReferenceCompletionFilter.$$$reportNull$$$0(4);
            }
            return set;
        }
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            Collection<TypeScriptModule> patternExternalModules = TypeScriptUtil.getAllPatternExternalModules(file.getProject(), (PsiElement)file);
            SmartList patterns = new SmartList();
            for (TypeScriptModule module : patternExternalModules) {
                String pattern;
                String text = module.getExternalModuleText();
                if (text == null || (pattern = JSStringUtil.unquoteAndUnescapeString(text)).length() <= 1 || !pattern.startsWith("*")) continue;
                patterns.add((Object)StringUtil.trimStart((String)pattern, (String)"*"));
            }
            return CachedValueProvider.Result.create((Object)patterns, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (collection == null) {
            TypeScriptFileReferenceCompletionFilter.$$$reportNull$$$0(5);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/modules/TypeScriptFileReferenceCompletionFilter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionsWithDot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFilter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/modules/TypeScriptFileReferenceCompletionFilter";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptablePatterns";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

