/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.javascript.nodejs.library.core.NodeCoreModulePathMapping;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.modules.JSNodeModuleStructure;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.ES6ExportedMembersByKindIndex;
import com.intellij.lang.javascript.psi.stubs.ES6ExportedNamesIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptComparingUtil;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationModulePathMapping;
import com.intellij.lang.typescript.psi.TypeScriptExcludeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.psi.TypesGlobalPathMapping;
import com.intellij.lang.typescript.psi.TypesModulePathMapping;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.impl.stubs.index.CssClassIndex;
import com.intellij.psi.css.util.CssFileTypeUtil;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class TypeScriptDeclarationMappingsImpl
implements TypeScriptDeclarationMappings {
    private static final String[] EMPTY_EXTENSIONS = new String[]{""};
    private static final String[] JS_GENERATED_EXTENSIONS = TypeScriptUtil.JAVASCRIPT_EXTENSIONS;
    private static final Logger LOGGER = Logger.getInstance(TypeScriptDeclarationMappingsImpl.class);
    @NotNull
    private final Project myProject;
    private final TypeScriptDeclarationModulePathMapping[] myMappings;

    public TypeScriptDeclarationMappingsImpl(@NotNull Project project) {
        if (project == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(0);
        }
        this.myMappings = new TypeScriptDeclarationModulePathMapping[]{new NodeCoreModulePathMapping(), new TypesGlobalPathMapping(), new TypesModulePathMapping()};
        this.myProject = project;
    }

    @Override
    @RequiresReadLock
    @NotNull
    public Collection<JSQualifiedNamedElement> getDeclarationElements(@NotNull PsiNamedElement sourceElement) {
        if (sourceElement == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (DumbService.isDumb((Project)this.myProject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        PsiFile file = sourceElement.getContainingFile();
        if (file == null || TypeScriptUtil.isDefinitionFile(file)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(3);
            }
            return list;
        }
        String name = file.getName();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || !virtualFile.isInLocalFileSystem()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        Set<VirtualFile> allLibraries = TypeScriptLibraryProvider.getAllLibraries(this.myProject);
        if (allLibraries.contains(virtualFile)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (sourceElement instanceof JSQualifiedNamedElement) {
            JSQualifiedNamedElement qualifiedElement = (JSQualifiedNamedElement)sourceElement;
            String fileNameWithoutExtension = JSFileReferencesUtil.getFileNameWithoutExtension(name, TypeScriptUtil.TYPESCRIPT_AND_JS_EXTENSIONS);
            if (StringUtil.isEmpty((String)fileNameWithoutExtension)) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(6);
                }
                return list;
            }
            List<JSQualifiedNamedElement> elements = TypeScriptDeclarationMappingsImpl.resolveModuleForTypeScript(qualifiedElement, fileNameWithoutExtension);
            if (!elements.isEmpty()) {
                List<JSQualifiedNamedElement> list = elements;
                if (list == null) {
                    TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(7);
                }
                return list;
            }
            Collection<VirtualFile> candidates = this.getDeclarationFileCandidatesByName(qualifiedElement, fileNameWithoutExtension);
            return this.getEqualElementsInFiles(qualifiedElement, candidates, false);
        }
        if (sourceElement instanceof CssClass) {
            CssClass cssClass = (CssClass)sourceElement;
            String cssClassName = cssClass.getName();
            if (cssClassName == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(8);
                }
                return list;
            }
            Collection<VirtualFile> siblings = TypeScriptDeclarationMappingsImpl.findSiblings((PsiNamedElement)cssClass, name, TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS);
            List resolveResults = ContainerUtil.flatMap(siblings, siblingDeclaration -> {
                PsiFile declarationPsi = PsiManager.getInstance((Project)this.myProject).findFile(siblingDeclaration);
                if (!(declarationPsi instanceof JSFile)) {
                    return Collections.emptyList();
                }
                JSFile jsFile = (JSFile)declarationPsi;
                return List.of(ES6PsiUtil.resolveSymbolInModule(cssClassName, (PsiElement)declarationPsi, jsFile));
            });
            List list = ContainerUtil.mapNotNull((Collection)resolveResults, result2 -> {
                PsiElement element = result2.getElement();
                if (element instanceof JSQualifiedNamedElement) {
                    JSQualifiedNamedElement qualifiedElement = (JSQualifiedNamedElement)element;
                    return qualifiedElement;
                }
                return null;
            });
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static List<JSQualifiedNamedElement> resolveModuleForTypeScript(@NotNull JSQualifiedNamedElement element, String fileNameWithoutExtension) {
        String name;
        if (element == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(11);
        }
        if (!element.isExportedWithDefault() && !element.isExported()) {
            List<JSQualifiedNamedElement> list = Collections.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(12);
            }
            return list;
        }
        String string = name = element.isExportedWithDefault() ? "default" : element.getName();
        if (name == null) {
            List<JSQualifiedNamedElement> list = Collections.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(13);
            }
            return list;
        }
        Collection<VirtualFile> siblings = TypeScriptDeclarationMappingsImpl.findSiblings(element, fileNameWithoutExtension, TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS);
        for (VirtualFile sibling : siblings) {
            List<JSQualifiedNamedElement> elements = TypeScriptDeclarationMappingsImpl.resolveFromFile(element, name, sibling);
            if (elements.isEmpty()) continue;
            List<JSQualifiedNamedElement> list = elements;
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(14);
            }
            return list;
        }
        List<JSQualifiedNamedElement> list = Collections.emptyList();
        if (list == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Override
    @RequiresReadLock
    @NotNull
    public Collection<PsiNamedElement> getSourceElements(@NotNull JSQualifiedNamedElement dtsCandidate) {
        if (dtsCandidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.softAssertReadAccess();
        String fileNameWithoutExtension = this.getDeclarationFileNameWithoutExtension(dtsCandidate);
        if (fileNameWithoutExtension == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(17);
            }
            return list;
        }
        if (CssFileTypeUtil.isCssFileName((String)fileNameWithoutExtension)) {
            Collection<VirtualFile> candidates = this.getTSFileCandidatesByNameWithExtensions(dtsCandidate, fileNameWithoutExtension, EMPTY_EXTENSIONS);
            if (candidates.isEmpty()) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(18);
                }
                return list;
            }
            GlobalSearchScope scope2 = GlobalSearchScope.filesScope((Project)this.myProject, candidates);
            Collection<PsiNamedElement> elements = this.findCssSelectorsByName(scope2, dtsCandidate.getName());
            if (!elements.isEmpty()) {
                Collection<PsiNamedElement> collection = elements;
                if (collection == null) {
                    TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(19);
                }
                return collection;
            }
            elements = this.findCssSelectorsByName(scope2, dtsCandidate.getQualifiedName());
            if (!elements.isEmpty()) {
                Collection<PsiNamedElement> collection = elements;
                if (collection == null) {
                    TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(20);
                }
                return collection;
            }
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(21);
            }
            return list;
        }
        Collection<VirtualFile> candidates = this.getTSFileCandidatesByNameWithExtensions(dtsCandidate, fileNameWithoutExtension, TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DECLARATIONS);
        Collection<JSQualifiedNamedElement> tsSourceElements = this.getEqualElementsInFiles(dtsCandidate, candidates, false);
        tsSourceElements.forEach(el -> el.putUserData(SOURCE_FILE_MARKER, true));
        List list = ContainerUtil.map(tsSourceElements, element -> element);
        if (list == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    private Collection<PsiNamedElement> findCssSelectorsByName(@NotNull GlobalSearchScope scope2, @Nullable String name) {
        if (scope2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(23);
        }
        if (name == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(24);
            }
            return list;
        }
        Collection elements = StubIndex.getElements((StubIndexKey)CssClassIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)scope2, CssSelectorSuffix.class);
        if (!elements.isEmpty()) {
            elements.forEach(el -> el.putUserData(SOURCE_FILE_MARKER, (Object)true));
            List list = ContainerUtil.map((Collection)elements, element -> element);
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(25);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Nullable
    private String getDeclarationFileNameWithoutExtension(@NotNull JSQualifiedNamedElement dtsCandidate) {
        if (dtsCandidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(27);
        }
        if (!TypeScriptUtil.isDefinitionFile(dtsCandidate.getContainingFile())) {
            return null;
        }
        PsiFile file = dtsCandidate.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || TypeScriptLibraryProvider.getAllLibraries(this.myProject).contains(virtualFile)) {
            return null;
        }
        String result2 = JSFileReferencesUtil.getFileNameWithoutExtension(file.getName(), TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS);
        return StringUtil.isEmpty((String)result2) || DumbService.isDumb((Project)this.myProject) ? null : result2;
    }

    @Override
    @RequiresReadLock
    @NotNull
    public Collection<? extends PsiElement> getJSSourceElementsOrSearchableStub(@NotNull JSQualifiedNamedElement dtsCandidate) {
        if (dtsCandidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(28);
        }
        ThreadingAssertions.softAssertReadAccess();
        return TypeScriptDeclarationMappingsImpl.postProcess(this.getJSSourceElements(dtsCandidate, true));
    }

    @Override
    @RequiresReadLock
    @NotNull
    public Collection<? extends PsiElement> getJSSourceElements(@NotNull JSQualifiedNamedElement dtsCandidate) {
        if (dtsCandidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(29);
        }
        ThreadingAssertions.softAssertReadAccess();
        return TypeScriptDeclarationMappingsImpl.postProcess(this.getJSSourceElements(dtsCandidate, false));
    }

    @NotNull
    private static JSQualifiedNamedElement adjustResolveElement(@NotNull JSQualifiedNamedElement element) {
        PsiElement parent;
        if (element == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(30);
        }
        if (element instanceof TypeScriptType && (parent = element.getParent()) instanceof JSQualifiedNamedElement) {
            element = (JSQualifiedNamedElement)parent;
        }
        if (element instanceof TypeScriptFunction) {
            Collection<TypeScriptFunction> signatures2 = TypeScriptPsiUtil.getAllOverloadsWithImplementation((TypeScriptFunction)element, false);
            if (signatures2.isEmpty()) {
                JSQualifiedNamedElement jSQualifiedNamedElement = element;
                if (jSQualifiedNamedElement == null) {
                    TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(31);
                }
                return jSQualifiedNamedElement;
            }
            List sorted = ContainerUtil.sorted(signatures2, Comparator.comparing(el -> el.getParameters().length));
            JSFunctionItem item = (JSFunctionItem)ContainerUtil.getLastItem((List)sorted);
            JSQualifiedNamedElement jSQualifiedNamedElement = item instanceof JSQualifiedNamedElement ? (JSQualifiedNamedElement)((Object)item) : element;
            if (jSQualifiedNamedElement == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(32);
            }
            return jSQualifiedNamedElement;
        }
        JSQualifiedNamedElement jSQualifiedNamedElement = element;
        if (jSQualifiedNamedElement == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(33);
        }
        return jSQualifiedNamedElement;
    }

    @NotNull
    private static Collection<? extends PsiElement> postProcess(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(34);
        }
        if (elements.isEmpty()) {
            Collection<? extends PsiElement> collection = elements;
            if (collection == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(35);
            }
            return collection;
        }
        return TypeScriptDeclarationMappingsImpl.withoutDefinitionsOrSelf(ContainerUtil.map(TypeScriptDeclarationMappingsImpl.withoutMinifiedOrSelf(elements), JSStubBasedPsiTreeUtil::calculateTargetElement));
    }

    @NotNull
    private static Collection<? extends PsiElement> withoutMinifiedOrSelf(@NotNull Collection<? extends PsiElement> elements) {
        Set nonMinified;
        if (elements == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(36);
        }
        Collection<Object> collection = !(nonMinified = elements.stream().filter(el -> {
            PsiFile file = el.getContainingFile();
            return !(file instanceof JSFile) || !((JSFile)file).isMinified();
        }).collect(Collectors.toUnmodifiableSet())).isEmpty() ? nonMinified : elements;
        if (collection == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(37);
        }
        return collection;
    }

    @NotNull
    private static Collection<? extends PsiElement> withoutDefinitionsOrSelf(@NotNull Collection<? extends PsiElement> elements) {
        Set nonDefinitions;
        if (elements == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(38);
        }
        Collection<Object> collection = !(nonDefinitions = elements.stream().filter(el -> !(el instanceof JSDefinitionExpression)).collect(Collectors.toUnmodifiableSet())).isEmpty() ? nonDefinitions : elements;
        if (collection == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(39);
        }
        return collection;
    }

    @NotNull
    private Collection<? extends PsiElement> getJSSourceElements(@NotNull JSQualifiedNamedElement dtsCandidate, boolean withSearchableStub) {
        if (dtsCandidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(40);
        }
        if (dtsCandidate instanceof TypeScriptCompileTimeType || dtsCandidate instanceof TypeScriptIndexSignature || dtsCandidate instanceof TypeScriptCallSignature || dtsCandidate instanceof JSParameter) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(41);
            }
            return list;
        }
        String fileNameWithoutExtension = this.getDeclarationFileNameWithoutExtension(dtsCandidate = TypeScriptDeclarationMappingsImpl.adjustResolveElement(dtsCandidate));
        if (fileNameWithoutExtension == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(42);
            }
            return list;
        }
        if (TypeScriptExcludeUtil.areSourcesExcluded((PsiElement)dtsCandidate)) {
            List<Object> list = withSearchableStub ? Collections.singletonList(TypeScriptExcludeUtil.createIncludeSourcesElement((PsiElement)dtsCandidate)) : Collections.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(43);
            }
            return list;
        }
        PsiFile psiFile = dtsCandidate.getContainingFile();
        if (psiFile == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(44);
            }
            return list;
        }
        VirtualFile currentVirtualFile = psiFile.getVirtualFile();
        Collection<? extends PsiElement> fromModules = this.resolveModuleForJavaScript(dtsCandidate, fileNameWithoutExtension, currentVirtualFile);
        if (!fromModules.isEmpty()) {
            Collection<? extends PsiElement> collection = fromModules;
            if (collection == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(45);
            }
            return collection;
        }
        Collection<VirtualFile> candidates = this.getJavaScriptFileCandidates(dtsCandidate, fileNameWithoutExtension);
        Collection<JSQualifiedNamedElement> elements = this.getEqualElementsInFiles(dtsCandidate, candidates, true);
        if (!elements.isEmpty()) {
            Collection<JSQualifiedNamedElement> collection = elements;
            if (collection == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(46);
            }
            return collection;
        }
        return this.getEqualElementsInScope(dtsCandidate, this.weakSeachScope(dtsCandidate, currentVirtualFile, candidates), true);
    }

    @NotNull
    private GlobalSearchScope weakSeachScope(@NotNull JSQualifiedNamedElement dtsCandidate, final @NotNull VirtualFile currentVirtualFile, final @NotNull Collection<VirtualFile> candidates) {
        if (dtsCandidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(47);
        }
        if (currentVirtualFile == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(48);
        }
        if (candidates == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(49);
        }
        GlobalSearchScope project = GlobalSearchScope.allScope((Project)this.myProject);
        GlobalSearchScope projectWithFileTypeFilter = TypeScriptDeclarationMappingsImpl.restrictScopeForJavaScriptCandidates(dtsCandidate, GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)project, (FileType[])new FileType[]{JavaScriptFileType.INSTANCE}));
        return new DelegatingGlobalSearchScope(projectWithFileTypeFilter){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !currentVirtualFile.equals(file) && !candidates.contains(file) && super.contains(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl$1", "contains"));
            }
        };
    }

    @NotNull
    private Collection<? extends PsiElement> resolveModuleForJavaScript(@NotNull JSQualifiedNamedElement element, @NotNull String fileNameWithoutExtension, @NotNull VirtualFile virtualFile) {
        String name;
        if (element == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(50);
        }
        if (fileNameWithoutExtension == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(51);
        }
        if (virtualFile == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(52);
        }
        if (!element.isExported() && !element.isExportedWithDefault()) {
            List list = Collections.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(53);
            }
            return list;
        }
        String string = name = element.isExportedWithDefault() ? "default" : element.getName();
        if (name == null) {
            List list = Collections.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(54);
            }
            return list;
        }
        GlobalSearchScope scope2 = GlobalSearchScope.allScope((Project)this.myProject);
        Collection<VirtualFile> rawSiblings = TypeScriptDeclarationMappingsImpl.findSiblings(element, fileNameWithoutExtension, JS_GENERATED_EXTENSIONS);
        List siblings = ContainerUtil.filter(rawSiblings, arg_0 -> ((GlobalSearchScope)scope2).contains(arg_0));
        for (VirtualFile sibling : siblings) {
            List<JSQualifiedNamedElement> elements = TypeScriptDeclarationMappingsImpl.resolveFromFile(element, name, sibling);
            if (elements.isEmpty()) continue;
            List<JSQualifiedNamedElement> list = elements;
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(55);
            }
            return list;
        }
        VirtualFile module = this.getMappedModuleFile(element, virtualFile);
        if (module == null) {
            List list = Collections.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(56);
            }
            return list;
        }
        return TypeScriptDeclarationMappingsImpl.resolveFromFile(element, name, module);
    }

    @NotNull
    private static List<JSQualifiedNamedElement> resolveFromFile(@NotNull JSQualifiedNamedElement element, @NotNull String nameOrDefault, @Nullable VirtualFile module) {
        if (element == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(57);
        }
        if (nameOrDefault == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(58);
        }
        if (module == null) {
            List<JSQualifiedNamedElement> list = Collections.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(59);
            }
            return list;
        }
        PsiFile psiFile = element.getManager().findFile(module);
        if (!(psiFile instanceof JSFile)) {
            List<JSQualifiedNamedElement> list = Collections.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(60);
            }
            return list;
        }
        ResolveResult[] results = ES6PsiUtil.resolveSymbolInModule(nameOrDefault, (PsiElement)psiFile, (JSElement)psiFile);
        List list = ContainerUtil.filterIsInstance(JSResolveResult.toElements(results), JSQualifiedNamedElement.class);
        if (list == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(61);
        }
        return list;
    }

    @Nullable
    private VirtualFile getMappedModuleFile(@NotNull JSQualifiedNamedElement element, @NotNull VirtualFile virtualFile) {
        VirtualFile file;
        if (element == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(62);
        }
        if (virtualFile == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(63);
        }
        if (virtualFile.equals(file = JSCorePredefinedLibrariesProvider.getReactLibraryFile())) {
            return TypesGlobalPathMapping.Companion.getMappedFile("react", (PsiElement)element);
        }
        JSNodeModuleStructure structure = JSNodeModuleStructure.getStructure(this.myProject, virtualFile);
        if (structure == null || !structure.isFromTypes()) {
            return null;
        }
        String moduleName = structure.getOriginalPackageName();
        for (TypeScriptDeclarationModulePathMapping mapping : this.myMappings) {
            if (!mapping.isAvailable(moduleName, structure)) continue;
            return mapping.getMappedModules(moduleName, structure, element);
        }
        return null;
    }

    @NotNull
    private Collection<VirtualFile> getJavaScriptFileCandidates(@NotNull JSQualifiedNamedElement context2, @NotNull String fileNameWithoutExtension) {
        if (context2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(64);
        }
        if (fileNameWithoutExtension == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(65);
        }
        return TypeScriptDeclarationMappingsImpl.getFilesByName(context2, fileNameWithoutExtension, JS_GENERATED_EXTENSIONS, TypeScriptDeclarationMappingsImpl.restrictScopeForJavaScriptCandidates(context2, GlobalSearchScope.allScope((Project)this.myProject)));
    }

    @NotNull
    private Collection<VirtualFile> getTSFileCandidatesByNameWithExtensions(@NotNull JSQualifiedNamedElement context2, @NotNull String fileNameWithoutExtension, String[] extensions) {
        if (context2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(66);
        }
        if (fileNameWithoutExtension == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(67);
        }
        return TypeScriptDeclarationMappingsImpl.getFilesByName(context2, fileNameWithoutExtension, extensions, TypeScriptDeclarationMappingsImpl.restrictScopeForTypeScriptCandidates(context2, GlobalSearchScope.allScope((Project)this.myProject)));
    }

    @NotNull
    private Collection<VirtualFile> getDeclarationFileCandidatesByName(@NotNull JSQualifiedNamedElement context2, @NotNull String fileNameWithoutExtension) {
        if (context2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(68);
        }
        if (fileNameWithoutExtension == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(69);
        }
        return TypeScriptDeclarationMappingsImpl.getFilesByName(context2, fileNameWithoutExtension, TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS, this.restrictScopeForDeclarationCandidates(context2, GlobalSearchScope.allScope((Project)this.myProject)));
    }

    @NotNull
    private static @Unmodifiable Collection<VirtualFile> getFilesByName(@NotNull JSQualifiedNamedElement context2, @NotNull String fileNameWithoutExtension, String[] extensions, @NotNull GlobalSearchScope scope2) {
        if (context2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(70);
        }
        if (fileNameWithoutExtension == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(71);
        }
        if (scope2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(72);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<VirtualFile> siblings = TypeScriptDeclarationMappingsImpl.findSiblings(context2, fileNameWithoutExtension, extensions);
        if (!siblings.isEmpty()) {
            List list = ContainerUtil.filter(siblings, el -> scope2.contains(el));
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(73);
            }
            return list;
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (String extension : extensions) {
            result2.addAll(FilenameIndex.getVirtualFilesByName((String)(fileNameWithoutExtension + extension), (GlobalSearchScope)scope2));
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(74);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<VirtualFile> findSiblings(@NotNull PsiNamedElement context2, @NotNull String fileNameWithoutExtension, String[] extensions) {
        VirtualFile file;
        if (context2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(75);
        }
        if (fileNameWithoutExtension == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(76);
        }
        if ((file = PsiUtilCore.getVirtualFile((PsiElement)context2)) == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(77);
            }
            return list;
        }
        VirtualFile directory = file.getParent();
        if (directory == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(78);
            }
            return list;
        }
        return TypeScriptDeclarationMappingsImpl.findSiblings(directory, fileNameWithoutExtension, extensions);
    }

    @NotNull
    private static Collection<VirtualFile> findSiblings(@NotNull VirtualFile directory, @NotNull String fileNameWithoutExtension, String[] extensions) {
        if (directory == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(79);
        }
        if (fileNameWithoutExtension == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(80);
        }
        SmartList siblings = new SmartList();
        for (String extension : extensions) {
            VirtualFile child = directory.findChild(fileNameWithoutExtension + extension);
            if (child == null) continue;
            siblings.add((Object)child);
        }
        SmartList smartList = siblings;
        if (smartList == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(81);
        }
        return smartList;
    }

    @NotNull
    private static GlobalSearchScope restrictScopeForTypeScriptCandidates(@NotNull JSQualifiedNamedElement dtsElement, @NotNull GlobalSearchScope scope2) {
        VirtualFile file;
        if (dtsElement == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(82);
        }
        if (scope2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(83);
        }
        if ((file = PsiUtilCore.getVirtualFile((PsiElement)dtsElement)) == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(84);
            }
            return globalSearchScope;
        }
        final Project project = dtsElement.getProject();
        final JSNodeModuleStructure structure = JSNodeModuleStructure.getStructure(project, file);
        return new DelegatingGlobalSearchScope(scope2){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!super.contains(file)) {
                    return false;
                }
                JSNodeModuleStructure currentStructure = JSNodeModuleStructure.getStructure(project, file);
                if (currentStructure == null) {
                    return true;
                }
                if (structure == null) {
                    return false;
                }
                return Objects.equals(currentStructure.getOriginalPackageName(), structure.getOriginalPackageName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl$2", "contains"));
            }
        };
    }

    @NotNull
    private GlobalSearchScope restrictScopeForDeclarationCandidates(@NotNull JSQualifiedNamedElement tsElement, @NotNull GlobalSearchScope scope2) {
        VirtualFile tsElementFile;
        if (tsElement == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(85);
        }
        if (scope2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(86);
        }
        if ((tsElementFile = PsiUtilCore.getVirtualFile((PsiElement)tsElement)) == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(87);
            }
            return globalSearchScope;
        }
        final Project project = tsElement.getProject();
        final JSNodeModuleStructure structure = JSNodeModuleStructure.getStructure(project, tsElementFile);
        return new DelegatingGlobalSearchScope(scope2){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!super.contains(file)) {
                    return false;
                }
                JSNodeModuleStructure currentStructure = JSNodeModuleStructure.getStructure(project, file);
                if (structure != null) {
                    return currentStructure != null && Objects.equals(currentStructure.getOriginalPackageName(), structure.getOriginalPackageName());
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl$3", "contains"));
            }
        };
    }

    @NotNull
    private static GlobalSearchScope restrictScopeForJavaScriptCandidates(@NotNull JSQualifiedNamedElement dtsElement, @NotNull GlobalSearchScope scope2) {
        VirtualFile file;
        if (dtsElement == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(88);
        }
        if (scope2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(89);
        }
        if ((file = PsiUtilCore.getVirtualFile((PsiElement)dtsElement)) == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(90);
            }
            return globalSearchScope;
        }
        final Project project = dtsElement.getProject();
        final JSNodeModuleStructure structure = JSNodeModuleStructure.getStructure(project, file);
        final VirtualFile root = NodeModuleUtil.getMainModuleRoot((PsiElement)dtsElement);
        return new DelegatingGlobalSearchScope(scope2){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!super.contains(file)) {
                    return false;
                }
                if (structure == null) {
                    return root == null || VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true);
                }
                JSNodeModuleStructure currentStructure = JSNodeModuleStructure.getStructure(project, file);
                if (currentStructure == null) {
                    return false;
                }
                return Objects.equals(currentStructure.getOriginalPackageName(), structure.getOriginalPackageName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl$4", "contains"));
            }
        };
    }

    @NotNull
    private Collection<JSQualifiedNamedElement> getEqualElementsInFiles(@NotNull JSQualifiedNamedElement element, @NotNull Collection<VirtualFile> files, boolean processWeakElements) {
        if (element == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(91);
        }
        if (files == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(92);
        }
        if (files.isEmpty()) {
            List<JSQualifiedNamedElement> list = Collections.emptyList();
            if (list == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(93);
            }
            return list;
        }
        GlobalSearchScope scope2 = GlobalSearchScope.filesScope((Project)this.myProject, files);
        return this.getEqualElementsInScope(element, scope2, processWeakElements);
    }

    @NotNull
    private Collection<JSQualifiedNamedElement> getEqualElementsInScope(@NotNull JSQualifiedNamedElement element, @NotNull GlobalSearchScope scope2, boolean processWeakElements) {
        if (element == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(94);
        }
        if (scope2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(95);
        }
        String qualifiedName = element.getQualifiedName();
        SmartList result2 = new SmartList();
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)element);
        Processor processor = arg_0 -> TypeScriptDeclarationMappingsImpl.lambda$getEqualElementsInScope$10(isTypeScript, element, (Collection)result2, arg_0);
        this.processDefaultSymbols(element, scope2, (Processor<? super JSElement>)processor, (Collection<JSQualifiedNamedElement>)result2);
        if (StringUtil.isEmpty((String)qualifiedName) || !result2.isEmpty()) {
            SmartList smartList = result2;
            if (smartList == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(96);
            }
            return smartList;
        }
        this.processSymbolsWithQualifier(scope2, (Processor<? super JSElement>)processor, qualifiedName);
        if (!result2.isEmpty()) {
            SmartList smartList = result2;
            if (smartList == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(97);
            }
            return smartList;
        }
        if (StringUtil.startsWith((CharSequence)qualifiedName, (CharSequence)"module:")) {
            qualifiedName = qualifiedName.substring("module:".length());
            this.processSymbolsWithQualifier(scope2, (Processor<? super JSElement>)processor, qualifiedName);
            String capitalized = StringUtil.capitalize((String)qualifiedName);
            if (!StringUtil.equals((CharSequence)capitalized, (CharSequence)qualifiedName)) {
                this.processSymbolsWithQualifier(scope2, (Processor<? super JSElement>)processor, capitalized);
            }
        }
        if (!processWeakElements || !result2.isEmpty()) {
            SmartList smartList = result2;
            if (smartList == null) {
                TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(98);
            }
            return smartList;
        }
        String name = element.getName();
        if (!StringUtil.isEmpty((String)name) && !StringUtil.equals((CharSequence)qualifiedName, (CharSequence)name)) {
            PsiElement parent = JSResolveUtil.findParent((PsiElement)element);
            if (parent instanceof TypeScriptModule) {
                qualifiedName = name;
                this.processSymbolsWithQualifier(scope2, (Processor<? super JSElement>)processor, qualifiedName);
            } else {
                JSClass container = JSUtils.getMemberContainingClass((PsiElement)element);
                if (container != null && !StringUtil.isEmpty((String)container.getName())) {
                    this.processSymbolsWithQualifier(scope2, (Processor<? super JSElement>)processor, container.getName() + "." + name);
                }
            }
        }
        if (StringUtil.equals((CharSequence)qualifiedName, (CharSequence)name)) {
            this.processSymbolsWithQualifier(scope2, (Processor<? super JSElement>)processor, "exports." + qualifiedName);
            this.processSymbolsWithQualifier(scope2, (Processor<? super JSElement>)processor, "module.exports." + qualifiedName);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(99);
        }
        return smartList;
    }

    private void processDefaultSymbols(@NotNull JSQualifiedNamedElement originalElement, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super JSElement> processor, @NotNull Collection<JSQualifiedNamedElement> result2) {
        if (originalElement == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(100);
        }
        if (scope2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(101);
        }
        if (processor == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(102);
        }
        if (result2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(103);
        }
        if (!originalElement.isExportedWithDefault()) {
            return;
        }
        String name = originalElement.getQualifiedName();
        if (StringUtil.isEmpty((String)name)) {
            elements = StubIndex.getElements(ES6ExportedMembersByKindIndex.KEY, (Object)"def", (Project)this.myProject, (GlobalSearchScope)scope2, JSElement.class);
            for (JSElement element : elements) {
                if (element instanceof ES6ExportDefaultAssignment) {
                    element = ((ES6ExportDefaultAssignment)element).getStubSafeElement();
                }
                if (!(element instanceof JSElementBase) || !StringUtil.isEmpty((String)element.getName()) || processor.process((Object)element)) continue;
                return;
            }
        } else {
            elements = StubIndex.getElements(ES6ExportedNamesIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)scope2, JSElement.class);
            for (JSElement element : elements) {
                if (!(element instanceof JSElementBase) || !((JSElementBase)((Object)element)).isExportedWithDefault() || processor.process((Object)element)) continue;
                return;
            }
        }
        if (!result2.isEmpty()) {
            return;
        }
        ArrayList candidates = new ArrayList();
        candidates.addAll(StubIndex.getElements(JSSymbolQualifiedNamesIndex.KEY, (Object)"module.exports", (Project)originalElement.getProject(), (GlobalSearchScope)scope2, JSElement.class));
        candidates.addAll(StubIndex.getElements(JSSymbolQualifiedNamesIndex.KEY, (Object)"exports.default", (Project)originalElement.getProject(), (GlobalSearchScope)scope2, JSElement.class));
        for (JSElement element : candidates) {
            if (element instanceof JSDefinitionExpression) {
                String ref2 = JSPsiImplUtils.getInitializerReference((JSDefinitionExpression)element);
                if (ref2 != null) {
                    PsiElement resolved = JSStubBasedPsiTreeUtil.resolveLocally(ref2, (PsiElement)element);
                    if (resolved instanceof JSElement) {
                        element = (JSElement)resolved;
                    }
                } else {
                    JSExpression stub = ((JSDefinitionExpression)element).getInitializerOrStub();
                    if (stub != null) {
                        element = stub;
                    }
                }
            }
            if (processor.process((Object)element)) continue;
            return;
        }
    }

    private void processSymbolsWithQualifier(@NotNull GlobalSearchScope scope2, @NotNull Processor<? super JSElement> processor, @NotNull String name) {
        if (scope2 == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(104);
        }
        if (processor == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(105);
        }
        if (name == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(106);
        }
        Collection elements = StubIndex.getElements(JSSymbolQualifiedNamesIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)scope2, JSElement.class);
        for (JSElement element : elements) {
            if (processor.process((Object)element)) continue;
            return;
        }
    }

    public static boolean areElementsEqual(@NotNull JSQualifiedNamedElement tsElement, @NotNull JSQualifiedNamedElement candidate) {
        JSExpression initializer;
        if (tsElement == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(107);
        }
        if (candidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(108);
        }
        if (!TypeScriptDeclarationMappingsImpl.areNamesEqual(tsElement, candidate) || !TypeScriptDeclarationMappingsImpl.areContextSimilar(tsElement, candidate)) {
            return false;
        }
        if (tsElement instanceof JSFunction && candidate instanceof JSVariable && (initializer = ((JSVariable)candidate).getInitializerOrStub()) instanceof JSFunction) {
            candidate = (JSFunction)((Object)initializer);
        }
        if (tsElement instanceof TypeScriptVariable && candidate instanceof JSFunction && (initializer = ((TypeScriptVariable)tsElement).getInitializer()) == null) {
            return true;
        }
        if (tsElement instanceof JSFunction && candidate instanceof JSFunction) {
            return TypeScriptComparingUtil.areFunctionsSimilar((JSFunction)tsElement, (JSFunction)candidate, null);
        }
        if (tsElement instanceof JSClass && candidate instanceof JSClass) {
            return TypeScriptDeclarationMappingsImpl.areJSClassesSimilar((JSClass)tsElement, (JSClass)candidate);
        }
        if (tsElement instanceof JSField && candidate instanceof JSField) {
            return TypeScriptDeclarationMappingsImpl.areFieldsSimilar((JSField)tsElement, (JSField)candidate);
        }
        if (tsElement instanceof JSVariable && candidate instanceof JSVariable) {
            return TypeScriptComparingUtil.areVariablesSimilar((JSVariable)tsElement, (JSVariable)candidate, null);
        }
        if (tsElement instanceof TypeScriptModule && candidate instanceof TypeScriptModule) {
            return TypeScriptDeclarationMappingsImpl.areModulesSimilar((TypeScriptModule)tsElement, (TypeScriptModule)candidate);
        }
        if (tsElement instanceof JSFunction && candidate instanceof JSClass) {
            return TypeScriptDeclarationMappingsImpl.areFunctionAndJSClassSimilar((JSFunction)tsElement, (JSClass)candidate);
        }
        if (tsElement instanceof JSClass && candidate instanceof JSFunction) {
            return TypeScriptDeclarationMappingsImpl.areFunctionAndJSClassSimilar((JSFunction)candidate, (JSClass)tsElement);
        }
        if (tsElement instanceof JSFunction && candidate instanceof JSDefinitionExpression) {
            return TypeScriptDeclarationMappingsImpl.areDefinitionAndFunctionSimilar((JSDefinitionExpression)candidate, (JSFunction)tsElement);
        }
        if (tsElement instanceof JSVariable && candidate instanceof JSDefinitionExpression) {
            return TypeScriptDeclarationMappingsImpl.areDefinitionAndVariableSimilar((JSDefinitionExpression)candidate, (JSVariable)tsElement);
        }
        return false;
    }

    private static boolean areModulesSimilar(@NotNull TypeScriptModule original, @NotNull TypeScriptModule candidate) {
        if (original == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(109);
        }
        if (candidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(110);
        }
        if (original.isInternal() != candidate.isInternal()) {
            return false;
        }
        Collection<String> originalMembers = TypeScriptDeclarationMappingsImpl.getPublicModuleMembers(original);
        Collection<String> candidateMembers = TypeScriptDeclarationMappingsImpl.getPublicModuleMembers(candidate);
        return originalMembers.equals(candidateMembers);
    }

    private static Collection<String> getPublicModuleMembers(@NotNull TypeScriptModule original) {
        if (original == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(111);
        }
        return Arrays.stream(original.getChildren()).filter(el -> el instanceof JSQualifiedNamedElement).map(el -> (JSQualifiedNamedElement)el).filter(el -> el.getAccessType() == JSAttributeList.AccessType.PUBLIC).map(el -> el.getName()).filter(el -> el != null).collect(Collectors.toSet());
    }

    public static boolean areFunctionAndJSClassSimilar(@NotNull JSFunction function, @NotNull JSClass jsClass) {
        JSFunction constructor;
        if (function == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(112);
        }
        if (jsClass == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(113);
        }
        if ((constructor = jsClass.getConstructor()) == null) {
            return function.getParameters().length == 0;
        }
        return TypeScriptComparingUtil.areFunctionsSimilar(constructor, function, null);
    }

    public static boolean areNamesEqual(@NotNull JSQualifiedNamedElement original, @NotNull JSQualifiedNamedElement candidate) {
        if (original == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(114);
        }
        if (candidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(115);
        }
        return StringUtil.equals((CharSequence)original.getName(), (CharSequence)candidate.getName()) || original.isExportedWithDefault() && Objects.equals(original.getName(), "_default") || original.isExportedWithDefault() && Objects.equals(candidate.getQualifiedName(), "exports");
    }

    private static boolean areDefinitionAndFunctionSimilar(@NotNull JSDefinitionExpression definition, @NotNull JSFunction candidate) {
        JSExpression expression;
        if (definition == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(116);
        }
        if (candidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(117);
        }
        if ((expression = definition.getInitializerOrStub()) instanceof JSFunction) {
            return TypeScriptComparingUtil.areFunctionsSimilar((JSFunction)((Object)expression), candidate, null);
        }
        return false;
    }

    private static boolean areDefinitionAndVariableSimilar(@NotNull JSDefinitionExpression definition, @NotNull JSVariable variable) {
        JSClass fieldOwner;
        if (definition == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(118);
        }
        if (variable == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(119);
        }
        if ((fieldOwner = JSUtils.getMemberContainingClass((PsiElement)variable)) != null && variable.getJSContext() == JSContext.INSTANCE) {
            JSClass constructorOwner;
            JSFunction constructorFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)definition, JSFunction.class);
            if (constructorFunction == null) {
                return false;
            }
            JSQualifiedNamedElement container = constructorFunction;
            if ("constructor".equals(constructorFunction.getName()) && (constructorOwner = JSUtils.getMemberContainingClass(constructorFunction)) != null) {
                container = constructorOwner;
            }
            return StringUtil.equals((CharSequence)container.getName(), (CharSequence)fieldOwner.getName());
        }
        return true;
    }

    private static boolean areContextSimilar(@NotNull JSQualifiedNamedElement element, @NotNull JSQualifiedNamedElement candidate) {
        if (element == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(120);
        }
        if (candidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(121);
        }
        JSNamespace originalNamespace = element.getJSNamespace();
        JSNamespace candidateNamespace = candidate.getJSNamespace();
        if (!originalNamespace.hasQualifiedName() || !candidateNamespace.hasQualifiedName()) {
            return true;
        }
        if (!Objects.equals(originalNamespace.getQualifiedName(), candidateNamespace.getQualifiedName())) {
            return true;
        }
        JSContext originalContext = element.getJSContext();
        JSContext candidateContext = candidate.getJSContext();
        return originalContext == JSContext.UNKNOWN && candidateContext == JSContext.STATIC || originalContext == JSContext.STATIC && candidateContext == JSContext.UNKNOWN || originalContext == candidateContext;
    }

    private static boolean areJSClassesSimilar(@NotNull JSClass originalClass, @NotNull JSClass candidateClass) {
        boolean isTypeScriptOnly;
        if (originalClass == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(122);
        }
        if (candidateClass == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(123);
        }
        if (!TypeScriptDeclarationMappingsImpl.areReferenceListsEqual(originalClass.getExtendsList(), candidateClass.getExtendsList())) {
            return false;
        }
        ArrayList originalMembers = ContainerUtil.newArrayList(originalClass.getMembers());
        ArrayList candidateMembers = ContainerUtil.newArrayList(candidateClass.getMembers());
        Set<String> originalNames = TypeScriptDeclarationMappingsImpl.getMethodNames(originalMembers);
        Set<String> candidateNames = TypeScriptDeclarationMappingsImpl.getMethodNames(candidateMembers);
        boolean bl = isTypeScriptOnly = originalClass instanceof TypeScriptClass && candidateClass instanceof TypeScriptClass;
        if (!originalNames.equals(candidateNames)) {
            if (isTypeScriptOnly) {
                return false;
            }
            if (originalClass instanceof TypeScriptClass && !TypeScriptDeclarationMappingsImpl.areTypeScriptAndJSClassMembersSimilar(originalNames, candidateNames)) {
                return false;
            }
            if (candidateClass instanceof TypeScriptClass && !TypeScriptDeclarationMappingsImpl.areTypeScriptAndJSClassMembersSimilar(candidateNames, originalNames)) {
                return false;
            }
        }
        return !isTypeScriptOnly || TypeScriptDeclarationMappingsImpl.areReferenceListsEqual(originalClass.getImplementsList(), candidateClass.getImplementsList());
    }

    private static boolean areTypeScriptAndJSClassMembersSimilar(@NotNull Set<String> tsMembers, @NotNull Set<String> jsMembers) {
        if (tsMembers == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(124);
        }
        if (jsMembers == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(125);
        }
        return tsMembers.containsAll(jsMembers);
    }

    private static boolean areReferenceListsEqual(@Nullable JSReferenceList list, @Nullable JSReferenceList candidateExtendsList) {
        if ((list == null || candidateExtendsList == null) && list != candidateExtendsList) {
            return false;
        }
        if (list != null) {
            Object[] texts = list.getReferenceTexts();
            Object[] candidatesTexts = candidateExtendsList.getReferenceTexts();
            return Arrays.equals(texts, candidatesTexts);
        }
        return true;
    }

    @NotNull
    private static Set<String> getMethodNames(@NotNull List<JSElement> candidateMembers) {
        if (candidateMembers == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(126);
        }
        Set<String> set = candidateMembers.stream().map(el -> el.getName()).filter(el -> el != null && !"constructor".equals(el)).collect(Collectors.toSet());
        if (set == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(127);
        }
        return set;
    }

    private static boolean areFieldsSimilar(@NotNull JSField original, @NotNull JSField candidate) {
        if (original == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(128);
        }
        if (candidate == null) {
            TypeScriptDeclarationMappingsImpl.$$$reportNull$$$0(129);
        }
        JSClass originalClass = JSUtils.getMemberContainingClass((PsiElement)original);
        JSClass candidateClass = JSUtils.getMemberContainingClass((PsiElement)candidate);
        if (originalClass == null || candidateClass == null || !TypeScriptDeclarationMappingsImpl.areJSClassesSimilar(originalClass, candidateClass)) {
            return false;
        }
        PsiElement typeElement = original.getTypeElement();
        PsiElement candidateTypeElement = candidate.getTypeElement();
        if (typeElement != null && candidateTypeElement != null) {
            JSType candidateType = candidate.getJSType();
            JSType type2 = original.getJSType();
            if (TypeScriptComparingUtil.skipType(type2) || TypeScriptComparingUtil.skipType(candidateType)) {
                return true;
            }
            return TypeScriptComparingUtil.areTypeTextEqual(type2, candidateType);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getEqualElementsInScope$10(boolean isTypeScript, JSQualifiedNamedElement element, Collection result2, JSElement candidate) {
        try {
            if (candidate instanceof JSQualifiedNamedElement) {
                JSQualifiedNamedElement candidateQualifiedElement = (JSQualifiedNamedElement)candidate;
                if (isTypeScript && TypeScriptDeclarationMappingsImpl.areElementsEqual(element, candidateQualifiedElement) || !isTypeScript && TypeScriptDeclarationMappingsImpl.areElementsEqual(candidateQualifiedElement, element)) {
                    result2.add((JSQualifiedNamedElement)candidate);
                }
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 24, 25, 26, 31, 32, 33, 35, 37, 39, 41, 42, 43, 44, 45, 46, 53, 54, 55, 56, 59, 60, 61, 73, 74, 77, 78, 81, 84, 87, 90, 93, 96, 97, 98, 99, 127 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 81: 
            case 84: 
            case 87: 
            case 90: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl";
                break;
            }
            case 11: 
            case 30: 
            case 50: 
            case 57: 
            case 62: 
            case 91: 
            case 94: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dtsCandidate";
                break;
            }
            case 23: 
            case 72: 
            case 83: 
            case 86: 
            case 89: 
            case 95: 
            case 101: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentVirtualFile";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 51: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 76: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameWithoutExtension";
                break;
            }
            case 52: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameOrDefault";
                break;
            }
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 82: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dtsElement";
                break;
            }
            case 85: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsElement";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 102: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 108: 
            case 110: 
            case 115: 
            case 117: 
            case 121: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 109: 
            case 111: 
            case 114: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 116: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalClass";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateClass";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsMembers";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsMembers";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptDeclarationMappingsImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationElements";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleForTypeScript";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceElements";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findCssSelectorsByName";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustResolveElement";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "postProcess";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutMinifiedOrSelf";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutDefinitionsOrSelf";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSSourceElements";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleForJavaScript";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFromFile";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByName";
                break;
            }
            case 77: 
            case 78: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "findSiblings";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScopeForTypeScriptCandidates";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScopeForDeclarationCandidates";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScopeForJavaScriptCandidates";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualElementsInFiles";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualElementsInScope";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationElements";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 81: 
            case 84: 
            case 87: 
            case 90: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 127: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleForTypeScript";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSourceElements";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findCssSelectorsByName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationFileNameWithoutExtension";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getJSSourceElementsOrSearchableStub";
                break;
            }
            case 29: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getJSSourceElements";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "adjustResolveElement";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "withoutMinifiedOrSelf";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "withoutDefinitionsOrSelf";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "weakSeachScope";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleForJavaScript";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "resolveFromFile";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getMappedModuleFile";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getJavaScriptFileCandidates";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getTSFileCandidatesByNameWithExtensions";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationFileCandidatesByName";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByName";
                break;
            }
            case 75: 
            case 76: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "findSiblings";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "restrictScopeForTypeScriptCandidates";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "restrictScopeForDeclarationCandidates";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "restrictScopeForJavaScriptCandidates";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getEqualElementsInFiles";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getEqualElementsInScope";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "processDefaultSymbols";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "processSymbolsWithQualifier";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "areElementsEqual";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "areModulesSimilar";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getPublicModuleMembers";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "areFunctionAndJSClassSimilar";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "areNamesEqual";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "areDefinitionAndFunctionSimilar";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "areDefinitionAndVariableSimilar";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "areContextSimilar";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "areJSClassesSimilar";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "areTypeScriptAndJSClassMembersSimilar";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "getMethodNames";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "areFieldsSimilar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 24, 25, 26, 31, 32, 33, 35, 37, 39, 41, 42, 43, 44, 45, 46, 53, 54, 55, 56, 59, 60, 61, 73, 74, 77, 78, 81, 84, 87, 90, 93, 96, 97, 98, 99, 127 -> new IllegalStateException(string);
        };
    }
}

