/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor.handlers;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.handlers.CsvDropUtilKt;
import com.intellij.jupyter.core.editor.handlers.DataInputCodeGenerationContext;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtilRt;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001:\u0001#B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bB?\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u0012B9\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\t\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u0014J\u0006\u0010\"\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006$"}, d2={"Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext;", "", "pathData", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext$PathData;", "generationContext", "Lcom/intellij/jupyter/core/editor/handlers/DataInputCodeGenerationContext;", "fileIndex", "", "dataframeName", "", "<init>", "(Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext$PathData;Lcom/intellij/jupyter/core/editor/handlers/DataInputCodeGenerationContext;ILjava/lang/String;)V", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "tableDataFile", "Ljava/io/File;", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/openapi/project/Project;Ljava/io/File;Lcom/intellij/jupyter/core/editor/handlers/DataInputCodeGenerationContext;ILjava/lang/String;)V", "pathToDataFile", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/editor/handlers/DataInputCodeGenerationContext;ILjava/lang/String;)V", "getPathData", "()Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext$PathData;", "getGenerationContext", "()Lcom/intellij/jupyter/core/editor/handlers/DataInputCodeGenerationContext;", "getFileIndex", "()I", "getDataframeName", "()Ljava/lang/String;", "dataFileNameWithoutExtension", "getDataFileNameWithoutExtension", "projectOrNull", "getProjectOrNull", "()Lcom/intellij/openapi/project/Project;", "resolveFilePath", "PathData", "intellij.jupyter.core"})
public final class TableDataFileDropHandlerContext {
    @NotNull
    private final PathData pathData;
    @NotNull
    private final DataInputCodeGenerationContext generationContext;
    private final int fileIndex;
    @Nullable
    private final String dataframeName;

    private TableDataFileDropHandlerContext(PathData pathData, DataInputCodeGenerationContext generationContext, int fileIndex, String dataframeName) {
        this.pathData = pathData;
        this.generationContext = generationContext;
        this.fileIndex = fileIndex;
        this.dataframeName = dataframeName;
    }

    /* synthetic */ TableDataFileDropHandlerContext(PathData pathData, DataInputCodeGenerationContext dataInputCodeGenerationContext, int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            string = null;
        }
        this(pathData, dataInputCodeGenerationContext, n, string);
    }

    @NotNull
    public final PathData getPathData() {
        return this.pathData;
    }

    @NotNull
    public final DataInputCodeGenerationContext getGenerationContext() {
        return this.generationContext;
    }

    public final int getFileIndex() {
        return this.fileIndex;
    }

    @Nullable
    public final String getDataframeName() {
        return this.dataframeName;
    }

    public TableDataFileDropHandlerContext(@NotNull BackedNotebookVirtualFile notebookFile, @NotNull Project project, @NotNull File tableDataFile, @NotNull DataInputCodeGenerationContext generationContext, int fileIndex, @Nullable String dataframeName) {
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tableDataFile, (String)"tableDataFile");
        Intrinsics.checkNotNullParameter((Object)((Object)generationContext), (String)"generationContext");
        this(new PathData.FileBased(notebookFile, tableDataFile, project), generationContext, fileIndex, dataframeName);
    }

    public /* synthetic */ TableDataFileDropHandlerContext(BackedNotebookVirtualFile backedNotebookVirtualFile, Project project, File file, DataInputCodeGenerationContext dataInputCodeGenerationContext, int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        if ((n2 & 0x20) != 0) {
            string = null;
        }
        this(backedNotebookVirtualFile, project, file, dataInputCodeGenerationContext, n, string);
    }

    public TableDataFileDropHandlerContext(@NotNull String pathToDataFile, @Nullable Project project, @NotNull DataInputCodeGenerationContext generationContext, int fileIndex, @Nullable String dataframeName) {
        Intrinsics.checkNotNullParameter((Object)pathToDataFile, (String)"pathToDataFile");
        Intrinsics.checkNotNullParameter((Object)((Object)generationContext), (String)"generationContext");
        this(new PathData.Lightweight(pathToDataFile, project), generationContext, fileIndex, dataframeName);
    }

    public /* synthetic */ TableDataFileDropHandlerContext(String string, Project project, DataInputCodeGenerationContext dataInputCodeGenerationContext, int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            string2 = null;
        }
        this(string, project, dataInputCodeGenerationContext, n, string2);
    }

    @NotNull
    public final String getDataFileNameWithoutExtension() {
        String string;
        PathData pathData = this.pathData;
        if (pathData instanceof PathData.FileBased) {
            string = FilesKt.getNameWithoutExtension((File)((PathData.FileBased)this.pathData).getTableDataFile());
        } else if (pathData instanceof PathData.Lightweight) {
            String string2 = PathUtilRt.getFileName((String)((PathData.Lightweight)this.pathData).getPathToDataFile());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFileName(...)");
            string = StringsKt.substringBeforeLast$default((String)string2, (String)".", null, (int)2, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Nullable
    public final Project getProjectOrNull() {
        Project project;
        PathData pathData = this.pathData;
        if (pathData instanceof PathData.FileBased) {
            project = ((PathData.FileBased)this.pathData).getProject();
        } else if (pathData instanceof PathData.Lightweight) {
            project = ((PathData.Lightweight)this.pathData).getProjectOrNull();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return project;
    }

    @NotNull
    public final String resolveFilePath() {
        String string;
        PathData pathData = this.pathData;
        if (pathData instanceof PathData.FileBased) {
            string = CsvDropUtilKt.createFilePath(((PathData.FileBased)this.pathData).getTableDataFile(), ((PathData.FileBased)this.pathData).getNotebookFile().getFile(), ((PathData.FileBased)this.pathData).getProject());
        } else if (pathData instanceof PathData.Lightweight) {
            string = ((PathData.Lightweight)this.pathData).getPathToDataFile();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext$PathData;", "", "FileBased", "Lightweight", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext$PathData$FileBased;", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext$PathData$Lightweight;", "intellij.jupyter.core"})
    public static interface PathData {

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J,\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c0\u0001\u00a2\u0006\u0002\b\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext$PathData$FileBased;", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext$PathData;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "tableDataFile", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Ljava/io/File;Lcom/intellij/openapi/project/Project;)V", "getNotebookFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getTableDataFile", "()Ljava/io/File;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "component3", "copy", "copy$intellij_jupyter_core", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.jupyter.core"})
        public static final class FileBased
        implements PathData {
            @NotNull
            private final BackedNotebookVirtualFile notebookFile;
            @NotNull
            private final File tableDataFile;
            @NotNull
            private final Project project;

            public FileBased(@NotNull BackedNotebookVirtualFile notebookFile, @NotNull File tableDataFile, @NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
                Intrinsics.checkNotNullParameter((Object)tableDataFile, (String)"tableDataFile");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                this.notebookFile = notebookFile;
                this.tableDataFile = tableDataFile;
                this.project = project;
            }

            @NotNull
            public final BackedNotebookVirtualFile getNotebookFile() {
                return this.notebookFile;
            }

            @NotNull
            public final File getTableDataFile() {
                return this.tableDataFile;
            }

            @NotNull
            public final Project getProject() {
                return this.project;
            }

            @NotNull
            public final BackedNotebookVirtualFile component1() {
                return this.notebookFile;
            }

            @NotNull
            public final File component2() {
                return this.tableDataFile;
            }

            @NotNull
            public final Project component3() {
                return this.project;
            }

            @NotNull
            public final FileBased copy$intellij_jupyter_core(@NotNull BackedNotebookVirtualFile notebookFile, @NotNull File tableDataFile, @NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
                Intrinsics.checkNotNullParameter((Object)tableDataFile, (String)"tableDataFile");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return new FileBased(notebookFile, tableDataFile, project);
            }

            public static /* synthetic */ FileBased copy$intellij_jupyter_core$default(FileBased fileBased, BackedNotebookVirtualFile backedNotebookVirtualFile, File file, Project project, int n, Object object) {
                if ((n & 1) != 0) {
                    backedNotebookVirtualFile = fileBased.notebookFile;
                }
                if ((n & 2) != 0) {
                    file = fileBased.tableDataFile;
                }
                if ((n & 4) != 0) {
                    project = fileBased.project;
                }
                return fileBased.copy$intellij_jupyter_core(backedNotebookVirtualFile, file, project);
            }

            @NotNull
            public String toString() {
                return "FileBased(notebookFile=" + this.notebookFile + ", tableDataFile=" + this.tableDataFile + ", project=" + this.project + ")";
            }

            public int hashCode() {
                int result = this.notebookFile.hashCode();
                result = result * 31 + this.tableDataFile.hashCode();
                result = result * 31 + this.project.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FileBased)) {
                    return false;
                }
                FileBased fileBased = (FileBased)other;
                if (!Intrinsics.areEqual((Object)this.notebookFile, (Object)fileBased.notebookFile)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.tableDataFile, (Object)fileBased.tableDataFile)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.project, (Object)fileBased.project);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J$\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c0\u0001\u00a2\u0006\u0002\b\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext$PathData$Lightweight;", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext$PathData;", "pathToDataFile", "", "projectOrNull", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "getPathToDataFile", "()Ljava/lang/String;", "getProjectOrNull", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "copy", "copy$intellij_jupyter_core", "equals", "", "other", "", "hashCode", "", "toString", "intellij.jupyter.core"})
        public static final class Lightweight
        implements PathData {
            @NotNull
            private final String pathToDataFile;
            @Nullable
            private final Project projectOrNull;

            public Lightweight(@NotNull String pathToDataFile, @Nullable Project projectOrNull) {
                Intrinsics.checkNotNullParameter((Object)pathToDataFile, (String)"pathToDataFile");
                this.pathToDataFile = pathToDataFile;
                this.projectOrNull = projectOrNull;
            }

            public /* synthetic */ Lightweight(String string, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    project = null;
                }
                this(string, project);
            }

            @NotNull
            public final String getPathToDataFile() {
                return this.pathToDataFile;
            }

            @Nullable
            public final Project getProjectOrNull() {
                return this.projectOrNull;
            }

            @NotNull
            public final String component1() {
                return this.pathToDataFile;
            }

            @Nullable
            public final Project component2() {
                return this.projectOrNull;
            }

            @NotNull
            public final Lightweight copy$intellij_jupyter_core(@NotNull String pathToDataFile, @Nullable Project projectOrNull) {
                Intrinsics.checkNotNullParameter((Object)pathToDataFile, (String)"pathToDataFile");
                return new Lightweight(pathToDataFile, projectOrNull);
            }

            public static /* synthetic */ Lightweight copy$intellij_jupyter_core$default(Lightweight lightweight, String string, Project project, int n, Object object) {
                if ((n & 1) != 0) {
                    string = lightweight.pathToDataFile;
                }
                if ((n & 2) != 0) {
                    project = lightweight.projectOrNull;
                }
                return lightweight.copy$intellij_jupyter_core(string, project);
            }

            @NotNull
            public String toString() {
                return "Lightweight(pathToDataFile=" + this.pathToDataFile + ", projectOrNull=" + this.projectOrNull + ")";
            }

            public int hashCode() {
                int result = this.pathToDataFile.hashCode();
                result = result * 31 + (this.projectOrNull == null ? 0 : this.projectOrNull.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Lightweight)) {
                    return false;
                }
                Lightweight lightweight = (Lightweight)other;
                if (!Intrinsics.areEqual((Object)this.pathToDataFile, (Object)lightweight.pathToDataFile)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.projectOrNull, (Object)lightweight.projectOrNull);
            }
        }
    }
}

