/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.runtime;

import com.intellij.jupyter.core.jupyter.connections.auth.JupyterAuthParams;
import com.intellij.jupyter.core.jupyter.connections.auth.token.JupyterTokenAuthParams;
import com.intellij.notebooks.jupyter.core.jupyter.preview.JupyterHttpUtilsKt;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/runtime/JupyterHttpParams;", "", "baseUrl", "Ljava/net/URI;", "authParams", "Lcom/intellij/jupyter/core/jupyter/connections/auth/JupyterAuthParams;", "authority", "", "useSystemProxy", "", "<init>", "(Ljava/net/URI;Lcom/intellij/jupyter/core/jupyter/connections/auth/JupyterAuthParams;Ljava/lang/String;Z)V", "getBaseUrl", "()Ljava/net/URI;", "getAuthParams", "()Lcom/intellij/jupyter/core/jupyter/connections/auth/JupyterAuthParams;", "getAuthority", "()Ljava/lang/String;", "getUseSystemProxy", "()Z", "toUrl", "toURI", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterHttpParams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterHttpParams.kt\ncom/intellij/jupyter/core/jupyter/connections/runtime/JupyterHttpParams\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,30:1\n1#2:31\n*E\n"})
public final class JupyterHttpParams {
    @NotNull
    private final URI baseUrl;
    @NotNull
    private final JupyterAuthParams authParams;
    @NotNull
    private final String authority;
    private final boolean useSystemProxy;

    public JupyterHttpParams(@NotNull URI baseUrl, @NotNull JupyterAuthParams authParams, @NotNull String authority, boolean useSystemProxy) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)authParams, (String)"authParams");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        this.baseUrl = baseUrl;
        this.authParams = authParams;
        this.authority = authority;
        this.useSystemProxy = useSystemProxy;
    }

    public /* synthetic */ JupyterHttpParams(URI uRI, JupyterAuthParams jupyterAuthParams, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(uRI, jupyterAuthParams, string, bl);
    }

    @NotNull
    public final URI getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final JupyterAuthParams getAuthParams() {
        return this.authParams;
    }

    @NotNull
    public final String getAuthority() {
        return this.authority;
    }

    public final boolean getUseSystemProxy() {
        return this.useSystemProxy;
    }

    @NotNull
    public final String toUrl() {
        String string = this.toURI().toASCIIString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toASCIIString(...)");
        return string;
    }

    @NotNull
    public final URI toURI() {
        URI uRI;
        if (this.authParams instanceof JupyterTokenAuthParams) {
            CharSequence charSequence;
            CharSequence charSequence2 = ((JupyterTokenAuthParams)this.authParams).getToken();
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            String token = (String)charSequence;
            uRI = token != null ? JupyterHttpUtilsKt.addQuery((URI)this.baseUrl, (String)"token", (String)token) : this.baseUrl;
        } else {
            uRI = this.baseUrl;
        }
        URI prepared = uRI;
        return prepared;
    }

    @NotNull
    public final URI component1() {
        return this.baseUrl;
    }

    @NotNull
    public final JupyterAuthParams component2() {
        return this.authParams;
    }

    @NotNull
    public final String component3() {
        return this.authority;
    }

    public final boolean component4() {
        return this.useSystemProxy;
    }

    @NotNull
    public final JupyterHttpParams copy(@NotNull URI baseUrl, @NotNull JupyterAuthParams authParams, @NotNull String authority, boolean useSystemProxy) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)authParams, (String)"authParams");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        return new JupyterHttpParams(baseUrl, authParams, authority, useSystemProxy);
    }

    public static /* synthetic */ JupyterHttpParams copy$default(JupyterHttpParams jupyterHttpParams, URI uRI, JupyterAuthParams jupyterAuthParams, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            uRI = jupyterHttpParams.baseUrl;
        }
        if ((n & 2) != 0) {
            jupyterAuthParams = jupyterHttpParams.authParams;
        }
        if ((n & 4) != 0) {
            string = jupyterHttpParams.authority;
        }
        if ((n & 8) != 0) {
            bl = jupyterHttpParams.useSystemProxy;
        }
        return jupyterHttpParams.copy(uRI, jupyterAuthParams, string, bl);
    }

    @NotNull
    public String toString() {
        return "JupyterHttpParams(baseUrl=" + this.baseUrl + ", authParams=" + this.authParams + ", authority=" + this.authority + ", useSystemProxy=" + this.useSystemProxy + ")";
    }

    public int hashCode() {
        int result = this.baseUrl.hashCode();
        result = result * 31 + this.authParams.hashCode();
        result = result * 31 + this.authority.hashCode();
        result = result * 31 + Boolean.hashCode(this.useSystemProxy);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JupyterHttpParams)) {
            return false;
        }
        JupyterHttpParams jupyterHttpParams = (JupyterHttpParams)other;
        if (!Intrinsics.areEqual((Object)this.baseUrl, (Object)jupyterHttpParams.baseUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.authParams, (Object)jupyterHttpParams.authParams)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.authority, (Object)jupyterHttpParams.authority)) {
            return false;
        }
        return this.useSystemProxy == jupyterHttpParams.useSystemProxy;
    }
}

