/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.debugger.common;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterInlineDebugRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.xdebugger.impl.inline.InlineDebugRendererBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\r0\u001a2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010#\u001a\u00020\u001bH\u0015R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/intellij/jupyter/core/jupyter/debugger/common/JupyterInlineDebugRendererBase;", "Lcom/intellij/xdebugger/impl/inline/InlineDebugRendererBase;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "createTime", "", "getCreateTime", "()J", "paint", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "executeReadActionAndUpdateCache", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "repaintIfNecessary", "Lkotlin/Function1;", "", "getInlineAttributes", "Lcom/intellij/openapi/editor/Editor;", "drawChevronIcon", "c", "Ljava/awt/Component;", "iconX", "", "calculateIsInExecutionPoint", "intellij.jupyter.core"})
@ApiStatus.Internal
public abstract class JupyterInlineDebugRendererBase
extends InlineDebugRendererBase {
    private final long createTime = System.currentTimeMillis();

    @Nullable
    protected abstract String getName();

    public final long getCreateTime() {
        return this.createTime;
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        int curX;
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Editor editor = inlay.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        EditorImpl editor2 = (EditorImpl)editor;
        this.executeReadActionAndUpdateCache(inlay, editor2);
        String string = this.getPresentation().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String text = string;
        TextAttributes inlineAttributes = this.getInlineAttributes((Editor)editor2);
        Font font = editor2.getColorsScheme().getFont(EditorFontType.ITALIC);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font font2 = font;
        Color textForegroundColor = inlineAttributes.getForegroundColor();
        FontMetrics metrics = g.getFontMetrics(font2);
        int initialOffset = metrics.charWidth(' ') * 4;
        this.myTextStartXCoordinate = curX = r.x + initialOffset;
        g.setColor(textForegroundColor);
        g.setFont(font2);
        g.drawString(text, curX, r.y + editor2.getAscent());
        Color color = inlineAttributes.getBackgroundColor();
        if (color != null) {
            Color bgColor = color;
            boolean bl = false;
            g.setColor(bgColor);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        curX += metrics.stringWidth(text);
        if (this.isHovered) {
            JComponent jComponent = editor2.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            this.drawChevronIcon(jComponent, g, curX, r);
        }
    }

    private final void executeReadActionAndUpdateCache(Inlay<?> inlay, EditorImpl editor) {
        Object[] objectArray = new Object[]{inlay};
        ReadAction.nonBlocking(() -> JupyterInlineDebugRendererBase.executeReadActionAndUpdateCache$lambda$1(this)).finishOnUiThread(ModalityState.stateForComponent((Component)editor.getComponent()), arg_0 -> JupyterInlineDebugRendererBase.executeReadActionAndUpdateCache$lambda$2(this.repaintIfNecessary(inlay), arg_0)).coalesceBy(objectArray).expireWith((Disposable)inlay).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private final Function1<Boolean, Unit> repaintIfNecessary(Inlay<?> inlay) {
        return arg_0 -> JupyterInlineDebugRendererBase.repaintIfNecessary$lambda$3(this, inlay, arg_0);
    }

    private final TextAttributes getInlineAttributes(Editor editor) {
        TextAttributes textAttributes;
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        TextAttributes inlinedAttributes = scheme.getAttributes(JupyterInlineDebugRenderer.Companion.getATTRIBUTES_KEY$intellij_jupyter_core());
        inlinedAttributes.setFontType(2);
        boolean bl = this.isHovered;
        if (bl) {
            TextAttributes hoveredInlineAttr = new TextAttributes();
            hoveredInlineAttr.copyFrom(inlinedAttributes);
            hoveredInlineAttr.setForegroundColor(scheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getForegroundColor());
            textAttributes = hoveredInlineAttr;
        } else if (!bl) {
            Intrinsics.checkNotNull((Object)inlinedAttributes);
            textAttributes = inlinedAttributes;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return textAttributes;
    }

    private final void drawChevronIcon(Component c, Graphics g, int iconX, Rectangle r) {
        Icon icon = AllIcons.General.LinkDropTriangle;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"LinkDropTriangle");
        Icon icon2 = icon;
        int iconY = r.y + r.height / 2 - icon2.getIconHeight() / 2;
        icon2.paintIcon(c, g, iconX, iconY);
    }

    @RequiresBackgroundThread
    protected boolean calculateIsInExecutionPoint() {
        return true;
    }

    private static final Boolean executeReadActionAndUpdateCache$lambda$1(JupyterInlineDebugRendererBase this$0) {
        return this$0.calculateIsInExecutionPoint();
    }

    private static final void executeReadActionAndUpdateCache$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit repaintIfNecessary$lambda$3(JupyterInlineDebugRendererBase this$0, Inlay $inlay, boolean freshValue) {
        if (freshValue != this$0.isInExecutionPointCached) {
            this$0.isInExecutionPointCached = freshValue;
            $inlay.repaint();
        }
        return Unit.INSTANCE;
    }
}

