/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.actions;

import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditorKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.CopyAction;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J:\u0010\u0010\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0011\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130\u00120\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/actions/JupyterCutHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler;", "defaultHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "executeWriteAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "runInJupyter", "", "mergeSelections", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "selections", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterCutHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterCutHandler.kt\ncom/intellij/jupyter/core/jupyter/editor/actions/JupyterCutHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1863#2,2:142\n1611#2,9:144\n1863#2:153\n1864#2:155\n1620#2:156\n1557#2:157\n1628#2,3:158\n1863#2,2:161\n1#3:154\n*S KotlinDebug\n*F\n+ 1 JupyterCutHandler.kt\ncom/intellij/jupyter/core/jupyter/editor/actions/JupyterCutHandler\n*L\n44#1:142,2\n50#1:144,9\n50#1:153\n50#1:155\n50#1:156\n62#1:157\n62#1:158,3\n67#1:161,2\n50#1:154\n*E\n"})
public final class JupyterCutHandler
extends EditorWriteActionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorActionHandler defaultHandler;

    public JupyterCutHandler(@NotNull EditorActionHandler defaultHandler) {
        Intrinsics.checkNotNullParameter((Object)defaultHandler, (String)"defaultHandler");
        this.defaultHandler = defaultHandler;
    }

    public void executeWriteAction(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        boolean success = this.runInJupyter(editor, dataContext);
        if (!success) {
            this.defaultHandler.execute(editor, caret, dataContext);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean runInJupyter(Editor editor, DataContext dataContext) {
        void $this$mapTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable it;
        if (!JupyterFileEditorKt.isJupyter(editor) || !editor.getCaretModel().supportsMultipleCarets()) {
            return false;
        }
        boolean hasAnySelection = editor.getSelectionModel().hasSelection(true);
        if (!hasAnySelection && CopyAction.isSkipCopyPasteForEmptySelection()) {
            return false;
        }
        if (!hasAnySelection) {
            List list = editor.getCaretModel().getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Caret)element$iv;
                boolean bl = false;
                it.selectLineAtCaret();
            }
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        List list = editor.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Iterable<Pair> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Caret caret = (Caret)element$iv$iv;
            boolean bl2 = false;
            if ((caret.hasSelection() ? new Pair((Object)caret, (Object)new TextRange(caret.getSelectionStart(), caret.getSelectionEnd())) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List initialSelections = (List)destination$iv$iv;
        EditorActionManager.getInstance().getActionHandler("EditorCopy").execute(editor, null, dataContext);
        Iterable $this$map$iv = this.mergeSelections(initialSelections);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            List carets = (List)pair.component1();
            TextRange selections = (TextRange)pair.component2();
            collection.add(new Pair((Object)carets, (Object)Companion.improvedSelection$intellij_jupyter_core(editor, selections.getStartOffset(), selections.getEndOffset())));
        }
        List improvedSelections = (List)destination$iv$iv2;
        editor.getCaretModel().runBatchCaretOperation(() -> JupyterCutHandler.runInJupyter$lambda$4(improvedSelections, document2));
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        return true;
    }

    private final List<Pair<List<Caret>, TextRange>> mergeSelections(List<? extends Pair<? extends Caret, ? extends TextRange>> selections) {
        SmartList mergedSelections = new SmartList();
        for (Pair<? extends Caret, ? extends TextRange> pair : selections) {
            boolean bl;
            Caret caret = (Caret)pair.component1();
            TextRange selection = (TextRange)pair.component2();
            Pair last = (Pair)CollectionsKt.removeLastOrNull((List)((List)mergedSelections));
            if (last == null) {
                bl = mergedSelections.add((Object)new Pair((Object)new SmartList((Object)caret), (Object)selection));
                continue;
            }
            if (((TextRange)last.getSecond()).getEndOffset() == selection.getStartOffset()) {
                ((SmartList)last.getFirst()).add((Object)caret);
                bl = mergedSelections.add((Object)new Pair(last.getFirst(), (Object)new TextRange(((TextRange)last.getSecond()).getStartOffset(), selection.getEndOffset())));
                continue;
            }
            mergedSelections.add((Object)last);
            bl = mergedSelections.add((Object)new Pair((Object)new SmartList((Object)caret), (Object)selection));
        }
        return (List)mergedSelections;
    }

    private static final void runInJupyter$lambda$4(List $improvedSelections, Document $document) {
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)$improvedSelections);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            List carets = (List)pair.component1();
            TextRange range = (TextRange)pair.component2();
            for (Caret caret : carets) {
                caret.moveToOffset(range.getStartOffset());
                caret.removeSelection();
            }
            $document.deleteString(range.getStartOffset(), range.getEndOffset());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/actions/JupyterCutHandler$Companion;", "", "<init>", "()V", "improvedSelection", "Lcom/intellij/openapi/util/TextRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "selectionStart", "", "selectionEnd", "improvedSelection$intellij_jupyter_core", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextRange improvedSelection$intellij_jupyter_core(@NotNull Editor editor, int selectionStart, int selectionEnd) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (selectionStart == selectionEnd) {
                return new TextRange(selectionStart, selectionEnd);
            }
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            int selectionStartLine = document2.getLineNumber(selectionStart);
            int selectionEndLine = document2.getLineNumber(selectionEnd);
            NotebookCellLines.Interval cell = NotebookVisualizationUiUtilKt.getCell((Editor)editor, (int)selectionStartLine);
            if (selectionEndLine != cell.getLines().getLast() + 1 || selectionEnd != document2.getLineStartOffset(selectionEndLine)) {
                return new TextRange(selectionStart, selectionEnd);
            }
            return selectionStartLine > cell.getFirstContentLine() && document2.getLineStartOffset(selectionStartLine) == selectionStart ? new TextRange(selectionStart - 1, selectionEnd - 1) : (selectionStartLine == cell.getLines().getFirst() ? new TextRange(selectionStart, selectionEnd) : new TextRange(selectionStart, selectionEnd - 1));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

