/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.jupyter.core.editor.NotebookExecutionInfo;
import com.intellij.jupyter.core.editor.NotebookExecutionInfoKt;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewCellElement;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewRoot;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewSelectionManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010\u001e\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u0018J\u0016\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010&2\u0006\u0010#\u001a\u00020\u0016J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0012R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel;", "Lcom/intellij/ide/structureView/TextEditorBasedStructureViewModel;", "Lcom/intellij/ide/structureView/StructureViewModel$ElementInfoProvider;", "psiFile", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;Lcom/intellij/openapi/editor/Editor;)V", "selectionManager", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewSelectionManager;", "getSelectionManager", "()Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewSelectionManager;", "setSelectionManager", "(Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewSelectionManager;)V", "executionInfo", "Lcom/intellij/jupyter/core/editor/NotebookExecutionInfo;", "cachedExecutingCellOrdinal", "", "Ljava/lang/Integer;", "intervalToElements", "", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewCellElement;", "getRoot", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "isAlwaysShowsPlus", "", "element", "isAlwaysLeaf", "getEditor", "fireModelUpdate", "", "setIntervalToComponent", "interval", "component", "getComponentsByInterval", "", "getCellStatus", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "ordinal", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterStructureViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterStructureViewModel.kt\ncom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1755#2,3:56\n*S KotlinDebug\n*F\n+ 1 JupyterStructureViewModel.kt\ncom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel\n*L\n45#1:56,3\n*E\n"})
public final class JupyterStructureViewModel
extends TextEditorBasedStructureViewModel
implements StructureViewModel.ElementInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Editor editor;
    @Nullable
    private JupyterStructureViewSelectionManager selectionManager;
    @Nullable
    private final NotebookExecutionInfo executionInfo;
    @Nullable
    private Integer cachedExecutingCellOrdinal;
    @NotNull
    private final Map<NotebookCellLines.Interval, List<JupyterStructureViewCellElement>> intervalToElements;
    @NotNull
    private static final Key<JupyterStructureViewModel> JUPYTER_STRUCTURE_MODEL_KEY;

    public JupyterStructureViewModel(@NotNull JupyterFile psiFile, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        super(editor, (PsiFile)psiFile);
        Editor editor2 = this.editor = editor;
        this.executionInfo = editor2 != null ? NotebookExecutionInfoKt.getExecutionInfo(editor2) : null;
        this.intervalToElements = new LinkedHashMap();
    }

    @Nullable
    public final JupyterStructureViewSelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public final void setSelectionManager(@Nullable JupyterStructureViewSelectionManager jupyterStructureViewSelectionManager) {
        this.selectionManager = jupyterStructureViewSelectionManager;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        PsiFile psiFile = this.getPsiFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile");
        return new JupyterStructureViewRoot((JupyterFile)psiFile, this);
    }

    public boolean isAlwaysShowsPlus(@Nullable StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(@Nullable StructureViewTreeElement element) {
        return false;
    }

    @Nullable
    public Editor getEditor() {
        return this.editor;
    }

    public void fireModelUpdate() {
        this.cachedExecutingCellOrdinal = null;
        super.fireModelUpdate();
    }

    public final boolean setIntervalToComponent(@NotNull NotebookCellLines.Interval interval, @NotNull JupyterStructureViewCellElement component2) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        return this.intervalToElements.computeIfAbsent(interval, arg_0 -> JupyterStructureViewModel.setIntervalToComponent$lambda$1(JupyterStructureViewModel::setIntervalToComponent$lambda$0, arg_0)).add(component2);
    }

    @Nullable
    public final List<JupyterStructureViewCellElement> getComponentsByInterval(@NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.intervalToElements.get(interval);
    }

    @NotNull
    public final ProgressStatus getCellStatus(int ordinal) {
        ProgressStatus progressStatus;
        NotebookExecutionInfo notebookExecutionInfo = this.executionInfo;
        if (notebookExecutionInfo == null) {
            return ProgressStatus.NOT_STARTED;
        }
        NotebookExecutionInfo info = notebookExecutionInfo;
        NotebookIntervalPointer notebookIntervalPointer = info.getCurrentCell();
        Integer currentCellOrdinal = notebookIntervalPointer != null && (notebookIntervalPointer = notebookIntervalPointer.get()) != null ? Integer.valueOf(notebookIntervalPointer.getOrdinal()) : null;
        if (currentCellOrdinal == null) {
            progressStatus = ProgressStatus.NOT_STARTED;
        } else if (ordinal == currentCellOrdinal && info.getCurrentStatus() == ProgressStatus.RUNNING) {
            progressStatus = ProgressStatus.RUNNING;
        } else {
            NotebookCellLines.Interval interval;
            NotebookIntervalPointer notebookIntervalPointer2;
            boolean bl;
            block8: {
                Iterable $this$any$iv = info.getExecutionQueue();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        NotebookIntervalPointer it = (NotebookIntervalPointer)element$iv;
                        boolean bl2 = false;
                        NotebookCellLines.Interval interval2 = it.get();
                        boolean bl3 = interval2 != null ? interval2.getOrdinal() == ordinal : false;
                        if (!bl3) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            progressStatus = bl ? ProgressStatus.QUEUED : (((notebookIntervalPointer2 = info.getErrorCell()) != null && (interval = notebookIntervalPointer2.get()) != null ? ordinal == interval.getOrdinal() : false) && info.getCurrentStatus() == ProgressStatus.STOPPED_ERROR ? ProgressStatus.STOPPED_ERROR : ProgressStatus.NOT_STARTED);
        }
        return progressStatus;
    }

    private static final List setIntervalToComponent$lambda$0(NotebookCellLines.Interval it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List setIntervalToComponent$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    static {
        Key key = Key.create((String)"JUPYTER_STRUCTURE_VIEW_MODEL");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        JUPYTER_STRUCTURE_MODEL_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel$Companion;", "", "<init>", "()V", "JUPYTER_STRUCTURE_MODEL_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewModel;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getJUPYTER_STRUCTURE_MODEL_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<JupyterStructureViewModel> getJUPYTER_STRUCTURE_MODEL_KEY() {
            return JUPYTER_STRUCTURE_MODEL_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

