/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import java.io.File;
import java.nio.file.Path;
import java.util.Date;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PluginDescriptor {
    @NotNull
    public PluginId getPluginId();

    @Nullable
    public ClassLoader getPluginClassLoader();

    @ApiStatus.Experimental
    @NotNull
    default public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.getPluginClassLoader();
        ClassLoader classLoader2 = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        if (classLoader2 == null) {
            PluginDescriptor.$$$reportNull$$$0(0);
        }
        return classLoader2;
    }

    default public boolean isBundled() {
        return false;
    }

    @Deprecated
    default public File getPath() {
        Path path = this.getPluginPath();
        return path == null ? null : path.toFile();
    }

    public Path getPluginPath();

    @Nullable
    @Nls
    public String getDescription();

    @Nullable
    public String getChangeNotes();

    @NlsSafe
    public String getName();

    @Nullable
    public String getProductCode();

    @Nullable
    public Date getReleaseDate();

    public int getReleaseVersion();

    public boolean isLicenseOptional();

    @Nullable
    @NlsSafe
    public String getVendor();

    @Nullable
    @NlsSafe
    default public String getOrganization() {
        return null;
    }

    @NlsSafe
    public String getVersion();

    @Nullable
    public String getResourceBundleBaseName();

    @Nullable
    @NlsSafe
    public String getCategory();

    @Nullable
    @Nls
    default public String getDisplayCategory() {
        return this.getCategory();
    }

    @Nullable
    public String getVendorEmail();

    @Nullable
    public String getVendorUrl();

    @Nullable
    public String getUrl();

    @Nullable
    @NlsSafe
    public String getSinceBuild();

    @Nullable
    @NlsSafe
    public String getUntilBuild();

    default public boolean allowBundledUpdate() {
        return false;
    }

    @ApiStatus.Internal
    default public boolean isImplementationDetail() {
        return false;
    }

    default public boolean isRequireRestart() {
        return false;
    }

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/PluginDescriptor", "getClassLoader"));
    }
}

