/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ReadEnv;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EnvReader
extends EnvironmentUtil.ShellEnvReader {
    private static final String READ_ENV_CLASS_NAME = ReadEnv.class.getCanonicalName();

    @Nullable
    private static String readEnvClasspath() {
        return PathManager.getJarPathForClass(ReadEnv.class);
    }

    @NotNull
    private static String javaExePath() {
        String string = (System.getProperty("java.home") + "/bin/java").replace('/', File.separatorChar);
        if (string == null) {
            EnvReader.$$$reportNull$$$0(0);
        }
        return string;
    }

    public EnvReader() {
    }

    public EnvReader(long timeoutMillis) {
        super(timeoutMillis);
    }

    @NotNull
    public Map<String, String> readBatEnv(@Nullable Path batchFile, List<String> args) throws IOException {
        Map map = (Map)this.readBatOutputAndEnv((Path)batchFile, args).second;
        if (map == null) {
            EnvReader.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    public final Pair<String, Map<String, String>> readBatOutputAndEnv(@Nullable Path batchFile, @Nullable List<@NotNull String> args) throws IOException {
        return this.readBatOutputAndEnv(batchFile, args, "cmd.exe");
    }

    @NotNull
    public final Pair<String, Map<String, String>> readBatOutputAndEnv(@Nullable Path batchFile, @Nullable List<@NotNull String> args, @NotNull String cmdExePath) throws IOException {
        if (cmdExePath == null) {
            EnvReader.$$$reportNull$$$0(2);
        }
        Pair<String, Map<String, String>> pair = this.readBatOutputAndEnv(batchFile, args, cmdExePath, it -> {});
        if (pair == null) {
            EnvReader.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @NotNull
    public Pair<String, Map<String, String>> readBatOutputAndEnv(@Nullable Path batchFile, @Nullable List<@NotNull String> args, @NotNull String cmdExePath, @NotNull @NotNull Consumer<? super @NotNull Map<String, String>> scriptEnvironmentProcessor) throws IOException {
        if (cmdExePath == null) {
            EnvReader.$$$reportNull$$$0(4);
        }
        if (scriptEnvironmentProcessor == null) {
            EnvReader.$$$reportNull$$$0(5);
        }
        if (batchFile != null && !Files.exists(batchFile, new LinkOption[0])) {
            throw new NoSuchFileException(batchFile.toString());
        }
        Path envDataFile = Files.createTempFile("intellij-cmd-env-data.", ".tmp", new FileAttribute[0]);
        ArrayList<String> callArgs = new ArrayList<String>();
        if (batchFile != null) {
            callArgs.add("call");
            callArgs.add(batchFile.toString());
            if (args != null) {
                callArgs.addAll(args);
            }
            callArgs.add("1>&2");
            callArgs.add("&&");
        }
        callArgs.add(EnvReader.javaExePath());
        callArgs.add("-cp");
        callArgs.add(PathManager.getJarPathForClass(ReadEnv.class));
        callArgs.add(ReadEnv.class.getCanonicalName());
        callArgs.add(envDataFile.toString());
        callArgs.add("||");
        callArgs.add("exit");
        callArgs.add("/B");
        callArgs.add("%ERRORLEVEL%");
        ArrayList<@NonNls String> cl = new ArrayList<String>();
        cl.add(cmdExePath);
        cl.add("/c");
        cl.add(EnvReader.prepareCallArgs(callArgs));
        Map.Entry entry = this.runProcessAndReadOutputAndEnvs(cl, batchFile != null ? batchFile.getParent() : null, scriptEnvironmentProcessor, envDataFile);
        return new Pair((Object)((String)entry.getKey()), (Object)((Map)entry.getValue()));
    }

    @NotNull
    public Pair<String, Map<String, String>> readPs1OutputAndEnv(@Nullable Path ps1Path, @Nullable List<@NotNull String> args, @NotNull @NotNull Consumer<? super @NotNull Map<String, String>> scriptEnvironmentProcessor) throws IOException {
        String innerScriptlet;
        if (scriptEnvironmentProcessor == null) {
            EnvReader.$$$reportNull$$$0(6);
        }
        if (ps1Path != null && !Files.exists(ps1Path, new LinkOption[0])) {
            throw new NoSuchFileException(ps1Path.toString());
        }
        Path envDataFile = Files.createTempFile("intellij-cmd-env-data.", ".tmp", new FileAttribute[0]);
        if (ps1Path == null) {
            innerScriptlet = "";
        } else {
            String argsStr = args == null ? "" : String.join((CharSequence)" ", args);
            innerScriptlet = String.format(Locale.ROOT, "& '%s' %s ; if (-not $?) { exit $LASTEXITCODE }; ", ps1Path, argsStr);
        }
        String scriptlet = String.format(Locale.ROOT, "& { %s & '%s' -cp '%s' %s '%s' ; exit $LASTEXITCODE }", innerScriptlet, EnvReader.javaExePath(), EnvReader.readEnvClasspath(), READ_ENV_CLASS_NAME, envDataFile.toString());
        String shellName = PathEnvironmentVariableUtil.findExecutableInWindowsPath("pwsh", "powershell.exe");
        List<String> command = List.of(shellName, "-ExecutionPolicy", "Bypass", "-NonInteractive", "-Command", scriptlet);
        Path workingDir = ps1Path != null ? ps1Path.getParent() : null;
        Map.Entry output = this.runProcessAndReadOutputAndEnvs(command, workingDir, scriptEnvironmentProcessor, envDataFile);
        return new Pair((Object)((String)output.getKey()), (Object)((Map)output.getValue()));
    }

    @NotNull
    Map<String, String> readPs1Env(Path ps1Path, List<String> args) throws IOException {
        Map map = (Map)this.readPs1OutputAndEnv((Path)ps1Path, args, (Consumer<Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$readPs1Env$1(java.util.Map ), (Ljava/util/Map;)V)()).second;
        if (map == null) {
            EnvReader.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    private static String prepareCallArgs(@NotNull List<String> callArgs) {
        if (callArgs == null) {
            EnvReader.$$$reportNull$$$0(8);
        }
        List preparedCallArgs = CommandLineUtil.toCommandLine(callArgs);
        String firstArg = (String)preparedCallArgs.remove(0);
        preparedCallArgs.add(0, CommandLineUtil.escapeParameterOnWindows((String)firstArg, (boolean)false));
        String string = "\"" + String.join((CharSequence)" ", preparedCallArgs) + "\"";
        if (string == null) {
            EnvReader.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void lambda$readPs1Env$1(Map it) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/EnvReader";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdExePath";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptEnvironmentProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "javaExePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readBatEnv";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/EnvReader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readBatOutputAndEnv";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readPs1Env";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCallArgs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readBatOutputAndEnv";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readPs1OutputAndEnv";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareCallArgs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6, 8 -> new IllegalArgumentException(string);
        };
    }
}

