/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerListener;
import git4idea.commands.GitTextHandler;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class GitSimpleHandler
extends GitTextHandler {
    private final StringBuilder myStderr;
    private final StringBuilder myStderrLine;
    private final StringBuilder myStdout;
    private final StringBuilder myStdoutLine;
    private final HashSet<Integer> myIgnoredErrorCodes;

    public GitSimpleHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        if (project == null) {
            GitSimpleHandler.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            GitSimpleHandler.$$$reportNull$$$0(1);
        }
        if (command == null) {
            GitSimpleHandler.$$$reportNull$$$0(2);
        }
        super(project, directory, command);
        this.myStderr = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myStdout = new StringBuilder();
        this.myStdoutLine = new StringBuilder();
        this.myIgnoredErrorCodes = new HashSet();
    }

    public GitSimpleHandler(@NotNull Project project, @NotNull VirtualFile directory, @NotNull GitCommand command) {
        if (project == null) {
            GitSimpleHandler.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            GitSimpleHandler.$$$reportNull$$$0(4);
        }
        if (command == null) {
            GitSimpleHandler.$$$reportNull$$$0(5);
        }
        super(project, directory, command);
        this.myStderr = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myStdout = new StringBuilder();
        this.myStdoutLine = new StringBuilder();
        this.myIgnoredErrorCodes = new HashSet();
    }

    @Override
    protected void processTerminated(int exitCode) {
        String stdout = this.myStdoutLine.toString();
        String stderr = this.myStderrLine.toString();
        if (!this.isStdoutSuppressed() && !StringUtil.isEmptyOrSpaces((String)stdout)) {
            LOG.info(stdout.trim());
            this.myStdoutLine.setLength(0);
        } else if (!this.isStderrSuppressed() && !StringUtil.isEmptyOrSpaces((String)stderr)) {
            LOG.info(stderr.trim());
            this.myStderrLine.setLength(0);
        } else {
            LOG.debug(stderr.trim());
        }
    }

    protected void onTextAvailable(String text2, Key outputType) {
        boolean suppressed;
        StringBuilder lineRest;
        StringBuilder entire;
        if (ProcessOutputTypes.STDOUT == outputType) {
            entire = this.myStdout;
            lineRest = this.myStdoutLine;
            suppressed = this.isStdoutSuppressed();
        } else if (ProcessOutputTypes.STDERR == outputType) {
            entire = this.myStderr;
            lineRest = this.myStderrLine;
            suppressed = this.isStderrSuppressed();
        } else {
            return;
        }
        entire.append(text2);
        if (suppressed && !LOG.isDebugEnabled()) {
            return;
        }
        char last = !lineRest.isEmpty() ? (char)lineRest.charAt(lineRest.length() - 1) : (char)'\uffffffff';
        int start = 0;
        for (int i = 0; i < text2.length(); ++i) {
            char ch = text2.charAt(i);
            if (last == '\n' || last == '\r') {
                int savedPos = (ch == '\n' || ch == '\r') && ch != last ? i - 1 : i;
                if (last != '\r' || savedPos != i) {
                    String line;
                    if (lineRest.isEmpty()) {
                        line = lineRest.append(text2, start, savedPos).toString();
                        lineRest.setLength(0);
                    } else {
                        line = text2.substring(start, savedPos);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)line)) {
                        if (!suppressed) {
                            LOG.info(line.trim());
                        } else {
                            LOG.debug(line.trim());
                        }
                    }
                }
                start = savedPos;
            }
            last = ch;
        }
        if (start != text2.length()) {
            lineRest.append(text2.substring(start));
        }
    }

    @NlsSafe
    public String getStderr() {
        return this.myStderr.toString();
    }

    @NlsSafe
    public String getStdout() {
        return this.myStdout.toString();
    }

    @NlsSafe
    public String run() throws VcsException {
        final Ref exRef = Ref.create();
        final Ref resultRef = Ref.create();
        this.addListener(new GitHandlerListener(){

            public void processTerminated(int exitCode) {
                try {
                    if (exitCode == 0 || GitSimpleHandler.this.isIgnoredErrorCode(exitCode)) {
                        resultRef.set((Object)GitSimpleHandler.this.getStdout());
                    } else {
                        String msg = GitSimpleHandler.this.getStderr();
                        if (msg.isEmpty()) {
                            msg = GitSimpleHandler.this.getStdout();
                        }
                        if (msg.isEmpty()) {
                            msg = GitBundle.message("git.error.exit", exitCode);
                        }
                        exRef.set((Object)new VcsException(msg));
                    }
                }
                catch (Throwable t) {
                    exRef.set((Object)new VcsException(t.toString(), t));
                }
            }

            public void startFailed(@NotNull Throwable exception) {
                if (exception == null) {
                    1.$$$reportNull$$$0(0);
                }
                exRef.set((Object)new VcsException(GitBundle.message("git.executable.unknown.error.message", exception.getMessage()), exception));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "git4idea/commands/GitSimpleHandler$1", "startFailed"));
            }
        });
        try {
            this.runInCurrentThread();
        }
        catch (IOException e) {
            exRef.set((Object)new VcsException(e.getMessage(), (Throwable)e));
        }
        if (!exRef.isNull()) {
            throw (VcsException)((Object)exRef.get());
        }
        if (resultRef.isNull()) {
            throw new VcsException(GitBundle.message("git.error.cant.process.output", this.printableCommandLine()));
        }
        return (String)resultRef.get();
    }

    @Override
    protected OSProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            GitSimpleHandler.$$$reportNull$$$0(6);
        }
        OSProcessHandler process = super.createProcess(commandLine);
        process.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                GitSimpleHandler.this.onTextAvailable(event.getText(), outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "git4idea/commands/GitSimpleHandler$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return process;
    }

    public void ignoreErrorCode(int code) {
        this.myIgnoredErrorCodes.add(code);
    }

    public boolean isIgnoredErrorCode(int code) {
        return this.myIgnoredErrorCodes.contains(code);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        objectArray2[1] = "git4idea/commands/GitSimpleHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

