/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.collections.list.ObservableList;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.ErrorBarGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.FlippableGeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0002()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0002J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J&\u0010#\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u00010\u00110$2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "isVertical", "", "(Z)V", "flipHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/FlippableGeomHelper;", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "wontRender", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "getWontRender", "()Ljava/util/List;", "afterRotation", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "rectangle", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "segment", "", "aes", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "clientRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "Companion", "ErrorBarLegendKeyElementFactory", "plot-base"})
@SourceDebugExtension(value={"SMAP\nErrorBarGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1549#2:167\n1620#2,3:168\n1549#2:171\n1620#2,3:172\n*S KotlinDebug\n*F\n+ 1 ErrorBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom\n*L\n41#1:167\n41#1:168,3\n69#1:171\n69#1:172,3\n*E\n"})
public final class ErrorBarGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isVertical;
    @NotNull
    private final FlippableGeomHelper flipHelper;
    public static final boolean HANDLES_GROUPS = false;

    public ErrorBarGeom(boolean isVertical) {
        this.isVertical = isVertical;
        this.flipHelper = new FlippableGeomHelper(this.isVertical);
    }

    private final Aes<Double> afterRotation(Aes<Double> aes2) {
        return this.flipHelper.getEffectiveAes(aes2);
    }

    private final DoubleRectangle afterRotation(DoubleRectangle rectangle) {
        return this.flipHelper.flip(rectangle);
    }

    private final DoubleSegment afterRotation(DoubleSegment segment2) {
        return this.flipHelper.flip(segment2);
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new ErrorBarLegendKeyElementFactory();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Aes<?>> getWontRender() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Aes[]{Aes.Companion.getY(), Aes.Companion.getXMIN(), Aes.Companion.getXMAX(), Aes.Companion.getHEIGHT()};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Aes aes2 = (Aes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.afterRotation((Aes<Double>)p0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Aes<Double> xAes = this.afterRotation(Aes.Companion.getX());
        Aes<Double> minAes = this.afterRotation(Aes.Companion.getYMIN());
        Aes<Double> maxAes = this.afterRotation(Aes.Companion.getYMAX());
        Aes<Double> widthAes = this.afterRotation(Aes.Companion.getWIDTH());
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.ERROR_BAR, ctx2);
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            void $this$mapTo$iv$iv;
            Double d = p.finiteOrNull(xAes);
            if (d == null) {
                continue;
            }
            double x2 = d;
            Double d2 = p.finiteOrNull(minAes);
            if (d2 == null) {
                continue;
            }
            double ymin = d2;
            Double d3 = p.finiteOrNull(maxAes);
            if (d3 == null) {
                continue;
            }
            double ymax = d3;
            Double d4 = p.finiteOrNull(widthAes);
            if (d4 == null) {
                continue;
            }
            double w = d4;
            double width2 = w * ctx2.getResolution(xAes);
            double height = ymax - ymin;
            DoubleRectangle rect2 = new DoubleRectangle(x2 - width2 / (double)2, ymin, width2, height);
            Iterable $this$map$iv = ErrorBarGeom.Companion.errorBarShapeSegments(rect2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                DoubleSegment doubleSegment = (DoubleSegment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.afterRotation((DoubleSegment)p0));
            }
            List segments = (List)destination$iv$iv;
            SvgGElement g = ErrorBarGeom.Companion.errorBarShape(segments, p, geomHelper);
            root.add(g);
        }
        Object[] objectArray = new Aes[]{minAes, maxAes};
        FlippableGeomHelper.buildHints$default(this.flipHelper, CollectionsKt.listOf((Object[])objectArray), aesthetics2, pos, coord, ctx2, this.clientRectByDataPoint(ctx2, geomHelper), buildIntern.1.INSTANCE, colorsByDataPoint, null, 256, null);
    }

    private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(GeomContext ctx2, GeomHelper geomHelper) {
        return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(this, ctx2, geomHelper){
            final /* synthetic */ ErrorBarGeom this$0;
            final /* synthetic */ GeomContext $ctx;
            final /* synthetic */ GeomHelper $geomHelper;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$geomHelper = $geomHelper;
                super(1, Intrinsics.Kotlin.class, "factory", "clientRectByDataPoint$factory(Lorg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom;Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", 0);
            }

            @Nullable
            public final DoubleRectangle invoke(@NotNull DataPointAesthetics p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ErrorBarGeom.access$clientRectByDataPoint$factory(this.this$0, this.$ctx, this.$geomHelper, p0);
            }
        };
    }

    private static final DoubleRectangle clientRectByDataPoint$factory(ErrorBarGeom this$0, GeomContext $ctx, GeomHelper $geomHelper, DataPointAesthetics p) {
        Aes<Double> xAes = this$0.afterRotation(Aes.Companion.getX());
        Aes<Double> minAes = this$0.afterRotation(Aes.Companion.getYMIN());
        Aes<Double> maxAes = this$0.afterRotation(Aes.Companion.getYMAX());
        Aes<Double> widthAes = this$0.afterRotation(Aes.Companion.getWIDTH());
        Double d = p.finiteOrNull(xAes);
        if (d == null) {
            return null;
        }
        double x2 = d;
        Double d2 = p.finiteOrNull(minAes);
        if (d2 == null) {
            return null;
        }
        double ymin = d2;
        Double d3 = p.finiteOrNull(maxAes);
        if (d3 == null) {
            return null;
        }
        double ymax = d3;
        Double d4 = p.finiteOrNull(widthAes);
        if (d4 == null) {
            return null;
        }
        double w = d4;
        double width2 = w * $ctx.getResolution(xAes);
        double height = ymax - ymin;
        DoubleRectangle doubleRectangle = $geomHelper.toClient(this$0.afterRotation(new DoubleRectangle(x2 - width2 / 2.0, ymax - height / 2.0, width2, 0.0)), p);
        Intrinsics.checkNotNull((Object)doubleRectangle);
        DoubleRectangle rect2 = doubleRectangle;
        return rect2;
    }

    public static final /* synthetic */ DoubleRectangle access$clientRectByDataPoint$factory(ErrorBarGeom this$0, GeomContext $ctx, GeomHelper $geomHelper, DataPointAesthetics p) {
        return ErrorBarGeom.clientRectByDataPoint$factory(this$0, $ctx, $geomHelper, p);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "errorBarLegendShape", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "segments", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "errorBarShape", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "errorBarShapeSegments", "r", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nErrorBarGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1855#2,2:167\n1855#2,2:169\n*S KotlinDebug\n*F\n+ 1 ErrorBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom$Companion\n*L\n128#1:167,2\n155#1:169,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final SvgGElement errorBarLegendShape(List<DoubleSegment> segments, DataPointAesthetics p) {
            SvgGElement g = new SvgGElement();
            Iterable $this$forEach$iv = segments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DoubleSegment segment2 = (DoubleSegment)element$iv;
                boolean bl = false;
                SvgLineElement shapeLine = new SvgLineElement(segment2.getStart().getX(), segment2.getStart().getY(), segment2.getEnd().getX(), segment2.getEnd().getY());
                GeomHelper.Companion.decorate$default(GeomHelper.Companion, shapeLine, p, false, null, false, 28, null);
                g.children().add(shapeLine);
            }
            return g;
        }

        private final List<DoubleSegment> errorBarShapeSegments(DoubleRectangle r) {
            double center = r.getLeft() + r.getWidth() / (double)2;
            DoubleRectangle $this$errorBarShapeSegments_u24lambda_u241 = r;
            boolean bl = false;
            Object[] objectArray = new DoubleSegment[]{new DoubleSegment(new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getLeft(), $this$errorBarShapeSegments_u24lambda_u241.getTop()), new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getRight(), $this$errorBarShapeSegments_u24lambda_u241.getTop())), new DoubleSegment(new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getLeft(), $this$errorBarShapeSegments_u24lambda_u241.getBottom()), new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getRight(), $this$errorBarShapeSegments_u24lambda_u241.getBottom())), new DoubleSegment(new DoubleVector(center, $this$errorBarShapeSegments_u24lambda_u241.getTop()), new DoubleVector(center, $this$errorBarShapeSegments_u24lambda_u241.getBottom()))};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private final SvgGElement errorBarShape(List<DoubleSegment> segments, DataPointAesthetics p, GeomHelper geomHelper) {
            SvgGElement g = new SvgGElement();
            GeomHelper.SvgElementHelper elementHelper = geomHelper.createSvgElementHelper();
            elementHelper.setStrokeAlphaEnabled(true);
            Iterable $this$forEach$iv = segments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DoubleSegment segment2 = (DoubleSegment)element$iv;
                boolean bl = false;
                ObservableList<SvgNode> observableList = g.children();
                Pair pair2 = GeomHelper.SvgElementHelper.createLine$default(elementHelper, segment2.getStart(), segment2.getEnd(), p, null, 8, null);
                Intrinsics.checkNotNull((Object)pair2);
                observableList.add(pair2.getFirst());
            }
            return g;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom$ErrorBarLegendKeyElementFactory;", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "()V", "createKeyElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-base"})
    public static final class ErrorBarLegendKeyElementFactory
    implements LegendKeyElementFactory {
        @Override
        @NotNull
        public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size2) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            double strokeWidth = AesScaling.INSTANCE.strokeWidth(p);
            Double d = p.width();
            Intrinsics.checkNotNull((Object)d);
            double width2 = d * (size2.getX() - strokeWidth);
            double height = size2.getY() - strokeWidth;
            double x2 = (size2.getX() - width2) / (double)2;
            double y2 = strokeWidth / (double)2;
            return Companion.errorBarLegendShape(Companion.errorBarShapeSegments(new DoubleRectangle(x2, y2, width2, height)), p);
        }

        @Override
        @NotNull
        public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
            return LegendKeyElementFactory.DefaultImpls.minimumKeySize(this, p);
        }
    }
}

