/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.FilledSquareLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.render.svg.TextLabel;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgImageElementEx;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/RasterGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nRasterGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RasterGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/RasterGeom\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class RasterGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = false;

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new FilledSquareLegendKeyElementFactory();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        double height;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Iterator<DataPointAesthetics> iter = GeomUtil.INSTANCE.with_X_Y(aesthetics2.dataPoints()).iterator();
        if (!iter.hasNext()) {
            return;
        }
        DataPointAesthetics randomP = iter.next();
        GeomHelper helper2 = new GeomHelper(pos, coord, ctx2);
        DoubleRectangle boundsXY = GeomBase.Companion.layerAesBounds(aesthetics2);
        double stepX = ctx2.getResolution(Aes.Companion.getX());
        double stepY = ctx2.getResolution(Aes.Companion.getY());
        if (!(stepX > 1.0E-50)) {
            boolean $i$a$-require-RasterGeom$buildIntern$32 = false;
            String $i$a$-require-RasterGeom$buildIntern$32 = "x-step is too small: " + stepX;
            throw new IllegalArgumentException($i$a$-require-RasterGeom$buildIntern$32.toString());
        }
        if (!(stepY > 1.0E-50)) {
            boolean bl = false;
            String string = "y-step is too small: " + stepY;
            throw new IllegalArgumentException(string.toString());
        }
        double width2 = Math.rint(boundsXY.getDimension().getX() / stepX) + 1.0;
        if (width2 * (height = Math.rint(boundsXY.getDimension().getY() / stepY) + 1.0) > 5000000.0) {
            DoubleVector center = boundsXY.getCenter();
            String[] stringArray = new String[]{"Raster image size", "" + '[' + width2 + " X " + height + ']', "exceeds capability", "of", "your imaging device"};
            String[] lines = stringArray;
            double fontSize = 12.0;
            double lineHeight = fontSize + (double)4;
            double y2 = center.getY() + lineHeight * (double)lines.length / 2.0;
            for (String line2 : lines) {
                DoubleVector loc;
                TextLabel label2 = new TextLabel(line2);
                label2.textColor().set(Color.Companion.getDARK_MAGENTA());
                label2.textOpacity().set(0.5);
                label2.setFontSize(fontSize);
                label2.setFontWeight("bold");
                label2.setHorizontalAnchor(Text.HorizontalAnchor.MIDDLE);
                label2.setVerticalAnchor(Text.VerticalAnchor.CENTER);
                Intrinsics.checkNotNull((Object)helper2.toClient(center.getX(), y2, randomP));
                label2.moveTo(loc);
                root.add(label2.getRootGroup());
                y2 -= lineHeight;
            }
            return;
        }
        int cols = (int)Math.rint(width2);
        int rows = (int)Math.rint(height);
        DoubleVector halfStep = new DoubleVector(stepX * 0.5, stepY * 0.5);
        DoubleVector doubleVector = helper2.toClient(boundsXY.getOrigin().subtract(halfStep), randomP);
        Intrinsics.checkNotNull((Object)doubleVector);
        DoubleVector corner0 = doubleVector;
        DoubleVector doubleVector2 = helper2.toClient(boundsXY.getOrigin().add(boundsXY.getDimension()).add(halfStep), randomP);
        Intrinsics.checkNotNull((Object)doubleVector2);
        DoubleVector corner2 = doubleVector2;
        boolean invertedX = corner2.getX() < corner0.getX();
        boolean invertedY = corner2.getY() < corner0.getY();
        double x0 = boundsXY.getOrigin().getX();
        double y0 = boundsXY.getOrigin().getY();
        int[] argbValues = new int[cols * rows];
        for (DataPointAesthetics p : GeomUtil.INSTANCE.with_X_Y(aesthetics2.dataPoints())) {
            Double x2 = p.x();
            Double y3 = p.y();
            Double alpha = p.alpha();
            Color color = p.fill();
            Double d = x2;
            Intrinsics.checkNotNull((Object)d);
            int col = (int)Math.rint((d - x0) / stepX);
            Double d2 = y3;
            Intrinsics.checkNotNull((Object)d2);
            int row = (int)Math.rint((d2 - y0) / stepY);
            if (invertedX) {
                col = cols - (col + 1);
            }
            if (invertedY) {
                row = rows - (row + 1);
            }
            Color color2 = color;
            Intrinsics.checkNotNull((Object)color2);
            Double d3 = alpha;
            Intrinsics.checkNotNull((Object)d3);
            argbValues[row * cols + col] = SvgUtils.INSTANCE.toARGB(color2, d3);
        }
        SvgImageElementEx.Bitmap bitmap = new SvgImageElementEx.Bitmap(cols, rows, argbValues);
        SvgImageElementEx svgImageElement = new SvgImageElementEx(Math.min(corner0.getX(), corner2.getX()), Math.min(corner0.getY(), corner2.getY()), Math.abs(corner0.getX() - corner2.getX()), Math.abs(corner0.getY() - corner2.getY()), bitmap);
        root.add(svgImageElement);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/RasterGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

