/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.DiscreteTransform;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsBuilder;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.plot.base.scale.Mappers;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.PosProviderContext;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PosProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u0004\u0018\u00010\u00012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nH\u0002JC\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00102\u001a\u0010\u0011\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0018JE\u0010\u0019\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u00122\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\nH\u0000\u00a2\u0006\u0002\b\u001dJ)\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J\u001e\u0010!\u001a\u0004\u0018\u00010\"2\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010&\u001a\u0004\u0018\u00010\b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002\u00a8\u0006("}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PlotUtil;", "", "()V", "constantToAesValue", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "v", "continuousTransform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "mapperOption", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "createLayerAesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "layer", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "aesList", "", "mapperByAes", "", "createLayerAesthetics$plot_builder", "createPositionAdjustment", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "posProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PosProvider;", "createPositionAdjustment$plot_builder", "prepareLayerAestheticMappers", "xAesMapper", "", "yAesMapper", "prepareLayerAestheticMappers$plot_builder", "rangeWithExpand", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "range", "scale", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "includeZero", "", "rangeWithExpand$plot_builder", "transformIfContinuous", "DemoAndTest", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/PlotUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n1#2:273\n*E\n"})
public final class PlotUtil {
    @NotNull
    public static final PlotUtil INSTANCE = new PlotUtil();

    private PlotUtil() {
    }

    @NotNull
    public final PositionAdjustment createPositionAdjustment$plot_builder(@NotNull PosProvider posProvider, @NotNull Aesthetics aes2) {
        Intrinsics.checkNotNullParameter((Object)posProvider, (String)"posProvider");
        Intrinsics.checkNotNullParameter((Object)aes2, (String)"aes");
        return posProvider.createPos(new PosProviderContext(aes2){
            @NotNull
            private final Lazy groupCount$delegate;
            final /* synthetic */ Aesthetics $aes;
            {
                this.$aes = $aes;
                this.groupCount$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>($aes){
                    final /* synthetic */ Aesthetics $aes;
                    {
                        this.$aes = $aes;
                        super(0);
                    }

                    @NotNull
                    public final Integer invoke() {
                        Set set2 = CollectionsKt.toSet(this.$aes.groups());
                        return set2.size();
                    }
                }));
            }

            @NotNull
            public Aesthetics getAesthetics() {
                return this.$aes;
            }

            public int getGroupCount() {
                Lazy lazy = this.groupCount$delegate;
                return ((Number)lazy.getValue()).intValue();
            }
        });
    }

    @NotNull
    public final Map<Aes<?>, ScaleMapper<?>> prepareLayerAestheticMappers$plot_builder(@NotNull GeomLayer layer, @NotNull ScaleMapper<Double> xAesMapper, @NotNull ScaleMapper<Double> yAesMapper) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter(xAesMapper, (String)"xAesMapper");
        Intrinsics.checkNotNullParameter(yAesMapper, (String)"yAesMapper");
        boolean yOrientation = layer.isYOrientation();
        HashMap mappers = new HashMap();
        Aes[] aesArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()};
        List renderedAes = CollectionsKt.plus((Collection)GeomLayer.DefaultImpls.renderedAes$default(layer, false, 1, null), (Iterable)CollectionsKt.listOf((Object[])aesArray));
        for (Aes aes2 : renderedAes) {
            ScaleMapper it;
            ScaleMapper mapper;
            ScaleMapper<Object> scaleMapper2;
            if (Intrinsics.areEqual((Object)aes2, Aes.Companion.getSLOPE())) {
                Double d = yAesMapper.invoke(1.0);
                Intrinsics.checkNotNull((Object)d);
                double d2 = ((Number)d).doubleValue();
                Double d3 = xAesMapper.invoke(1.0);
                Intrinsics.checkNotNull((Object)d3);
                scaleMapper2 = Mappers.INSTANCE.mul(d2 / ((Number)d3).doubleValue());
            } else {
                scaleMapper2 = Intrinsics.areEqual((Object)aes2, Aes.Companion.getX()) ? xAesMapper : (Intrinsics.areEqual((Object)aes2, Aes.Companion.getY()) ? yAesMapper : (Aes.Companion.isPositionalX(aes2) ? (yOrientation ? yAesMapper : xAesMapper) : (Aes.Companion.isPositionalY(aes2) ? (yOrientation ? xAesMapper : yAesMapper) : (mapper = layer.hasBinding(aes2) ? (ScaleMapper)MapsKt.getValue(layer.getScaleMappersNP(), (Object)aes2) : null))));
            }
            if (mapper == null) continue;
            boolean bl = false;
            ((Map)mappers).put(aes2, it);
        }
        return mappers;
    }

    @NotNull
    public final Aesthetics createLayerAesthetics$plot_builder(@NotNull GeomLayer layer, @NotNull List<? extends Aes<?>> aesList, @NotNull Map<Aes<?>, ? extends ScaleMapper<?>> mapperByAes) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter(aesList, (String)"aesList");
        Intrinsics.checkNotNullParameter(mapperByAes, (String)"mapperByAes");
        AestheticsBuilder aesBuilder = new AestheticsBuilder(0, 1, null);
        aesBuilder.group(layer.getGroup()).colorAes(layer.getColorByAes()).fillAes(layer.getFillByAes());
        boolean hasPositionalConstants = false;
        for (Aes<?> aes2 : aesList) {
            if (!Aes.Companion.isPositional(aes2) || !layer.hasConstant(aes2)) continue;
            hasPositionalConstants = true;
            break;
        }
        DataFrame data = layer.getDataFrame();
        Integer dataPointCount = null;
        for (Aes<Object> aes2 : aesList) {
            ContinuousTransform t;
            Object v;
            ScaleMapper<Double> mapperOption;
            Intrinsics.checkNotNull(aes2, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.Aes<kotlin.Any>");
            Aes<Object> aes4 = aes2;
            ScaleMapper<Double> scaleMapper2 = mapperOption = Aes.Companion.isPositional(aes4) ? Mappers.INSTANCE.getIDENTITY() : mapperByAes.get(aes4);
            if (layer.hasConstant(aes4)) {
                v = layer.getConstant(aes4);
                t = this.transformIfContinuous(this.scale(aes4, layer));
                aesBuilder.constantAes(aes4, this.constantToAesValue(aes4, v, t, mapperOption));
                continue;
            }
            if (layer.hasBinding(aes4)) {
                if (!(mapperOption != null)) {
                    boolean $i$a$-check-PlotUtil$createLayerAesthetics$432 = false;
                    String $i$a$-check-PlotUtil$createLayerAesthetics$432 = "No scale mapper defined for aesthetic " + aes4;
                    throw new IllegalStateException($i$a$-check-PlotUtil$createLayerAesthetics$432.toString());
                }
                DataFrame.Variable transformVar = DataFrameUtil.INSTANCE.transformVarFor(aes4);
                if (!data.has(transformVar)) {
                    boolean $i$a$-check-PlotUtil$createLayerAesthetics$532 = false;
                    String $i$a$-check-PlotUtil$createLayerAesthetics$532 = "Undefined var " + transformVar + " for aesthetic " + aes4;
                    throw new IllegalStateException($i$a$-check-PlotUtil$createLayerAesthetics$532.toString());
                }
                List<Double> numericValues2 = data.getNumeric(transformVar);
                if (dataPointCount == null) {
                    dataPointCount = numericValues2.size();
                } else {
                    int $i$a$-check-PlotUtil$createLayerAesthetics$532 = numericValues2.size();
                    if (!(dataPointCount == $i$a$-check-PlotUtil$createLayerAesthetics$532)) {
                        boolean bl = false;
                        String string = "" + aes4 + " expected data size=" + dataPointCount + " was size=" + numericValues2.size();
                        throw new IllegalStateException(string.toString());
                    }
                }
                if (dataPointCount == 0 && hasPositionalConstants) {
                    aesBuilder.constantAes(aes4, layer.getAestheticsDefaults().defaultValue(aes4));
                    continue;
                }
                Function1<Integer, Double> integerFunction = AestheticsBuilder.Companion.listMapper(numericValues2, mapperOption);
                aesBuilder.aes(aes4, integerFunction);
                if (!(((Scale)MapsKt.getValue(layer.getScaleMap(), aes4)).getTransform() instanceof DiscreteTransform)) continue;
                aesBuilder.resolution(aes4, 1.0);
                continue;
            }
            v = layer.getDefault(aes4);
            t = this.transformIfContinuous(this.scale(aes4, layer));
            aesBuilder.constantAes(aes4, this.constantToAesValue(aes4, v, t, mapperOption));
        }
        if (dataPointCount != null && ((Number)dataPointCount).intValue() > 0) {
            aesBuilder.dataPointCount(((Number)dataPointCount).intValue());
        } else if (hasPositionalConstants) {
            aesBuilder.dataPointCount(1);
        }
        return aesBuilder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object constantToAesValue(Aes<?> aes2, Object v, ContinuousTransform continuousTransform, ScaleMapper<?> mapperOption) {
        Object object;
        if (aes2.isNumeric()) {
            Double transformed;
            Double d;
            if (continuousTransform != null) {
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Double");
                boolean bl = continuousTransform.isInDomain((Double)((Object)v));
                if (bl) {
                    d = continuousTransform.apply((Double)((Object)v));
                } else {
                    if (bl) throw new NoWhenBranchMatchedException();
                    d = null;
                }
            } else {
                d = transformed = v instanceof Double ? (Double)((Object)v) : null;
            }
            if ((object = mapperOption) != null && (object = object.invoke(transformed)) != null) return object;
            object = transformed;
            return object;
        } else {
            object = v;
        }
        return object;
    }

    @Nullable
    public final DoubleSpan rangeWithExpand$plot_builder(@Nullable DoubleSpan range, @NotNull Scale scale, boolean includeZero) {
        double transformed;
        double transformed2;
        double lowerExpand;
        Object object;
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        if (range == null) {
            return null;
        }
        double mulExp = scale.getMultiplicativeExpand();
        double addExp = scale.getAdditiveExpand();
        ContinuousTransform continuousTransform = this.transformIfContinuous(scale);
        Object object2 = continuousTransform;
        DoubleSpan domain = new DoubleSpan(object2 != null && (object2 = object2.applyInverse(range.getLowerEnd())) != null ? ((Double)object2).doubleValue() : range.getLowerEnd().doubleValue(), (object = continuousTransform) != null && (object = object.applyInverse(range.getUpperEnd())) != null ? ((Double)object).doubleValue() : range.getUpperEnd().doubleValue());
        double lowerEndpoint = domain.getLowerEnd();
        double upperEndpoint = domain.getUpperEnd();
        double length = upperEndpoint - lowerEndpoint;
        double upperExpand = lowerExpand = addExp + length * mulExp;
        if (includeZero && (lowerEndpoint == 0.0 || upperEndpoint == 0.0 || Math.signum(lowerEndpoint) == Math.signum(upperEndpoint))) {
            if (lowerEndpoint >= 0.0) {
                lowerExpand = 0.0;
            } else {
                upperExpand = 0.0;
            }
        }
        double it = lowerEndpoint - lowerExpand;
        boolean bl = false;
        Object object3 = continuousTransform;
        double d = object3 != null && (object3 = object3.apply(it)) != null ? (Double)object3 : (transformed2 = it);
        double lowerEndWithExpand = Double.isNaN(transformed2) ? range.getLowerEnd() : transformed2;
        double it2 = upperEndpoint + upperExpand;
        boolean bl2 = false;
        Object object4 = continuousTransform;
        double d2 = object4 != null && (object4 = object4.apply(it2)) != null ? (Double)object4 : (transformed = it2);
        double upperEndWithExpand = Double.isNaN(transformed) ? range.getUpperEnd() : transformed;
        return new DoubleSpan(lowerEndWithExpand, upperEndWithExpand);
    }

    private final ContinuousTransform transformIfContinuous(Scale scale) {
        ContinuousTransform continuousTransform;
        if (scale == null) {
            return null;
        }
        if (scale.isContinuousDomain()) {
            Transform transform2 = scale.getTransform();
            Intrinsics.checkNotNull((Object)transform2, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.ContinuousTransform");
            continuousTransform = (ContinuousTransform)transform2;
        } else {
            continuousTransform = null;
        }
        return continuousTransform;
    }

    private final Scale scale(Aes<?> aes2, GeomLayer layer) {
        Aes<?> aes3 = Aes.Companion.isPositionalXY(aes2) ? Aes.Companion.toAxisAes(aes2, layer.isYOrientation()) : aes2;
        return layer.getScaleMap().containsKey(aes3) ? layer.getScaleMap().get(aes3) : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PlotUtil$DemoAndTest;", "", "()V", "layerAestheticsWithoutLayout", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "layer", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "plot-builder"})
    public static final class DemoAndTest {
        @NotNull
        public static final DemoAndTest INSTANCE = new DemoAndTest();

        private DemoAndTest() {
        }

        @NotNull
        public final Aesthetics layerAestheticsWithoutLayout(@NotNull GeomLayer layer) {
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            Map<Aes<?>, ScaleMapper<?>> mappers = INSTANCE.prepareLayerAestheticMappers$plot_builder(layer, Mappers.INSTANCE.getIDENTITY(), Mappers.INSTANCE.getIDENTITY());
            return INSTANCE.createLayerAesthetics$plot_builder(layer, layer.renderedAes(true), mappers);
        }
    }
}

