/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.model.SideEffectGuard;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyPackageRequirementsInspection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/python/inspections/quickfix/IgnoreRequirementFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "packageNames", "", "", "<init>", "(Ljava/util/Set;)V", "getFamilyName", "Lorg/jetbrains/annotations/Nls;", "startInWriteAction", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "createUndoAction", "Lcom/intellij/notification/NotificationAction;", "inspection", "Lcom/jetbrains/python/inspections/PyPackageRequirementsInspection;", "packagesToIgnore", "profileManager", "Lcom/intellij/profile/codeInspection/ProjectInspectionProfileManager;", "createEditSettingsAction", "Companion", "intellij.python.community.impl"})
public final class IgnoreRequirementFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> packageNames;
    @NotNull
    private static final String NOTIFICATION_GROUP_ID = "Package requirements";
    @NotNull
    private static final NotificationGroup BALLOON_NOTIFICATIONS;

    public IgnoreRequirementFix(@NotNull Set<String> packageNames) {
        Intrinsics.checkNotNullParameter(packageNames, (String)"packageNames");
        this.packageNames = packageNames;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.packageNames.size()};
        String string = PyPsiBundle.message("QFIX.NAME.ignore.requirements", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        block4: {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getPsiElement();
            if (psiElement == null) break block4;
            PsiElement element = psiElement;
            boolean bl = false;
            SideEffectGuard.Companion.checkSideEffectAllowed(SideEffectGuard.EffectType.PROJECT_MODEL);
            PyPackageRequirementsInspection inspection = PyPackageRequirementsInspection.Companion.getInstance(element);
            if (inspection == null) {
                return;
            }
            Set packagesToIgnore = SetsKt.minus(this.packageNames, (Iterable)inspection.getIgnoredPackages());
            if (packagesToIgnore.isEmpty()) {
                return;
            }
            inspection.setIgnoredPackages(packagesToIgnore);
            ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.Companion.getInstance(project);
            profileManager.fireProfileChanged();
            if (packagesToIgnore.size() == 1) {
                Object[] objectArray = new Object[]{CollectionsKt.first((Iterable)packagesToIgnore)};
                string = PyPsiBundle.message("INSP.package.requirements.requirement.has.been.ignored", objectArray);
            } else {
                string = PyPsiBundle.message("INSP.package.requirements.requirements.have.been.ignored", new Object[0]);
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String notificationMessage = string2;
            Notification notification2 = BALLOON_NOTIFICATIONS.createNotification(notificationMessage, NotificationType.INFORMATION);
            notification2.addAction((AnAction)this.createUndoAction(inspection, packagesToIgnore, profileManager));
            notification2.addAction((AnAction)this.createEditSettingsAction(project));
            notification2.notify(project);
        }
    }

    private final NotificationAction createUndoAction(PyPackageRequirementsInspection inspection, Set<String> packagesToIgnore, ProjectInspectionProfileManager profileManager) {
        NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)ActionsBundle.message((String)"action.$Undo.text", (Object[])new Object[0]), () -> IgnoreRequirementFix.createUndoAction$lambda$1(inspection, packagesToIgnore, profileManager));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
        return notificationAction;
    }

    private final NotificationAction createEditSettingsAction(Project project) {
        NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)PyBundle.message("notification.action.edit.settings", new Object[0]), () -> IgnoreRequirementFix.createEditSettingsAction$lambda$2(project));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
        return notificationAction;
    }

    private static final void createUndoAction$lambda$1(PyPackageRequirementsInspection $inspection, Set $packagesToIgnore, ProjectInspectionProfileManager $profileManager) {
        List packagesToRestore = CollectionsKt.minus((Iterable)$inspection.getIgnoredPackages(), (Iterable)$packagesToIgnore);
        $inspection.setIgnoredPackages(CollectionsKt.toSet((Iterable)packagesToRestore));
        $profileManager.fireProfileChanged();
    }

    private static final void createEditSettingsAction$lambda$2(Project $project) {
        InspectionProfileImpl profile = ProjectInspectionProfileManager.Companion.getInstance($project).getCurrentProfile();
        String toolName = PyPackageRequirementsInspection.class.getSimpleName();
        EditInspectionToolsSettingsAction.editToolSettings((Project)$project, (InspectionProfileImpl)profile, (String)toolName);
    }

    private static final NotificationGroup BALLOON_NOTIFICATIONS$lambda$3() {
        return NotificationGroupManager.getInstance().getNotificationGroup(NOTIFICATION_GROUP_ID);
    }

    static {
        Object object = Cancellation.forceNonCancellableSectionInClassInitializer(IgnoreRequirementFix::BALLOON_NOTIFICATIONS$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forceNonCancellableSectionInClassInitializer(...)");
        BALLOON_NOTIFICATIONS = (NotificationGroup)object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/inspections/quickfix/IgnoreRequirementFix$Companion;", "", "<init>", "()V", "NOTIFICATION_GROUP_ID", "", "BALLOON_NOTIFICATIONS", "Lcom/intellij/notification/NotificationGroup;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

