/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetCustomToolWizardStep;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetEnvironmentWizard;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.sdk.add.collector.PythonNewInterpreterAddedCollector;
import com.jetbrains.python.target.PythonLanguageRuntimeType;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/sdk/AddInterpreterOnTargetAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "targetType", "Lcom/intellij/execution/target/TargetEnvironmentType;", "onSdkCreated", "Ljava/util/function/Consumer;", "Lcom/intellij/openapi/projectRoots/Sdk;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/target/TargetEnvironmentType;Ljava/util/function/Consumer;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.community.impl"})
final class AddInterpreterOnTargetAction
extends AnAction
implements DumbAware {
    @NotNull
    private final Project project;
    @NotNull
    private final TargetEnvironmentType<?> targetType;
    @NotNull
    private final Consumer<Sdk> onSdkCreated;

    public AddInterpreterOnTargetAction(@NotNull Project project, @NotNull TargetEnvironmentType<?> targetType, @NotNull Consumer<Sdk> onSdkCreated) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter(onSdkCreated, (String)"onSdkCreated");
        Object[] objectArray = new Object[]{targetType.getDisplayName()};
        super(PyBundle.messagePointer("python.sdk.action.add.interpreter.based.on.target.text", objectArray), targetType.getIcon());
        this.project = project;
        this.targetType = targetType;
        this.onSdkCreated = onSdkCreated;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        TargetEnvironmentWizard wizard = TargetEnvironmentWizard.Companion.createWizard(this.project, this.targetType, (LanguageRuntimeType)PythonLanguageRuntimeType.Companion.getInstance());
        if (wizard != null && wizard.showAndGet()) {
            Sdk sdk2;
            ProjectSdksModel model2 = PyConfigurableInterpreterList.getInstance(this.project).getModel();
            Step step = wizard.getCurrentStepObject();
            TargetCustomToolWizardStep targetCustomToolWizardStep = step instanceof TargetCustomToolWizardStep ? (TargetCustomToolWizardStep)step : null;
            Object object = targetCustomToolWizardStep != null ? targetCustomToolWizardStep.getCustomTool() : null;
            Sdk sdk3 = sdk2 = object instanceof Sdk ? (Sdk)object : null;
            if (sdk2 != null) {
                PythonNewInterpreterAddedCollector.INSTANCE.logPythonNewInterpreterAdded(sdk2);
                if (model2.findSdk(sdk2.getName()) == null) {
                    model2.addSdk(sdk2);
                    model2.apply();
                    this.onSdkCreated.accept(sdk2);
                }
            }
        }
    }
}

