/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.TimeoutUtil;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.PythonSdkUtil;
import org.jetbrains.annotations.NotNull;

public class PyUpdateProjectSdkAction
extends DumbAwareAction {
    private static final int N_REPEATS = 1;
    private static final int TIMEOUT = 0;
    private static final Logger LOG = Logger.getInstance(PyUpdateProjectSdkAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            PyUpdateProjectSdkAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (int i = 0; i < 1; ++i) {
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    Sdk sdk2 = PythonSdkUtil.findPythonSdk(module);
                    if (sdk2 == null) {
                        LOG.info("Skipping module " + String.valueOf(module) + " as not having a Python SDK");
                        continue;
                    }
                    PythonSdkUpdater.scheduleUpdate(sdk2, project);
                    TimeoutUtil.sleep((long)0L);
                }
            }
        });
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PyUpdateProjectSdkAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PyUpdateProjectSdkAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PyUpdateProjectSdkAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

