/*
 * Decompiled with CFR 0.152.
 */
package io.github.z4kn4fein.semver.constraints;

import io.github.z4kn4fein.semver.Version;
import io.github.z4kn4fein.semver.VersionExtensionsKt;
import io.github.z4kn4fein.semver.constraints.ComparatorBuilder;
import io.github.z4kn4fein.semver.constraints.Condition;
import io.github.z4kn4fein.semver.constraints.Op;
import io.github.z4kn4fein.semver.constraints.Range;
import io.github.z4kn4fein.semver.constraints.VersionComparator;
import io.github.z4kn4fein.semver.constraints.VersionDescriptor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lio/github/z4kn4fein/semver/constraints/TildeComparatorBuilder;", "Lio/github/z4kn4fein/semver/constraints/ComparatorBuilder;", "()V", "acceptedOperators", "", "", "getAcceptedOperators", "()[Ljava/lang/String;", "[Ljava/lang/String;", "buildComparator", "Lio/github/z4kn4fein/semver/constraints/VersionComparator;", "operatorString", "versionDescriptor", "Lio/github/z4kn4fein/semver/constraints/VersionDescriptor;", "semver"})
public final class TildeComparatorBuilder
implements ComparatorBuilder {
    @NotNull
    private final String[] acceptedOperators;

    public TildeComparatorBuilder() {
        String[] stringArray = new String[]{"~>", "~"};
        this.acceptedOperators = stringArray;
    }

    @Override
    @NotNull
    public String[] getAcceptedOperators() {
        return this.acceptedOperators;
    }

    @Override
    @NotNull
    public VersionComparator buildComparator(@NotNull String operatorString, @NotNull VersionDescriptor versionDescriptor) {
        VersionComparator versionComparator;
        Intrinsics.checkNotNullParameter((Object)operatorString, (String)"operatorString");
        Intrinsics.checkNotNullParameter((Object)versionDescriptor, (String)"versionDescriptor");
        if (versionDescriptor.isWildcard()) {
            versionComparator = VersionDescriptor.toComparator$default(versionDescriptor, null, 1, null);
        } else {
            Version version2 = new Version(versionDescriptor.getMajor(), versionDescriptor.getMinor(), versionDescriptor.getPatch(), versionDescriptor.getPreRelease(), versionDescriptor.getBuildMetadata());
            versionComparator = new Range(new Condition(Op.GREATER_THAN_OR_EQUAL, version2), new Condition(Op.LESS_THAN, VersionExtensionsKt.nextMinor(version2, "")), Op.EQUAL);
        }
        return versionComparator;
    }
}

