/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import androidx.compose.ui.internal.InlineClassHelperKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u001a(\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014j\u0002`\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001H\u0082\b\u00a2\u0006\u0002\u0010\u0018\u001a(\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0006H\u0002\u001a\u0011\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0082\b\u001a2\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u00012\b\b\u0002\u0010$\u001a\u00020\u0014H\u0000\u001a\u0012\u0010%\u001a\u00020&*\u00020'2\u0006\u0010(\u001a\u00020)\u001a\u0014\u0010*\u001a\u00020&*\u00020'2\u0006\u0010(\u001a\u00020)H\u0002\u001a\u0014\u0010+\u001a\u00020&*\u00020'2\u0006\u0010(\u001a\u00020)H\u0002\u001a\u0014\u0010,\u001a\u00020\u0003*\u00020\u00142\u0006\u0010-\u001a\u00020\u0014H\u0002\u001a,\u0010.\u001a\u00020\u0003*\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`/2\u0006\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u0001H\u0082\n\u00a2\u0006\u0002\u00102\u001a\r\u00103\u001a\u00020\u0003*\u00020\u0014H\u0082\b\u001a4\u00104\u001a\u00020&*\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`/2\u0006\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u00012\u0006\u00105\u001a\u00020\u0003H\u0082\n\u00a2\u0006\u0002\u00106\u001a1\u00104\u001a\u00020&*\n\u0012\u0006\u0012\u0004\u0018\u0001070\u00132\u0006\u00108\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u0002092\u0006\u0010:\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010;\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\",\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068G@GX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\",\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068G@GX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\t\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\r*\u0018\b\u0002\u0010\u0012\"\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0012\u0004\u0012\u00020\u00140\u0013*\f\b\u0002\u0010<\"\u00020\u00142\u00020\u0014\u00a8\u0006="}, d2={"AssumePointerMoveStoppedMilliseconds", "", "DefaultWeight", "", "HorizonMilliseconds", "<set-?>", "", "VelocityTrackerAddPointsFix", "getVelocityTrackerAddPointsFix$annotations", "()V", "getVelocityTrackerAddPointsFix", "()Z", "setVelocityTrackerAddPointsFix", "(Z)V", "VelocityTrackerStrategyUseImpulse", "getVelocityTrackerStrategyUseImpulse$annotations", "getVelocityTrackerStrategyUseImpulse", "setVelocityTrackerStrategyUseImpulse", "Matrix", "", "", "Landroidx/compose/ui/input/pointer/util/Vector;", "rows", "cols", "(II)[[F", "calculateImpulseVelocity", "dataPoints", "time", "sampleCount", "isDataDifferential", "kineticEnergyToVelocity", "kineticEnergy", "polyFitLeastSquares", "x", "y", "degree", "coefficients", "addPointerInputChange", "", "Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "event", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "addPointerInputChangeLegacy", "addPointerInputChangeWithFix", "dot", "a", "get", "Landroidx/compose/ui/input/pointer/util/Matrix;", "row", "col", "([[FII)F", "norm", "set", "value", "([[FIIF)V", "Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "index", "", "dataPoint", "([Landroidx/compose/ui/input/pointer/util/DataPointAtTime;IJF)V", "Vector", "ui"})
@SourceDebugExtension(value={"SMAP\nVelocityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,756:1\n718#1:769\n725#1,2:770\n721#1,6:772\n718#1:778\n718#1:779\n713#1:780\n699#1:782\n699#1:783\n33#2,6:757\n33#2,6:763\n78#3:781\n*S KotlinDebug\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n*L\n520#1:769\n522#1:770,2\n524#1:772,6\n531#1:778\n533#1:779\n546#1:780\n683#1:782\n689#1:783\n418#1:757,6\n454#1:763,6\n546#1:781\n*E\n"})
public final class VelocityTrackerKt {
    private static final int AssumePointerMoveStoppedMilliseconds = 40;
    private static final int HorizonMilliseconds = 100;
    private static final float DefaultWeight = 1.0f;
    private static boolean VelocityTrackerAddPointsFix = true;
    private static boolean VelocityTrackerStrategyUseImpulse;

    private static final void set(DataPointAtTime[] $this$set, int index2, long time, float dataPoint) {
        DataPointAtTime currentEntry = $this$set[index2];
        if (currentEntry == null) {
            $this$set[index2] = new DataPointAtTime(time, dataPoint);
        } else {
            currentEntry.setTime(time);
            currentEntry.setDataPoint(dataPoint);
        }
    }

    public static final void addPointerInputChange(@NotNull VelocityTracker $this$addPointerInputChange, @NotNull PointerInputChange event) {
        Intrinsics.checkNotNullParameter((Object)$this$addPointerInputChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (VelocityTrackerAddPointsFix) {
            VelocityTrackerKt.addPointerInputChangeWithFix($this$addPointerInputChange, event);
        } else {
            VelocityTrackerKt.addPointerInputChangeLegacy($this$addPointerInputChange, event);
        }
    }

    private static final void addPointerInputChangeLegacy(VelocityTracker $this$addPointerInputChangeLegacy, PointerInputChange event) {
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            $this$addPointerInputChangeLegacy.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(event.getPosition-F1C5BW0());
            $this$addPointerInputChangeLegacy.resetTracking();
        }
        long previousPointerPosition = 0L;
        previousPointerPosition = event.getPreviousPosition-F1C5BW0();
        List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            HistoricalChange item$iv;
            HistoricalChange it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            long historicalDelta = Offset.minus-MK-Hz9U(it.getPosition-F1C5BW0(), previousPointerPosition);
            previousPointerPosition = it.getPosition-F1C5BW0();
            $this$addPointerInputChangeLegacy.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(Offset.plus-MK-Hz9U($this$addPointerInputChangeLegacy.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), historicalDelta));
            $this$addPointerInputChangeLegacy.addPosition-Uv8p0NA(it.getUptimeMillis(), $this$addPointerInputChangeLegacy.getCurrentPointerPositionAccumulator-F1C5BW0$ui());
        }
        long delta = Offset.minus-MK-Hz9U(event.getPosition-F1C5BW0(), previousPointerPosition);
        $this$addPointerInputChangeLegacy.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(Offset.plus-MK-Hz9U($this$addPointerInputChangeLegacy.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), delta));
        $this$addPointerInputChangeLegacy.addPosition-Uv8p0NA(event.getUptimeMillis(), $this$addPointerInputChangeLegacy.getCurrentPointerPositionAccumulator-F1C5BW0$ui());
    }

    private static final void addPointerInputChangeWithFix(VelocityTracker $this$addPointerInputChangeWithFix, PointerInputChange event) {
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            $this$addPointerInputChangeWithFix.resetTracking();
        }
        if (!PointerEventKt.changedToUpIgnoreConsumed(event)) {
            List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                HistoricalChange item$iv;
                HistoricalChange it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                $this$addPointerInputChangeWithFix.addPosition-Uv8p0NA(it.getUptimeMillis(), it.getOriginalEventPosition-F1C5BW0$ui());
            }
            $this$addPointerInputChangeWithFix.addPosition-Uv8p0NA(event.getUptimeMillis(), event.getOriginalEventPosition-F1C5BW0$ui());
        }
        if (PointerEventKt.changedToUpIgnoreConsumed(event) && event.getUptimeMillis() - $this$addPointerInputChangeWithFix.getLastMoveEventTimeStamp$ui() > 40L) {
            $this$addPointerInputChangeWithFix.resetTracking();
        }
        $this$addPointerInputChangeWithFix.setLastMoveEventTimeStamp$ui(event.getUptimeMillis());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final float[] polyFitLeastSquares(@NotNull float[] x, @NotNull float[] y, int sampleCount, int degree, @NotNull float[] coefficients) {
        int $i$f$get;
        int $i$f$set;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)coefficients, (String)"coefficients");
        if (degree < 1) {
            InlineClassHelperKt.throwIllegalArgumentException("The degree must be at positive integer");
        }
        if (sampleCount == 0) {
            InlineClassHelperKt.throwIllegalArgumentException("At least one point must be provided");
        }
        int truncatedDegree = degree >= sampleCount ? sampleCount - 1 : degree;
        int m = sampleCount;
        int n = truncatedDegree + 1;
        boolean $i$f$Matrix = false;
        int n2 = 0;
        float[][] fArrayArray = new float[n][];
        while (n2 < n) {
            int n3 = n2++;
            fArrayArray[n3] = new float[m];
        }
        float[][] a = fArrayArray;
        for (int h = 0; h < m; ++h) {
            float[][] fArrayArray2 = a;
            boolean bl = false;
            float value$iv22 = 1.0f;
            $i$f$set = 0;
            $this$set$iv[row$iv][h] = value$iv22;
            for (int i = 1; i < n; ++i) {
                void $this$get$iv;
                float[][] row$iv = a;
                float[][] value$iv22 = a;
                int row$iv2 = i - 1;
                $i$f$get = 0;
                value$iv22 = $this$get$iv[row$iv2][h] * x[h];
                $i$f$set = 0;
                $this$set$iv[i][h] = value$iv22;
            }
        }
        boolean $i$f$Matrix2 = false;
        int $this$set$iv = 0;
        float[][] value$iv32 = new float[n][];
        while ($this$set$iv < n) {
            $i$f$set = $this$set$iv++;
            value$iv32[$i$f$set] = new float[m];
        }
        float[][] q = value$iv32;
        boolean $i$f$Matrix3 = false;
        int value$iv32 = 0;
        float[][] $i$f$set2 = new float[n][];
        while (value$iv32 < n) {
            $i$f$get = value$iv32++;
            $i$f$set2[$i$f$get] = new float[n];
        }
        float[][] r = $i$f$set2;
        for (int j = 0; j < n; ++j) {
            void $this$fastCoerceAtLeast$iv;
            float[] w = q[j];
            ArraysKt.copyInto((float[])a[j], (float[])w, (int)0, (int)0, (int)m);
            for (int i = 0; i < j; ++i) {
                float[] z = q[i];
                float dot = VelocityTrackerKt.dot(w, z);
                for (int h = 0; h < m; ++h) {
                    int n4 = h;
                    w[n4] = w[n4] - dot * z[h];
                }
            }
            float[] $this$norm$iv22 = w;
            boolean $i$f$norm = false;
            float $this$norm$iv22 = (float)Math.sqrt(VelocityTrackerKt.dot($this$norm$iv22, $this$norm$iv22));
            float minimumValue$iv2 = 1.0E-6f;
            boolean $i$f$fastCoerceAtLeast = false;
            float inverseNorm = 1.0f / ($this$fastCoerceAtLeast$iv < minimumValue$iv2 ? minimumValue$iv2 : $this$fastCoerceAtLeast$iv);
            int h = 0;
            while (h < m) {
                int minimumValue$iv2 = h++;
                w[minimumValue$iv2] = w[minimumValue$iv2] * inverseNorm;
            }
            float[] v = r[j];
            for (int i = 0; i < n; ++i) {
                v[i] = i < j ? 0.0f : VelocityTrackerKt.dot(w, a[i]);
            }
        }
        float[] wy = y;
        for (int i = n - 1; -1 < i; --i) {
            float c = VelocityTrackerKt.dot(q[i], wy);
            float[] ri = r[i];
            int n5 = i + 1;
            int j = n - 1;
            if (n5 <= j) {
                while (true) {
                    c -= ri[j] * coefficients[j];
                    if (j == n5) break;
                    --j;
                }
            }
            coefficients[i] = c / ri[i];
        }
        return coefficients;
    }

    public static /* synthetic */ float[] polyFitLeastSquares$default(float[] fArray, float[] fArray2, int n, int n2, float[] fArray3, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            fArray3 = new float[RangesKt.coerceAtLeast((int)(n2 + 1), (int)0)];
        }
        return VelocityTrackerKt.polyFitLeastSquares(fArray, fArray2, n, n2, fArray3);
    }

    private static final float calculateImpulseVelocity(float[] dataPoints, float[] time, int sampleCount, boolean isDataDifferential) {
        float work = 0.0f;
        int start = sampleCount - 1;
        float nextTime = time[start];
        for (int i = start; 0 < i; --i) {
            float currentTime = nextTime;
            if (currentTime == (nextTime = time[i - 1])) continue;
            float dataPointsDelta = isDataDifferential ? -dataPoints[i - 1] : dataPoints[i] - dataPoints[i - 1];
            float vCurr = dataPointsDelta / (currentTime - nextTime);
            boolean $i$f$kineticEnergyToVelocity = false;
            float vPrev = Math.signum(work) * (float)Math.sqrt((float)2 * Math.abs(work));
            work += (vCurr - vPrev) * Math.abs(vCurr);
            if (i != start) continue;
            work *= 0.5f;
        }
        boolean $i$f$kineticEnergyToVelocity = false;
        return Math.signum(work) * (float)Math.sqrt((float)2 * Math.abs(work));
    }

    private static final float kineticEnergyToVelocity(float kineticEnergy) {
        boolean $i$f$kineticEnergyToVelocity = false;
        return Math.signum(kineticEnergy) * (float)Math.sqrt((float)2 * Math.abs(kineticEnergy));
    }

    private static final float dot(float[] $this$dot, float[] a) {
        float result2 = 0.0f;
        int n = $this$dot.length;
        for (int i = 0; i < n; ++i) {
            result2 += $this$dot[i] * a[i];
        }
        return result2;
    }

    private static final float norm(float[] $this$norm) {
        boolean $i$f$norm = false;
        return (float)Math.sqrt(VelocityTrackerKt.dot($this$norm, $this$norm));
    }

    private static final float[][] Matrix(int rows, int cols) {
        boolean $i$f$Matrix = false;
        int n = 0;
        float[][] fArrayArray = new float[rows][];
        while (n < rows) {
            int n2 = n++;
            fArrayArray[n2] = new float[cols];
        }
        return fArrayArray;
    }

    private static final float get(float[][] $this$get, int row, int col) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        boolean $i$f$get = false;
        return $this$get[row][col];
    }

    private static final void set(float[][] $this$set, int row, int col, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        boolean $i$f$set = false;
        $this$set[row][col] = value;
    }

    @ExperimentalComposeUiApi
    public static final boolean getVelocityTrackerAddPointsFix() {
        return VelocityTrackerAddPointsFix;
    }

    @ExperimentalComposeUiApi
    public static final void setVelocityTrackerAddPointsFix(boolean bl) {
        VelocityTrackerAddPointsFix = bl;
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void getVelocityTrackerAddPointsFix$annotations() {
    }

    @ExperimentalComposeUiApi
    public static final boolean getVelocityTrackerStrategyUseImpulse() {
        return VelocityTrackerStrategyUseImpulse;
    }

    @ExperimentalComposeUiApi
    public static final void setVelocityTrackerStrategyUseImpulse(boolean bl) {
        VelocityTrackerStrategyUseImpulse = bl;
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void getVelocityTrackerStrategyUseImpulse$annotations() {
    }

    public static final /* synthetic */ void access$set(DataPointAtTime[] $receiver, int index2, long time, float dataPoint) {
        VelocityTrackerKt.set($receiver, index2, time, dataPoint);
    }

    public static final /* synthetic */ float access$calculateImpulseVelocity(float[] dataPoints, float[] time, int sampleCount, boolean isDataDifferential) {
        return VelocityTrackerKt.calculateImpulseVelocity(dataPoints, time, sampleCount, isDataDifferential);
    }
}

