/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.visualization.markerRenderers;

import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.ui.visualization.markerRenderers.NotebookLineMarkerRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J6\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/notebooks/ui/visualization/markerRenderers/NotebookMarkdownCellCornerGutterLineMarkerRenderer;", "Lcom/intellij/notebooks/ui/visualization/markerRenderers/NotebookLineMarkerRenderer;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "position", "Lcom/intellij/notebooks/ui/visualization/markerRenderers/NotebookMarkdownCellCornerGutterLineMarkerRenderer$Position;", "color", "Ljava/awt/Color;", "inlayId", "", "<init>", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/intellij/notebooks/ui/visualization/markerRenderers/NotebookMarkdownCellCornerGutterLineMarkerRenderer$Position;Ljava/awt/Color;J)V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "paintNotebookCellBorderGutter", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "top", "", "height", "Position", "intellij.notebooks.ui"})
public final class NotebookMarkdownCellCornerGutterLineMarkerRenderer
extends NotebookLineMarkerRenderer {
    @NotNull
    private final RangeHighlighter highlighter;
    @NotNull
    private final Position position;
    @NotNull
    private final Color color;

    public NotebookMarkdownCellCornerGutterLineMarkerRenderer(@NotNull RangeHighlighter highlighter, @NotNull Position position, @NotNull Color color, long inlayId) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        super(inlayId);
        this.highlighter = highlighter;
        this.position = position;
        this.color = color;
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        EditorImpl cfr_ignored_0 = (EditorImpl)editor;
        IntRange lines = new IntRange(((EditorImpl)editor).getDocument().getLineNumber(this.highlighter.getStartOffset()), ((EditorImpl)editor).getDocument().getLineNumber(this.highlighter.getEndOffset()));
        Rectangle rectangle = this.getInlayBounds((EditorEx)editor, lines);
        if (rectangle == null) {
            return;
        }
        Rectangle inlayBounds = rectangle;
        int bottomRectHeight = NotebookUtil.INSTANCE.getNotebookAppearance(editor).getCellBorderHeight() / 2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.position.ordinal()]) {
            case 1: {
                int delimiterHeight = inlayBounds.height - bottomRectHeight;
                int topPosition = inlayBounds.y + delimiterHeight;
                this.paintNotebookCellBorderGutter((EditorImpl)editor, g, r, topPosition, bottomRectHeight, Position.TOP);
                break;
            }
            case 2: 
            case 3: {
                this.paintNotebookCellBorderGutter((EditorImpl)editor, g, r, inlayBounds.y, inlayBounds.height, this.position);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void paintNotebookCellBorderGutter(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull Rectangle r, int top, int height, @NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Graphics2D g2d = (Graphics2D)g;
        NotebookEditorAppearance appearance = NotebookUtil.INSTANCE.getNotebookAppearance((Editor)editor);
        int borderWidth = appearance.getLeftBorderWidth();
        float leftBorderX = r.width - borderWidth;
        float rightBorderX = r.x + r.width;
        float topY = (float)top + 0.5f;
        float bottomY = (float)(top + height) + 0.5f;
        Stroke originalStroke = g2d.getStroke();
        RenderingHints originalHints = g2d.getRenderingHints();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setColor(this.color);
        g2d.setStroke(new BasicStroke(1.0f));
        switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
            case 1: {
                g2d.draw(new Line2D.Float(leftBorderX, topY, rightBorderX, topY));
                g2d.draw(new Line2D.Float(leftBorderX, topY, leftBorderX, bottomY));
                break;
            }
            case 2: {
                g2d.draw(new Line2D.Float(leftBorderX, topY, leftBorderX, bottomY - 1.0f));
                break;
            }
            case 3: {
                g2d.draw(new Line2D.Float(leftBorderX, bottomY - 1.0f, rightBorderX, bottomY - 1.0f));
                g2d.draw(new Line2D.Float(leftBorderX, topY, leftBorderX, bottomY - 1.0f));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        g2d.setStroke(originalStroke);
        g2d.setRenderingHints(originalHints);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/notebooks/ui/visualization/markerRenderers/NotebookMarkdownCellCornerGutterLineMarkerRenderer$Position;", "", "<init>", "(Ljava/lang/String;I)V", "BOTTOM", "MIDDLE", "TOP", "intellij.notebooks.ui"})
    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position BOTTOM = new Position();
        public static final /* enum */ Position MIDDLE = new Position();
        public static final /* enum */ Position TOP = new Position();
        private static final /* synthetic */ Position[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String value) {
            return Enum.valueOf(Position.class, value);
        }

        @NotNull
        public static EnumEntries<Position> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = positionArray = new Position[]{Position.BOTTOM, Position.MIDDLE, Position.TOP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Position.values().length];
            try {
                nArray[Position.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Position.MIDDLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Position.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

