/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.editor;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.scientific.tables.DSTableDataManager;
import com.intellij.scientific.tables.DSTableDataRetrieverFromDataSourceImpl;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.DSTableOutputData;
import com.intellij.scientific.tables.api.DSTableText;
import com.intellij.scientific.tables.editor.DSTableFileEditorKt;
import com.intellij.scientific.tables.editor.DSTableFileType;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0004\u0010\u0010B3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0012J\b\u0010&\u001a\u00020\u001fH\u0016R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010 \"\u0004\b!\u0010\"R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010\u0005\u00a8\u0006'"}, d2={"Lcom/intellij/scientific/tables/editor/DSTableVirtualFile;", "Lcom/intellij/testFramework/LightVirtualFile;", "tabName", "", "<init>", "(Ljava/lang/String;)V", "project", "Lcom/intellij/openapi/project/Project;", "tableDataRetriever", "Lcom/intellij/scientific/tables/DSTableDataRetrieverFromDataSourceImpl;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/scientific/tables/DSTableDataRetrieverFromDataSourceImpl;)V", "varName", "tableType", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "executor", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/scientific/tables/api/DSTableDataType;Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;)V", "format", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/scientific/tables/api/DSTableDataType;Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;Ljava/lang/String;)V", "commandExecutor", "getCommandExecutor", "()Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "setCommandExecutor", "(Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;)V", "outputData", "Lcom/intellij/scientific/tables/api/DSTableOutputData;", "getOutputData", "()Lcom/intellij/scientific/tables/api/DSTableOutputData;", "setOutputData", "(Lcom/intellij/scientific/tables/api/DSTableOutputData;)V", "isDynamicTable", "", "()Z", "setDynamicTable", "(Z)V", "getFormat", "()Ljava/lang/String;", "setFormat", "isWritable", "intellij.scientific.tables"})
public final class DSTableVirtualFile
extends LightVirtualFile {
    @Nullable
    private DSTableCommandExecutor commandExecutor;
    @Nullable
    private DSTableOutputData outputData;
    private boolean isDynamicTable;
    @Nullable
    private String format;

    private DSTableVirtualFile(String tabName) {
        super(tabName, (FileType)DSTableFileType.INSTANCE, (CharSequence)"");
    }

    @Nullable
    public final DSTableCommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public final void setCommandExecutor(@Nullable DSTableCommandExecutor dSTableCommandExecutor) {
        this.commandExecutor = dSTableCommandExecutor;
    }

    @Nullable
    public final DSTableOutputData getOutputData() {
        return this.outputData;
    }

    public final void setOutputData(@Nullable DSTableOutputData dSTableOutputData) {
        this.outputData = dSTableOutputData;
    }

    public final boolean isDynamicTable() {
        return this.isDynamicTable;
    }

    public final void setDynamicTable(boolean bl) {
        this.isDynamicTable = bl;
    }

    @Nullable
    public final String getFormat() {
        return this.format;
    }

    public final void setFormat(@Nullable String string) {
        this.format = string;
    }

    public DSTableVirtualFile(@NotNull String tabName, @NotNull Project project, @NotNull DSTableDataRetrieverFromDataSourceImpl tableDataRetriever) {
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tableDataRetriever, (String)"tableDataRetriever");
        this(tabName);
        this.commandExecutor = tableDataRetriever.getTableCommandExecutor();
        DSTableOutputData dSTableOutputData = DSTableDataManager.Companion.getInstance(project).getStaticTableData(tableDataRetriever.getDataId());
        if (dSTableOutputData == null) {
            dSTableOutputData = new DSTableOutputData(tableDataRetriever.getCurrentTableExpression(), DSTableFileEditorKt.getDEFAULT_EDITOR_TAB_NAME(), new DSTableText("", ""), tableDataRetriever.getTableDataProvider().getType());
        }
        this.outputData = dSTableOutputData;
        this.isDynamicTable = tableDataRetriever.isDynamicTable();
    }

    public DSTableVirtualFile(@NotNull String tabName, @NotNull String varName, @NotNull DSTableDataType tableType, @NotNull DSTableCommandExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        Intrinsics.checkNotNullParameter((Object)((Object)tableType), (String)"tableType");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this(tabName);
        this.commandExecutor = executor;
        this.outputData = new DSTableOutputData(varName, tabName, new DSTableText("", ""), tableType);
        this.isDynamicTable = true;
    }

    public DSTableVirtualFile(@NotNull String tabName, @NotNull String varName, @NotNull DSTableDataType tableType, @NotNull DSTableCommandExecutor executor, @Nullable String format) {
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        Intrinsics.checkNotNullParameter((Object)((Object)tableType), (String)"tableType");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this(tabName);
        this.commandExecutor = executor;
        this.outputData = new DSTableOutputData(varName, tabName, new DSTableText("", ""), tableType);
        this.isDynamicTable = true;
        this.format = format;
    }

    public boolean isWritable() {
        return true;
    }
}

