/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.features.ide.inspections.workflow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.StackOverflowPreventedException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Stack;
import com.intellij.vcs.github.ultimate.features.i18n.GithubUltimateBundle;
import com.intellij.vcs.github.ultimate.features.ide.PluginSettingsUtilKt;
import com.intellij.vcs.github.ultimate.features.ide.inspections.BaseGitHubActionInspection;
import com.intellij.vcs.github.ultimate.features.ide.inspections.workflow.CyclicJobDependencyInspectionKt;
import com.intellij.vcs.github.ultimate.features.workflow.GitHubWorkflowUtilKt;
import com.intellij.vcs.github.ultimate.features.workflow.job.needs.JobNeedReference;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.extensions.GithubYamlFileDetectionKt;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/github/ultimate/features/ide/inspections/workflow/CyclicJobDependencyInspection;", "Lcom/intellij/vcs/github/ultimate/features/ide/inspections/BaseGitHubActionInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isAvailableForFile", "file", "Lcom/intellij/psi/PsiFile;", "JobReferenceCycleDetector", "intellij.vcs.github.ultimate.features"})
public final class CyclicJobDependencyInspection
extends BaseGitHubActionInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new YamlPsiElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitKeyValue(YAMLKeyValue keyValue) {
                block8: {
                    Object object;
                    block7: {
                        block6: {
                            Intrinsics.checkNotNullParameter((Object)keyValue, (String)"keyValue");
                            if (!GitHubWorkflowUtilKt.getJobIdPattern().accepts((Object)keyValue)) {
                                return;
                            }
                            object = keyValue.getValue();
                            if (object == null) break block6;
                            YAMLValue it = object;
                            boolean bl = false;
                            List<JobNeedReference> list = CyclicJobDependencyInspectionKt.collectReferences((PsiElement)it);
                            object = list;
                            if (list != null) break block7;
                        }
                        object = CollectionsKt.emptyList();
                    }
                    Object jobNeedReferences = object;
                    String string = keyValue.getContainingFile().getVirtualFile().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    JobReferenceCycleDetector cycleDetector = new JobReferenceCycleDetector(string);
                    String string2 = keyValue.getKeyText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKeyText(...)");
                    cycleDetector.traverseAndDetectCycle(string2, (Stack<JobNeedReference>)new Stack((Collection)jobNeedReferences), (Stack<String>)new Stack());
                    if (!cycleDetector.cycleDetected()) break block8;
                    PsiElement psiElement = keyValue.getKey();
                    if (psiElement != null) {
                        PsiElement psiElement2 = psiElement;
                        ProblemsHolder problemsHolder = this.$holder;
                        PsiElement it = psiElement2;
                        boolean bl = false;
                        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)cycleDetector.collectCyclePath(), (CharSequence)"->", null, null, (int)0, null, null, (int)62, null)};
                        problemsHolder.registerProblem(it, GithubUltimateBundle.message("github.action.inspections.message.cyclic.job.dependency", objectArray), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    @Override
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return PluginSettingsUtilKt.githubActionsSupportEnabled() && GithubYamlFileDetectionKt.isGithubWorkflowFile(file);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fJ*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/github/ultimate/features/ide/inspections/workflow/CyclicJobDependencyInspection$JobReferenceCycleDetector;", "", "fileName", "", "<init>", "(Ljava/lang/String;)V", "cyclePath", "", "visited", "", "RECURSION_MAX_LENGTH", "", "cycleDetected", "", "collectCyclePath", "", "traverseAndDetectCycle", "", "current", "nextJobs", "Lcom/intellij/util/containers/Stack;", "Lcom/intellij/vcs/github/ultimate/features/workflow/job/needs/JobNeedReference;", "currentPath", "intellij.vcs.github.ultimate.features"})
    @SourceDebugExtension(value={"SMAP\nCyclicJobDependencyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CyclicJobDependencyInspection.kt\ncom/intellij/vcs/github/ultimate/features/ide/inspections/workflow/CyclicJobDependencyInspection$JobReferenceCycleDetector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n59#2:93\n37#2,2:94\n*S KotlinDebug\n*F\n+ 1 CyclicJobDependencyInspection.kt\ncom/intellij/vcs/github/ultimate/features/ide/inspections/workflow/CyclicJobDependencyInspection$JobReferenceCycleDetector\n*L\n61#1:93\n61#1:94,2\n*E\n"})
    private static final class JobReferenceCycleDetector {
        @NotNull
        private final String fileName;
        @NotNull
        private final List<String> cyclePath;
        @NotNull
        private final Set<String> visited;
        private final int RECURSION_MAX_LENGTH;

        public JobReferenceCycleDetector(@NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            this.fileName = fileName;
            this.cyclePath = new ArrayList();
            this.visited = new LinkedHashSet();
            this.RECURSION_MAX_LENGTH = Registry.Companion.intValue("github.actions.inspection.cyclic.job.dependency.stack");
        }

        public final boolean cycleDetected() {
            return !((Collection)this.cyclePath).isEmpty();
        }

        @NotNull
        public final List<String> collectCyclePath() {
            return CollectionsKt.toList((Iterable)this.cyclePath);
        }

        public final void traverseAndDetectCycle(@NotNull String current, @NotNull Stack<JobNeedReference> nextJobs, @NotNull Stack<String> currentPath) {
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter(nextJobs, (String)"nextJobs");
            Intrinsics.checkNotNullParameter(currentPath, (String)"currentPath");
            currentPath.push((Object)current);
            if (currentPath.size() > this.RECURSION_MAX_LENGTH) {
                String message2 = "Error while detecting cyclic job dependencies in workflow file \"" + this.fileName + "\" Job dependencies stack too deep: " + this.RECURSION_MAX_LENGTH + ". Use \"github.actions.inspection.cyclic.job.dependency.stack\" registry key to increase the value.";
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warnWithDebug(message2, (Throwable)new StackOverflowPreventedException(message2));
                this.cyclePath.addAll((Collection)currentPath);
            }
            while (!((Collection)nextJobs).isEmpty() && this.cyclePath.isEmpty()) {
                PsiElement resolvedNextJob;
                ProgressManager.checkCanceled();
                if (((JobNeedReference)((Object)nextJobs.pop())).resolve() == null) continue;
                String resolvedNextJobName = resolvedNextJob.getText();
                if (currentPath.contains((Object)resolvedNextJobName)) {
                    this.cyclePath.addAll(CollectionsKt.plus((Collection)((Collection)currentPath), (Object)resolvedNextJobName));
                    continue;
                }
                if (this.visited.contains(resolvedNextJobName)) continue;
                List<JobNeedReference> references = CyclicJobDependencyInspectionKt.collectReferences(resolvedNextJob);
                Intrinsics.checkNotNull((Object)resolvedNextJobName);
                this.traverseAndDetectCycle(resolvedNextJobName, (Stack<JobNeedReference>)new Stack((Collection)references), currentPath);
                this.visited.add(resolvedNextJobName);
            }
            currentPath.pop();
        }
    }
}

