/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.chunking.Chunker;
import org.languagetool.chunking.EnglishChunker;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.BERTSuggestionRanking;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.EmptyLineRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.ParagraphRepeatBeginningRule;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd2;
import org.languagetool.rules.ReadabilityRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.en.AvsAnRule;
import org.languagetool.rules.en.CompoundRule;
import org.languagetool.rules.en.ConsistentApostrophesRule;
import org.languagetool.rules.en.ContractionSpellingRule;
import org.languagetool.rules.en.EnglishConfusionProbabilityRule;
import org.languagetool.rules.en.EnglishDashRule;
import org.languagetool.rules.en.EnglishDiacriticsRule;
import org.languagetool.rules.en.EnglishForDutchmenFalseFriendRule;
import org.languagetool.rules.en.EnglishForFrenchFalseFriendRule;
import org.languagetool.rules.en.EnglishForGermansFalseFriendRule;
import org.languagetool.rules.en.EnglishForSpaniardsFalseFriendRule;
import org.languagetool.rules.en.EnglishMultitokenSpeller;
import org.languagetool.rules.en.EnglishNgramProbabilityRule;
import org.languagetool.rules.en.EnglishPlainEnglishRule;
import org.languagetool.rules.en.EnglishRedundancyRule;
import org.languagetool.rules.en.EnglishRepeatedWordsRule;
import org.languagetool.rules.en.EnglishSpecificCaseRule;
import org.languagetool.rules.en.EnglishUnpairedBracketsRule;
import org.languagetool.rules.en.EnglishUnpairedQuotesRule;
import org.languagetool.rules.en.EnglishWordRepeatBeginningRule;
import org.languagetool.rules.en.EnglishWordRepeatRule;
import org.languagetool.rules.en.EnglishWrongWordInContextRule;
import org.languagetool.rules.en.LongSentenceRule;
import org.languagetool.rules.en.MorfologikAmericanSpellerRule;
import org.languagetool.rules.en.SimpleReplaceProfanityRule;
import org.languagetool.rules.en.SimpleReplaceRule;
import org.languagetool.rules.en.StyleTooOftenUsedAdjectiveRule;
import org.languagetool.rules.en.StyleTooOftenUsedNounRule;
import org.languagetool.rules.en.StyleTooOftenUsedVerbRule;
import org.languagetool.rules.en.UpperCaseNgramRule;
import org.languagetool.rules.en.WordCoherencyRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.multitoken.MultitokenSpeller;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.en.EnglishSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.en.EnglishHybridDisambiguator;
import org.languagetool.tagging.en.EnglishTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.en.EnglishWordTokenizer;
import org.languagetool.tools.Tools;

public class English
extends Language
implements AutoCloseable {
    protected static final LoadingCache<String, List<Rule>> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<Rule>>(){

        public List<Rule> load(@NotNull String path) throws IOException {
            ArrayList<Rule> rules = new ArrayList<Rule>();
            PatternRuleLoader loader = new PatternRuleLoader();
            try (InputStream is = JLanguageTool.getDataBroker().getAsStream(path);){
                rules.addAll(loader.getRules(is, path, null));
            }
            return rules;
        }
    });
    private static final Language AMERICAN_ENGLISH = new AmericanEnglish();
    private static final Pattern FALSE_FRIENDS_PATTERN = Pattern.compile("EN_FOR_[A-Z]+_SPEAKERS_FALSE_FRIENDS.*");
    private LanguageModel languageModel;
    private static final Map<String, Integer> id2prio = new HashMap<String, Integer>();

    @Deprecated
    public English() {
    }

    @Override
    public Language getDefaultLanguageVariant() {
        return AMERICAN_ENGLISH;
    }

    @Override
    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer(this);
    }

    @Override
    public String getName() {
        return "English";
    }

    @Override
    public String getShortCode() {
        return "en";
    }

    @Override
    public String[] getCountries() {
        return new String[0];
    }

    @Override
    @NotNull
    public Tagger createDefaultTagger() {
        return EnglishTagger.INSTANCE;
    }

    @Override
    @Nullable
    public Chunker createDefaultChunker() {
        return new EnglishChunker();
    }

    @Override
    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return EnglishSynthesizer.INSTANCE;
    }

    @Override
    public Disambiguator createDefaultDisambiguator() {
        return new EnglishHybridDisambiguator(this.getDefaultLanguageVariant());
    }

    @Override
    public Tokenizer createDefaultWordTokenizer() {
        return new EnglishWordTokenizer();
    }

    @Override
    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    @Override
    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Mike Unwalla"), Contributors.MARCIN_MILKOWSKI, Contributors.DANIEL_NABER};
    }

    @Override
    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> allRules = new ArrayList<Rule>();
        if (motherTongue != null) {
            if ("de".equals(motherTongue.getShortCode())) {
                allRules.addAll((Collection)cache.getUnchecked((Object)"/org/languagetool/rules/en/grammar-l2-de.xml"));
            } else if ("fr".equals(motherTongue.getShortCode())) {
                allRules.addAll((Collection)cache.getUnchecked((Object)"/org/languagetool/rules/en/grammar-l2-fr.xml"));
            }
        }
        allRules.addAll(Arrays.asList(new CommaWhitespaceRule(messages, Example.wrong("We had coffee<marker> ,</marker> cheese and crackers and grapes."), Example.fixed("We had coffee<marker>,</marker> cheese and crackers and grapes.")), new DoublePunctuationRule(messages, Tools.getUrl("https://languagetool.org/insights/post/punctuation-guide/#what-are-periods")), new UppercaseSentenceStartRule(messages, this, Example.wrong("This house is old. <marker>it</marker> was built in 1950."), Example.fixed("This house is old. <marker>It</marker> was built in 1950."), Tools.getUrl("https://languagetool.org/insights/post/spelling-capital-letters/")), new MultipleWhitespaceRule(messages, this), new SentenceWhitespaceRule(messages), new WhiteSpaceBeforeParagraphEnd(messages, this), new WhiteSpaceAtBeginOfParagraph(messages), new EmptyLineRule(messages, this), new LongSentenceRule(messages, userConfig, 40), new LongParagraphRule(messages, this, userConfig), new ParagraphRepeatBeginningRule(messages, this), new PunctuationMarkAtParagraphEnd(messages, this), new PunctuationMarkAtParagraphEnd2(messages, this), new ConsistentApostrophesRule(messages), new EnglishSpecificCaseRule(messages), new EnglishUnpairedBracketsRule(messages, this), new EnglishUnpairedQuotesRule(messages, this), new EnglishWordRepeatRule(messages, this), new AvsAnRule(messages), new EnglishWordRepeatBeginningRule(messages, this), new CompoundRule(messages, this, userConfig), new ContractionSpellingRule(messages, this), new EnglishWrongWordInContextRule(messages, this), new EnglishDashRule(messages), new WordCoherencyRule(messages), new EnglishDiacriticsRule(messages), new EnglishPlainEnglishRule(messages), new EnglishRedundancyRule(messages), new SimpleReplaceRule(messages, this), new SimpleReplaceProfanityRule(messages, this), new ReadabilityRule(messages, this, userConfig, false), new ReadabilityRule(messages, this, userConfig, true), new EnglishRepeatedWordsRule(messages), new StyleTooOftenUsedVerbRule(messages, this, userConfig), new StyleTooOftenUsedNounRule(messages, this, userConfig), new StyleTooOftenUsedAdjectiveRule(messages, this, userConfig)));
        return allRules;
    }

    @Override
    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Arrays.asList(new UpperCaseNgramRule(messages, languageModel, this, userConfig), new EnglishConfusionProbabilityRule(messages, languageModel, this), new EnglishNgramProbabilityRule(messages, languageModel, this));
    }

    @Override
    public List<Rule> getRelevantLanguageModelCapableRules(ResourceBundle messages, @Nullable LanguageModel lm, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        if (lm != null && motherTongue != null) {
            if ("fr".equals(motherTongue.getShortCode())) {
                return Arrays.asList(new EnglishForFrenchFalseFriendRule(messages, lm, motherTongue, this));
            }
            if ("de".equals(motherTongue.getShortCode())) {
                return Arrays.asList(new EnglishForGermansFalseFriendRule(messages, lm, motherTongue, this));
            }
            if ("es".equals(motherTongue.getShortCode())) {
                return Arrays.asList(new EnglishForSpaniardsFalseFriendRule(messages, lm, motherTongue, this));
            }
            if ("nl".equals(motherTongue.getShortCode())) {
                return Arrays.asList(new EnglishForDutchmenFalseFriendRule(messages, lm, motherTongue, this));
            }
        }
        return Arrays.asList(new Rule[0]);
    }

    @Override
    public boolean hasNGramFalseFriendRule(Language motherTongue) {
        return motherTongue != null && ("de".equals(motherTongue.getShortCode()) || "fr".equals(motherTongue.getShortCode()) || "es".equals(motherTongue.getShortCode()) || "nl".equals(motherTongue.getShortCode()));
    }

    @Override
    public String getOpeningDoubleQuote() {
        return "\u201c";
    }

    @Override
    public String getClosingDoubleQuote() {
        return "\u201d";
    }

    @Override
    public String getOpeningSingleQuote() {
        return "\u2018";
    }

    @Override
    public String getClosingSingleQuote() {
        return "\u2019";
    }

    @Override
    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    @Override
    protected int getDefaultRulePriorityForStyle() {
        return -50;
    }

    @Override
    public Map<String, Integer> getPriorityMap() {
        return id2prio;
    }

    @Override
    protected int getPriorityForId(String id) {
        Integer prio = id2prio.get(id);
        if (prio != null) {
            return prio;
        }
        if (id.startsWith("EN_COMPOUNDS_")) {
            return 2;
        }
        if (id.equals("PRP_VBZ")) {
            return -2;
        }
        if (id.startsWith("CONFUSION_RULE_")) {
            return -20;
        }
        if (id.equals("EN_UPPER_CASE_NGRAM")) {
            return -12;
        }
        if (id.startsWith("AI_SPELLING_RULE")) {
            return -9;
        }
        if (id.startsWith("EN_MULTITOKEN_SPELLING_")) {
            return -9;
        }
        if (id.startsWith("EN_GB_SIMPLE_REPLACE")) {
            return -5;
        }
        if (id.startsWith("EN_US_SIMPLE_REPLACE")) {
            return -5;
        }
        if (id.equals("QB_EN_OXFORD")) {
            return -51;
        }
        if (id.startsWith("EN_SIMPLE_REPLACE") && (id.endsWith("GRAMME") || id.endsWith("GRAMMES"))) {
            return -49;
        }
        if (id.startsWith("AI_HYDRA_LEO")) {
            if (id.equals("AI_HYDRA_LEO_MISSING_COMMA")) {
                return -51;
            }
            if (id.startsWith("AI_HYDRA_LEO_CP_YOU_YOUARE")) {
                return -1;
            }
            if (id.startsWith("AI_HYDRA_LEO_CP")) {
                return 2;
            }
            if (id.startsWith("AI_HYDRA_LEO_MISSING_TO")) {
                return -14;
            }
            return -11;
        }
        if (id.startsWith("AI_EN_LECTOR")) {
            return -11;
        }
        if (FALSE_FRIENDS_PATTERN.matcher(id).matches()) {
            return -21;
        }
        return super.getPriorityForId(id);
    }

    @Override
    public Function<Rule, Rule> getRemoteEnhancedRules(ResourceBundle messageBundle, List<RemoteRuleConfig> configs, UserConfig userConfig, Language motherTongue, List<Language> altLanguages, boolean inputLogging) throws IOException {
        Function<Rule, Rule> fallback = super.getRemoteEnhancedRules(messageBundle, configs, userConfig, motherTongue, altLanguages, inputLogging);
        RemoteRuleConfig bert = RemoteRuleConfig.getRelevantConfig("BERT_SUGGESTION_RANKING", configs);
        return original -> {
            if (original.isDictionaryBasedSpellingRule() && original.getId().startsWith("MORFOLOGIK_RULE_EN") && bert != null) {
                return new BERTSuggestionRanking((Language)this, (Rule)original, bert, inputLogging);
            }
            return (Rule)fallback.apply((Rule)original);
        };
    }

    @Override
    public boolean hasMinMatchesRules() {
        return true;
    }

    @Override
    public SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikAmericanSpellerRule(messages, this, null, Collections.emptyList());
    }

    @Override
    public List<RuleMatch> filterRuleMatches(List<RuleMatch> ruleMatches, AnnotatedText text2, Set<String> enabledRules) {
        ArrayList<RuleMatch> newRuleMatches = new ArrayList<RuleMatch>();
        for (RuleMatch rm : ruleMatches) {
            String errorStr = rm.getOriginalErrorStr();
            List<SuggestedReplacement> suggestedReplacements = rm.getSuggestedReplacementObjects();
            ArrayList<SuggestedReplacement> newReplacements = new ArrayList<SuggestedReplacement>();
            for (SuggestedReplacement suggestedReplacement : suggestedReplacements) {
                String newReplStr = suggestedReplacement.getReplacement();
                if (errorStr.length() > 2) {
                    if (errorStr.startsWith("'") && !newReplStr.startsWith("'") && !newReplStr.startsWith("\u2019") && !newReplStr.startsWith(" ")) {
                        newReplStr = " " + newReplStr;
                    }
                    if (errorStr.startsWith("n't") && !newReplStr.startsWith("n't") && !newReplStr.startsWith("n\u2019t")) {
                        newReplStr = " " + newReplStr;
                    }
                }
                SuggestedReplacement newSuggestedReplacement = new SuggestedReplacement(suggestedReplacement);
                newSuggestedReplacement.setReplacement(newReplStr);
                if (newReplacements.contains(newSuggestedReplacement)) continue;
                newReplacements.add(newSuggestedReplacement);
            }
            RuleMatch newMatch = new RuleMatch(rm, newReplacements);
            if (newMatch.getSpecificRuleId().startsWith("EN_SIMPLE_REPLACE") && (newMatch.getSpecificRuleId().endsWith("GRAMME") || newMatch.getSpecificRuleId().endsWith("GRAMMES"))) {
                newMatch.getRule().setLocQualityIssueType(ITSIssueType.LocaleViolation);
            }
            newRuleMatches.add(newMatch);
        }
        return newRuleMatches;
    }

    @Override
    public List<String> prepareLineForSpeller(String line) {
        String[] parts = line.split("#");
        if (parts.length == 0) {
            return Arrays.asList(line);
        }
        if (line.contains("+")) {
            return Arrays.asList("");
        }
        String[] formTag = parts[0].split("\t");
        String form = formTag[0].trim();
        if (formTag.length > 1) {
            String tag = formTag[1].trim();
            if (tag.startsWith("NN") || tag.startsWith("JJ")) {
                return Arrays.asList(form);
            }
            return Arrays.asList("");
        }
        return Arrays.asList(line);
    }

    @Override
    public MultitokenSpeller getMultitokenSpeller() {
        return EnglishMultitokenSpeller.INSTANCE;
    }

    static {
        id2prio.put("I_E", 10);
        id2prio.put("CHILDISH_LANGUAGE", 8);
        id2prio.put("RUDE_SARCASTIC", 6);
        id2prio.put("FOR_NOUN_SAKE", 6);
        id2prio.put("YEAR_OLD_HYPHEN", 6);
        id2prio.put("MISSING_HYPHEN", 5);
        id2prio.put("WRONG_APOSTROPHE", 5);
        id2prio.put("YOU_GOOD", 3);
        id2prio.put("DOS_AND_DONTS", 3);
        id2prio.put("IF_YOU_FURTHER_QUESTIONS", 3);
        id2prio.put("ABBREVIATION_PUNCTUATION", 2);
        id2prio.put("READ_ONLY_ACCESS_HYPHEN", 2);
        id2prio.put("MAKE_OR_BREAK_HYPHEN", 2);
        id2prio.put("LINKED_IN", 2);
        id2prio.put("T_HE", 1);
        id2prio.put("I_A_M", 1);
        id2prio.put("ACCESS_EXCESS", 1);
        id2prio.put("PRP_ABLE_TO", 1);
        id2prio.put("WEE_WE", 1);
        id2prio.put("CAN_MISSPELLING", 1);
        id2prio.put("FOR_THE_MOST_PART2", 1);
        id2prio.put("FACE_TO_FACE_HYPHEN", 1);
        id2prio.put("RUN_ON", 1);
        id2prio.put("ON_THE_LOOK_OUT", 1);
        id2prio.put("APOSTROPHE_IN_DAYS", 1);
        id2prio.put("SAFE_GUARD_COMPOUND", 1);
        id2prio.put("EVEN_HANDED_HYPHEN", 1);
        id2prio.put("GET_TOGETHER_HYPHEN", 1);
        id2prio.put("GOT_HERE", 1);
        id2prio.put("PICTURE_PERFECT_HYPHEN", 1);
        id2prio.put("SEEM_SEEN", 1);
        id2prio.put("SAVE_SAFE", 1);
        id2prio.put("FEDEX", 2);
        id2prio.put("DROP_DEAD_HYPHEN", 1);
        id2prio.put("HEAR_HERE", 1);
        id2prio.put("THE_FRENCH", 1);
        id2prio.put("A_HEADS_UP", 1);
        id2prio.put("UNITES_UNITED", 1);
        id2prio.put("THIS_MISSING_VERB", 1);
        id2prio.put("YOURE", 1);
        id2prio.put("LIFE_COMPOUNDS", 1);
        id2prio.put("DRIVE_THROUGH_HYPHEN", 1);
        id2prio.put("CAUSE_COURSE", 1);
        id2prio.put("THANK_YOUR", 1);
        id2prio.put("AN_AND", 1);
        id2prio.put("HER_S", 1);
        id2prio.put("ONE_TO_MANY_HYPHEN", 1);
        id2prio.put("COVID_19", 1);
        id2prio.put("RATHER_NOT_VB", 1);
        id2prio.put("PIECE_COMPOUNDS", 1);
        id2prio.put("OTHER_WISE_COMPOUND", 1);
        id2prio.put("ON_EXCEL", 1);
        id2prio.put("ALL_NN", 1);
        id2prio.put("SHOW_COMPOUNDS", 1);
        id2prio.put("PRP_AREA", 1);
        id2prio.put("IF_VB_PCT", 1);
        id2prio.put("CAUSE_BECAUSE", 1);
        id2prio.put("MAY_MANY", 1);
        id2prio.put("BOUT_TO", 1);
        id2prio.put("HAVE_HAVE", 1);
        id2prio.put("LUV", 1);
        id2prio.put("DAT", 1);
        id2prio.put("MAC_OS", 1);
        id2prio.put("BESTEST", 1);
        id2prio.put("OFF_OF", 1);
        id2prio.put("SHELL_COMPOUNDS", 1);
        id2prio.put("HANDS_ON_HYPHEN", 1);
        id2prio.put("PROFITS_WARNINGS", 1);
        id2prio.put("QUIET_QUITE", 1);
        id2prio.put("A_OK", 1);
        id2prio.put("I_A", 1);
        id2prio.put("PRP_NO_VB", 1);
        id2prio.put("GAVE_HAVE", 1);
        id2prio.put("THERE_FORE", 1);
        id2prio.put("FOLLOW_UP", 1);
        id2prio.put("IT_SOMETHING", 1);
        id2prio.put("NO_KNOW", 1);
        id2prio.put("WILL_BASED_ON", 1);
        id2prio.put("DON_T_AREN_T", 1);
        id2prio.put("WILL_BECOMING", 1);
        id2prio.put("WOULD_NEVER_VBN", 1);
        id2prio.put("MONEY_BACK_HYPHEN", 1);
        id2prio.put("WORLDS_BEST", 1);
        id2prio.put("STEP_COMPOUNDS", 1);
        id2prio.put("WON_T_TO", 1);
        id2prio.put("WAN_T", 1);
        id2prio.put("THE_US", 1);
        id2prio.put("THE_IT", 1);
        id2prio.put("THANK_YOU_MUCH", 1);
        id2prio.put("TO_DO_HYPHEN", 1);
        id2prio.put("A_NUMBER_NNS", 1);
        id2prio.put("A_HUNDREDS", 1);
        id2prio.put("NOW_A_DAYS", 1);
        id2prio.put("COUPLE_OF_TIMES", 1);
        id2prio.put("A_WINDOWS", 1);
        id2prio.put("A_SCISSOR", 1);
        id2prio.put("A_SNICKERS", 1);
        id2prio.put("A_NNS_BEST_NN", 1);
        id2prio.put("BACHELORS", 1);
        id2prio.put("WERE_WEAR", 1);
        id2prio.put("NEITHER_NOR", 1);
        id2prio.put("FOR_AWHILE", 1);
        id2prio.put("A_BUT", 1);
        id2prio.put("BORN_IN", 1);
        id2prio.put("DO_TO", 1);
        id2prio.put("CURIOS_CURIOUS", 1);
        id2prio.put("INCORRECT_POSSESSIVE_APOSTROPHE", 1);
        id2prio.put("THIS_YEARS_POSSESSIVE_APOSTROPHE", 1);
        id2prio.put("SPURIOUS_APOSTROPHE", 1);
        id2prio.put("BE_NOT_BE_JJ", 1);
        id2prio.put("IN_THIS_REGARDS", 1);
        id2prio.put("IT_SEAMS", 1);
        id2prio.put("NO_WHERE", 1);
        id2prio.put("APOSTROPHE_VS_QUOTE", 1);
        id2prio.put("ALL_OF_SUDDEN", 1);
        id2prio.put("COMMA_PERIOD", 1);
        id2prio.put("COMMA_CLOSING_PARENTHESIS", 1);
        id2prio.put("ELLIPSIS", 1);
        id2prio.put("HERE_HEAR", 1);
        id2prio.put("MISSING_POSS_APOS", 1);
        id2prio.put("DO_HE_VERB", 1);
        id2prio.put("LIGATURES", 1);
        id2prio.put("APPSTORE", 1);
        id2prio.put("INCORRECT_CONTRACTIONS", 1);
        id2prio.put("DONT_T", 1);
        id2prio.put("WHATS_APP", 1);
        id2prio.put("NON_STANDARD_COMMA", 1);
        id2prio.put("NON_ENGLISH_CHARACTER_IN_A_WORD", 1);
        id2prio.put("WONT_CONTRACTION", 1);
        id2prio.put("THAN_THANK", 1);
        id2prio.put("SPURIOUS_APOSTROPHE", 1);
        id2prio.put("IT_IF", 1);
        id2prio.put("FINE_TUNE_COMPOUNDS", 1);
        id2prio.put("WHAT_IS_YOU", 1);
        id2prio.put("SUPPOSE_TO", 1);
        id2prio.put("CONFUSION_GONG_GOING", 1);
        id2prio.put("SEEN_SEEM", 1);
        id2prio.put("PROFANITY", 1);
        id2prio.put("PROFANITY_XML", 1);
        id2prio.put("GOOD_FLUCK", 2);
        id2prio.put("PROFANITY_TYPOS", 2);
        id2prio.put("THE_THEM", 1);
        id2prio.put("THERE_THEIR", 1);
        id2prio.put("TO_WORRIED_ABOUT", 1);
        id2prio.put("IT_IS_DEPENDING_ON", 1);
        id2prio.put("TO_NIGHT_TO_DAY", 1);
        id2prio.put("IRREGARDLESS", 1);
        id2prio.put("MD_APOSTROPHE_VB", 1);
        id2prio.put("ULTRA_HYPHEN", 1);
        id2prio.put("THINK_BELIEVE_THAT", 1);
        id2prio.put("HAS_TO_APPROVED_BY", 1);
        id2prio.put("MD_VBD", -1);
        id2prio.put("PRP_PRP", -1);
        id2prio.put("IS_LIKELY_TO_BE", -1);
        id2prio.put("WANNA", 1);
        id2prio.put("LOOK_FORWARD_TO", 1);
        id2prio.put("LOOK_SLIKE", 1);
        id2prio.put("A3FT", 1);
        id2prio.put("HYPHEN_TO_EN", 1);
        id2prio.put("EVERY_NOW_AND_THEN", 0);
        id2prio.put("EN_DIACRITICS_REPLACE_ORTHOGRAPHY", -1);
        id2prio.put("MISSING_COMMA_BETWEEN_DAY_AND_YEAR", -1);
        id2prio.put("FASTLY", -1);
        id2prio.put("WHO_NOUN", -1);
        id2prio.put("ANYWAYS", -1);
        id2prio.put("MISSING_GENITIVE", -1);
        id2prio.put("EN_UNPAIRED_BRACKETS", -1);
        id2prio.put("WAKED_UP", -1);
        id2prio.put("NEEDS_FIXED", -1);
        id2prio.put("SENT_START_NNP_COMMA", -1);
        id2prio.put("SENT_START_NN_DT", -1);
        id2prio.put("DT_PDT", -1);
        id2prio.put("MD_VB_AND_NOTVB", -1);
        id2prio.put("BLACK_SEA", -1);
        id2prio.put("A_TO", -1);
        id2prio.put("MANY_NN", -1);
        id2prio.put("WE_BE", -1);
        id2prio.put("A_LOT_OF_NN", -1);
        id2prio.put("REPETITIONS_STYLE", -51);
        id2prio.put("ORDER_OF_WORDS_WITH_NOT", -1);
        id2prio.put("ADVERB_WORD_ORDER_10_TEMP", 1);
        id2prio.put("ADVERB_WORD_ORDER", -1);
        id2prio.put("HAVE_VB_DT", -1);
        id2prio.put("MD_PRP", -1);
        id2prio.put("IT_IS_2", -1);
        id2prio.put("A_RB_NN", -1);
        id2prio.put("DT_RB_IN", -1);
        id2prio.put("VERB_NOUN_CONFUSION", -1);
        id2prio.put("NOUN_VERB_CONFUSION", -1);
        id2prio.put("PLURAL_VERB_AFTER_THIS", -1);
        id2prio.put("BE_RB_BE", -1);
        id2prio.put("IT_ITS", -1);
        id2prio.put("ENGLISH_WORD_REPEAT_RULE", -1);
        id2prio.put("DT_JJ_NO_NOUN", -1);
        id2prio.put("AGREEMENT_SENT_START", -1);
        id2prio.put("PREPOSITION_VERB", -1);
        id2prio.put("EN_A_VS_AN", -1);
        id2prio.put("CD_NN", -1);
        id2prio.put("CD_NNU", -1);
        id2prio.put("ATD_VERBS_TO_COLLOCATION", -1);
        id2prio.put("ORDINAL_NUMBER_MISSING_ORDINAL_INDICATOR", -1);
        id2prio.put("ADVERB_OR_HYPHENATED_ADJECTIVE", -1);
        id2prio.put("GOING_TO_VBD", -1);
        id2prio.put("MISSING_PREPOSITION", -1);
        id2prio.put("CHARACTER_APOSTROPHE_WORD", -1);
        id2prio.put("SINGLE_CHARACTER", -1);
        id2prio.put("BE_TO_VBG", -1);
        id2prio.put("NON3PRS_VERB", -1);
        id2prio.put("DT_NN_VBG", -1);
        id2prio.put("NNS_THAT_ARE_JJ", -1);
        id2prio.put("DID_FOUND_AMBIGUOUS", -1);
        id2prio.put("BE_I_BE_GERUND", -1);
        id2prio.put("VBZ_VBD", -1);
        id2prio.put("SUPERLATIVE_THAN", -1);
        id2prio.put("UNLIKELY_OPENING_PUNCTUATION", -1);
        id2prio.put("MD_DT_JJ", -1);
        id2prio.put("I_IF", -1);
        id2prio.put("NOUNPHRASE_VB_RB_DT", -1);
        id2prio.put("SENT_START_NN_NN_VB", -1);
        id2prio.put("VB_A_JJ_NNS", -1);
        id2prio.put("DUPLICATION_OF_IS_VBZ", -1);
        id2prio.put("METRIC_UNITS_EN_IMPERIAL", -1);
        id2prio.put("IF_THEN_COMMA", -1);
        id2prio.put("COMMA_COMPOUND_SENTENCE", -1);
        id2prio.put("COMMA_COMPOUND_SENTENCE_2", -1);
        id2prio.put("BE_VBG_BE", -1);
        id2prio.put("PRP_VB_VB", -1);
        id2prio.put("FOR_ANY_CLARIFICATIONS", -1);
        id2prio.put("PLEASE_LET_ME_KNOW", -1);
        id2prio.put("UNNECESSARY_CAPITALIZATION", -1);
        id2prio.put("CONFUSION_OF_A_JJ_NNP_NNS_PRP", -1);
        id2prio.put("PLURALITY_CONFUSION_OF_NNS_OF_NN", -1);
        id2prio.put("NP_TO_IS", -1);
        id2prio.put("REPEATED_VERBS", -1);
        id2prio.put("NNP_COMMA_QUESTION", -2);
        id2prio.put("THE_CC", -2);
        id2prio.put("PRP_VBG", -2);
        id2prio.put("CANT_JJ", -2);
        id2prio.put("WOULD_A", -2);
        id2prio.put("I_AM_VB", -2);
        id2prio.put("VBP_VBP", -2);
        id2prio.put("GONNA_TEMP", -3);
        id2prio.put("A_INFINITIVE", -3);
        id2prio.put("INDIAN_ENGLISH", -3);
        id2prio.put("DO_PRP_NOTVB", -3);
        id2prio.put("GONNA", -4);
        id2prio.put("WHATCHA", -4);
        id2prio.put("DONTCHA", -4);
        id2prio.put("GOTCHA", -4);
        id2prio.put("OUTTA", -4);
        id2prio.put("Y_ALL", -4);
        id2prio.put("GIMME", -4);
        id2prio.put("LEMME", -4);
        id2prio.put("ID_CASING", -4);
        id2prio.put("MORFOLOGIK_RULE_EN_US", -10);
        id2prio.put("MORFOLOGIK_RULE_EN_GB", -10);
        id2prio.put("MORFOLOGIK_RULE_EN_CA", -10);
        id2prio.put("MORFOLOGIK_RULE_EN_ZA", -10);
        id2prio.put("MORFOLOGIK_RULE_EN_NZ", -10);
        id2prio.put("MORFOLOGIK_RULE_EN_AU", -10);
        id2prio.put("MD_PRP_QUESTION_MARK", -11);
        id2prio.put("PRP_RB_NO_VB", -12);
        id2prio.put("MD_JJ", -12);
        id2prio.put("HE_VERB_AGR", -12);
        id2prio.put("MD_BASEFORM", -12);
        id2prio.put("IT_VBZ", -12);
        id2prio.put("PRP_THE", -12);
        id2prio.put("PRP_JJ", -12);
        id2prio.put("SINGULAR_NOUN_VERB_AGREEMENT", -12);
        id2prio.put("SINGULAR_AGREEMENT_SENT_START", -12);
        id2prio.put("VB_TO_NN_DT", -12);
        id2prio.put("SUBJECTVERBAGREEMENT_2", -12);
        id2prio.put("THE_SENT_END", -12);
        id2prio.put("DT_NN_ARE_AME", -12);
        id2prio.put("COLLECTIVE_NOUN_VERB_AGREEMENT_VBP", -12);
        id2prio.put("SUBJECT_VERB_AGREEMENT", -12);
        id2prio.put("VERB_APOSTROPHE_S", -12);
        id2prio.put("WHERE_MD_VB", -12);
        id2prio.put("SENT_START_PRPS_JJ_NN_VBP", -12);
        id2prio.put("TO_AFTER_MODAL_VERBS", -12);
        id2prio.put("SINGULAR_NOUN_ADV_AGREEMENT", -12);
        id2prio.put("BE_VBP_IN", -12);
        id2prio.put("BE_VBG_NN", -12);
        id2prio.put("THE_NNS_NN_IS", -12);
        id2prio.put("IF_DT_NN_VBZ", -12);
        id2prio.put("PRP_MD_NN", -12);
        id2prio.put("HAVE_PART_AGREEMENT", -13);
        id2prio.put("BEEN_PART_AGREEMENT", -13);
        id2prio.put("BE_WITH_WRONG_VERB_FORM", -14);
        id2prio.put("TWO_CONNECTED_MODAL_VERBS", -15);
        id2prio.put("PRP_NO_ADVERB_VERB", -15);
        id2prio.put("MISSING_TO_BETWEEN_BE_AND_VB", -15);
        id2prio.put("IN_DT_IN", -15);
        id2prio.put("MISSING_SUBJECT", -15);
        id2prio.put("HAVE_TO_NOTVB", -15);
        id2prio.put("PLEASE_DO_NOT_THE_CAT", -15);
        id2prio.put("VB_TO_JJ", -15);
        id2prio.put("CC_PRP_ARTICLE", -15);
        id2prio.put("BE_MD", -20);
        id2prio.put("POSSESSIVE_APOSTROPHE", -10);
        id2prio.put("WANT_TO_NN", -25);
        id2prio.put("QUESTION_WITHOUT_VERB", -25);
        id2prio.put("PRP_VB", -25);
        id2prio.put("PRP_VB_NN", -25);
        id2prio.put("BE_NN", -26);
        id2prio.put("BE_VB_OR_NN", -26);
        id2prio.put("DO_DT_NN_BE", -26);
        id2prio.put("PRONOUN_NOUN", -26);
        id2prio.put("ETC_PERIOD", -49);
        id2prio.put("COULD_YOU_NOT_NEEDED", -49);
        id2prio.put("SENTENCE_FRAGMENT", -50);
        id2prio.put("SENTENCE_FRAGMENT", -51);
        id2prio.put("SEEMS_TO_BE", -51);
        id2prio.put("MD_NN", -60);
        id2prio.put("I_THINK_FEEL", -60);
        id2prio.put("KNOW_AWARE_REDO", -60);
        id2prio.put("EN_REDUNDANCY_REPLACE", -510);
        id2prio.put("EN_PLAIN_ENGLISH_REPLACE", -511);
        id2prio.put("REP_PASSIVE_VOICE", -599);
        id2prio.put("FOUR_NN", -599);
        id2prio.put("THREE_NN", -600);
        id2prio.put("SENT_START_NUM", -600);
        id2prio.put("PASSIVE_VOICE", -600);
        id2prio.put("EG_NO_COMMA", -600);
        id2prio.put("IE_NO_COMMA", -600);
        id2prio.put("REASON_WHY", -600);
        id2prio.put("TOO_LONG_SENTENCE", -997);
        id2prio.put("TOO_LONG_PARAGRAPH", -998);
        id2prio.put("ALL_UPPERCASE", -1000);
    }
}

