/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.profiler.BaseCallTreeBuilder;
import com.intellij.profiler.CallTreeBuilder;
import com.intellij.profiler.MainCallTreeNode;
import com.intellij.profiler.Stack;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.SamplesCountMetric;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.model.AllThreadsMerged;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallTreeNodeWithCompactChildren;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.model.ThreadInfoKt;
import com.intellij.profiler.model.Transformation;
import com.intellij.profiler.model.TreeNode;
import com.intellij.profiler.model.TreeNodeKt;
import com.intellij.profiler.model.TreeTransformer;
import com.intellij.profiler.model.TreeTransformerKt;
import com.intellij.profiler.model.TreeUtilKt;
import com.intellij.profiler.ui.grouping.FoldingNodesGroup;
import com.intellij.profiler.ui.grouping.ProfilerNodesGrouper;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u001cJ\u001a\u0010\u001d\u001a\u00020\u001a2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u001cJ \u0010\u001f\u001a\u00020\u001a2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000!0\u001cJ\u001a\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000$0#H\u0016J\u0016\u0010%\u001a\u00020\u001a2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0002J&\u0010'\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000)\u0018\u00010(*\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0002J*\u0010*\u001a\u00020\u001a\"\b\b\u0001\u0010+*\u00020\u0002*\b\u0012\u0004\u0012\u0002H+0\u000e2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0\u000eH\u0002J\u001c\u0010-\u001a\u00020.\"\b\b\u0001\u0010+*\u00020\u0002*\b\u0012\u0004\u0012\u0002H+0\u000eH\u0002J&\u0010/\u001a\b\u0012\u0004\u0012\u0002H+0\u000e\"\b\b\u0001\u0010+*\u00020\u00022\f\u00100\u001a\b\u0012\u0004\u0012\u0002H+0\u000eH\u0002Jj\u00101\u001a6\u0012\f\u0012\n\u0012\u0004\u0012\u0002H+\u0018\u000103\u0012\n\u0012\b\u0012\u0004\u0012\u0002H+0\u000e\u0012\f\u0012\n\u0012\u0004\u0012\u0002H4\u0018\u000103\u0012\n\u0012\b\u0012\u0004\u0012\u0002H40\u000e02\"\b\b\u0001\u0010+*\u00020\u0002\"\b\b\u0002\u00104*\u00020\u00022\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u0002H+\u0012\n\u0012\b\u0012\u0004\u0012\u0002H40!0\u001cH\u0002J\u0014\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000706H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0013\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00068"}, d2={"Lcom/intellij/profiler/BaseCallTreeBuilder;", "ElementType", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/CallTreeBuilder;", "groupers", "", "Lcom/intellij/profiler/ui/grouping/ProfilerNodesGrouper;", "<init>", "(Ljava/util/List;)V", "getGroupers", "()Ljava/util/List;", "forest", "", "Lcom/intellij/profiler/model/ThreadInfo;", "Lcom/intellij/profiler/MainCallTreeNode;", "getForest", "()Ljava/util/Map;", "isEmpty", "", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "getMetric", "()Lcom/intellij/profiler/api/ValueMetric;", "setMetric", "(Lcom/intellij/profiler/api/ValueMetric;)V", "renameThreads", "", "nameMapFunc", "Lkotlin/Function1;", "mapTreeElements", "mapFunc", "transformTreeElements", "transformer", "Lcom/intellij/profiler/model/Transformation;", "buildCallTree", "", "Lcom/intellij/profiler/model/CallTreeNode;", "groupTree", "root", "tryCreateGroup", "Lkotlin/Pair;", "Lcom/intellij/profiler/ui/grouping/FoldingNodesGroup;", "replaceWith", "T", "other", "ownValue", "", "mergeChildren", "node", "createTransformer", "Lcom/intellij/profiler/model/TreeTransformer;", "Lcom/intellij/profiler/model/CallWithValue;", "R", "getAllStacks", "", "Lcom/intellij/profiler/Stack;", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nCallTreeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallTreeBuilder.kt\ncom/intellij/profiler/BaseCallTreeBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,234:1\n1557#2:235\n1628#2,3:236\n1246#2,4:242\n1246#2,4:248\n1734#2,3:252\n1863#2,2:255\n1863#2:257\n1863#2,2:258\n1864#2:260\n1485#2:261\n1510#2,3:262\n1513#2,3:272\n1368#2:275\n1454#2,5:276\n1485#2:281\n1510#2,3:282\n1513#2,3:292\n1368#2:302\n1454#2,5:303\n1#3:239\n477#4:240\n423#4:241\n462#4:246\n412#4:247\n381#4,7:265\n381#4,7:285\n487#4,7:295\n*S KotlinDebug\n*F\n+ 1 CallTreeBuilder.kt\ncom/intellij/profiler/BaseCallTreeBuilder\n*L\n55#1:235\n55#1:236,3\n57#1:242,4\n67#1:248,4\n77#1:252,3\n81#1:255,2\n85#1:257\n87#1:258,2\n85#1:260\n138#1:261\n138#1:262,3\n138#1:272,3\n149#1:275\n149#1:276,5\n149#1:281\n149#1:282,3\n149#1:292,3\n100#1:302\n100#1:303,5\n57#1:240\n57#1:241\n67#1:246\n67#1:247\n138#1:265,7\n149#1:285,7\n177#1:295,7\n*E\n"})
public abstract class BaseCallTreeBuilder<ElementType extends BaseCallStackElement>
implements CallTreeBuilder<ElementType> {
    @NotNull
    private final List<ProfilerNodesGrouper> groupers;
    @NotNull
    private final Map<ThreadInfo, MainCallTreeNode<ElementType>> forest;
    @NotNull
    private ValueMetric metric;

    public BaseCallTreeBuilder(@NotNull List<? extends ProfilerNodesGrouper> groupers) {
        Intrinsics.checkNotNullParameter(groupers, (String)"groupers");
        this.groupers = groupers;
        this.forest = new HashMap();
        this.metric = SamplesCountMetric.INSTANCE;
    }

    public /* synthetic */ BaseCallTreeBuilder(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list);
    }

    @NotNull
    protected final List<ProfilerNodesGrouper> getGroupers() {
        return this.groupers;
    }

    @NotNull
    protected final Map<ThreadInfo, MainCallTreeNode<ElementType>> getForest() {
        return this.forest;
    }

    @Override
    public boolean isEmpty() {
        return this.forest.isEmpty();
    }

    @Override
    @NotNull
    public ValueMetric getMetric() {
        return this.metric;
    }

    public void setMetric(@NotNull ValueMetric valueMetric) {
        Intrinsics.checkNotNullParameter((Object)valueMetric, (String)"<set-?>");
        this.metric = valueMetric;
    }

    /*
     * WARNING - void declaration
     */
    public final void renameThreads(@NotNull Function1<? super ThreadInfo, ? extends ThreadInfo> nameMapFunc) {
        void $this$mapKeysTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(nameMapFunc, (String)"nameMapFunc");
        Iterable $this$map$iv = this.forest.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ThreadInfo threadInfo = (ThreadInfo)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it instanceof AllThreadsMerged ? TuplesKt.to((Object)it, (Object)it) : TuplesKt.to((Object)it, (Object)nameMapFunc.invoke((Object)it)));
        }
        Map newNames = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        if (!(CollectionsKt.toSet((Iterable)newNames.values()).size() == newNames.values().size())) {
            boolean $i$a$-require-BaseCallTreeBuilder$renameThreads$22 = false;
            String $i$a$-require-BaseCallTreeBuilder$renameThreads$22 = "Multiple old threads mapped to single new thread.";
            throw new IllegalArgumentException($i$a$-require-BaseCallTreeBuilder$renameThreads$22.toString());
        }
        Map<ThreadInfo, MainCallTreeNode<ElementType>> $this$mapKeys$iv = this.forest;
        boolean $i$f$mapKeys = false;
        destination$iv$iv = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            ThreadInfo oldName = (ThreadInfo)entry.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            ThreadInfo threadInfo = (ThreadInfo)MapsKt.getValue((Map)newNames, (Object)oldName);
            Object object2 = object;
            boolean bl2 = false;
            Object v = it$iv$iv.getValue();
            object2.put(threadInfo, v);
        }
        Map tmp = destination$iv$iv2;
        this.forest.clear();
        this.forest.putAll(tmp);
    }

    public final void mapTreeElements(@NotNull Function1<? super ElementType, ? extends ElementType> mapFunc) {
        Intrinsics.checkNotNullParameter(mapFunc, (String)"mapFunc");
        this.transformTreeElements(arg_0 -> BaseCallTreeBuilder.mapTreeElements$lambda$3(mapFunc, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final void transformTreeElements(@NotNull Function1<? super ElementType, ? extends Transformation<ElementType>> transformer2) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
        Map<ThreadInfo, MainCallTreeNode<ElementType>> $this$mapValues$iv = this.forest;
        boolean $i$f$mapValues = false;
        Map<ThreadInfo, MainCallTreeNode<ElementType>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            MainCallTreeNode tree = (MainCallTreeNode)entry2.getValue();
            MainCallTreeNode mainCallTreeNode = this.mergeChildren(TreeTransformerKt.transformTree(this.createTransformer(transformer2), (TreeNode)tree));
            map3.put(k, mainCallTreeNode);
        }
        Map tmp = destination$iv$iv;
        this.forest.clear();
        this.forest.putAll(tmp);
    }

    @Override
    @NotNull
    public Map<ThreadInfo, CallTreeNode<ElementType>> buildCallTree() {
        if (this.forest.isEmpty()) {
            return MapsKt.emptyMap();
        }
        if (!ThreadInfoKt.noThreadInfoInThreadList((Collection<? extends ThreadInfo>)this.forest.keySet())) {
            MainCallTreeNode $i$f$all2;
            boolean bl;
            Collection<MainCallTreeNode<ElementType>> forestRoots;
            block10: {
                if (!(!this.forest.keySet().contains(AllThreadsMerged.INSTANCE))) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                forestRoots = this.forest.values();
                Iterable $this$all$iv = forestRoots;
                boolean $i$f$all2 = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        MainCallTreeNode it = (MainCallTreeNode)element$iv;
                        boolean bl2 = false;
                        if (it.getParent() == null && it.getData() == null) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                String $i$f$all2 = "Failed requirement.";
                throw new IllegalArgumentException($i$f$all2.toString());
            }
            MainCallTreeNode $this$buildCallTree_u24lambda_u246 = $i$f$all2 = MainCallTreeNode.Companion.root();
            boolean bl3 = false;
            $this$buildCallTree_u24lambda_u246.addChildren(forestRoots);
            MainCallTreeNode mergedRoot = $i$f$all2;
            Iterable $this$forEach$iv = forestRoots;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                MainCallTreeNode it = (MainCallTreeNode)element$iv;
                boolean bl4 = false;
                it.setParent(null);
            }
            Object $i$f$forEach22 = CollectionsKt.single(this.mergeChildren(mergedRoot).getChildren());
            MainCallTreeNode $this$buildCallTree_u24lambda_u248 = (MainCallTreeNode)$i$f$forEach22;
            boolean bl5 = false;
            $this$buildCallTree_u24lambda_u248.setParent(null);
            MainCallTreeNode fixed = (MainCallTreeNode)$i$f$forEach22;
            this.forest.put(AllThreadsMerged.INSTANCE, fixed);
        }
        Iterable $this$forEach$iv = this.forest.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MainCallTreeNode it = (MainCallTreeNode)element$iv;
            boolean bl = false;
            this.groupTree(it);
            Iterable $this$forEach$iv2 = (Iterable)TreeUtilKt.allNodesIterable((TreeNode)it);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                MainCallTreeNode p0 = (MainCallTreeNode)element$iv2;
                boolean bl6 = false;
                p0.compactChildren();
            }
        }
        return this.forest;
    }

    private final void groupTree(MainCallTreeNode<ElementType> root) {
        Map groupsWithGroupers = new LinkedHashMap();
        JBIterable jBIterable = ((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> BaseCallTreeBuilder.groupTree$lambda$14(arg_0 -> BaseCallTreeBuilder.groupTree$lambda$13(this, groupsWithGroupers, arg_0), arg_0)).withRoot(root)).traverse(TreeTraversal.PRE_ORDER_DFS);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
        CollectionsKt.count((Iterable)((Iterable)jBIterable));
        for (Map.Entry entry : groupsWithGroupers.entrySet()) {
            ProfilerNodesGrouper grouper = (ProfilerNodesGrouper)entry.getKey();
            List groups = (List)entry.getValue();
            grouper.postprocessGroups(groups);
        }
    }

    private final Pair<ProfilerNodesGrouper, FoldingNodesGroup<ElementType>> tryCreateGroup(MainCallTreeNode<ElementType> $this$tryCreateGroup) {
        for (ProfilerNodesGrouper grouper : this.groupers) {
            FoldingNodesGroup<ElementType> group2;
            if (!grouper.isApplicable($this$tryCreateGroup) || (group2 = grouper.groupWithRootNode($this$tryCreateGroup)) == null || !ProfilerNodesGrouper.Companion.validateGroup(group2)) continue;
            return TuplesKt.to((Object)grouper, group2);
        }
        return null;
    }

    private final <T extends BaseCallStackElement> void replaceWith(MainCallTreeNode<T> $this$replaceWith, MainCallTreeNode<T> other) {
        CallTreeNodeWithCompactChildren callTreeNodeWithCompactChildren = $this$replaceWith.getParent();
        if (callTreeNodeWithCompactChildren != null) {
            callTreeNodeWithCompactChildren.replaceChild((CallTreeNodeWithCompactChildren)$this$replaceWith, (CallTreeNodeWithCompactChildren)other);
        }
        other.setParent((MainCallTreeNode<T>)$this$replaceWith.getParent());
        for (MainCallTreeNode child : $this$replaceWith.getChildren()) {
            child.setParent(other);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends BaseCallStackElement> long ownValue(MainCallTreeNode<T> $this$ownValue) {
        long l;
        Iterable iterable = $this$ownValue.getChildren();
        long l2 = $this$ownValue.getValue();
        long l3 = 0L;
        for (Object t : iterable) {
            void it;
            MainCallTreeNode mainCallTreeNode = (MainCallTreeNode)t;
            l = l3;
            boolean bl = false;
            long l4 = it.getValue();
            l3 = l + l4;
        }
        l = l3;
        return l2 - l;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends BaseCallStackElement> MainCallTreeNode<T> mergeChildren(MainCallTreeNode<T> node) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        if (!(node.getParent() == null && node.getData() == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        MainCallTreeNode newRoot = new MainCallTreeNode((BaseCallStackElement)node.getCallOrNull$intellij_profiler_common(), node.getValue(), node.getDepth(), null, 8, null);
        Object[] objectArray = new StackFrame[1];
        Iterable iterable = node.getChildren();
        int n = 0;
        Object object = newRoot;
        int n2 = 0;
        Object[] objectArray2 = objectArray;
        int $i$f$groupBy = 0;
        Iterable iterable2 = $this$groupBy$iv;
        Object destination$iv$iv22 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            MainCallTreeNode it = (MainCallTreeNode)element$iv$iv;
            boolean bl = false;
            Object key$iv$iv = it.getCallOrNull$intellij_profiler_common();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv22;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv2 = (List)object2;
            list$iv$iv2.add(element$iv$iv);
        }
        Map map = destination$iv$iv22;
        List list = CollectionsKt.toList((Iterable)map.values());
        int n3 = n;
        MainCallTreeNode mainCallTreeNode = object;
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000-\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00070\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001b\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00070\u0007H\u00c6\u0003JD\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00070\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"com/intellij/profiler/BaseCallTreeBuilder$mergeChildren$StackFrame", "", "node", "Lcom/intellij/profiler/MainCallTreeNode;", "nextGroupedChild", "", "groupedOriginal", "", "<init>", "(Lcom/intellij/profiler/MainCallTreeNode;ILjava/util/List;)V", "getNode", "()Lcom/intellij/profiler/MainCallTreeNode;", "getNextGroupedChild", "()I", "setNextGroupedChild", "(I)V", "getGroupedOriginal", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "(Lcom/intellij/profiler/MainCallTreeNode;ILjava/util/List;)Lcom/intellij/profiler/BaseCallTreeBuilder$mergeChildren$StackFrame;", "equals", "", "other", "hashCode", "toString", "", "intellij.profiler.common"})
        public final class StackFrame {
            private final MainCallTreeNode<T> node;
            private int nextGroupedChild;
            private final List<List<MainCallTreeNode<T>>> groupedOriginal;

            public StackFrame(MainCallTreeNode<T> node, int nextGroupedChild, List<? extends List<? extends MainCallTreeNode<T>>> groupedOriginal) {
                Intrinsics.checkNotNullParameter(node, (String)"node");
                Intrinsics.checkNotNullParameter(groupedOriginal, (String)"groupedOriginal");
                this.node = node;
                this.nextGroupedChild = nextGroupedChild;
                this.groupedOriginal = groupedOriginal;
            }

            public final MainCallTreeNode<T> getNode() {
                return this.node;
            }

            public final int getNextGroupedChild() {
                return this.nextGroupedChild;
            }

            public final void setNextGroupedChild(int n) {
                this.nextGroupedChild = n;
            }

            public final List<List<MainCallTreeNode<T>>> getGroupedOriginal() {
                return this.groupedOriginal;
            }

            public final MainCallTreeNode<T> component1() {
                return this.node;
            }

            public final int component2() {
                return this.nextGroupedChild;
            }

            public final List<List<MainCallTreeNode<T>>> component3() {
                return this.groupedOriginal;
            }

            public final StackFrame copy(MainCallTreeNode<T> node, int nextGroupedChild, List<? extends List<? extends MainCallTreeNode<T>>> groupedOriginal) {
                Intrinsics.checkNotNullParameter(node, (String)"node");
                Intrinsics.checkNotNullParameter(groupedOriginal, (String)"groupedOriginal");
                return new StackFrame(node, nextGroupedChild, groupedOriginal);
            }

            public static /* synthetic */ StackFrame copy$default(StackFrame stackFrame, MainCallTreeNode mainCallTreeNode, int n, List list, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    mainCallTreeNode = stackFrame.node;
                }
                if ((n2 & 2) != 0) {
                    n = stackFrame.nextGroupedChild;
                }
                if ((n2 & 4) != 0) {
                    list = stackFrame.groupedOriginal;
                }
                return stackFrame.copy(mainCallTreeNode, n, list);
            }

            public String toString() {
                return "StackFrame(node=" + this.node + ", nextGroupedChild=" + this.nextGroupedChild + ", groupedOriginal=" + this.groupedOriginal + ")";
            }

            public int hashCode() {
                int result2 = this.node.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.nextGroupedChild);
                result2 = result2 * 31 + ((Object)this.groupedOriginal).hashCode();
                return result2;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StackFrame)) {
                    return false;
                }
                StackFrame stackFrame = (StackFrame)other;
                if (!Intrinsics.areEqual(this.node, stackFrame.node)) {
                    return false;
                }
                if (this.nextGroupedChild != stackFrame.nextGroupedChild) {
                    return false;
                }
                return Intrinsics.areEqual(this.groupedOriginal, stackFrame.groupedOriginal);
            }
        }
        objectArray2[n2] = new StackFrame(mainCallTreeNode, n3, list);
        List stack = CollectionsKt.mutableListOf((Object[])objectArray);
        while (!((Collection)stack).isEmpty()) {
            void $this$groupByTo$iv$iv2;
            void $this$groupBy$iv2;
            Iterable list$iv$iv;
            MainCallTreeNode it;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            long l;
            StackFrame top = (StackFrame)CollectionsKt.last((List)stack);
            if (top.getNextGroupedChild() > CollectionsKt.getLastIndex(top.getGroupedOriginal())) {
                top.getNode().compactChildren();
                stack.remove(CollectionsKt.getLastIndex((List)stack));
                continue;
            }
            List group2 = top.getGroupedOriginal().get(top.getNextGroupedChild());
            $i$f$groupBy = top.getNextGroupedChild();
            top.setNextGroupedChild($i$f$groupBy + 1);
            iterable2 = group2;
            Object object3 = ((MainCallTreeNode)CollectionsKt.first(group2)).getCallOrNull$intellij_profiler_common();
            long destination$iv$iv22 = 0L;
            for (Object element$iv$iv : iterable2) {
                void it2;
                MainCallTreeNode list$iv$iv2 = (MainCallTreeNode)element$iv$iv;
                l = destination$iv$iv22;
                boolean bl = false;
                long l2 = it2.getValue();
                destination$iv$iv22 = l + l2;
            }
            l = destination$iv$iv22;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n4 = 8;
            MainCallTreeNode mainCallTreeNode2 = null;
            int n5 = ((MainCallTreeNode)CollectionsKt.first(group2)).getDepth();
            long l3 = l;
            Object ElementType = object3;
            MainCallTreeNode child = new MainCallTreeNode((BaseCallStackElement)ElementType, l3, n5, mainCallTreeNode2, n4, defaultConstructorMarker);
            iterable2 = stack;
            destination$iv$iv22 = group2;
            int n6 = 0;
            object3 = child;
            boolean $i$f$flatMap = false;
            Iterator iterator2 = $this$flatMap$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (MainCallTreeNode)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.getChildren();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            object = (List)destination$iv$iv;
            $this$flatMap$iv = (Iterable)object;
            boolean $i$f$groupBy2 = false;
            $this$flatMapTo$iv$iv = $this$groupBy$iv2;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                Object object4;
                it = (MainCallTreeNode)element$iv$iv;
                boolean bl = false;
                Object key$iv$iv = it.getCallOrNull$intellij_profiler_common();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object4 = answer$iv$iv$iv;
                } else {
                    object4 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object4;
                list$iv$iv.add(element$iv$iv);
            }
            object = destination$iv$iv;
            List list2 = CollectionsKt.toList((Iterable)object.values());
            int n7 = n6;
            Object object5 = object3;
            iterable2.add(new StackFrame(object5, n7, list2));
            top.getNode().addChild((CallTreeNodeWithCompactChildren)child);
        }
        return newRoot;
    }

    private final <T extends BaseCallStackElement, R extends BaseCallStackElement> TreeTransformer<CallWithValue<T>, MainCallTreeNode<T>, CallWithValue<R>, MainCallTreeNode<R>> createTransformer(Function1<? super T, ? extends Transformation<R>> transformer2) {
        return new TreeTransformer<CallWithValue<? extends T>, MainCallTreeNode<T>, CallWithValue<? extends R>, MainCallTreeNode<R>>(transformer2){
            final /* synthetic */ Function1<T, Transformation<R>> $transformer;
            {
                this.$transformer = $transformer;
            }

            public boolean preConditionChecker(MainCallTreeNode<T> node) {
                Intrinsics.checkNotNullParameter(node, (String)"node");
                return node.getParent() == null && node.getDepth() == 0;
            }

            public List<MainCallTreeNode<T>> children(MainCallTreeNode<T> node) {
                Intrinsics.checkNotNullParameter(node, (String)"node");
                return node.getChildren();
            }

            /*
             * WARNING - void declaration
             */
            public Transformation<MainCallTreeNode<R>> transform(MainCallTreeNode<T> node) {
                void $this$mapIndexedTo$iv$iv;
                Intrinsics.checkNotNullParameter(node, (String)"node");
                if (node.getCallOrNull$intellij_profiler_common() == null) {
                    return new Transformation.Single<MainCallTreeNode<ElementType>>(new MainCallTreeNode<ElementType>(null, node.getValue(), node.getDepth(), null, 8, null));
                }
                Iterable $this$mapIndexed$iv = ((Transformation)this.$transformer.invoke(node.getCallOrNull$intellij_profiler_common())).getList();
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void i;
                    void r;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    BaseCallStackElement baseCallStackElement = (BaseCallStackElement)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new MainCallTreeNode<ElementType>((BaseCallStackElement)r, node.getValue(), node.getDepth() + i, null, 8, null));
                }
                List treeNodes = (List)destination$iv$iv;
                return new Transformation.ListOf<ResultType>(treeNodes);
            }

            public void postProcess(MainCallTreeNode<R> alreadyMappedParent, MainCallTreeNode<R> node) {
                Intrinsics.checkNotNullParameter(alreadyMappedParent, (String)"alreadyMappedParent");
                Intrinsics.checkNotNullParameter(node, (String)"node");
                alreadyMappedParent.addChild((CallTreeNodeWithCompactChildren)node);
            }
        };
    }

    @Override
    @NotNull
    public Iterable<Stack<ElementType>> getAllStacks() {
        Map<ThreadInfo, MainCallTreeNode<ElementType>> $this$filterKeys$iv = this.forest;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<ThreadInfo, MainCallTreeNode<ElementType>> result$iv = new LinkedHashMap<ThreadInfo, MainCallTreeNode<ElementType>>();
        for (Map.Entry<ThreadInfo, MainCallTreeNode<ElementType>> entry$iv : $this$filterKeys$iv.entrySet()) {
            ThreadInfo it = entry$iv.getKey();
            boolean bl = false;
            if (!(it != AllThreadsMerged.INSTANCE)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        JBIterable jBIterable = JBIterable.from((Iterable)((Map)result$iv).entrySet()).flatMap(arg_0 -> BaseCallTreeBuilder.getAllStacks$lambda$30(arg_0 -> BaseCallTreeBuilder.getAllStacks$lambda$29(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"flatMap(...)");
        return (Iterable)jBIterable;
    }

    private static final Transformation mapTreeElements$lambda$3(Function1 $mapFunc, BaseCallStackElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Transformation.Single<Object>($mapFunc.invoke((Object)it));
    }

    private static final List groupTree$lambda$13$lambda$10(ProfilerNodesGrouper it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List groupTree$lambda$13$lambda$11(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable groupTree$lambda$13(BaseCallTreeBuilder this$0, Map $groupsWithGroupers, MainCallTreeNode node) {
        Iterable iterable;
        Intrinsics.checkNotNull((Object)node);
        Pair result2 = this$0.tryCreateGroup(node);
        if (result2 != null) {
            void $this$flatMapTo$iv$iv;
            ProfilerNodesGrouper grouper = (ProfilerNodesGrouper)result2.component1();
            FoldingNodesGroup group2 = (FoldingNodesGroup)result2.component2();
            this$0.replaceWith(node, group2);
            $groupsWithGroupers.computeIfAbsent(grouper, arg_0 -> BaseCallTreeBuilder.groupTree$lambda$13$lambda$11(BaseCallTreeBuilder::groupTree$lambda$13$lambda$10, arg_0)).add(group2);
            Iterable $this$flatMap$iv = group2.getGroupEnd();
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                MainCallTreeNode it = (MainCallTreeNode)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getChildren();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            iterable = (List)destination$iv$iv;
        } else {
            iterable = node.getChildren();
        }
        return iterable;
    }

    private static final Iterable groupTree$lambda$14(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final Pair getAllStacks$lambda$29$lambda$21(BaseCallTreeBuilder this$0, MainCallTreeNode it) {
        Intrinsics.checkNotNull((Object)it);
        return TuplesKt.to((Object)it, (Object)this$0.ownValue(it));
    }

    private static final Pair getAllStacks$lambda$29$lambda$22(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }

    private static final boolean getAllStacks$lambda$29$lambda$23(Pair it) {
        return ((Number)it.getSecond()).longValue() > 0L;
    }

    private static final boolean getAllStacks$lambda$29$lambda$24(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BaseCallStackElement getAllStacks$lambda$29$lambda$27$lambda$25(MainCallTreeNode it) {
        return it.getCallOrNull$intellij_profiler_common();
    }

    private static final BaseCallStackElement getAllStacks$lambda$29$lambda$27$lambda$26(Function1 $tmp0, Object p0) {
        return (BaseCallStackElement)$tmp0.invoke(p0);
    }

    private static final Stack getAllStacks$lambda$29$lambda$27(ThreadInfo $thread, Pair pair) {
        MainCallTreeNode n = (MainCallTreeNode)pair.component1();
        long ownValue = ((Number)pair.component2()).longValue();
        JBIterable jBIterable = TreeNodeKt.parentsIterable$default(n, false, 1, null).map(arg_0 -> BaseCallTreeBuilder.getAllStacks$lambda$29$lambda$27$lambda$26(BaseCallTreeBuilder::getAllStacks$lambda$29$lambda$27$lambda$25, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
        return new Stack($thread, CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)CollectionsKt.reversed((Iterable)((Iterable)jBIterable)), n.getCallOrNull$intellij_profiler_common())), ownValue);
    }

    private static final Stack getAllStacks$lambda$29$lambda$28(Function1 $tmp0, Object p0) {
        return (Stack)$tmp0.invoke(p0);
    }

    private static final Iterable getAllStacks$lambda$29(BaseCallTreeBuilder this$0, Map.Entry entry) {
        Intrinsics.checkNotNull((Object)entry);
        ThreadInfo thread = (ThreadInfo)entry.getKey();
        MainCallTreeNode tree = (MainCallTreeNode)entry.getValue();
        return (Iterable)TreeUtilKt.allNodesIterable((TreeNode)tree).map(arg_0 -> BaseCallTreeBuilder.getAllStacks$lambda$29$lambda$22(arg_0 -> BaseCallTreeBuilder.getAllStacks$lambda$29$lambda$21(this$0, arg_0), arg_0)).filter(arg_0 -> BaseCallTreeBuilder.getAllStacks$lambda$29$lambda$24(BaseCallTreeBuilder::getAllStacks$lambda$29$lambda$23, arg_0)).map(arg_0 -> BaseCallTreeBuilder.getAllStacks$lambda$29$lambda$28(arg_0 -> BaseCallTreeBuilder.getAllStacks$lambda$29$lambda$27(thread, arg_0), arg_0));
    }

    private static final Iterable getAllStacks$lambda$30(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    public BaseCallTreeBuilder() {
        this(null, 1, null);
    }
}

