/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.console.RemoteDataProducer;
import com.jetbrains.plugins.remotesdk.console.SshConsoleOptionsProvider;
import com.jetbrains.plugins.remotesdk.console.SshTerminalCachingRunner;
import com.jetbrains.plugins.remotesdk.console.SshTerminalRunnerFactory;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

public class RunSshConsoleAction
extends AnAction
implements DumbAware {
    private static final Logger LOGGER = Logger.getInstance(RunSshConsoleAction.class);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RunSshConsoleAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunSshConsoleAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            RunSshConsoleAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)event.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        SshConsoleOptionsProvider optionsProvider = SshConsoleOptionsProvider.getInstance(project);
        RemoteConnector contextConnector = this.getContextRemoteConnector(event);
        if (contextConnector != null) {
            this.connectToSsh(project, optionsProvider, contextConnector);
        } else {
            new RemoteDataProducer().withActionEvent(event).withShowProjectLevelServers(true).selectRemoteConnector(optionsProvider.getConnectionType(), optionsProvider.getConnectionId(), optionsProvider.getAdditionalData(), connector -> this.connectToSsh(project, optionsProvider, (RemoteConnector)connector));
        }
    }

    @RequiresEdt
    private void connectToSsh(@NotNull Project project, @NotNull SshConsoleOptionsProvider optionsProvider, @NotNull RemoteConnector connector) {
        if (project == null) {
            RunSshConsoleAction.$$$reportNull$$$0(3);
        }
        if (optionsProvider == null) {
            RunSshConsoleAction.$$$reportNull$$$0(4);
        }
        if (connector == null) {
            RunSshConsoleAction.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
        RunSshConsoleAction.connectToSsh(project, connector, credentials -> this.getRunner(project, optionsProvider, (RemoteCredentials)credentials));
    }

    public static void connectToSsh(@NotNull Project project, @NotNull RemoteConnector connector, @NotNull Function<RemoteCredentials, SshTerminalCachingRunner> runnerFactory) {
        if (project == null) {
            RunSshConsoleAction.$$$reportNull$$$0(6);
        }
        if (connector == null) {
            RunSshConsoleAction.$$$reportNull$$$0(7);
        }
        if (runnerFactory == null) {
            RunSshConsoleAction.$$$reportNull$$$0(8);
        }
        RemoteDataProducer.produceRemoteCredentials(project, connector, credentials -> {
            if (credentials != null) {
                SshTerminalCachingRunner runner = (SshTerminalCachingRunner)((Object)((Object)runnerFactory.apply((RemoteCredentials)credentials)));
                runner.useConnectorPresentableName(connector);
                RunSshConsoleAction.connectToSshUnderProgress(project, runner, credentials);
            }
        });
    }

    @NotNull
    protected SshTerminalCachingRunner getRunner(Project project, SshConsoleOptionsProvider optionsProvider, RemoteCredentials data) {
        SshTerminalCachingRunner sshTerminalCachingRunner = SshTerminalRunnerFactory.getInstance(project).createRunner(optionsProvider, data);
        if (sshTerminalCachingRunner == null) {
            RunSshConsoleAction.$$$reportNull$$$0(9);
        }
        return sshTerminalCachingRunner;
    }

    @Nullable
    protected RemoteConnector getContextRemoteConnector(@NotNull AnActionEvent event) {
        if (event == null) {
            RunSshConsoleAction.$$$reportNull$$$0(10);
        }
        return null;
    }

    public static void connectToSshUnderProgress(final @NotNull Project project, final @NotNull SshTerminalCachingRunner runner, final @NotNull RemoteCredentials data) {
        if (project == null) {
            RunSshConsoleAction.$$$reportNull$$$0(11);
        }
        if (runner == null) {
            RunSshConsoleAction.$$$reportNull$$$0(12);
        }
        if (data == null) {
            RunSshConsoleAction.$$$reportNull$$$0(13);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, RemoteSdkBundle.message("progress.title.connecting.to", runner.getDefaultTabTitle()), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                RunSshConsoleAction.createTerminalSession(indicator, runner, data, project, this.getTitle());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/console/RunSshConsoleAction$1", "run"));
            }
        });
    }

    private static void createTerminalSession(@NotNull ProgressIndicator indicator, SshTerminalCachingRunner runner, RemoteCredentials data, Project project, @NlsContexts.DialogTitle String title) {
        block3: {
            if (indicator == null) {
                RunSshConsoleAction.$$$reportNull$$$0(14);
            }
            try {
                runner.connect();
                AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> TerminalToolWindowManager.getInstance((Project)project).createNewSession((AbstractTerminalRunner)runner));
            }
            catch (RemoteSdkException e) {
                if (indicator.isCanceled()) break block3;
                LOGGER.warn("unable to get session for " + String.valueOf(data), (Throwable)e);
                AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)title));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/console/RunSshConsoleAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsProvider";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connector";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerFactory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/console/RunSshConsoleAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "connectToSsh";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContextRemoteConnector";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "connectToSshUnderProgress";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalSession";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }
}

