/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.ssh.target;

import com.intellij.execution.Platform;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\"\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshVolumeBase;", "Lcom/intellij/execution/target/TargetEnvironment$Volume;", "platform", "Lcom/intellij/execution/Platform;", "localRoot", "Ljava/nio/file/Path;", "targetRoot", "", "<init>", "(Lcom/intellij/execution/Platform;Ljava/nio/file/Path;Ljava/lang/String;)V", "getPlatform", "()Lcom/intellij/execution/Platform;", "getLocalRoot", "()Ljava/nio/file/Path;", "getTargetRoot", "()Ljava/lang/String;", "resolveTargetPath", "relativePath", "intellij.remoteRun"})
abstract class SshVolumeBase
implements TargetEnvironment.Volume {
    @NotNull
    private final Platform platform;
    @NotNull
    private final Path localRoot;
    @NotNull
    private final String targetRoot;

    public SshVolumeBase(@NotNull Platform platform, @NotNull Path localRoot, @NotNull String targetRoot) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
        Intrinsics.checkNotNullParameter((Object)targetRoot, (String)"targetRoot");
        this.platform = platform;
        this.localRoot = localRoot;
        this.targetRoot = targetRoot;
    }

    @NotNull
    protected final Platform getPlatform() {
        return this.platform;
    }

    @NotNull
    public Path getLocalRoot() {
        return this.localRoot;
    }

    @NotNull
    public String getTargetRoot() {
        return this.targetRoot;
    }

    @NotNull
    public String resolveTargetPath(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String string = FileUtil.toCanonicalPath((String)StringsKt.replace$default((String)(this.getTargetRoot() + this.platform.fileSeparator + relativePath), (char)File.separatorChar, (char)this.platform.fileSeparator, (boolean)false, (int)4, null), (char)this.platform.fileSeparator);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toCanonicalPath(...)");
        return string;
    }
}

