/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.prettierjs.ReformatWithPrettierAction;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public final class PrettierPostFormatProcessor
implements PostFormatProcessor {
    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = source;
        if (psiElement == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile psiFile, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (psiFile == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(3);
        }
        if (rangeToReformat == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(5);
        }
        if (PrettierPostFormatProcessor.isApplicable(psiFile)) {
            TextRange extendedRange = PrettierPostFormatProcessor.extendRange(psiFile, rangeToReformat);
            TextRange textRange = ReformatWithPrettierAction.processFileAsPostFormatProcessor(psiFile, extendedRange);
            if (textRange == null) {
                PrettierPostFormatProcessor.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        TextRange textRange = rangeToReformat;
        if (textRange == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    private static boolean isApplicable(@NotNull PsiFile psiFile) {
        Template template;
        Project project;
        PrettierConfiguration configuration;
        if (psiFile == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(8);
        }
        if (!(configuration = PrettierConfiguration.getInstance(project = psiFile.getProject())).isRunOnReformat()) {
            return false;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return false;
        }
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file);
        if (fileEditor instanceof TextEditor && (template = TemplateManager.getInstance((Project)psiFile.getProject()).getActiveTemplate(((TextEditor)fileEditor).getEditor())) != null) {
            return false;
        }
        return PrettierUtil.isFormattingAllowedForFile(project, file);
    }

    @NotNull
    private static TextRange extendRange(@NotNull PsiFile file, @NotNull TextRange rangeToReformat) {
        TextRange parentRange;
        PsiElement commonParent;
        if (file == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(9);
        }
        if (rangeToReformat == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(10);
        }
        PsiElement end = file.findElementAt(rangeToReformat.getEndOffset() - 1);
        PsiElement start = file.findElementAt(rangeToReformat.getStartOffset());
        if (start == null || end == null) {
            TextRange textRange = rangeToReformat;
            if (textRange == null) {
                PrettierPostFormatProcessor.$$$reportNull$$$0(11);
            }
            return textRange;
        }
        if (!(rangeToReformat.getStartOffset() == 0 && rangeToReformat.getEndOffset() == file.getTextRange().getEndOffset() || !((commonParent = PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)end)) instanceof JSBlockStatement) || rangeToReformat.contains(parentRange = commonParent.getTextRange()) || rangeToReformat.getStartOffset() != parentRange.getStartOffset() && rangeToReformat.getEndOffset() != parentRange.getEndOffset())) {
            TextRange textRange = parentRange;
            if (textRange == null) {
                PrettierPostFormatProcessor.$$$reportNull$$$0(12);
            }
            return textRange;
        }
        if (end instanceof PsiWhiteSpace || end instanceof PsiComment) {
            PsiElement maybeComment = end;
            PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)end, (boolean)true);
            while (prev instanceof PsiWhiteSpace || prev instanceof PsiComment) {
                if (prev instanceof PsiComment) {
                    maybeComment = prev;
                }
                prev = PsiTreeUtil.prevLeaf((PsiElement)prev, (boolean)true);
            }
            if (maybeComment instanceof PsiComment) {
                TextRange textRange = TextRange.create((int)rangeToReformat.getStartOffset(), (int)maybeComment.getTextRange().getStartOffset());
                if (textRange == null) {
                    PrettierPostFormatProcessor.$$$reportNull$$$0(13);
                }
                return textRange;
            }
        }
        TextRange textRange = rangeToReformat;
        if (textRange == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(14);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/prettierjs/PrettierPostFormatProcessor";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/prettierjs/PrettierPostFormatProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extendRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extendRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

