/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.psi.css.descriptor.CssElementDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssPropertyInfo {
    public static final CssPropertyInfo[] EMPTY_ARRAY = new CssPropertyInfo[0];
    @NonNls
    public static final String INITIAL_VALUE_ATTRIBUTE = "initialValue";
    @NonNls
    public static final String APPLIES_TO_ATTRIBUTE = "appliesTo";
    @NonNls
    public static final String INHERITED_ATTRIBUTE = "inherited";
    @NonNls
    public static final String PERCENTAGE_ATTRIBUTE = "percentage";
    @NonNls
    public static final String MEDIA_GROUP_ATTRIBUTE = "mediaGroup";
    @NonNls
    public static final String HELP_REF_ATTRIBUTE = "helpRef";
    private final Map<String, String> myAttributeMap;
    private final CssElementDescriptor.CssVersion myVersion;

    public CssPropertyInfo(@NotNull Element e, @NotNull CssElementDescriptor.CssVersion version) {
        if (e == null) {
            CssPropertyInfo.$$$reportNull$$$0(0);
        }
        if (version == null) {
            CssPropertyInfo.$$$reportNull$$$0(1);
        }
        this.myAttributeMap = new HashMap<String, String>();
        this.addAttributes(e, INITIAL_VALUE_ATTRIBUTE, APPLIES_TO_ATTRIBUTE, INHERITED_ATTRIBUTE, PERCENTAGE_ATTRIBUTE, MEDIA_GROUP_ATTRIBUTE, HELP_REF_ATTRIBUTE);
        this.myVersion = version;
    }

    private void addAttributes(@NotNull Element element, String ... names) {
        if (element == null) {
            CssPropertyInfo.$$$reportNull$$$0(2);
        }
        if (names == null) {
            CssPropertyInfo.$$$reportNull$$$0(3);
        }
        for (String name : names) {
            String attributeValue = element.getAttributeValue(name);
            if (attributeValue == null) continue;
            this.myAttributeMap.put(name, attributeValue);
        }
    }

    @Nullable
    public String getAttributeValue(@NotNull String attributeName) {
        if (attributeName == null) {
            CssPropertyInfo.$$$reportNull$$$0(4);
        }
        return this.myAttributeMap.get(attributeName);
    }

    public String getInherited() {
        return this.myAttributeMap.get(INHERITED_ATTRIBUTE);
    }

    public String getHelpRef() {
        return this.myAttributeMap.get(HELP_REF_ATTRIBUTE);
    }

    @NotNull
    public CssElementDescriptor.CssVersion getVersion() {
        CssElementDescriptor.CssVersion cssVersion = this.myVersion;
        if (cssVersion == null) {
            CssPropertyInfo.$$$reportNull$$$0(5);
        }
        return cssVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/CssPropertyInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/CssPropertyInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

