/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssOneLineStatement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssStubElementTypes;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CssBlockImpl
extends LazyParseablePsiElement
implements CssBlock {
    private static final Hash.Strategy<CssDeclaration> ourStrategy = new Hash.Strategy<CssDeclaration>(){

        public int hashCode(CssDeclaration object) {
            return object == null ? 0 : object.equalityHashCode();
        }

        public boolean equals(CssDeclaration o1, CssDeclaration o2) {
            return o1 == o2 || o1 != null && o2 != null && o1.isEqualTo(o2);
        }
    };

    CssBlockImpl(CharSequence text) {
        this(text, (IElementType)CssElementTypes.CSS_DECLARATION_BLOCK);
    }

    CssBlockImpl(CharSequence text, IElementType type) {
        super(type, text);
    }

    @Override
    public CssRuleset @NotNull [] getRulesets() {
        CssRuleset[] cssRulesetArray = (CssRuleset[])this.getChildrenAsPsiElements((IElementType)CssStubElementTypes.CSS_RULESET, CssRuleset.ARRAY_FACTORY);
        if (cssRulesetArray == null) {
            CssBlockImpl.$$$reportNull$$$0(0);
        }
        return cssRulesetArray;
    }

    @Override
    public CssDeclaration @NotNull [] getDeclarations() {
        CssDeclaration[] cssDeclarationArray = (CssDeclaration[])this.getChildrenAsPsiElements((IElementType)CssStubElementTypes.CSS_DECLARATION, CssDeclaration.ARRAY_FACTORY);
        if (cssDeclarationArray == null) {
            CssBlockImpl.$$$reportNull$$$0(1);
        }
        return cssDeclarationArray;
    }

    @NotNull
    public Language getLanguage() {
        Language language = CssElement.getLanguageOf(this);
        if (language == null) {
            CssBlockImpl.$$$reportNull$$$0(2);
        }
        return language;
    }

    @Override
    public boolean isEqualTo(Object object) {
        if (!(object instanceof CssBlockImpl)) {
            return false;
        }
        CssBlockImpl block = (CssBlockImpl)object;
        Set<CssDeclaration> set1 = CssBlockImpl.getDeclarationsHashSet(this);
        Set<CssDeclaration> set2 = CssBlockImpl.getDeclarationsHashSet(block);
        return set1.equals(set2);
    }

    @Override
    @Nullable
    public PsiElement getLBrace() {
        ASTNode node;
        PsiElement firstChild = PsiTreeUtil.getDeepestFirst((PsiElement)this);
        if (firstChild instanceof PsiWhiteSpace) {
            firstChild = PsiTreeUtil.nextVisibleLeaf((PsiElement)firstChild);
        }
        if (firstChild != null && (node = firstChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_LBRACE) {
            return firstChild;
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement getRBrace() {
        ASTNode node;
        PsiElement lastChild = PsiTreeUtil.getDeepestLast((PsiElement)this);
        if (lastChild instanceof PsiWhiteSpace) {
            lastChild = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastChild);
        }
        if (lastChild != null && (node = lastChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_RBRACE) {
            return lastChild;
        }
        return null;
    }

    private static Set<CssDeclaration> getDeclarationsHashSet(CssBlockImpl block) {
        return new ObjectOpenCustomHashSet((Object[])block.getDeclarations(), ourStrategy);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            CssBlockImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssBlock(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public CssDeclaration addDeclaration(@NotNull String name, @NotNull String value, @Nullable CssDeclaration declarationAnchor) throws IncorrectOperationException {
        IElementType type;
        ASTNode astNode;
        if (name == null) {
            CssBlockImpl.$$$reportNull$$$0(4);
        }
        if (value == null) {
            CssBlockImpl.$$$reportNull$$$0(5);
        }
        CssOneLineStatement anchor = declarationAnchor;
        assert (anchor == null || anchor.getParent() == this);
        Project project = this.getProject();
        CssElementFactory factory = CssElementFactory.getInstance(project);
        CssDeclaration cssDeclaration = factory.createProperty(name, value, CssPsiUtil.getStylesheetLanguage(this));
        PsiElement semicolon = cssDeclaration.getNextSibling();
        if (semicolon != null && semicolon.getNode().getElementType() != CssElementTypes.CSS_SEMICOLON) {
            semicolon = null;
        }
        if (anchor != null) {
            anchor = CssUtil.appendStatementWithSemicolonIfNeeded(project, anchor);
        }
        PsiElement nextSibling = anchor != null ? PsiTreeUtil.nextVisibleLeaf((PsiElement)anchor) : null;
        PsiElement _anchor = nextSibling == null ? this.getFirstVisibleChild() : nextSibling;
        ASTNode aSTNode = astNode = _anchor != null ? _anchor.getNode() : null;
        if (astNode != null && (type = astNode.getElementType()) != CssElementTypes.CSS_SEMICOLON && anchor != null) {
            _anchor = anchor;
        }
        if (anchor != null && _anchor != null) {
            nextSibling = PsiTreeUtil.nextLeaf((PsiElement)_anchor);
            boolean containsNewLine = false;
            while (nextSibling != null && !containsNewLine) {
                boolean isComment = nextSibling instanceof PsiComment;
                boolean isWhiteSpace = nextSibling instanceof PsiWhiteSpace;
                if (!isComment && !isWhiteSpace) break;
                containsNewLine = StringUtil.containsChar((String)nextSibling.getText(), (char)'\n');
                if (containsNewLine && !isComment) continue;
                _anchor = nextSibling;
                nextSibling = PsiTreeUtil.nextLeaf((PsiElement)nextSibling);
            }
        }
        return (CssDeclaration)(semicolon != null ? this.addRangeAfter(cssDeclaration, semicolon, _anchor) : this.addAfter(cssDeclaration, _anchor));
    }

    @Nullable
    private PsiElement getFirstVisibleChild() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild != null) {
            return StringUtil.isEmptyOrSpaces((String)firstChild.getText()) ? PsiTreeUtil.nextVisibleLeaf((PsiElement)firstChild) : firstChild;
        }
        return null;
    }

    @Override
    public void removeDeclaration(@NotNull CssDeclaration declaration) throws IncorrectOperationException {
        PsiElement nextSibling;
        if (declaration == null) {
            CssBlockImpl.$$$reportNull$$$0(6);
        }
        if ((nextSibling = declaration.getNextSibling()) != null) {
            ASTNode astNode1;
            PsiElement nextNextSibling;
            ASTNode astNode = nextSibling.getNode();
            if (!(astNode == null || astNode.getElementType() != CssElementTypes.CSS_WHITE_SPACE && astNode.getElementType() != CssElementTypes.CSS_SEMICOLON || (nextNextSibling = nextSibling.getNextSibling()) == null || (astNode1 = nextNextSibling.getNode()) == null || CssElementTypes.CSS_SEMICOLON != astNode1.getElementType() && CssElementTypes.CSS_WHITE_SPACE != astNode1.getElementType())) {
                nextSibling = nextNextSibling;
            }
            if ((astNode = nextSibling.getNode()) != null && (astNode.getElementType() == CssElementTypes.CSS_SEMICOLON || astNode.getElementType() == CssElementTypes.CSS_WHITE_SPACE)) {
                this.deleteChildRange(declaration, nextSibling);
            } else {
                this.deleteChildRange(declaration, declaration);
            }
        }
    }

    @Override
    @Nullable
    public CssDeclaration findDeclaration(@NotNull String propertyName) {
        if (propertyName == null) {
            CssBlockImpl.$$$reportNull$$$0(7);
        }
        return this.findDeclaration(propertyName, true);
    }

    @Override
    @Nullable
    public CssDeclaration findDeclaration(@NotNull String propertyName, boolean searchInShorthand) {
        if (propertyName == null) {
            CssBlockImpl.$$$reportNull$$$0(8);
        }
        return CssPsiUtil.findDeclaration(this, propertyName, searchInShorthand);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssBlockImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRulesets";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssBlockImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeDeclaration";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

