/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.frontend.changes.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.platform.vcs.impl.frontend.changes.ChangeList;
import com.intellij.platform.vcs.impl.frontend.changes.ChangeListKt;
import com.intellij.platform.vcs.impl.frontend.shelf.ShelfService;
import com.intellij.platform.vcs.impl.frontend.shelf.tree.ShelfTree;
import com.intellij.platform.vcs.impl.shared.rhizome.NodeEntity;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/vcs/impl/frontend/changes/actions/CreatePatchForShelvedChangeAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "silentClipboard", "", "<init>", "(Z)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.vcs.impl.frontend"})
@ApiStatus.Internal
public abstract class CreatePatchForShelvedChangeAction
extends AnAction {
    private final boolean silentClipboard;

    public CreatePatchForShelvedChangeAction(boolean silentClipboard) {
        this.silentClipboard = silentClipboard;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        List list = (List)e.getData(ChangeListKt.getCHANGE_LISTS_KEY());
        if (list == null) {
            return;
        }
        List changeLists = list;
        ChangeList shelvedChangeList = (ChangeList)CollectionsKt.singleOrNull((List)changeLists);
        DataKey<ShelfTree> dataKey = ShelfTree.Companion.getSHELVED_CHANGES_TREE_KEY();
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        ShelfTree shelfTree = (ShelfTree)((Object)dataKey.getData(dataContext));
        ShelfService shelfService = ShelfService.Companion.getInstance(project2);
        if (shelfTree != null) {
            if (shelvedChangeList != null) {
                List<NodeEntity> list2;
                boolean entireList;
                boolean bl = entireList = CollectionsKt.singleOrNull((Iterable)shelfTree.getExactlySelectedLists()) != null;
                if (entireList) {
                    List<NodeEntity> list3 = ContainerUtil.emptyList();
                    list2 = list3;
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"emptyList(...)");
                } else {
                    list2 = shelvedChangeList.getChanges();
                }
                List<NodeEntity> selectedChanges = list2;
                shelfService.createPatch(CollectionsKt.listOf((Object)new ChangeList(shelvedChangeList.getChangeListNode(), selectedChanges)), this.silentClipboard);
            } else {
                shelfService.createPatch(changeLists, this.silentClipboard);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Collection changeLists;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List list = (List)e.getData(ChangeListKt.getCHANGE_LISTS_KEY());
        Collection collection = changeLists = list != null ? (Collection)list : (Collection)SetsKt.emptySet();
        if (changeLists.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        int changelistNum = changeLists.size();
        if (changelistNum > 1) {
            e.getPresentation().setEnabled(false);
            return;
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

