/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.parser;

import com.intellij.indentation.OperationParserHelper;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssStubElementTypes;
import com.intellij.psi.css.impl.parsing.CssParser;
import com.intellij.psi.css.impl.parsing.IndentPreprocessorParser;
import com.intellij.psi.css.impl.parsing.PreprocessorTokenTypeProvider;
import com.intellij.psi.css.impl.util.CssStylesheetLazyElementType;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.parser.SassMathParser;
import org.jetbrains.plugins.sass.parser.SassTokenTypeProvider;
import org.jetbrains.plugins.sass.psi.SASSElementTypes;
import org.jetbrains.plugins.sass.psi.SASSTokenTypes;
import org.jetbrains.plugins.sass.psi.SassStubElementTypes;
import org.jetbrains.plugins.scss.SCSSElementTypes;
import org.jetbrains.plugins.scss.lexer.SCSSTokenTypes;

public class SASSParser
extends IndentPreprocessorParser
implements OperationParserHelper.BinaryOperationParser,
CssParser {
    private static final TokenSet[] OPERATOR_PRIORITY = new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{SASSTokenTypes.MULTIPLY, SASSTokenTypes.DIVIDE}), TokenSet.create((IElementType[])new IElementType[]{SASSTokenTypes.PLUS, SASSTokenTypes.MINUS}), TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_GE, CssElementTypes.CSS_GT, CssElementTypes.CSS_LE, CssElementTypes.CSS_LT, SASSTokenTypes.EQQ, SASSTokenTypes.NEQ}), TokenSet.create((IElementType[])new IElementType[]{SASSTokenTypes.AND, SASSTokenTypes.OR, SASSTokenTypes.NOT, CssElementTypes.CSS_PERCENT})};
    private static final IElementType[] OPERATOR_ELEMENT_TYPES = new IElementType[]{SASSElementTypes.EXPRESSION, SASSElementTypes.EXPRESSION, SASSElementTypes.EXPRESSION, SASSElementTypes.EXPRESSION};
    private static final TokenSet POSSIBLE_IDENTIFIERS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_IDENT, SASSTokenTypes.IDENTIFIER, SASSTokenTypes.ONLY, SASSTokenTypes.AND, SASSTokenTypes.OR, CssElementTypes.CSS_AMPERSAND});
    private final SassMathParser SASS_MATH_PARSER = new SassMathParser(this);
    private boolean allowImportantInTermList = false;
    private boolean mySkipDeclarationBlock = true;
    private boolean mySkipFunctionBody = true;

    protected boolean parseSelectorSuffix() {
        return this.parseInterpolation() || this.parsePlaceholderSelector() || this.parseClass() || this.parseIdSelector() || this.parsePseudo() || this.parseAttribute();
    }

    protected boolean parseIdentMergedToAmpersand() {
        boolean result = false;
        while (!this.hasWhitespaceBefore()) {
            if (this.isIdent() && this.addIdentOrError()) {
                result = true;
                continue;
            }
            if (!this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_MINUS, CssElementTypes.CSS_NUMBER})) break;
            this.addSingleToken();
            result = true;
        }
        return result || super.parseIdentMergedToAmpersand();
    }

    protected List<IElementType> getSelectorPrefixTokenTypes() {
        return Collections.singletonList(CssElementTypes.CSS_AMPERSAND);
    }

    private boolean parsePlaceholderSelector() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_PERCENT})) {
            PsiBuilder.Marker placeholderSelector = this.mark();
            this.advance();
            if (!this.isNewLine() && this.rawLookup(-1) == CssElementTypes.CSS_PERCENT) {
                this.parseIdentOrInterpolation();
                this.parseInterpolationAfterIdent();
            }
            this.done(placeholderSelector, SASSElementTypes.PLACEHOLDER_SELECTOR);
            return true;
        }
        return false;
    }

    protected TokenSet getPossibleIdentifiers() {
        return POSSIBLE_IDENTIFIERS;
    }

    private boolean parseKeyframes() {
        if (this.getTokenType() != CssElementTypes.CSS_KEYFRAMES_SYM) {
            return false;
        }
        int parentIndent = this.getCurrentIndent();
        PsiBuilder.Marker keyframes = this.mark();
        this.advance();
        if (!this.isNewLine() && this.parseIdentOrInterpolation()) {
            this.parseInterpolationAfterIdent();
        } else if (!this.parseString(false)) {
            this.errorUntilEol(SASSBundle.message("parsing.error.keyframes.name.expected", new Object[0]));
        }
        if (parentIndent >= this.getCurrentIndent()) {
            this.error(SASSBundle.message("parsing.error.keyframes.block.expected", new Object[0]));
        }
        while (!this.eof() && parentIndent < this.getCurrentIndent() && (this.parseKeyframesRuleset(parentIndent) || this.parseSassConstructionsDeclarations())) {
        }
        this.done(keyframes, CssElementTypes.CSS_KEYFRAMES_RULE);
        return true;
    }

    public boolean parseInterpolation() {
        if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.INTERPOLATION_PREFIX})) {
            PsiBuilder.Marker interpolation = this.mark();
            this.advance();
            PsiBuilder.Marker possibleError = this.mark();
            if (!this.parseTermList(false, new IElementType[]{SASSTokenTypes.INTERPOLATION_SUFFIX})) {
                this.advanceUntil(TokenSet.create((IElementType[])new IElementType[]{SASSTokenTypes.INTERPOLATION_SUFFIX}));
                possibleError.error(SASSBundle.message("error.text.invalid.term", new Object[0]));
            } else {
                SASSParser.drop((PsiBuilder.Marker)possibleError);
            }
            if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{SASSTokenTypes.INTERPOLATION_SUFFIX})) {
                this.advance();
                this.done(interpolation, SASSElementTypes.INTERPOLATION);
            } else {
                this.done(interpolation, SASSElementTypes.INTERPOLATION);
                this.errorUntilEol(SASSBundle.message("parsing.error.unclosed.interpolation", new Object[0]));
            }
            return true;
        }
        return false;
    }

    protected boolean parsePropertyRuleset() {
        PsiBuilder.Marker rulesetMarker = this.mark(true);
        int indent = this.getCurrentIndent();
        boolean parsedWithValue = this.parseDeclaration(true, true, true);
        if (parsedWithValue && indent < this.getCurrentIndent() || !parsedWithValue && this.parseDeclaration(false, true, true)) {
            this.parseDeclarationBlock(indent);
            this.done(rulesetMarker, SASSElementTypes.PROPERTY_RULESET);
            return true;
        }
        this.rollbackTo(rulesetMarker);
        return false;
    }

    private boolean parseVariableDeclaration() {
        if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.VARIABLE}) && this.lookAhead(1) == SASSTokenTypes.COLON) {
            PsiBuilder.Marker variableDeclaration = this.mark();
            PsiBuilder.Marker variableNameMarker = this.mark();
            this.advance();
            this.done(variableNameMarker, SASSElementTypes.VARIABLE);
            this.advance();
            if (!this.parseVariableValue(true, new IElementType[0])) {
                this.error(SASSBundle.message("parsing.error.variable.value.expected", new Object[0]));
            }
            while (!this.isNewLine() && this.currentTokenIn(new IElementType[]{SASSTokenTypes.DEFAULT, SASSTokenTypes.GLOBAL, SASSTokenTypes.DYNAMIC})) {
                this.advance();
            }
            this.expectEolOrEof();
            this.done(variableDeclaration, SASSElementTypes.VARIABLE_DECLARATION);
            return true;
        }
        return false;
    }

    private boolean parseVariableDeclarationWithoutValue() {
        if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.VARIABLE})) {
            PsiBuilder.Marker variableDeclaration = this.mark();
            PsiBuilder.Marker variableNameMarker = this.mark();
            this.advance();
            this.done(variableNameMarker, SASSElementTypes.VARIABLE);
            this.done(variableDeclaration, SASSElementTypes.VARIABLE_DECLARATION);
            return true;
        }
        return false;
    }

    private boolean parseVariableValue(boolean strict, IElementType ... stopElements) {
        boolean oldValue = this.allowImportantInTermList;
        this.allowImportantInTermList = true;
        boolean result = this.parseTermList(strict, stopElements);
        this.allowImportantInTermList = oldValue;
        return result;
    }

    protected boolean parseInclude() {
        if (this.getTokenType() == SASSTokenTypes.INCLUDE) {
            int includeIndent = this.getCurrentIndent();
            PsiBuilder.Marker possibleRuleset = this.mark();
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.IDENTIFIER, SASSTokenTypes.FUNCTION_TOKEN})) {
                this.advance();
                if (!this.isNewLine() && this.getTokenType() == CssElementTypes.CSS_PERIOD) {
                    this.advance();
                    if (!(this.isNewLine() || this.getTokenType() != CssElementTypes.CSS_IDENT && this.getTokenType() != CssElementTypes.CSS_FUNCTION_TOKEN)) {
                        this.advance();
                    } else {
                        this.error(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
                    }
                }
                if (!this.isNewLine()) {
                    this.parseArgumentList();
                }
                if ((this.getTokenType() == CssElementTypes.CSS_IDENT || this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN) && "using".equals(this.getTokenText())) {
                    this.addToken();
                    this.parseParameterList();
                }
            } else {
                this.error(SASSBundle.message("parsing.error.mixin.name.expected", new Object[0]));
            }
            this.done(marker, SASSElementTypes.INCLUDE);
            this.expectEolOrEof();
            if (!this.eof() && this.getCurrentIndent() > includeIndent) {
                this.parseDeclarationBlock(includeIndent);
                this.done(possibleRuleset, (IElementType)CssStubElementTypes.CSS_RULESET);
            } else {
                SASSParser.drop((PsiBuilder.Marker)possibleRuleset);
            }
            return true;
        }
        return false;
    }

    protected boolean parseDeclaration() {
        return this.parseDeclaration(true, false, false);
    }

    private boolean parseDeclaration(boolean requirePropertyValue, boolean requireNewLineAfterDeclaration, boolean couldBeSelector) {
        return this.parseDeclaration(requirePropertyValue, requireNewLineAfterDeclaration, couldBeSelector, SASSElementTypes.DECLARATION, false);
    }

    private boolean parseDeclaration(boolean requirePropertyValue, boolean requireNewLineAfterDeclaration, boolean couldBeSelector, IElementType elementType, boolean require) {
        PsiBuilder.Marker declarationMarker = this.mark(true);
        if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.MULTIPLY})) {
            this.advance();
            if (this.isNewLine()) {
                this.rollbackTo(declarationMarker);
                return false;
            }
        }
        boolean filterProperty = this.getTokenType() == CssElementTypes.CSS_IDENT && this.getTokenText().endsWith("filter");
        boolean colonMissed = false;
        if (this.parseIdentOrInterpolation()) {
            if (this.parseInterpolationAfterIdent()) {
                filterProperty = false;
            }
            if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{SASSTokenTypes.COLON}) && SASSTokenTypes.WHITESPACE_TOKENS.contains(this.rawLookup(1))) {
                this.advance();
            } else {
                if (couldBeSelector) {
                    this.rollbackTo(declarationMarker);
                    return false;
                }
                boolean bl = colonMissed = !this.currentTokenIn(new IElementType[]{SASSTokenTypes.COLON});
            }
            if (!(requirePropertyValue && this.isNewLine() || this.eof() || colonMissed)) {
                if (filterProperty) {
                    while (!this.isNewLine() && !this.eof()) {
                        PsiBuilder.Marker termList = this.createCompositeElement();
                        PsiBuilder.Marker term = this.createCompositeElement();
                        this.parseTermList(false, false, CssElementTypes.CSS_COMMA);
                        if (!this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA})) {
                            term.drop();
                            termList.drop();
                            break;
                        }
                        term.done(CssElementTypes.CSS_TERM);
                        while (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA})) {
                            this.advance();
                            term = this.createCompositeElement();
                            this.parseTermList(false, false, CssElementTypes.CSS_COMMA);
                            term.done(CssElementTypes.CSS_TERM);
                        }
                        termList.done(CssElementTypes.CSS_TERM_LIST);
                    }
                    if (!this.isNewLine() && !this.eof()) {
                        if (requireNewLineAfterDeclaration) {
                            this.expect(SASSTokenTypes.IMPORTANT, CssBundle.message((String)"parsing.error.unexpected.term", (Object[])new Object[0]));
                        } else if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.IMPORTANT})) {
                            this.advance();
                        }
                    }
                } else if (this.parseTermList(new IElementType[0])) {
                    if (!this.isNewLine() && !this.eof()) {
                        if (requireNewLineAfterDeclaration) {
                            this.expect(SASSTokenTypes.IMPORTANT, CssBundle.message((String)"parsing.error.unexpected.term", (Object[])new Object[0]));
                        } else if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.IMPORTANT})) {
                            this.advance();
                        }
                    }
                } else if (requirePropertyValue) {
                    PsiBuilder.Marker termListMarker = this.mark();
                    this.error(SASSBundle.message("parsing.error.value.expected", new Object[0]));
                    while (!this.isTermListFinished()) {
                        this.advance();
                    }
                    this.done(termListMarker, SASSElementTypes.TERM_LIST);
                }
                this.done(declarationMarker, elementType);
                if (requireNewLineAfterDeclaration) {
                    this.expectEolOrEof();
                }
                return true;
            }
            if (require) {
                if (requirePropertyValue || !colonMissed) {
                    this.error(SASSBundle.message("parsing.error.property.value.expected", new Object[0]));
                }
                this.done(declarationMarker, elementType);
                return false;
            }
        }
        this.rollbackTo(declarationMarker);
        return false;
    }

    protected boolean selectorsCouldBeInANewLine(int lineIndent) {
        return false;
    }

    protected boolean parseMediaExpression() {
        boolean result = false;
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            PsiBuilder.Marker mediaExpression = this.mark();
            this.expect(CssElementTypes.CSS_LPAREN, "'('");
            PsiBuilder.Marker tempMarker = this.mark(true);
            if (!(this.isTermListFinished() || this.isIdent() && SASSParser.tokenIn((IElementType)this.lookAhead(1), (IElementType[])new IElementType[]{CssElementTypes.CSS_COLON, CssElementTypes.CSS_RPAREN, CssElementTypes.CSS_COMMA}) || this.isLastLineElement())) {
                result = this.parseCustomMediaExpression();
            }
            if (!result) {
                this.rollbackTo(tempMarker);
                result = true;
                if (this.isNewLine() || this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_RPAREN})) {
                    this.error(CssBundle.message((String)"parsing.error.media.feature.expected", (Object[])new Object[0]));
                }
                this.parseDeclaration(false, false, false, CssElementTypes.CSS_MEDIA_FEATURE, true);
            } else {
                SASSParser.drop((PsiBuilder.Marker)tempMarker);
            }
            this.parseRightParenthesis();
            this.done(mediaExpression, CssElementTypes.CSS_MEDIA_EXPRESSION);
        } else if (this.isInterpolation()) {
            PsiBuilder.Marker mediaExpression = this.mark();
            this.parseInterpolation();
            this.done(mediaExpression, CssElementTypes.CSS_MEDIA_EXPRESSION);
            result = true;
        }
        return result;
    }

    private boolean parseCustomMediaExpression() {
        if (this.parseTermList(true, new IElementType[]{CssElementTypes.CSS_COLON, CssElementTypes.CSS_RPAREN})) {
            if (this.getTokenType() == CssElementTypes.CSS_COLON) {
                this.addSingleToken();
                if (!this.parseTermList(true, new IElementType[]{CssElementTypes.CSS_RPAREN})) {
                    this.error(CssBundle.message((String)"parsing.error.term.expected", (Object[])new Object[0]));
                }
            }
            return true;
        }
        return false;
    }

    protected boolean isInterpolation() {
        return this.currentTokenIn(new IElementType[]{SASSTokenTypes.INTERPOLATION_PREFIX});
    }

    protected boolean isIdSelectorStart() {
        return super.isIdSelectorStart() || this.currentTokenIn(new IElementType[]{SASSTokenTypes.HASH_SIGN}) && this.rawLookup(1) == SASSTokenTypes.INTERPOLATION_PREFIX;
    }

    protected boolean isTermListFinished() {
        return this.currentTokenIn(new IElementType[]{SASSTokenTypes.DEFAULT, SASSTokenTypes.DYNAMIC, SASSTokenTypes.GLOBAL}) || super.isTermListFinished();
    }

    private void parseFunctionBody(int parentIndent) {
        if (this.mySkipFunctionBody) {
            this.skipBlock(parentIndent, SASSElementTypes.FUNCTION_BODY);
        } else {
            this.mySkipFunctionBody = true;
            while (!this.eof() && this.getCurrentIndent() > parentIndent) {
                if (this.parseVariableDeclaration() || this.parseControlDirectives(false) || this.parseReturnStatement()) continue;
                PsiBuilder.Marker errorMarker = this.mark();
                this.advance();
                this.advanceUntilEol();
                errorMarker.error(SASSBundle.message("error.text.functions.can.only.contain.variable.declarations", new Object[0]));
            }
            if (!this.eof()) {
                this.errorUntilEof();
            }
            this.mySkipFunctionBody = false;
        }
    }

    protected void parseDeclarationBlock(int parentIndent) {
        if (this.mySkipDeclarationBlock) {
            this.skipBlock(parentIndent, SASSElementTypes.DECLARATION_BLOCK);
        } else {
            this.mySkipDeclarationBlock = true;
            this.parseRootDeclarationBlock(-1);
            if (!this.eof()) {
                this.errorUntilEof();
            }
            this.mySkipDeclarationBlock = false;
        }
    }

    private void skipBlock(int parentIndent, @NotNull ILazyParseableElementType elementType) {
        if (elementType == null) {
            SASSParser.$$$reportNull$$$0(0);
        }
        PsiBuilder.Marker declarationBlockMarker = this.mark();
        if (!this.eof() && parentIndent < this.getCurrentIndent()) {
            while (!this.eof() && parentIndent < this.getCurrentIndent()) {
                this.advance();
            }
        } else {
            SASSParser.drop((PsiBuilder.Marker)declarationBlockMarker);
            return;
        }
        SASSParser.collapse((PsiBuilder.Marker)declarationBlockMarker, (IElementType)elementType);
        declarationBlockMarker.setCustomEdgeTokenBinders(this.COMMENTS_AND_INDENT_BEFORE_BINDER, this.WHITE_SPACES_AFTER_BINDER);
    }

    private void parseRootDeclarationBlock(int parentIndent) {
        while (!this.eof() && this.getCurrentIndent() > parentIndent) {
            PsiBuilder.Marker toRollback = this.mark(true);
            if (this.parseSmthInBlock(parentIndent)) {
                SASSParser.drop((PsiBuilder.Marker)toRollback);
                continue;
            }
            this.rollbackTo(toRollback);
            toRollback = this.mark(true);
            if (!this.parseKeyframesRuleset(parentIndent)) {
                this.rollbackTo(toRollback);
                this.parseSmthInBlock(parentIndent);
                continue;
            }
            SASSParser.drop((PsiBuilder.Marker)toRollback);
        }
    }

    private boolean parseSmthInBlock(int parentIndent) {
        if (this.parseStyleDeclarations(parentIndent) || this.parseSassConstructionsDeclarations()) {
            return true;
        }
        if (this.parseVariable()) {
            this.error(SASSBundle.message("parsing.error.unexpected.variable", new Object[0]));
        } else {
            PsiBuilder.Marker errorMarker = this.mark();
            this.advance();
            errorMarker.error(CssBundle.message((String)"parsing.error.unexpected.token", (Object[])new Object[0]));
        }
        return false;
    }

    private boolean parseSassConstructionsDeclarations() {
        return this.parseVariableDeclaration() || this.parseMixin() || this.parseControlDirectives(true) || this.parseFunctionDeclaration() || this.parseInclude() || this.parseImport() || this.parseUseAtRule() || this.parseForwardAtRule() || this.parseGenericAtRule() || this.parseContent();
    }

    private boolean parseUseAtRule() {
        if (this.getTokenType() != SCSSTokenTypes.USE) {
            return false;
        }
        PsiBuilder.Marker useAtRule = this.myBuilder.mark();
        this.addToken();
        if (!this.parseImportDestination()) {
            this.error(SASSBundle.message("parsing.error.string.expected", new Object[0]));
        }
        if (!this.isNewLine() && this.getTokenType() == CssElementTypes.CSS_IDENT && "as".equals(this.getTokenText())) {
            PsiBuilder.Marker useAs = this.myBuilder.mark();
            this.addToken();
            if (this.isNewLine()) {
                this.error(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
            } else if (this.getTokenType() == CssElementTypes.CSS_ASTERISK) {
                this.addToken();
            } else {
                this.addIdentOrError();
            }
            useAs.done(SASSElementTypes.SASS_USE_AS);
        }
        if (!this.isNewLine() && this.getTokenType() == CssElementTypes.CSS_IDENT && "with".equals(this.getTokenText())) {
            PsiBuilder.Marker useWith = this.myBuilder.mark();
            this.addToken();
            this.parseArgumentList();
            useWith.done(SASSElementTypes.SASS_USE_WITH);
        }
        useAtRule.done(SASSElementTypes.SASS_USE_AT_RULE);
        this.expectEolOrEof();
        return true;
    }

    private boolean parseForwardAtRule() {
        if (this.getTokenType() != SCSSTokenTypes.FORWARD) {
            return false;
        }
        PsiBuilder.Marker forwardAtRule = this.myBuilder.mark();
        this.addToken();
        if (!this.parseImportDestination()) {
            this.error(SASSBundle.message("parsing.error.string.expected", new Object[0]));
        }
        if (!this.isNewLine() && this.getTokenType() == CssElementTypes.CSS_IDENT && "as".equals(this.getTokenText())) {
            this.addToken();
            if (this.isNewLine()) {
                this.error(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
            } else if (this.addIdentOrError()) {
                if (!this.isNewLine() && this.getTokenType() == CssElementTypes.CSS_ASTERISK) {
                    this.addToken();
                } else {
                    this.error(SASSBundle.message("parsing.error.asterisk.expected", new Object[0]));
                }
            }
        }
        if (!this.isNewLine() && this.getTokenType() == CssElementTypes.CSS_IDENT && ("show".equals(this.getTokenText()) || "hide".equals(this.getTokenText()))) {
            this.addToken();
            if (!(this.isNewLine() || this.getTokenType() != CssElementTypes.CSS_IDENT && this.getTokenType() != SCSSTokenTypes.VARIABLE)) {
                this.addToken();
                while (!this.isNewLine() && this.getTokenType() == CssElementTypes.CSS_COMMA) {
                    this.addToken();
                    if (!(this.isNewLine() || this.getTokenType() != CssElementTypes.CSS_IDENT && this.getTokenType() != SCSSTokenTypes.VARIABLE)) {
                        this.addToken();
                        continue;
                    }
                    this.error(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
                    break;
                }
            } else {
                this.error(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
            }
        }
        if (!this.isNewLine() && this.getTokenType() == CssElementTypes.CSS_IDENT && "with".equals(this.getTokenText())) {
            PsiBuilder.Marker useWith = this.myBuilder.mark();
            this.addToken();
            this.parseArgumentList();
            useWith.done(SASSElementTypes.SASS_USE_WITH);
        }
        forwardAtRule.done(SASSElementTypes.SASS_FORWARD_AT_RULE);
        this.expectEolOrEof();
        return true;
    }

    private boolean parseGenericAtRule() {
        return this.parseGenericAtRule(CssElementTypes.CSS_ATKEYWORD, CssElementTypes.CSS_GENERIC_AT_RULE);
    }

    private boolean parseContainer() {
        return this.parseGenericAtRule(CssElementTypes.CSS_CONTAINER_SYM, CssElementTypes.CSS_CONTAINER);
    }

    private boolean parseLayer() {
        return this.parseGenericAtRule(CssElementTypes.CSS_LAYER_SYM, CssElementTypes.CSS_LAYER);
    }

    protected boolean parseGenericAtRule(@NotNull IElementType atKeywordElementType, @NotNull IElementType atRuleElementType) {
        if (atKeywordElementType == null) {
            SASSParser.$$$reportNull$$$0(1);
        }
        if (atRuleElementType == null) {
            SASSParser.$$$reportNull$$$0(2);
        }
        if (this.getTokenType() != atKeywordElementType) {
            return false;
        }
        int indent = this.getCurrentIndent();
        PsiBuilder.Marker atRule = this.mark(true);
        this.addToken();
        while (!this.isNewLine() && !this.eof()) {
            this.addToken();
        }
        this.parseDeclarationBlock(indent);
        atRule.done(atRuleElementType);
        return true;
    }

    private boolean parseStyleDeclarations(int parentIndent) {
        return this.parseNamespaceList(parentIndent) || this.parseCharset() || this.parsePropertyRuleset() || this.parseDeclaration(true, true, true) || this.parseRuleset(parentIndent) || this.parseRulesetCustomProperty() || this.parsePage() || this.parseCounterStyle() || this.parseDocument() || this.parseRegion() || this.parseScopeRule() || this.parseKeyframes() || this.parseSupports() || this.parseStartingStyle() || this.parseFontPaletteValues() || this.parseFontFace() || this.parseViewPort() || this.parseExtend() || this.parseAtRoot() || this.parsePageMarginRules() || this.parseRulesetMedia() || this.parseContainer() || this.parseLayer();
    }

    private boolean parseReturnStatement() {
        if (this.getTokenType() == SASSTokenTypes.RETURN) {
            PsiBuilder.Marker returnStatement = this.mark();
            this.advance();
            this.parseVariableValue(true, new IElementType[0]);
            this.done(returnStatement, SASSElementTypes.RETURN_STATEMENT);
            return true;
        }
        return false;
    }

    private boolean parseContent() {
        if (this.getTokenType() == SASSTokenTypes.CONTENT) {
            PsiBuilder.Marker atRule = this.mark();
            this.advance();
            if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
                this.parseArgumentList();
            }
            this.done(atRule, SASSElementTypes.CONTENT_STATEMENT);
            this.expectEolOrEof();
            return true;
        }
        return false;
    }

    private boolean parseNamespaceList(int parentIndent) {
        PsiBuilder.Marker importList = this.mark();
        boolean result = false;
        if (this.isNewLine()) {
            while (parentIndent < this.getCurrentIndent() && this.parseNamespace()) {
                result = true;
            }
        }
        if (result) {
            this.done(importList, CssElementTypes.CSS_NAMESPACE_LIST);
        } else {
            SASSParser.drop((PsiBuilder.Marker)importList);
        }
        return result;
    }

    private boolean parseExtend() {
        if (this.getTokenType() == SASSTokenTypes.EXTEND_TOKEN) {
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            if (!this.parseSelectorList(this.getCurrentIndent(), false, false)) {
                this.error(CssBundle.message((String)"parsing.error.selector.expected", (Object[])new Object[0]));
            }
            if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{SCSSTokenTypes.OPTIONAL})) {
                this.addToken();
            } else if (!this.isNewLine() && "!".equals(this.getTokenText())) {
                this.addSingleToken();
                PsiBuilder.Marker error = this.mark();
                if (!this.isNewLine() && this.isIdent() && !this.hasWhitespaceBefore()) {
                    this.addToken();
                }
                error.error(SASSBundle.message("parsing.error.excl.optional.expected", new Object[0]));
            }
            this.done(marker, SASSElementTypes.EXTEND);
            this.expectEolOrEof();
            return true;
        }
        return false;
    }

    private boolean parseAtRoot() {
        if (this.getTokenType() == SASSTokenTypes.AT_ROOT_TOKEN) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker atRoot = this.mark();
            this.advance();
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LPAREN})) {
                this.addToken();
                PsiBuilder.Marker atRootQuery = this.mark();
                if (this.isIdent()) {
                    String text = this.getTokenText();
                    PsiBuilder.Marker possibleError = this.mark();
                    this.addIdentOrError();
                    if ("without".equals(text) || "with".equals(text)) {
                        possibleError.drop();
                    } else {
                        possibleError.error(SASSBundle.message("parsing.error.with.or.without.query.expected", new Object[0]));
                    }
                    if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COLON})) {
                        this.addToken();
                        PsiBuilder.Marker queryValue = this.mark();
                        while (this.isIdent()) {
                            this.addIdentOrError();
                        }
                        this.done(queryValue, SASSElementTypes.AT_ROOT_QUERY_VALUE);
                    } else {
                        this.errorUntilEol(SASSBundle.message("parsing.error.colon.expected", new Object[0]));
                    }
                } else {
                    this.error(SASSBundle.message("parsing.error.with.or.without.query.expected", new Object[0]));
                }
                this.done(atRootQuery, SASSElementTypes.AT_ROOT_QUERY);
                if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_RPAREN})) {
                    this.addToken();
                } else {
                    this.errorUntilEol(CssBundle.message((String)"parsing.error.closing.parenthesis.expected", (Object[])new Object[0]));
                }
                this.expectEolOrEof();
            } else if (!this.isNewLine() && !this.parseSelectorList(this.getCurrentIndent())) {
                this.error(CssBundle.message((String)"parsing.error.selector.expected", (Object[])new Object[0]));
                this.expectEolOrEof();
            }
            this.parseDeclarationBlock(indent);
            this.done(atRoot, SASSElementTypes.AT_ROOT);
            this.expectEolOrEof();
            return true;
        }
        return false;
    }

    protected boolean parseParameter() {
        PsiBuilder.Marker parameter = this.mark();
        PsiBuilder.Marker declaration = this.mark();
        boolean defaultValueParsed = false;
        if (this.parseVariable()) {
            if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{SASSTokenTypes.COLON})) {
                defaultValueParsed = true;
                this.advance();
                if (this.isNewLine() || !this.parseVariableValue(true, CssElementTypes.CSS_COMMA)) {
                    this.error(SASSBundle.message("parsing.error.variable.value.expected", new Object[0]));
                }
            }
            this.done(declaration, SASSElementTypes.VARIABLE_DECLARATION);
            if (!defaultValueParsed) {
                this.parseThreeDots();
            }
            this.done(parameter, SASSElementTypes.PARAMETER);
            return true;
        }
        SASSParser.drop((PsiBuilder.Marker)declaration);
        SASSParser.drop((PsiBuilder.Marker)parameter);
        return false;
    }

    private boolean parseFunction() {
        if (this.rawLookup(-1) != CssElementTypes.CSS_PERIOD && this.getTokenType() == CssElementTypes.CSS_IDENT && this.lookAhead(1) == CssElementTypes.CSS_PERIOD && this.lookAhead(2) == CssElementTypes.CSS_FUNCTION_TOKEN) {
            PsiBuilder.Marker function = this.createCompositeElement();
            this.addToken();
            this.addToken();
            this.addToken();
            if (!this.parseArgumentList()) {
                this.error(CssBundle.message((String)"parsing.error.opening.parenthesis.expected", (Object[])new Object[0]));
            }
            function.done(CssElementTypes.CSS_FUNCTION);
            return true;
        }
        if (this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN && this.lookAhead(1) == CssElementTypes.CSS_LPAREN) {
            String functionName = CssPropertyUtil.getElementNameWithoutVendorPrefix((String)StringUtil.notNullize((String)this.getTokenText()));
            if (functionName.equalsIgnoreCase("calc")) {
                PsiBuilder.Marker functionInvocationMarker = this.mark();
                this.advance();
                this.advance();
                PsiBuilder.Marker termList = this.mark();
                boolean result = this.SASS_MATH_PARSER.parse();
                termList.done(CssElementTypes.CSS_TERM_LIST);
                this.parseRightParenthesis();
                this.done(functionInvocationMarker, CssElementTypes.CSS_FUNCTION);
                return result;
            }
            PsiBuilder.Marker functionInvocationMarker = this.mark();
            this.advance();
            if (!this.parseArgumentList()) {
                this.error(CssBundle.message((String)"parsing.error.opening.parenthesis.expected", (Object[])new Object[0]));
                if (this.isNewLine()) {
                    this.error(CssBundle.message((String)"parsing.error.closing.parenthesis.expected", (Object[])new Object[0]));
                    this.done(functionInvocationMarker, CssElementTypes.CSS_FUNCTION);
                    return false;
                }
            }
            this.done(functionInvocationMarker, CssElementTypes.CSS_FUNCTION);
            return true;
        }
        return false;
    }

    protected boolean parseMap() {
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            PsiBuilder.Marker possibleMap = this.mark(true);
            this.advance();
            if (this.parseMapEntry()) {
                while (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA})) {
                    this.addSingleToken();
                    if (!this.isNewLine() && this.parseMapEntry()) continue;
                }
                if (this.isNewLine()) {
                    this.error(CssBundle.message((String)"parsing.error.closing.parenthesis.expected", (Object[])new Object[0]));
                } else {
                    this.parseRightParenthesis();
                }
                this.done(possibleMap, SASSElementTypes.MAP);
                return true;
            }
            this.rollbackTo(possibleMap);
        }
        return false;
    }

    private boolean parseMapEntry() {
        if (this.getTokenType() == CssElementTypes.CSS_RPAREN) {
            return false;
        }
        PsiBuilder.Marker mapEntry = this.createCompositeElement();
        if (this.parseTermList(true, new IElementType[]{CssElementTypes.CSS_COLON, CssElementTypes.CSS_COMMA})) {
            if (this.getTokenType() == CssElementTypes.CSS_COLON) {
                this.addSingleToken();
                if (!this.parseTermList(true, new IElementType[]{CssElementTypes.CSS_COMMA})) {
                    this.error(CssBundle.message((String)"parsing.error.term.expected", (Object[])new Object[0]));
                }
                mapEntry.done(SASSElementTypes.MAP_ENTRY);
                return true;
            }
            this.error(SASSBundle.message("parsing.error.colon.expected", new Object[0]));
        }
        SASSParser.drop((PsiBuilder.Marker)mapEntry);
        return false;
    }

    protected boolean isTrailingCommaInParamsAllowed() {
        return true;
    }

    protected boolean parseArgument() {
        if (this.getTokenType() == SASSTokenTypes.VARIABLE && this.lookAhead(1) == SASSTokenTypes.COLON) {
            PsiBuilder.Marker declarationMarker = this.mark();
            this.parseVariable();
            if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.COLON})) {
                this.advance();
                if (!this.isNewLine()) {
                    this.parseVariableValue(true, CssElementTypes.CSS_COMMA);
                }
            }
            if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.DEFAULT})) {
                this.advance();
            }
            this.done(declarationMarker, SASSElementTypes.VARIABLE_DECLARATION);
            return true;
        }
        if (this.getTokenType() == SASSTokenTypes.VARIABLE && this.rawLookup(1) == CssElementTypes.CSS_PERIOD) {
            PsiBuilder.Marker term = this.mark();
            this.parseVariable();
            this.parseThreeDots();
            this.done(term, CssElementTypes.CSS_TERM);
            return true;
        }
        return this.parseVariableValue(false, CssElementTypes.CSS_COMMA);
    }

    @Nullable
    protected IElementType getParameterListElementType() {
        return SASSElementTypes.PARAMETER_LIST;
    }

    private boolean parseMixin() {
        if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.MIXIN, SASSTokenTypes.EQUALS})) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.IDENTIFIER, SASSTokenTypes.FUNCTION_TOKEN})) {
                this.advance();
                if (!this.isNewLine()) {
                    this.parseParameterList();
                }
                this.expectEolOrEof();
                this.parseDeclarationBlock(indent);
            } else {
                this.error(SASSBundle.message("parsing.error.mixin.name.expected", new Object[0]));
            }
            this.done(marker, (IElementType)SassStubElementTypes.SASS_MIXIN_DECLARATION);
            return true;
        }
        return false;
    }

    private boolean parseFunctionDeclaration() {
        if (this.getTokenType() == SASSTokenTypes.FUNCTION_KEYWORD) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            if (this.getTokenType() == SASSTokenTypes.FUNCTION_TOKEN) {
                this.advance();
                if (!this.parseParameterList()) {
                    this.error(SASSBundle.message("parsing.error.function.arguments.expected", new Object[0]));
                }
                this.expectEolOrEof();
                this.parseFunctionBody(indent);
            } else if (this.parseIdent()) {
                this.expect(CssElementTypes.CSS_LPAREN, CssBundle.message((String)"parsing.error.opening.parenthesis.expected", (Object[])new Object[0]));
            } else {
                this.error(SASSBundle.message("parsing.error.function.name.expected", new Object[0]));
            }
            this.done(marker, SASSElementTypes.FUNCTION_DECLARATION);
            return true;
        }
        return false;
    }

    protected void parseRoot(IElementType root) {
        if (root == SASSElementTypes.DECLARATION_BLOCK) {
            PsiBuilder.Marker declarationBlockMarker = this.mark();
            this.recalculateCurrentIndent();
            this.mySkipDeclarationBlock = false;
            this.parseDeclarationBlock(this.getCurrentIndent() - 1);
            this.done(declarationBlockMarker, (IElementType)SASSElementTypes.DECLARATION_BLOCK);
        } else if (root == SASSElementTypes.FUNCTION_BODY) {
            PsiBuilder.Marker declarationBlockMarker = this.mark();
            this.recalculateCurrentIndent();
            this.mySkipFunctionBody = false;
            this.parseFunctionBody(this.getCurrentIndent() - 1);
            this.done(declarationBlockMarker, (IElementType)SASSElementTypes.FUNCTION_BODY);
        } else {
            this.mySkipDeclarationBlock = true;
            PsiBuilder.Marker rootMarker = this.mark();
            boolean hasCommentsAndWhitespacesOnly = this.getTokenType() == null;
            PsiBuilder.Marker stylesheetMarker = this.mark();
            this.parseCharset();
            PsiBuilder.Marker rulesetListMarker = this.mark();
            this.parseRootDeclarationBlock(-1);
            this.done(rulesetListMarker, (IElementType)CssStubElementTypes.CSS_RULESET_LIST);
            rulesetListMarker.setCustomEdgeTokenBinders(this.COMMENTS_BEFORE_BINDER, WhitespacesBinders.GREEDY_RIGHT_BINDER);
            WhitespacesAndCommentsBinder stylesheetLeftBinder = SASSParser.getStylesheetLeftBinder(hasCommentsAndWhitespacesOnly);
            if (root instanceof CssStylesheetLazyElementType) {
                this.done(stylesheetMarker, (IElementType)SassStubElementTypes.SASS_STYLESHEET);
                stylesheetMarker.setCustomEdgeTokenBinders(stylesheetLeftBinder, WhitespacesBinders.GREEDY_RIGHT_BINDER);
                this.done(rootMarker, root);
                rootMarker.setCustomEdgeTokenBinders(stylesheetLeftBinder, WhitespacesBinders.GREEDY_RIGHT_BINDER);
            } else {
                SASSParser.collapse((PsiBuilder.Marker)stylesheetMarker, (IElementType)SASSElementTypes.SASS_LAZY_STYLESHEET);
                stylesheetMarker.setCustomEdgeTokenBinders(stylesheetLeftBinder, WhitespacesBinders.GREEDY_RIGHT_BINDER);
                this.done(rootMarker, root);
            }
        }
    }

    private static WhitespacesAndCommentsBinder getStylesheetLeftBinder(boolean hasCommentsAndWhitespacesOnly) {
        return hasCommentsAndWhitespacesOnly ? WhitespacesBinders.DEFAULT_LEFT_BINDER : WhitespacesBinders.GREEDY_LEFT_BINDER;
    }

    protected IElementType getIndentElementType() {
        return SASSTokenTypes.INDENT;
    }

    protected IElementType getEolElementType() {
        return SASSTokenTypes.EOL;
    }

    protected boolean parseExpression() {
        return OperationParserHelper.callParsingBinaryOperation((OperationParserHelper.BinaryOperationParser)this, (int)(OPERATOR_PRIORITY.length - 1));
    }

    protected boolean parseTermList(boolean strict, boolean rollbackOnError, IElementType ... stopElements) {
        PsiBuilder.Marker toRollback = this.mark(true);
        if ((this.isIdent() || this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_HASH})) && this.lookAhead(1) == CssElementTypes.CSS_EQ) {
            PsiBuilder.Marker innerTerm = this.createCompositeElement();
            this.advance();
            innerTerm.done(CssElementTypes.CSS_TERM);
            if (!this.isNewLine()) {
                this.advance();
                if (!this.isNewLine()) {
                    this.parseTerm();
                    SASSParser.drop((PsiBuilder.Marker)toRollback);
                    return true;
                }
            }
        }
        this.rollbackTo(toRollback);
        return super.parseTermList(strict, rollbackOnError, stopElements);
    }

    protected TokenSet getComments() {
        return SASSTokenTypes.COMMENTS;
    }

    protected boolean ruleCouldContainBraces() {
        return false;
    }

    protected PreprocessorTokenTypeProvider getTokenTypeProvider() {
        return SassTokenTypeProvider.getInstance();
    }

    boolean parseVariable() {
        if (this.getTokenType() == SASSTokenTypes.VARIABLE) {
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            this.done(marker, SASSElementTypes.VARIABLE);
            return true;
        }
        if (this.getTokenType() == CssElementTypes.CSS_IDENT && this.lookAhead(1) == CssElementTypes.CSS_PERIOD && this.lookAhead(2) == SCSSTokenTypes.VARIABLE) {
            PsiBuilder.Marker variable = this.createCompositeElement();
            this.addToken();
            this.addToken();
            this.addToken();
            variable.done(SCSSElementTypes.SCSS_VARIABLE);
            return true;
        }
        return false;
    }

    public boolean parseInterpolationAfterIdent() {
        if (!this.eof() && !this.isNewLine() && !this.hasWhitespaceBefore() && this.currentTokenIn(SASSTokenTypes.TOKENS_AFTER_INTERPOLATION_OR_IDENT)) {
            while (!(this.eof() || this.isNewLine() || this.hasWhitespaceBefore())) {
                if (this.parseInterpolation() || this.parseIdent()) continue;
                if (!this.currentTokenIn(SASSTokenTypes.TOKENS_AFTER_INTERPOLATION_OR_IDENT)) break;
                this.advance();
            }
            return true;
        }
        return false;
    }

    private void parseThreeDots() {
        if (this.getTokenType() == CssElementTypes.CSS_PERIOD && this.rawLookup(1) == CssElementTypes.CSS_PERIOD && this.rawLookup(2) == CssElementTypes.CSS_PERIOD) {
            this.advance();
            this.advance();
            this.advance();
        }
    }

    private boolean parseControlDirectives(boolean withDeclarations) {
        return this.parseIf(withDeclarations) || this.parseEach(withDeclarations) || this.parseWhile(withDeclarations) || this.parseFor(withDeclarations) || this.parseWarn() || this.parseDebug() || this.parseError();
    }

    private boolean parseIf(boolean withDeclarations) {
        if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.IF})) {
            PsiBuilder.Marker ifStatement = this.mark();
            this.parseSingleIfTokens(withDeclarations, this.getCurrentIndent());
            while (this.isNewLine() && this.currentTokenIn(new IElementType[]{SASSTokenTypes.ELSE})) {
                int indentBeforeElse = this.getCurrentIndent();
                this.advance();
                int indent = this.getCurrentIndent();
                if (!this.isNewLine()) {
                    if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.IF})) {
                        this.parseSingleIfTokens(withDeclarations, indent);
                        continue;
                    }
                    this.errorUntilEol(SASSBundle.message("parsing.error.if.statement.or.new.line.expected", new Object[0]));
                    continue;
                }
                this.parseInnerBlock(indentBeforeElse, withDeclarations);
            }
            this.done(ifStatement, SASSElementTypes.IF_STATEMENT);
            return true;
        }
        return false;
    }

    private void parseSingleIfTokens(boolean withDeclarations, int indent) {
        this.advance();
        if (this.isNewLine() || !this.parseExpression()) {
            this.errorUntilEol(SASSBundle.message("parsing.error.condition.expected", new Object[0]));
        }
        this.expectEolOrEof();
        this.parseInnerBlock(indent, withDeclarations);
    }

    private boolean parseEach(boolean withDeclarations) {
        if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.EACH})) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker eachStatement = this.mark();
            this.advance();
            if (this.isNewLine() || !this.parseVariableDeclarationWithoutValue()) {
                this.errorUntilEol(CssBundle.message((String)"parsing.error.variable.expected", (Object[])new Object[0]));
            }
            while (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA})) {
                this.addToken();
                if (!this.isNewLine() && this.parseVariableDeclarationWithoutValue()) continue;
                this.errorUntilEol(CssBundle.message((String)"parsing.error.variable.expected", (Object[])new Object[0]));
                break;
            }
            if (!this.isNewLine() && "in".equals(this.getTokenText())) {
                this.advance();
            } else {
                this.errorUntilEol(SASSBundle.message("parsing.error.in.expected", new Object[0]));
            }
            if (this.isNewLine() || !this.parseExpression()) {
                this.errorUntilEol(SASSBundle.message("parsing.error.list.expected", new Object[0]));
            }
            while (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA})) {
                this.advance();
                this.parseExpression();
            }
            this.expectEolOrEof();
            this.parseInnerBlock(indent, withDeclarations);
            this.done(eachStatement, SASSElementTypes.EACH_STATEMENT);
            return true;
        }
        return false;
    }

    private boolean parseWhile(boolean withDeclarations) {
        if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.WHILE})) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker whileStatement = this.mark();
            this.advance();
            if (this.isNewLine() || !this.parseExpression()) {
                this.errorUntilEol(SASSBundle.message("parsing.error.condition.expected", new Object[0]));
            }
            this.expectEolOrEof();
            this.parseInnerBlock(indent, withDeclarations);
            this.done(whileStatement, SASSElementTypes.WHILE_STATEMENT);
            return true;
        }
        return false;
    }

    private boolean parseFor(boolean withDeclarations) {
        if (this.currentTokenIn(new IElementType[]{SASSTokenTypes.FOR})) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker forStatement = this.mark();
            this.advance();
            if (this.isNewLine() || !this.parseVariableDeclarationWithoutValue()) {
                this.errorUntilEol(CssBundle.message((String)"parsing.error.variable.expected", (Object[])new Object[0]));
            }
            if (!this.isNewLine() && "from".equals(this.getTokenText())) {
                this.advance();
            } else {
                this.errorUntilEol(CssBundle.message((String)"parsing.error.from.expected", (Object[])new Object[0]));
            }
            if (this.isNewLine() || !this.parseExpression()) {
                this.errorUntilEol(CssBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
            }
            String tokenText = this.getTokenText();
            if (!this.isNewLine() && ("through".equals(tokenText) || "to".equals(tokenText))) {
                this.advance();
            } else {
                this.errorUntilEol(SASSBundle.message("parsing.error.through.or.to.expected", new Object[0]));
            }
            if (this.isNewLine() || !this.parseExpression()) {
                this.errorUntilEol(CssBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
            }
            this.expectEolOrEof();
            this.parseInnerBlock(indent, withDeclarations);
            this.done(forStatement, SASSElementTypes.FOR_STATEMENT);
            return true;
        }
        return false;
    }

    private void parseInnerBlock(int parentIndent, boolean withDeclarations) {
        if (withDeclarations) {
            this.parseDeclarationBlock(parentIndent);
        } else {
            this.parseFunctionBody(parentIndent);
        }
    }

    private boolean parseDebug() {
        return this.parseLoggingStatement(SASSTokenTypes.DEBUG, SASSElementTypes.DEBUG_STATEMENT);
    }

    private boolean parseWarn() {
        return this.parseLoggingStatement(SASSTokenTypes.WARN, SASSElementTypes.WARN_STATEMENT);
    }

    private boolean parseError() {
        return this.parseLoggingStatement(SASSTokenTypes.ERROR, SASSElementTypes.ERROR_STATEMENT);
    }

    private boolean parseLoggingStatement(IElementType tokenType, IElementType elementType) {
        if (this.currentTokenIn(new IElementType[]{tokenType})) {
            PsiBuilder.Marker warnStatement = this.mark();
            this.advance();
            if (!this.parseVariableValue(false, new IElementType[0])) {
                this.errorUntilEol(SASSBundle.message("parsing.error.subject.expected", new Object[0]));
            }
            this.done(warnStatement, elementType);
            return true;
        }
        return false;
    }

    private boolean isLastLineElement() {
        int i = 1;
        while (this.getWhitespaceTokenSet().contains(this.rawLookup(i))) {
            if (this.getEolElementType() == this.rawLookup(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean parseSimpleExpression() {
        boolean result = false;
        if (!this.isNewLine()) {
            result = true;
            if (this.currentTokenIn(new IElementType[]{SCSSTokenTypes.INTERPOLATION_PREFIX})) {
                PsiBuilder.Marker concatOperation = this.mark(true);
                if (this.parseInterpolation()) {
                    if (!(this.eof() || this.isNewLine() || this.hasWhitespaceBefore())) {
                        if (this.parseSimpleExpression()) {
                            concatOperation.done(SCSSElementTypes.SCSS_OPERATION);
                            return true;
                        }
                    } else {
                        SASSParser.drop((PsiBuilder.Marker)concatOperation);
                        return true;
                    }
                }
                this.rollbackTo(concatOperation);
            }
            if (!(this.parseFunction() || this.parseMap() || this.parseParenthesis() || this.parseVariable() || this.parseNumber() || this.parseCssExpression())) {
                if (this.parseIdentOrInterpolation()) {
                    this.parseInterpolationAfterIdent();
                } else if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_UNICODE_RANGE, CssElementTypes.CSS_HASH, CssElementTypes.CSS_URL}) || this.allowImportantInTermList && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IMPORTANT})) {
                    this.advance();
                } else if (!this.parseString(true)) {
                    result = false;
                }
            }
        }
        return result;
    }

    public TokenSet getWhitespaceTokenSet() {
        return SASSTokenTypes.WHITESPACE_TOKENS;
    }

    public TokenSet getPrefixOperators() {
        return TokenSet.EMPTY;
    }

    public TokenSet getPostfixOperators() {
        return TokenSet.EMPTY;
    }

    public TokenSet @NotNull [] getOperatorsByPriority() {
        if (OPERATOR_PRIORITY == null) {
            SASSParser.$$$reportNull$$$0(3);
        }
        return OPERATOR_PRIORITY;
    }

    @Nullable
    public IElementType getPostfixExpressionElementType() {
        return null;
    }

    @Nullable
    public IElementType getPrefixExpressionElementType() {
        return null;
    }

    public IElementType @NotNull [] getOperationElementTypes() {
        if (OPERATOR_ELEMENT_TYPES == null) {
            SASSParser.$$$reportNull$$$0(4);
        }
        return OPERATOR_ELEMENT_TYPES;
    }

    protected IElementType getMultiplyToken() {
        return SASSTokenTypes.MULTIPLY;
    }

    protected IElementType getInterpolationPrefixToken() {
        return SASSTokenTypes.INTERPOLATION_PREFIX;
    }

    protected IElementType getInterpolationSuffixToken() {
        return SASSTokenTypes.INTERPOLATION_SUFFIX;
    }

    public boolean isIdent() {
        return this.currentTokenIn(this.getPossibleIdentifiers());
    }

    public void advanceUntil(IElementType ... types) {
        this.advanceUntil(TokenSet.create((IElementType[])types));
    }

    public boolean addIdentOrError() {
        if (this.parseIdentOrInterpolation()) {
            this.parseInterpolationAfterIdent();
            return true;
        }
        return false;
    }

    public boolean parseFunction(boolean strict) {
        return this.parseFunction();
    }

    public void addToken() {
        this.advance();
    }

    public void addSingleToken() {
        this.advance();
    }

    @NotNull
    public PsiBuilder.Marker createCompositeElement() {
        PsiBuilder.Marker marker = this.mark();
        if (marker == null) {
            SASSParser.$$$reportNull$$$0(5);
        }
        return marker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "atKeywordElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "atRuleElementType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/parser/SASSParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/parser/SASSParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperatorsByPriority";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationElementTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "skipBlock";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseGenericAtRule";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

