/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.collectors.fus.ActionPlaceHolder;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.FeatureUsageDataKt;
import com.intellij.internal.statistic.eventLog.QodanaEventsData;
import com.intellij.internal.statistic.eventLog.QodanaEventsDataKt;
import com.intellij.internal.statistic.eventLog.ShortcutDataProvider;
import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0011\b\u0007\u0018\u0000 T2\u00020\u0001:\u0001TB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0017\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0012\u0010\u0011\u001a\u00020\u00002\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u0003J\u0012\u0010\u0013\u001a\u00020\u00002\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0012\u0010\u0018\u001a\u00020\u00002\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0018\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010\u001d\u001a\u00020\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u001a\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u001c\u0010 \u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\"2\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\u0003J\u0010\u0010 \u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010$J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020%J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020&J\u0012\u0010'\u001a\u00020\u00002\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\u0003J\u0010\u0010(\u001a\u00020)2\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0012\u0010*\u001a\u00020\u00002\n\b\u0001\u0010+\u001a\u0004\u0018\u00010\u0003J\u0010\u0010,\u001a\u00020\u00002\b\b\u0001\u0010\u0019\u001a\u00020\u0003J\u001c\u0010-\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\n\b\u0001\u0010/\u001a\u0004\u0018\u00010\u0003J \u0010-\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\u000e\b\u0001\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000300J&\u0010-\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\n\b\u0001\u0010/\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u00101\u001a\u00020)J$\u00102\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\u0006\u00103\u001a\u0002042\n\b\u0001\u0010/\u001a\u0004\u0018\u00010\u0003J\u000e\u00105\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0001J\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020)J\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020:J\u0018\u0010;\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020)J\u0018\u0010;\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020:J\u0018\u0010;\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u000204J\u0018\u0010;\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020<J\u0018\u0010;\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020=J\u001a\u0010;\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\b\b\u0001\u0010/\u001a\u00020\u0003J\u001e\u0010;\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000300J%\u0010>\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\f\u0010/\u001a\b\u0012\u0004\u0012\u00020?00H\u0000\u00a2\u0006\u0002\b@J%\u0010A\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\f\u0010/\u001a\b\u0012\u0004\u0012\u00020400H\u0000\u00a2\u0006\u0002\bBJ+\u0010C\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010DH\u0000\u00a2\u0006\u0002\bEJ1\u0010F\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u00032\u0018\u0010/\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010D00H\u0000\u00a2\u0006\u0002\bGJ\u0018\u0010H\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0001H\u0002J\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010DJ\u000e\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0000J\u0018\u0010L\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\u00002\b\b\u0001\u0010N\u001a\u00020\u0003J\u0006\u0010O\u001a\u00020\u0000J\u0013\u0010P\u001a\u00020)2\b\u0010Q\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010R\u001a\u00020:H\u0016J\b\u0010S\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "", "recorderId", "", "<init>", "(Ljava/lang/String;)V", "()V", "getRecorderId", "()Ljava/lang/String;", "data", "", "addClientId", "clientId", "parsePermanentClientId", "addProject", "project", "Lcom/intellij/openapi/project/Project;", "addVersionByString", "version", "addVersion", "Lcom/intellij/openapi/util/Version;", "addPluginInfo", "info", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "addLanguage", "id", "language", "Lcom/intellij/lang/Language;", "name", "addCurrentFile", "addLanguageInternal", "fieldName", "addInputEvent", "event", "Ljava/awt/event/InputEvent;", "place", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Ljava/awt/event/KeyEvent;", "Ljava/awt/event/MouseEvent;", "addPlace", "isCommonPlace", "", "addAnonymizedPath", "path", "addAnonymizedId", "addAnonymizedValue", "key", "value", "", "short", "addDatedShortAnonymizedValue", "timestamp", "", "addValue", "addEnabled", "enabled", "addCount", "count", "", "addData", "", "", "addListNumberData", "", "addListNumberData$intellij_platform_statistics", "addListLongData", "addListLongData$intellij_platform_statistics", "addObjectData", "", "addObjectData$intellij_platform_statistics", "addListObjectData", "addListObjectData$intellij_platform_statistics", "addDataInternal", "build", "addAll", "from", "merge", "next", "prefix", "copy", "equals", "other", "hashCode", "toString", "Companion", "intellij.platform.statistics"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFeatureUsageData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureUsageData.kt\ncom/intellij/internal/statistic/eventLog/FeatureUsageData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,386:1\n1#2:387\n1557#3:388\n1628#3,3:389\n*S KotlinDebug\n*F\n+ 1 FeatureUsageData.kt\ncom/intellij/internal/statistic/eventLog/FeatureUsageData\n*L\n224#1:388\n224#1:389,3\n*E\n"})
public final class FeatureUsageData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recorderId;
    @NotNull
    private Map<String, Object> data;
    @NotNull
    private static final List<String> platformDataKeys;
    @NotNull
    private static final QodanaEventsData QODANA_EVENTS_DATA;

    public FeatureUsageData(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        this.recorderId = recorderId;
        this.data = new HashMap();
        ClientId clientId = ClientId.Companion.getCurrentOrNull();
        if (clientId != null && !Intrinsics.areEqual((Object)clientId, (Object)ClientId.Companion.getDefaultLocalId())) {
            this.addClientId(clientId.getValue());
        }
        if (QODANA_EVENTS_DATA.getProjectId() != null) {
            this.data.put("system_qdcld_project_id", QODANA_EVENTS_DATA.getProjectId());
        }
        if (QODANA_EVENTS_DATA.getOrganizationId() != null) {
            this.data.put("system_qdcld_org_id", QODANA_EVENTS_DATA.getOrganizationId());
        }
    }

    @NotNull
    public final String getRecorderId() {
        return this.recorderId;
    }

    @Deprecated(message="Recorder ID should be explicitly provided", replaceWith=@ReplaceWith(expression="FeatureUsageData(recorderId)", imports={}), level=DeprecationLevel.WARNING)
    @TestOnly
    public FeatureUsageData() {
        this("FUS");
    }

    @NotNull
    public final FeatureUsageData addClientId(@Nullable String clientId) {
        block0: {
            String string = clientId;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            String permanentClientId = this.parsePermanentClientId(clientId);
            this.data.put("client_id", EventLogConfiguration.getOrCreate$default(EventLogConfiguration.Companion.getInstance(), this.recorderId, null, 2, null).anonymize(permanentClientId));
        }
        return this;
    }

    private final String parsePermanentClientId(String clientId) {
        int separator = StringsKt.indexOf$default((CharSequence)clientId, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (separator > 0) {
            String string = clientId.substring(0, separator);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return clientId;
    }

    @NotNull
    public final FeatureUsageData addProject(@Nullable Project project) {
        if (project != null) {
            this.data.put("project", EventLogConfiguration.getOrCreate$default(EventLogConfiguration.Companion.getInstance(), this.recorderId, null, 2, null).anonymize(ProjectUtil.getProjectCacheFileName$default((Project)project, (boolean)false, null, null, (int)7, null)));
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addVersionByString(@NonNls @Nullable String version) {
        if (version == null) {
            this.data.put("version", "unknown");
        } else {
            this.addVersion(Version.parseVersion((String)version));
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addVersion(@NonNls @Nullable Version version) {
        Version version2 = version;
        this.data.put("version", version2 != null ? version2.major + "." + version.minor : "unknown.format");
        return this;
    }

    @NotNull
    public final FeatureUsageData addPluginInfo(@Nullable PluginInfo info) {
        block0: {
            PluginInfo pluginInfo = info;
            if (pluginInfo == null) break block0;
            PluginInfo it = pluginInfo;
            boolean bl = false;
            StatisticsUtil.addPluginInfoTo(info, this.data);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addLanguage(@NonNls @Nullable String id) {
        block0: {
            String string = id;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.addLanguage(Language.findLanguageByID((String)id));
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addLanguage(@Nullable Language language) {
        return this.addLanguageInternal("lang", language);
    }

    @NotNull
    public final FeatureUsageData addLanguage(@NotNull String name, @Nullable Language language) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.addLanguageInternal(name, language);
    }

    @NotNull
    public final FeatureUsageData addCurrentFile(@Nullable Language language) {
        return this.addLanguageInternal("current_file", language);
    }

    private final FeatureUsageData addLanguageInternal(String fieldName, Language language) {
        block2: {
            Language language2 = language;
            if (language2 == null) break block2;
            Language it = language2;
            boolean bl = false;
            PluginInfo type = PluginInfoDetectorKt.getPluginInfo(language.getClass());
            if (type.isSafeToReport()) {
                this.data.put(fieldName, language.getID());
            } else {
                this.data.put(fieldName, "third.party");
            }
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addInputEvent(@Nullable InputEvent event, @NonNls @Nullable String place) {
        String inputEvent = ShortcutDataProvider.getInputEventText(event, place);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addInputEvent(@Nullable AnActionEvent event) {
        String inputEvent = ShortcutDataProvider.getActionEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addInputEvent(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String inputEvent = ShortcutDataProvider.getKeyEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addInputEvent(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String inputEvent = ShortcutDataProvider.getMouseEventText(event);
        if (inputEvent != null && StringUtil.isNotEmpty((String)inputEvent)) {
            this.data.put("input_event", inputEvent);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData addPlace(@NonNls @Nullable String place) {
        if (place == null) {
            return this;
        }
        String reported = "unknown";
        if (this.isCommonPlace(place) || ActionPlaceHolder.isCustomActionPlace(place)) {
            reported = place;
        } else if (ActionPlaces.isPopupPlace((String)place)) {
            reported = "popup";
        }
        this.data.put("place", reported);
        return this;
    }

    private final boolean isCommonPlace(String place) {
        return ActionPlaces.isCommonPlace((String)place);
    }

    @NotNull
    public final FeatureUsageData addAnonymizedPath(@NonNls @Nullable String path) {
        String string;
        String string2;
        Map<String, Object> map;
        block3: {
            block2: {
                map = this.data;
                string2 = "file_path";
                string = path;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string3 = EventLogConfiguration.getOrCreate$default(EventLogConfiguration.Companion.getInstance(), this.recorderId, null, 2, null).anonymize(path);
                string = string3;
                if (string3 != null) break block3;
            }
            string = "undefined";
        }
        String string4 = string;
        map.put(string2, string4);
        return this;
    }

    @NotNull
    public final FeatureUsageData addAnonymizedId(@NonNls @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.data.put("anonymous_id", EventLogConfiguration.getOrCreate$default(EventLogConfiguration.Companion.getInstance(), this.recorderId, null, 2, null).anonymize(id));
        return this;
    }

    @NotNull
    public final FeatureUsageData addAnonymizedValue(@NonNls @NotNull String key, @NonNls @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.addAnonymizedValue(key, value, false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FeatureUsageData addAnonymizedValue(@NonNls @NotNull String key, @NonNls @NotNull List<String> value) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Map<String, Object> map = this.data;
        Iterable $this$map$iv = value;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(EventLogConfiguration.getOrCreate$default(EventLogConfiguration.Companion.getInstance(), this.recorderId, null, 2, null).anonymize((String)it, false));
        }
        List list = (List)destination$iv$iv;
        map.put(key, list);
        return this;
    }

    @NotNull
    public final FeatureUsageData addAnonymizedValue(@NonNls @NotNull String key, @NonNls @Nullable String value, boolean bl) {
        String string;
        Map<String, Object> map;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                map = this.data;
                string = value;
                if (string == null) break block2;
                String it = string;
                boolean bl2 = false;
                String string2 = EventLogConfiguration.getOrCreate$default(EventLogConfiguration.Companion.getInstance(), this.recorderId, null, 2, null).anonymize(value, bl);
                string = string2;
                if (string2 != null) break block3;
            }
            string = "undefined";
        }
        String string3 = string;
        map.put(key, string3);
        return this;
    }

    public static /* synthetic */ FeatureUsageData addAnonymizedValue$default(FeatureUsageData featureUsageData, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return featureUsageData.addAnonymizedValue(string, string2, bl);
    }

    @NotNull
    public final FeatureUsageData addDatedShortAnonymizedValue(@NonNls @NotNull String key, long timestamp, @NonNls @Nullable String value) {
        String string;
        String string2;
        Map<String, Object> map;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                map = this.data;
                string2 = StatisticsUtil.getTimestampDateInUTC$default(StatisticsUtil.INSTANCE, timestamp, null, 2, null);
                string = value;
                if (string == null) break block2;
                String string3 = string;
                String string4 = string2;
                boolean bl = false;
                String string5 = EventLogConfiguration.getOrCreate$default(EventLogConfiguration.Companion.getInstance(), this.recorderId, null, 2, null).anonymize(value, true);
                string2 = string4;
                string = string5;
                if (string5 != null) break block3;
            }
            string = "undefined";
        }
        String string6 = string2 + "-" + string;
        map.put(key, string6);
        return this;
    }

    @NotNull
    public final FeatureUsageData addValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return this.addDataInternal("value", value);
        }
        return this.addData("value", value.toString());
    }

    @NotNull
    public final FeatureUsageData addEnabled(boolean enabled) {
        return this.addData("enabled", enabled);
    }

    @NotNull
    public final FeatureUsageData addCount(int count) {
        return this.addData("count", count);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, float value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.addDataInternal(key, Float.valueOf(value));
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, double value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, @NonNls @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addData(@NonNls @NotNull String key, @NotNull List<String> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addListNumberData$intellij_platform_statistics(@NonNls @NotNull String key, @NotNull List<? extends Number> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addListLongData$intellij_platform_statistics(@NonNls @NotNull String key, @NotNull List<Long> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.addListNumberData$intellij_platform_statistics(key, value);
    }

    @NotNull
    public final FeatureUsageData addObjectData$intellij_platform_statistics(@NonNls @NotNull String key, @NotNull Map<String, ? extends Object> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.addDataInternal(key, value);
    }

    @NotNull
    public final FeatureUsageData addListObjectData$intellij_platform_statistics(@NonNls @NotNull String key, @NotNull List<? extends Map<String, ? extends Object>> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.addDataInternal(key, value);
    }

    private final FeatureUsageData addDataInternal(String key, Object value) {
        if (!ApplicationManager.getApplication().isUnitTestMode() && platformDataKeys.contains(key)) {
            FeatureUsageDataKt.access$getLOG$p().warn("Collectors should not reuse platform keys: " + key);
            return this;
        }
        String escapedKey = StatisticsEventEscaper.escapeFieldName((String)key);
        if (!Intrinsics.areEqual((Object)escapedKey, (Object)key)) {
            FeatureUsageDataKt.access$getLOG$p().warn("Key contains invalid symbols, they will be escaped: '" + key + "' -> '" + escapedKey + "'");
        }
        this.data.put(escapedKey, value);
        return this;
    }

    @NotNull
    public final Map<String, Object> build() {
        if (this.data.isEmpty()) {
            Map<String, Object> map = Collections.emptyMap();
            Intrinsics.checkNotNullExpressionValue(map, (String)"emptyMap(...)");
            return map;
        }
        return this.data;
    }

    @NotNull
    public final FeatureUsageData addAll(@NotNull FeatureUsageData from) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        this.data.putAll(from.data);
        return this;
    }

    @NotNull
    public final FeatureUsageData merge(@NotNull FeatureUsageData next, @NonNls @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        for (Map.Entry<String, Object> entry : next.build().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String newKey = StringsKt.startsWith$default((String)key, (String)"data_", (boolean)false, (int)2, null) ? prefix + key : key;
            this.data.put(newKey, value);
        }
        return this;
    }

    @NotNull
    public final FeatureUsageData copy() {
        FeatureUsageData result = new FeatureUsageData(this.recorderId);
        for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            result.data.put(key, value);
        }
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.FeatureUsageData");
        FeatureUsageData cfr_ignored_0 = (FeatureUsageData)other;
        return Intrinsics.areEqual(this.data, ((FeatureUsageData)other).data);
    }

    public int hashCode() {
        return ((Object)this.data).hashCode();
    }

    @NotNull
    public String toString() {
        return this.data.toString();
    }

    static {
        Object[] objectArray = new String[]{"plugin", "project", "os", "plugin_type", "lang", "current_file", "input_event", "place", "file_path", "anonymous_id", "client_id", "system_qdcld_project_id", "system_qdcld_org_id", "auto_license_type"};
        platformDataKeys = CollectionsKt.listOf((Object[])objectArray);
        QODANA_EVENTS_DATA = QodanaEventsDataKt.calcQodanaEventsData();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageData$Companion;", "", "<init>", "()V", "platformDataKeys", "", "", "getPlatformDataKeys", "()Ljava/util/List;", "QODANA_EVENTS_DATA", "Lcom/intellij/internal/statistic/eventLog/QodanaEventsData;", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getPlatformDataKeys() {
            return platformDataKeys;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

