/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.ui;

import com.intellij.json.psi.JsonFile;
import com.intellij.jsonpath.JsonPathBundle;
import com.intellij.jsonpath.ui.EvaluateResult;
import com.intellij.jsonpath.ui.IncorrectDocument;
import com.intellij.jsonpath.ui.IncorrectExpression;
import com.intellij.jsonpath.ui.ResultNotFound;
import com.intellij.jsonpath.ui.ResultString;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.ClassUtil;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluator;", "", "jsonFile", "Lcom/intellij/json/psi/JsonFile;", "expression", "", "evalOptions", "", "Lcom/jayway/jsonpath/Option;", "<init>", "(Lcom/intellij/json/psi/JsonFile;Ljava/lang/String;Ljava/util/Set;)V", "getExpression", "()Ljava/lang/String;", "evaluate", "Lcom/intellij/jsonpath/ui/EvaluateResult;", "toResultString", "config", "Lcom/jayway/jsonpath/Configuration;", "result", "intellij.jsonpath"})
public final class JsonPathEvaluator {
    @Nullable
    private final JsonFile jsonFile;
    @NotNull
    private final String expression;
    @NotNull
    private final Set<Option> evalOptions;

    public JsonPathEvaluator(@Nullable JsonFile jsonFile, @NotNull String expression, @NotNull Set<? extends Option> evalOptions) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter(evalOptions, (String)"evalOptions");
        this.jsonFile = jsonFile;
        this.expression = expression;
        this.evalOptions = evalOptions;
    }

    @NotNull
    public final String getExpression() {
        return this.expression;
    }

    @Nullable
    public final EvaluateResult evaluate() {
        Object t;
        DocumentContext documentContext;
        String json;
        JsonPath jsonPath;
        try {
            if (StringsKt.isBlank((CharSequence)this.expression)) {
                return null;
            }
            jsonPath = JsonPath.compile(this.expression, new Predicate[0]);
            Intrinsics.checkNotNull((Object)jsonPath);
        }
        catch (InvalidPathException ip) {
            String string = ip.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
            return new IncorrectExpression(string);
        }
        JsonPath jsonPath2 = jsonPath;
        Configuration config = new Configuration.ConfigurationBuilder().jsonProvider(new JacksonJsonProvider()).mappingProvider(new JacksonMappingProvider()).options(this.evalOptions).build();
        JsonFile jsonFile = this.jsonFile;
        String string = json = jsonFile != null ? jsonFile.getText() : null;
        if (json == null) {
            String string2 = JsonPathBundle.message("jsonpath.evaluate.file.not.found", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return new IncorrectDocument(string2);
        }
        try {
            documentContext = JsonPath.parse(json, config);
            Intrinsics.checkNotNull((Object)documentContext);
        }
        catch (IllegalArgumentException e) {
            String string3 = e.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLocalizedMessage(...)");
            return new IncorrectDocument(string3);
        }
        catch (InvalidJsonException ej) {
            if (!Intrinsics.areEqual((Object)ej.getCause(), (Object)ej)) {
                String string4 = ej.getMessage();
                if (string4 == null) {
                    string4 = "";
                }
                if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"ParseException", (boolean)false, (int)2, null)) {
                    String message;
                    Throwable throwable = ej.getCause();
                    String string5 = message = throwable != null ? throwable.getLocalizedMessage() : null;
                    if (message != null) {
                        return new IncorrectDocument(message);
                    }
                }
            }
            String string6 = ej.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getLocalizedMessage(...)");
            return new IncorrectDocument(string6);
        }
        DocumentContext jsonDocument = documentContext;
        try {
            t = jsonDocument.read(jsonPath2);
        }
        catch (PathNotFoundException pe) {
            String string7 = pe.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getLocalizedMessage(...)");
            return new ResultNotFound(string7);
        }
        catch (JsonPathException jpe) {
            String string8 = jpe.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getLocalizedMessage(...)");
            return new ResultNotFound(string8);
        }
        catch (IllegalStateException ise) {
            String string9 = ise.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getLocalizedMessage(...)");
            return new ResultNotFound(string9);
        }
        Object result = t;
        Intrinsics.checkNotNull((Object)config);
        return new ResultString(this.toResultString(config, result));
    }

    private final String toResultString(Configuration config, Object result) {
        if (result == null) {
            return "null";
        }
        if (result instanceof String) {
            return "\"" + StringUtil.escapeStringCharacters((String)((String)result)) + "\"";
        }
        if (ClassUtil.isPrimitive(result.getClass())) {
            return result.toString();
        }
        if (result instanceof Collection) {
            return "[" + CollectionsKt.joinToString$default((Iterable)((Iterable)result), (CharSequence)", ", null, null, (int)0, null, arg_0 -> JsonPathEvaluator.toResultString$lambda$0(this, config, arg_0), (int)30, null) + "]";
        }
        String string = config.jsonProvider().toJson(result);
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final CharSequence toResultString$lambda$0(JsonPathEvaluator this$0, Configuration $config, Object it) {
        return this$0.toResultString($config, it);
    }
}

