/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.python.profiler.CallStat;
import com.intellij.python.profiler.FuncStat;
import com.intellij.python.profiler.Function;
import com.intellij.python.profiler.FunctionStat;
import com.intellij.python.profiler.ProfileDataKt;
import com.intellij.python.profiler.ProfileStatData;
import com.intellij.python.profiler.Stats;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0001J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0001J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001fH\u0016J\b\u0010 \u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020\u0006H\u0016J\b\u0010#\u001a\u00020\u0006H\u0016J\b\u0010$\u001a\u00020\u0006H\u0016J\b\u0010%\u001a\u00020\u0006H\u0016J\b\u0010&\u001a\u00020\u0006H\u0016J\u0013\u0010'\u001a\u00020\u00192\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020\u0006H\u0016J\b\u0010+\u001a\u00020\u0003H\u0016J\b\u0010,\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0015j\b\u0012\u0004\u0012\u00020\u0001`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0015j\b\u0012\u0004\u0012\u00020\u0001`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/python/profiler/CallTreeStatData;", "Lcom/intellij/python/profiler/FunctionStat;", "fileName", "", "funcName", "lineNumber", "", "hits", "samplingInterval", "", "profileStatData", "Lcom/intellij/python/profiler/ProfileStatData;", "<init>", "(Ljava/lang/String;Ljava/lang/String;IIDLcom/intellij/python/profiler/ProfileStatData;)V", "getFileName", "()Ljava/lang/String;", "getHits", "()I", "setHits", "(I)V", "callersSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "childrenSet", "addCaller", "", "func", "addChild", "getFuncStat", "Lcom/intellij/python/profiler/FuncStat;", "getCallers", "", "getFile", "getName", "getLine", "getCallCount", "getTotalTimeMs", "getOwnTimeMs", "getBaseTotalTime", "equals", "other", "", "hashCode", "getThreadName", "getThreadId", "intellij.python.profiler"})
@SourceDebugExtension(value={"SMAP\nProfileData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileData.kt\ncom/intellij/python/profiler/CallTreeStatData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,387:1\n1#2:388\n*E\n"})
public final class CallTreeStatData
implements FunctionStat {
    @NotNull
    private final String fileName;
    @NotNull
    private final String funcName;
    private final int lineNumber;
    private int hits;
    private final double samplingInterval;
    @NotNull
    private final ProfileStatData profileStatData;
    @NotNull
    private final HashSet<FunctionStat> callersSet;
    @NotNull
    private final HashSet<FunctionStat> childrenSet;

    public CallTreeStatData(@NotNull String fileName, @NotNull String funcName, int lineNumber, int hits, double samplingInterval, @NotNull ProfileStatData profileStatData) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)funcName, (String)"funcName");
        Intrinsics.checkNotNullParameter((Object)profileStatData, (String)"profileStatData");
        this.fileName = fileName;
        this.funcName = funcName;
        this.lineNumber = lineNumber;
        this.hits = hits;
        this.samplingInterval = samplingInterval;
        this.profileStatData = profileStatData;
        this.callersSet = new HashSet();
        this.childrenSet = new HashSet();
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    public final int getHits() {
        return this.hits;
    }

    public final void setHits(int n) {
        this.hits = n;
    }

    public final boolean addCaller(@NotNull FunctionStat func) {
        Intrinsics.checkNotNullParameter((Object)func, (String)"func");
        return this.callersSet.add(func);
    }

    public final boolean addChild(@NotNull FunctionStat func) {
        Intrinsics.checkNotNullParameter((Object)func, (String)"func");
        return this.childrenSet.add(func);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FuncStat getFuncStat() {
        Object v3;
        Object object;
        block1: {
            Stats stats = this.profileStatData.getStats();
            object = stats;
            if (stats == null) return null;
            List<Function> list = ((Stats)object).func_stats;
            object = list;
            if (list == null) return null;
            Iterable iterable = (Iterable)object;
            for (Object t : iterable) {
                Function it = (Function)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.func_stat.func_name, (Object)this.funcName)) continue;
                v3 = t;
                break block1;
            }
            v3 = null;
        }
        Function function = v3;
        object = function;
        if (function == null) return null;
        FuncStat funcStat = ((Function)object).func_stat;
        return funcStat;
    }

    @Override
    @NotNull
    public List<FunctionStat> getCallers() {
        return new CopyOnWriteArrayList(this.callersSet);
    }

    @Override
    @NotNull
    public String getFile() {
        return this.fileName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.funcName;
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }

    @Override
    public int getCallCount() {
        return this.hits;
    }

    @Override
    public int getTotalTimeMs() {
        return (int)((double)this.hits * this.samplingInterval * (double)1000);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getOwnTimeMs() {
        int n;
        Iterable iterable = this.childrenSet;
        int n2 = this.getTotalTimeMs();
        int n3 = 0;
        for (Object t : iterable) {
            void it;
            FunctionStat functionStat = (FunctionStat)t;
            n = n3;
            boolean bl = false;
            int n4 = it.getTotalTimeMs();
            n3 = n + n4;
        }
        n = n3;
        return RangesKt.coerceAtLeast((int)(n2 - n), (int)0);
    }

    @Override
    public int getBaseTotalTime() {
        return this.profileStatData.getBaseTotalTimeMs();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CallTreeStatData ? Intrinsics.areEqual(ProfileDataKt.callId(this), ProfileDataKt.callId((CallStat)other)) : super.equals(other);
    }

    public int hashCode() {
        return ProfileDataKt.callId(this).hashCode();
    }

    @Override
    @NotNull
    public String getThreadName() {
        Object object = this.getFuncStat();
        if (object == null || (object = ((FuncStat)object).threadName) == null) {
            object = "MainThread";
        }
        return object;
    }

    @Override
    @NotNull
    public String getThreadId() {
        Object object = this.getFuncStat();
        if (object == null || (object = ((FuncStat)object).threadId) == null) {
            object = "0";
        }
        return object;
    }
}

