/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestLanguage;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.UIBundle;
import com.intellij.util.PathUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OpenInScratchFileUtil {
    public static void createAndOpenScratchFile(@NotNull Project project, @NotNull RestClientRequest request, @Nullable String comment) {
        NavigatablePsiElement psiElement;
        if (project == null) {
            OpenInScratchFileUtil.$$$reportNull$$$0(0);
        }
        if (request == null) {
            OpenInScratchFileUtil.$$$reportNull$$$0(1);
        }
        String fileName = PathUtil.makeFileName((String)"rest-api", (String)HttpRequestFileType.INSTANCE.getDefaultExtension());
        try {
            psiElement = (NavigatablePsiElement)WriteCommandAction.writeCommandAction((Project)project).withName(RestClientBundle.message("http.request.create.scratch.file.with.request.action.title", new Object[0])).withGlobalUndo().shouldRecordActionForActiveDocument(false).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).compute(() -> {
                VirtualFile file;
                ScratchFileService fileService = ScratchFileService.getInstance();
                try {
                    file = fileService.findFile((RootType)ScratchRootType.getInstance(), fileName, ScratchFileService.Option.create_new_always);
                }
                catch (IOException e) {
                    throw new Exception(UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{fileName}), e);
                }
                fileService.getScratchesMapping().setMapping(file, (Object)HttpRequestLanguage.INSTANCE);
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (!(psiFile instanceof HttpRequestPsiFile)) {
                    throw new Exception(RestClientBundle.message("http.request.create.scratch.file.with.request.failed", new Object[0]));
                }
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
                Document document = manager.getDocument(psiFile);
                if (document == null) {
                    throw new Exception(RestClientBundle.message("http.request.create.scratch.file.with.request.file.is.invalid", new Object[0]));
                }
                Object convertedRequest = comment != null ? comment + HttpRequestPsiConverter.toPsiHttpRequest(request) : HttpRequestPsiConverter.toPsiHttpRequest(request);
                document.insertString(document.getTextLength(), (CharSequence)convertedRequest);
                manager.commitDocument(document);
                HttpRequestBlock[] updated = HttpRequestPsiUtils.getRequestBlocks(psiFile);
                if (updated.length > 0) {
                    return updated[updated.length - 1];
                }
                return psiFile;
            });
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]));
            return;
        }
        if (psiElement != null) {
            psiElement.navigate(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "request";
                break;
            }
        }
        objectArray[1] = "com/intellij/httpClient/actions/OpenInScratchFileUtil";
        objectArray[2] = "createAndOpenScratchFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

