/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.copyPaste;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentsProvider;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.run.GlobalHttpClientSessionScope;
import com.intellij.httpClient.http.request.run.HttpRequestGlobalContext;
import com.intellij.httpClient.http.request.substitution.HttpRequestVariableRootSubstitutorKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&R\u0012\u0010\t\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/httpClient/actions/copyPaste/Environment;", "", "<init>", "()V", "getVariables", "", "", "globalContext", "Lcom/intellij/httpClient/http/request/run/HttpRequestGlobalContext;", "name", "getName", "()Ljava/lang/String;", "getSubstitutor", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/psi/PsiFile;", "FileEnvironment", "NoEnvironment", "Lcom/intellij/httpClient/actions/copyPaste/Environment$FileEnvironment;", "Lcom/intellij/httpClient/actions/copyPaste/Environment$NoEnvironment;", "intellij.restClient"})
abstract class Environment {
    private Environment() {
    }

    @NotNull
    public abstract Set<String> getVariables(@NotNull HttpRequestGlobalContext var1);

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract HttpRequestVariableSubstitutor getSubstitutor(@NotNull Project var1, @NotNull PsiFile var2);

    public /* synthetic */ Environment(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0007H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/intellij/httpClient/actions/copyPaste/Environment$FileEnvironment;", "Lcom/intellij/httpClient/actions/copyPaste/Environment;", "environmentDescriptor", "Lcom/intellij/httpClient/http/request/environment/HttpClientEnvironmentsProvider$EnvironmentDescriptor;", "<init>", "(Lcom/intellij/httpClient/http/request/environment/HttpClientEnvironmentsProvider$EnvironmentDescriptor;)V", "name", "", "getName", "()Ljava/lang/String;", "getVariables", "", "globalContext", "Lcom/intellij/httpClient/http/request/run/HttpRequestGlobalContext;", "getSubstitutor", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/psi/PsiFile;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.restClient"})
    public static final class FileEnvironment
    extends Environment {
        @NotNull
        private final HttpClientEnvironmentsProvider.EnvironmentDescriptor environmentDescriptor;

        public FileEnvironment(@NotNull HttpClientEnvironmentsProvider.EnvironmentDescriptor environmentDescriptor) {
            Intrinsics.checkNotNullParameter((Object)environmentDescriptor, (String)"environmentDescriptor");
            super(null);
            this.environmentDescriptor = environmentDescriptor;
        }

        @Override
        @NotNull
        public String getName() {
            return this.environmentDescriptor.getName();
        }

        @Override
        @NotNull
        public Set<String> getVariables(@NotNull HttpRequestGlobalContext globalContext) {
            Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
            Set allVariables = CollectionsKt.toMutableSet((Iterable)this.environmentDescriptor.getVariables());
            Collection<String> collection = globalContext.getAllVariables();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllVariables(...)");
            allVariables.addAll(collection);
            return allVariables;
        }

        @Override
        @NotNull
        public HttpRequestVariableSubstitutor getSubstitutor(@NotNull Project project, @NotNull PsiFile context2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            HttpRequestEnvironment httpRequestEnvironment = HttpRequestEnvironment.create(project, this.getName(), context2);
            Intrinsics.checkNotNullExpressionValue((Object)httpRequestEnvironment, (String)"create(...)");
            return HttpRequestVariableRootSubstitutorKt.createRootSubstitutor(project, httpRequestEnvironment, context2, new GlobalHttpClientSessionScope());
        }

        private final HttpClientEnvironmentsProvider.EnvironmentDescriptor component1() {
            return this.environmentDescriptor;
        }

        @NotNull
        public final FileEnvironment copy(@NotNull HttpClientEnvironmentsProvider.EnvironmentDescriptor environmentDescriptor) {
            Intrinsics.checkNotNullParameter((Object)environmentDescriptor, (String)"environmentDescriptor");
            return new FileEnvironment(environmentDescriptor);
        }

        public static /* synthetic */ FileEnvironment copy$default(FileEnvironment fileEnvironment, HttpClientEnvironmentsProvider.EnvironmentDescriptor environmentDescriptor, int n, Object object) {
            if ((n & 1) != 0) {
                environmentDescriptor = fileEnvironment.environmentDescriptor;
            }
            return fileEnvironment.copy(environmentDescriptor);
        }

        @NotNull
        public String toString() {
            return "FileEnvironment(environmentDescriptor=" + this.environmentDescriptor + ")";
        }

        public int hashCode() {
            return this.environmentDescriptor.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileEnvironment)) {
                return false;
            }
            FileEnvironment fileEnvironment = (FileEnvironment)other;
            return Intrinsics.areEqual((Object)this.environmentDescriptor, (Object)fileEnvironment.environmentDescriptor);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/httpClient/actions/copyPaste/Environment$NoEnvironment;", "Lcom/intellij/httpClient/actions/copyPaste/Environment;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "getSubstitutor", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/psi/PsiFile;", "getVariables", "", "globalContext", "Lcom/intellij/httpClient/http/request/run/HttpRequestGlobalContext;", "intellij.restClient"})
    public static final class NoEnvironment
    extends Environment {
        @NotNull
        public static final NoEnvironment INSTANCE = new NoEnvironment();

        private NoEnvironment() {
            super(null);
        }

        @Override
        @NotNull
        public String getName() {
            String string = RestClientBundle.message("http.request.convert.to.curl.no.environment.option", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        @NotNull
        public HttpRequestVariableSubstitutor getSubstitutor(@NotNull Project project, @NotNull PsiFile context2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            HttpRequestEnvironment httpRequestEnvironment = HttpRequestEnvironment.empty();
            Intrinsics.checkNotNullExpressionValue((Object)httpRequestEnvironment, (String)"empty(...)");
            return HttpRequestVariableRootSubstitutorKt.createRootSubstitutor(project, httpRequestEnvironment, context2, new GlobalHttpClientSessionScope());
        }

        @Override
        @NotNull
        public Set<String> getVariables(@NotNull HttpRequestGlobalContext globalContext) {
            Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
            Collection<String> collection = globalContext.getAllVariables();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllVariables(...)");
            return CollectionsKt.toSet((Iterable)collection);
        }
    }
}

